/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.modmanager;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.models.metadata.ModCategories;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.modmanager.ModManagementScreen;
import com.unciv.ui.screens.modmanager.ModUIData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0006\u0010*\u001a\u00020\u0013J\u0006\u0010+\u001a\u00020\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR\u000e\u0010\"\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/unciv/ui/screens/modmanager/ModManagementOptions;", "", "modManagementScreen", "Lcom/unciv/ui/screens/modmanager/ModManagementScreen;", "(Lcom/unciv/ui/screens/modmanager/ModManagementScreen;)V", "category", "Lcom/unciv/models/metadata/ModCategories$Category;", "getCategory", "()Lcom/unciv/models/metadata/ModCategories$Category;", "setCategory", "(Lcom/unciv/models/metadata/ModCategories$Category;)V", "categorySelect", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "expander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "getExpander", "()Lcom/unciv/ui/components/widgets/ExpanderTab;", "expanderChangeEvent", "Lkotlin/Function0;", "", "getExpanderChangeEvent", "()Lkotlin/jvm/functions/Function0;", "setExpanderChangeEvent", "(Lkotlin/jvm/functions/Function0;)V", "sortInstalled", "Lcom/unciv/ui/screens/modmanager/ModManagementOptions$SortType;", "getSortInstalled", "()Lcom/unciv/ui/screens/modmanager/ModManagementOptions$SortType;", "setSortInstalled", "(Lcom/unciv/ui/screens/modmanager/ModManagementOptions$SortType;)V", "sortInstalledSelect", "sortOnline", "getSortOnline", "setSortOnline", "sortOnlineSelect", "textField", "Lcom/unciv/ui/components/widgets/UncivTextField;", "getFilter", "Lcom/unciv/ui/screens/modmanager/ModManagementOptions$Filter;", "getInstalledHeader", "", "getOnlineHeader", "installedHeaderClicked", "onlineHeaderClicked", "Companion", "Filter", "SortType", "core"})
@SourceDebugExtension(value={"SMAP\nModManagementOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModManagementOptions.kt\ncom/unciv/ui/screens/modmanager/ModManagementOptions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n766#2:186\n857#2,2:187\n1549#2:189\n1620#2,3:190\n1549#2:193\n1620#2,3:194\n*S KotlinDebug\n*F\n+ 1 ModManagementOptions.kt\ncom/unciv/ui/screens/modmanager/ModManagementOptions\n*L\n100#1:186\n100#1:187,2\n100#1:189\n100#1:190,3\n109#1:193\n109#1:194,3\n*E\n"})
public final class ModManagementOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModManagementScreen modManagementScreen;
    @NotNull
    private final UncivTextField textField;
    @NotNull
    private ModCategories.Category category;
    @NotNull
    private SortType sortInstalled;
    @NotNull
    private SortType sortOnline;
    @NotNull
    private final TranslatedSelectBox categorySelect;
    @NotNull
    private final TranslatedSelectBox sortInstalledSelect;
    @NotNull
    private final TranslatedSelectBox sortOnlineSelect;
    @Nullable
    private Function0<Unit> expanderChangeEvent;
    @NotNull
    private final ExpanderTab expander;
    @NotNull
    private static final Comparator<ModUIData> sortByName = ModManagementOptions::sortByName$lambda$3;
    @NotNull
    private static final Comparator<ModUIData> sortByNameDesc = ModManagementOptions::sortByNameDesc$lambda$4;
    @NotNull
    private static final Comparator<ModUIData> sortByDate = ModManagementOptions::sortByDate$lambda$5;
    @NotNull
    private static final Comparator<ModUIData> sortByDateDesc = ModManagementOptions::sortByDateDesc$lambda$6;
    @NotNull
    private static final Comparator<ModUIData> sortByStars = ModManagementOptions::sortByStars$lambda$7;
    @NotNull
    private static final Comparator<ModUIData> sortByStatus = ModManagementOptions::sortByStatus$lambda$8;
    @NotNull
    public static final String installedHeaderText = "Current mods";
    @NotNull
    public static final String onlineHeaderText = "Downloadable mods";

    /*
     * WARNING - void declaration
     */
    public ModManagementOptions(@NotNull ModManagementScreen modManagementScreen) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        SortType sort;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(modManagementScreen, "modManagementScreen");
        this.modManagementScreen = modManagementScreen;
        this.textField = new UncivTextField("Enter search text", null, null, 6, null);
        this.category = ModCategories.Companion.default();
        this.sortInstalled = SortType.Name;
        this.sortOnline = SortType.Stars;
        Actor actor = ImageGetter.INSTANCE.getImage("OtherIcons/Search");
        Color color = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
        final IconCircleGroup searchIcon = Scene2dExtensionsKt.surroundWithCircle$default(actor, 50.0f, false, color, null, 10, null);
        Iterable iterable = SortType.getEntries();
        ModManagementOptions modManagementOptions = this;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            sort = (SortType)((Object)element$iv$iv);
            boolean bl = false;
            if (!(sort != SortType.Stars)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            sort = (SortType)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(sort.getLabel());
        }
        String string = this.sortInstalled.getLabel();
        Collection collection2 = (List)destination$iv$iv;
        modManagementOptions.sortInstalledSelect = new TranslatedSelectBox(collection2, string);
        ActivationExtensionsKt.onChange(this.sortInstalledSelect, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                this.setSortInstalled(SortType.Companion.fromSelectBox(sortInstalledSelect));
                modManagementScreen.refreshInstalledModTable$core();
            }
        });
        $this$map$iv = SortType.getEntries();
        modManagementOptions = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            sort = (SortType)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(sort.getLabel());
        }
        String string2 = this.sortOnline.getLabel();
        Collection collection3 = (List)destination$iv$iv;
        modManagementOptions.sortOnlineSelect = new TranslatedSelectBox(collection3, string2);
        ActivationExtensionsKt.onChange(this.sortOnlineSelect, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                this.setSortOnline(SortType.Companion.fromSelectBox(sortOnlineSelect));
                modManagementScreen.refreshOnlineModTable$core();
            }
        });
        this.categorySelect = new TranslatedSelectBox(SequencesKt.toList(SequencesKt.map(ModCategories.Companion.asSequence(), 6.INSTANCE)), this.category.getLabel());
        ActivationExtensionsKt.onChange(this.categorySelect, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                this.setCategory(ModCategories.Companion.fromSelectBox(categorySelect));
                modManagementScreen.refreshInstalledModTable$core();
                modManagementScreen.refreshOnlineModTable$core();
            }
        });
        this.expander = new ExpanderTab("Sort and Filter", 18, null, false, 2.5f, 15.0f, 360.0f, null, null, new Function0<Unit>(){

            @Override
            public final void invoke() {
                block0: {
                    Function0<Unit> function0 = this.getExpanderChangeEvent();
                    if (function0 == null) break block0;
                    function0.invoke();
                }
            }
        }, new Function1<Table, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@NotNull Table it) {
                void $this$invoke_u24lambda_u240;
                Intrinsics.checkNotNullParameter(it, "it");
                it.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "ModManagementOptions/ExpanderTab", null, new Color(540037375), 2, null));
                it.pad(7.5f);
                Table table2 = new Table();
                ModManagementOptions modManagementOptions = this;
                IconCircleGroup iconCircleGroup = searchIcon;
                Table table3 = table2;
                Table table4 = it;
                boolean bl = false;
                $this$invoke_u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("Filter:")).left();
                $this$invoke_u24lambda_u240.add((Actor)modManagementOptions.textField).pad(0.0f, 5.0f, 0.0f, 5.0f).growX();
                $this$invoke_u24lambda_u240.add((Actor)iconCircleGroup).right();
                table4.add((Actor)table2).colspan(2).growX().padBottom(7.5f).row();
                it.add((Actor)Scene2dExtensionsKt.toLabel("Category:")).left();
                it.add((Actor)categorySelect).right().padBottom(7.5f).row();
                it.add((Actor)Scene2dExtensionsKt.toLabel("Sort Current:")).left();
                it.add((Actor)sortInstalledSelect).right().padBottom(7.5f).row();
                it.add((Actor)Scene2dExtensionsKt.toLabel("Sort Downloadable:")).left();
                it.add((Actor)sortOnlineSelect).right().row();
            }
        }, 388, null);
        searchIcon.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onActivation(searchIcon, new Function0<Unit>(){

            @Override
            public final void invoke() {
                if (this.getExpander().isOpen()) {
                    modManagementScreen.refreshInstalledModTable$core();
                    modManagementScreen.refreshOnlineModTable$core();
                } else {
                    modManagementScreen.getStage().setKeyboardFocus(textField);
                }
                this.getExpander().toggle();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(searchIcon).add(KeyCharAndCode.Companion.getRETURN());
        UncivTooltip.Companion.addTooltip((Actor)searchIcon, KeyCharAndCode.Companion.getRETURN(), 18.0f);
    }

    @NotNull
    public final Filter getFilter() {
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        return new Filter(string, this.category.getTopic());
    }

    @NotNull
    public final ModCategories.Category getCategory() {
        return this.category;
    }

    public final void setCategory(@NotNull ModCategories.Category category) {
        Intrinsics.checkNotNullParameter(category, "<set-?>");
        this.category = category;
    }

    @NotNull
    public final SortType getSortInstalled() {
        return this.sortInstalled;
    }

    public final void setSortInstalled(@NotNull SortType sortType) {
        Intrinsics.checkNotNullParameter((Object)sortType, "<set-?>");
        this.sortInstalled = sortType;
    }

    @NotNull
    public final SortType getSortOnline() {
        return this.sortOnline;
    }

    public final void setSortOnline(@NotNull SortType sortType) {
        Intrinsics.checkNotNullParameter((Object)sortType, "<set-?>");
        this.sortOnline = sortType;
    }

    @Nullable
    public final Function0<Unit> getExpanderChangeEvent() {
        return this.expanderChangeEvent;
    }

    public final void setExpanderChangeEvent(@Nullable Function0<Unit> function0) {
        this.expanderChangeEvent = function0;
    }

    @NotNull
    public final ExpanderTab getExpander() {
        return this.expander;
    }

    @NotNull
    public final String getInstalledHeader() {
        return TranslationsKt.tr$default(installedHeaderText, false, 1, null) + ' ' + this.sortInstalled.getSymbols();
    }

    @NotNull
    public final String getOnlineHeader() {
        return TranslationsKt.tr$default(onlineHeaderText, false, 1, null) + ' ' + this.sortOnline.getSymbols();
    }

    public final void installedHeaderClicked() {
        do {
            this.sortInstalled = this.sortInstalled.next();
        } while (this.sortInstalled == SortType.Stars);
        this.sortInstalledSelect.setSelected(new TranslatedSelectBox.TranslatedString(this.sortInstalled.getLabel()));
        this.modManagementScreen.refreshInstalledModTable$core();
    }

    public final void onlineHeaderClicked() {
        this.sortOnline = this.sortOnline.next();
        this.sortOnlineSelect.setSelected(new TranslatedSelectBox.TranslatedString(this.sortOnline.getLabel()));
        this.modManagementScreen.refreshOnlineModTable$core();
    }

    private static final int sortByName$lambda$3(ModUIData mod1, ModUIData mod2) {
        Intrinsics.checkNotNullParameter(mod2, "mod2");
        return StringsKt.compareTo(mod1.getName(), mod2.getName(), true);
    }

    private static final int sortByNameDesc$lambda$4(ModUIData mod1, ModUIData mod2) {
        Intrinsics.checkNotNullParameter(mod2, "mod2");
        return StringsKt.compareTo(mod2.getName(), mod1.getName(), true);
    }

    private static final int sortByDate$lambda$5(ModUIData mod1, ModUIData mod2) {
        Intrinsics.checkNotNullParameter(mod2, "mod2");
        return mod1.lastUpdated().compareTo(mod2.lastUpdated());
    }

    private static final int sortByDateDesc$lambda$6(ModUIData mod1, ModUIData mod2) {
        Intrinsics.checkNotNullParameter(mod2, "mod2");
        return mod2.lastUpdated().compareTo(mod1.lastUpdated());
    }

    private static final int sortByStars$lambda$7(ModUIData mod1, ModUIData mod2) {
        Intrinsics.checkNotNullParameter(mod2, "mod2");
        return 10 * (mod2.stargazers() - mod1.stargazers()) + MathKt.getSign(StringsKt.compareTo(mod1.getName(), mod2.getName(), true));
    }

    private static final int sortByStatus$lambda$8(ModUIData mod1, ModUIData mod2) {
        Intrinsics.checkNotNullParameter(mod2, "mod2");
        return 10 * (mod2.stateSortWeight() - mod1.stateSortWeight()) + MathKt.getSign(StringsKt.compareTo(mod1.getName(), mod2.getName(), true));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001f\u0010\u000e\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001f\u0010\u0010\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u001f\u0010\u0012\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u001f\u0010\u0014\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/modmanager/ModManagementOptions$Companion;", "", "()V", "installedHeaderText", "", "onlineHeaderText", "sortByDate", "Ljava/util/Comparator;", "Lcom/unciv/ui/screens/modmanager/ModUIData;", "kotlin.jvm.PlatformType", "getSortByDate", "()Ljava/util/Comparator;", "sortByDateDesc", "getSortByDateDesc", "sortByName", "getSortByName", "sortByNameDesc", "getSortByNameDesc", "sortByStars", "getSortByStars", "sortByStatus", "getSortByStatus", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<ModUIData> getSortByName() {
            return sortByName;
        }

        @NotNull
        public final Comparator<ModUIData> getSortByNameDesc() {
            return sortByNameDesc;
        }

        @NotNull
        public final Comparator<ModUIData> getSortByDate() {
            return sortByDate;
        }

        @NotNull
        public final Comparator<ModUIData> getSortByDateDesc() {
            return sortByDateDesc;
        }

        @NotNull
        public final Comparator<ModUIData> getSortByStars() {
            return sortByStars;
        }

        @NotNull
        public final Comparator<ModUIData> getSortByStatus() {
            return sortByStatus;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/modmanager/ModManagementOptions$Filter;", "", "text", "", "topic", "(Ljava/lang/String;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getTopic", "core"})
    public static final class Filter {
        @NotNull
        private final String text;
        @NotNull
        private final String topic;

        public Filter(@NotNull String text2, @NotNull String topic) {
            Intrinsics.checkNotNullParameter(text2, "text");
            Intrinsics.checkNotNullParameter(topic, "topic");
            this.text = text2;
            this.topic = topic;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getTopic() {
            return this.topic;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006j\n\u0012\u0006\b\u0000\u0012\u00020\u0007`\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0000R%\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u00070\u0006j\n\u0012\u0006\b\u0000\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/screens/modmanager/ModManagementOptions$SortType;", "", "label", "", "symbols", "comparator", "Ljava/util/Comparator;", "Lcom/unciv/ui/screens/modmanager/ModUIData;", "Lkotlin/Comparator;", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/Comparator;)V", "getComparator", "()Ljava/util/Comparator;", "getLabel", "()Ljava/lang/String;", "getSymbols", "next", "Name", "NameDesc", "Date", "DateDesc", "Stars", "Status", "Companion", "core"})
    public static final class SortType
    extends Enum<SortType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String label;
        @NotNull
        private final String symbols;
        @NotNull
        private final Comparator<? super ModUIData> comparator;
        public static final /* enum */ SortType Name;
        public static final /* enum */ SortType NameDesc;
        public static final /* enum */ SortType Date;
        public static final /* enum */ SortType DateDesc;
        public static final /* enum */ SortType Stars;
        public static final /* enum */ SortType Status;
        private static final /* synthetic */ SortType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SortType(String label2, String symbols, Comparator<? super ModUIData> comparator) {
            this.label = label2;
            this.symbols = symbols;
            this.comparator = comparator;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String getSymbols() {
            return this.symbols;
        }

        @NotNull
        public final Comparator<? super ModUIData> getComparator() {
            return this.comparator;
        }

        @NotNull
        public final SortType next() {
            return (SortType)((Object)SortType.getEntries().get((this.ordinal() + 1) % SortType.getEntries().size()));
        }

        public static SortType[] values() {
            return (SortType[])$VALUES.clone();
        }

        public static SortType valueOf(String value) {
            return Enum.valueOf(SortType.class, value);
        }

        @NotNull
        public static EnumEntries<SortType> getEntries() {
            return $ENTRIES;
        }

        static {
            Name = new SortType("Name \uffea", "\uffea", Companion.getSortByName());
            NameDesc = new SortType("Name \uffec", "\uffec", Companion.getSortByNameDesc());
            Date = new SortType("Date \uffea", "\u231a\uffea", Companion.getSortByDate());
            DateDesc = new SortType("Date \uffec", "\u231a\uffec", Companion.getSortByDateDesc());
            Stars = new SortType("Stars \uffec", "\u272f\uffec", Companion.getSortByStars());
            Status = new SortType("Status \uffec", "\u25c9\uffec", Companion.getSortByStatus());
            $VALUES = sortTypeArray = new SortType[]{SortType.Name, SortType.NameDesc, SortType.Date, SortType.DateDesc, SortType.Stars, SortType.Status};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/modmanager/ModManagementOptions$SortType$Companion;", "", "()V", "fromSelectBox", "Lcom/unciv/ui/screens/modmanager/ModManagementOptions$SortType;", "selectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "core"})
        @SourceDebugExtension(value={"SMAP\nModManagementOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModManagementOptions.kt\ncom/unciv/ui/screens/modmanager/ModManagementOptions$SortType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n288#2,2:186\n*S KotlinDebug\n*F\n+ 1 ModManagementOptions.kt\ncom/unciv/ui/screens/modmanager/ModManagementOptions$SortType$Companion\n*L\n67#1:186,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final SortType fromSelectBox(@NotNull TranslatedSelectBox selectBox) {
                SortType sortType;
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter(selectBox, "selectBox");
                    String selected = ((TranslatedSelectBox.TranslatedString)selectBox.getSelected()).getValue();
                    Iterable $this$firstOrNull$iv = SortType.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        SortType it = (SortType)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getLabel(), selected)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((sortType = (SortType)v0) == null) {
                    sortType = Name;
                }
                return sortType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

