/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.validation.ModCompatibility;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.newgamescreen.ModCheckboxTable;
import com.unciv.ui.screens.newgamescreen.NewGameModCheckHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00012BK\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!J \u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0010H\u0002J\u0012\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010$H\u0002J\u0006\u0010*\u001a\u00020\rJ\b\u0010+\u001a\u00020\rH\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100-H\u0002J\b\u0010.\u001a\u00020\nH\u0002J\u000e\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\u0004J\u0006\u00101\u001a\u00020\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00180\u0017j\b\u0012\u0004\u0012\u00020\u0018`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "mods", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "initialBaseRuleset", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "isPortrait", "", "onUpdate", "Lkotlin/Function1;", "", "(Ljava/util/LinkedHashSet;Ljava/lang/String;Lcom/unciv/ui/screens/basescreen/BaseScreen;ZLkotlin/jvm/functions/Function1;)V", "baseRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "baseRulesetName", "disableChangeEvents", "expanderPadOther", "", "expanderPadTop", "modWidgets", "Ljava/util/ArrayList;", "Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable$ModWithCheckBox;", "Lkotlin/collections/ArrayList;", "savedModcheckResult", "getSavedModcheckResult", "()Ljava/lang/String;", "setSavedModcheckResult", "(Ljava/lang/String;)V", "changeGameParameters", "newGameParameters", "Lcom/unciv/models/metadata/GameParameters;", "checkBoxChanged", "checkBox", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "changeEvent", "Lcom/badlogic/gdx/scenes/scene2d/utils/ChangeListener$ChangeEvent;", "mod", "deselectIncompatibleMods", "skipCheckBox", "disableAllCheckboxes", "disableIncompatibleMods", "getSelectedMods", "", "runComplexModCheck", "setBaseRuleset", "newBaseRulesetName", "updateSelection", "ModWithCheckBox", "core"})
@SourceDebugExtension(value={"SMAP\nModCheckboxTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModCheckboxTable.kt\ncom/unciv/ui/screens/newgamescreen/ModCheckboxTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n766#2:231\n857#2,2:232\n1045#2:234\n766#2:235\n857#2,2:236\n*S KotlinDebug\n*F\n+ 1 ModCheckboxTable.kt\ncom/unciv/ui/screens/newgamescreen/ModCheckboxTable\n*L\n55#1:231\n55#1:232,2\n59#1:234\n94#1:235\n94#1:236,2\n*E\n"})
public final class ModCheckboxTable
extends Table {
    @NotNull
    private LinkedHashSet<String> mods;
    @NotNull
    private final BaseScreen screen;
    @NotNull
    private final Function1<String, Unit> onUpdate;
    @NotNull
    private String baseRulesetName;
    private Ruleset baseRuleset;
    @NotNull
    private final ArrayList<ModWithCheckBox> modWidgets;
    @Nullable
    private String savedModcheckResult;
    private boolean disableChangeEvents;
    private final float expanderPadTop;
    private final float expanderPadOther;

    /*
     * WARNING - void declaration
     */
    public ModCheckboxTable(@NotNull LinkedHashSet<String> mods, @NotNull String initialBaseRuleset, @NotNull BaseScreen screen, boolean isPortrait, @NotNull Function1<? super String, Unit> onUpdate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(mods, "mods");
        Intrinsics.checkNotNullParameter(initialBaseRuleset, "initialBaseRuleset");
        Intrinsics.checkNotNullParameter(screen, "screen");
        Intrinsics.checkNotNullParameter(onUpdate, "onUpdate");
        this.mods = mods;
        this.screen = screen;
        this.onUpdate = onUpdate;
        this.baseRulesetName = "";
        this.modWidgets = new ArrayList();
        this.expanderPadTop = isPortrait ? 0.0f : 16.0f;
        this.expanderPadOther = isPortrait ? 0.0f : 10.0f;
        Collection<Ruleset> collection = RulesetCache.INSTANCE.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Ruleset it = (Ruleset)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!ModCompatibility.INSTANCE.isExtensionMod(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modRulesets = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = modRulesets;
        boolean $i$f$sortedBy = false;
        for (final Ruleset mod : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Ruleset it = (Ruleset)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Ruleset)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        })) {
            final CheckBox checkBox2 = Scene2dExtensionsKt.toCheckBox$default(mod.getName(), this.mods.contains(mod.getName()), null, 2, null);
            ActivationExtensionsKt.onChange(checkBox2, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

                @Override
                public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                    ChangeListener.ChangeEvent changeEvent = it;
                    Intrinsics.checkNotNull(changeEvent);
                    Ruleset ruleset2 = mod;
                    Intrinsics.checkNotNullExpressionValue(ruleset2, "$mod");
                    if (this.checkBoxChanged(checkBox2, changeEvent, ruleset2)) {
                        onUpdate.invoke(mod.getName());
                    }
                }
            });
            checkBox2.left();
            Collection collection2 = this.modWidgets;
            Intrinsics.checkNotNull(mod);
            collection2.add(new ModWithCheckBox(mod, checkBox2));
        }
        this.setBaseRuleset(initialBaseRuleset);
    }

    public /* synthetic */ ModCheckboxTable(LinkedHashSet linkedHashSet, String string, BaseScreen baseScreen, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(linkedHashSet, string, baseScreen, bl, function1);
    }

    @Nullable
    public final String getSavedModcheckResult() {
        return this.savedModcheckResult;
    }

    public final void setSavedModcheckResult(@Nullable String string) {
        this.savedModcheckResult = string;
    }

    public final void updateSelection() {
        this.savedModcheckResult = null;
        this.disableChangeEvents = true;
        for (ModWithCheckBox mod : this.modWidgets) {
            mod.getWidget().setChecked(this.mods.contains(mod.getMod().getName()));
        }
        this.disableChangeEvents = false;
        this.deselectIncompatibleMods(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setBaseRuleset(@NotNull String newBaseRulesetName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(newBaseRulesetName, "newBaseRulesetName");
        Ruleset ruleset2 = (Ruleset)RulesetCache.INSTANCE.get((Object)newBaseRulesetName);
        if (ruleset2 == null) {
            this.setBaseRuleset(BaseRuleset.Civ_V_GnK.getFullName());
            return;
        }
        Ruleset newBaseRuleset = ruleset2;
        this.baseRulesetName = newBaseRulesetName;
        this.baseRuleset = newBaseRuleset;
        this.savedModcheckResult = null;
        this.clear();
        this.mods.clear();
        Iterable iterable = this.modWidgets;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModWithCheckBox it = (ModWithCheckBox)element$iv$iv;
            boolean bl = false;
            Ruleset ruleset3 = it.getMod();
            Ruleset ruleset4 = this.baseRuleset;
            if (ruleset4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("baseRuleset");
                ruleset4 = null;
            }
            if (!ModCompatibility.INSTANCE.meetsBaseRequirements(ruleset3, ruleset4)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List compatibleMods = (List)destination$iv$iv;
        if (CollectionsKt.none(compatibleMods)) {
            return;
        }
        for (ModWithCheckBox mod : compatibleMods) {
            if (!mod.getWidget().isChecked()) continue;
            ((Collection)this.mods).add(mod.getMod().getName());
        }
        this.add((Actor)new ExpanderTab("Extension mods", 0, null, false, 0.0f, 0.0f, 0.0f, "NewGameExpansionMods", null, null, new Function1<Table, Unit>((List<ModWithCheckBox>)compatibleMods){
            final /* synthetic */ List<ModWithCheckBox> $compatibleMods;
            {
                this.$compatibleMods = $compatibleMods;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Cell cell2 = it.defaults();
                Intrinsics.checkNotNullExpressionValue(cell2, "defaults(...)");
                Scene2dExtensionsKt.pad(cell2, 5.0f, 0.0f);
                for (ModWithCheckBox mod : this.$compatibleMods) {
                    it.add((Actor)mod.getWidget()).row();
                }
            }
        }, 894, null)).pad(this.expanderPadOther).padTop(this.expanderPadTop).growX().row();
        this.disableIncompatibleMods();
        this.runComplexModCheck();
    }

    public final void disableAllCheckboxes() {
        this.disableChangeEvents = true;
        for (ModWithCheckBox mod : this.modWidgets) {
            mod.getWidget().setChecked(false);
        }
        this.mods.clear();
        this.disableChangeEvents = false;
        this.savedModcheckResult = null;
        this.disableIncompatibleMods();
        this.onUpdate.invoke("-");
    }

    private final boolean runComplexModCheck() {
        InputProcessor currentInputProcessor = Gdx.input.getInputProcessor();
        Gdx.input.setInputProcessor(null);
        RulesetErrorList complexModLinkCheck = RulesetCache.checkCombinedModLinks$default(RulesetCache.INSTANCE, this.mods, this.baseRulesetName, false, 4, null);
        if (!complexModLinkCheck.isWarnUser()) {
            this.savedModcheckResult = null;
            Gdx.input.setInputProcessor(currentInputProcessor);
            return false;
        }
        this.savedModcheckResult = RulesetErrorList.getErrorText$default(complexModLinkCheck, false, 1, null);
        NewGameModCheckHelpersKt.showWarnOrErrorToast(complexModLinkCheck, this.screen);
        Gdx.input.setInputProcessor(currentInputProcessor);
        return complexModLinkCheck.isError();
    }

    private final boolean checkBoxChanged(CheckBox checkBox2, ChangeListener.ChangeEvent changeEvent, Ruleset mod) {
        if (this.disableChangeEvents) {
            return false;
        }
        if (checkBox2.isChecked()) {
            RulesetErrorList modLinkErrors = Ruleset.checkModLinks$default(mod, false, 1, null);
            if (modLinkErrors.isError()) {
                NewGameModCheckHelpersKt.showWarnOrErrorToast(modLinkErrors, this.screen);
                changeEvent.cancel();
                return false;
            }
            this.mods.add(mod.getName());
            if (this.runComplexModCheck()) {
                changeEvent.cancel();
                this.mods.remove(mod.getName());
                this.savedModcheckResult = null;
                return false;
            }
        } else {
            this.mods.remove(mod.getName());
            if (this.runComplexModCheck()) {
                changeEvent.cancel();
                this.mods.add(mod.getName());
                this.savedModcheckResult = null;
                return false;
            }
        }
        this.disableIncompatibleMods();
        return true;
    }

    private final void deselectIncompatibleMods(CheckBox skipCheckBox) {
        this.disableChangeEvents = true;
        for (ModWithCheckBox modWidget : this.modWidgets) {
            if (Intrinsics.areEqual(modWidget.getWidget(), skipCheckBox)) continue;
            Ruleset ruleset2 = modWidget.getMod();
            Ruleset ruleset3 = this.baseRuleset;
            if (ruleset3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("baseRuleset");
                ruleset3 = null;
            }
            if (ModCompatibility.INSTANCE.meetsAllRequirements(ruleset2, ruleset3, this.getSelectedMods())) continue;
            modWidget.getWidget().setChecked(false);
            this.mods.remove(modWidget.getMod().getName());
        }
        this.disableChangeEvents = false;
    }

    private final void disableIncompatibleMods() {
        for (ModWithCheckBox modWidget : this.modWidgets) {
            boolean enable;
            Ruleset ruleset2 = modWidget.getMod();
            Ruleset ruleset3 = this.baseRuleset;
            if (ruleset3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("baseRuleset");
                ruleset3 = null;
            }
            if (!(enable = ModCompatibility.INSTANCE.meetsAllRequirements(ruleset2, ruleset3, this.getSelectedMods())) && modWidget.getWidget().isChecked()) {
                modWidget.getWidget().setChecked(false);
            }
            modWidget.getWidget().setDisabled(!enable);
        }
    }

    private final Iterable<Ruleset> getSelectedMods() {
        return SequencesKt.asIterable(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.modWidgets), getSelectedMods.1.INSTANCE), getSelectedMods.2.INSTANCE));
    }

    public final void changeGameParameters(@NotNull GameParameters newGameParameters) {
        Intrinsics.checkNotNullParameter(newGameParameters, "newGameParameters");
        this.mods = newGameParameters.getMods();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable$ModWithCheckBox;", "", "mod", "Lcom/unciv/models/ruleset/Ruleset;", "widget", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "(Lcom/unciv/models/ruleset/Ruleset;Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;)V", "getMod", "()Lcom/unciv/models/ruleset/Ruleset;", "getWidget", "()Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "core"})
    private static final class ModWithCheckBox {
        @NotNull
        private final Ruleset mod;
        @NotNull
        private final CheckBox widget;

        public ModWithCheckBox(@NotNull Ruleset mod, @NotNull CheckBox widget) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(widget, "widget");
            this.mod = mod;
            this.widget = widget;
        }

        @NotNull
        public final Ruleset getMod() {
            return this.mod;
        }

        @NotNull
        public final CheckBox getWidget() {
            return this.widget;
        }
    }
}

