/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.objectdescriptions.TechnologyDescriptions;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0002J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/screens/pickerscreens/TechButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "techName", "", "techManager", "Lcom/unciv/logic/civilization/managers/TechManager;", "isWorldScreen", "", "(Ljava/lang/String;Lcom/unciv/logic/civilization/managers/TechManager;Z)V", "backgroundImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "text", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getText$core", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "turns", "getTurns$core", "addTechEnabledIcons", "", "rightSide", "setButtonColor", "color", "Lcom/badlogic/gdx/graphics/Color;", "core"})
@SourceDebugExtension(value={"SMAP\nTechButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TechButton.kt\ncom/unciv/ui/screens/pickerscreens/TechButton\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,119:1\n1#2:120\n1313#3,2:121\n*S KotlinDebug\n*F\n+ 1 TechButton.kt\ncom/unciv/ui/screens/pickerscreens/TechButton\n*L\n108#1:121,2\n*E\n"})
public final class TechButton
extends Table {
    @NotNull
    private final TechManager techManager;
    @NotNull
    private final Label text;
    @NotNull
    private final Label turns;
    @NotNull
    private final Image backgroundImage;

    /*
     * WARNING - void declaration
     */
    public TechButton(@NotNull String techName, @NotNull TechManager techManager, boolean isWorldScreen) {
        void $this$turns_u24lambda_u241;
        Label $this$text_u24lambda_u240;
        Label label2;
        Intrinsics.checkNotNullParameter(techName, "techName");
        Intrinsics.checkNotNullParameter(techManager, "techManager");
        super(BaseScreen.Companion.getSkin());
        this.techManager = techManager;
        Label label3 = label2 = Scene2dExtensionsKt.toLabel("");
        TechButton techButton = this;
        boolean bl = false;
        $this$text_u24lambda_u240.setWrap(false);
        Scene2dExtensionsKt.setFontSize($this$text_u24lambda_u240, 14);
        $this$text_u24lambda_u240.setAlignment(8);
        $this$text_u24lambda_u240.setEllipsis(true);
        techButton.text = label2;
        $this$text_u24lambda_u240 = label2 = Scene2dExtensionsKt.toLabel("");
        techButton = this;
        boolean bl2 = false;
        Scene2dExtensionsKt.setFontSize((Label)$this$turns_u24lambda_u241, 14);
        $this$turns_u24lambda_u241.setAlignment(16);
        techButton.turns = label2;
        this.setTouchable(Touchable.enabled);
        String path = "TechPickerScreen/TechButton";
        String string = BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape();
        this.backgroundImage = new Image(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), path, string, null, 4, null));
        SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.setBackground(skinStrings.getUiBackground(path, string, Scene2dExtensionsKt.darken(color, 0.3f)));
        this.backgroundImage.toBack();
        this.addActor(this.backgroundImage);
        this.pad(5.0f, 5.0f, 5.0f, 0.0f);
        this.add((Actor)ImageGetter.INSTANCE.getTechIconPortrait(techName, 46.0f)).padRight(5.0f).padLeft(2.0f).left();
        if (isWorldScreen) {
            int techCost = this.techManager.costOfTech(techName);
            int remainingTech = this.techManager.remainingScienceToTech(techName);
            float techThisTurn = this.techManager.getCivInfo().getStats().getStatsForNextTurn().getScience();
            float percentComplete = (float)(techCost - remainingTech) / (float)techCost;
            float percentWillBeComplete = ((float)techCost - ((float)remainingTech - techThisTurn)) / (float)techCost;
            ImageGetter.ProgressBar progressBar = new ImageGetter.ProgressBar(2.0f, 48.0f, true);
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            ImageGetter.ProgressBar progressBar2 = progressBar.setBackground(color2);
            Color color3 = Color.BLUE.cpy();
            Intrinsics.checkNotNullExpressionValue(color3, "cpy(...)");
            ImageGetter.ProgressBar progressBar3 = ImageGetter.ProgressBar.setSemiProgress$default(progressBar2, Scene2dExtensionsKt.brighten(color3, 0.3f), percentWillBeComplete, 0.0f, 4, null);
            Color color4 = Color.BLUE.cpy();
            Intrinsics.checkNotNullExpressionValue(color4, "cpy(...)");
            ImageGetter.ProgressBar progressBar4 = ImageGetter.ProgressBar.setProgress$default(progressBar3, Scene2dExtensionsKt.darken(color4, 0.5f), percentComplete, 0.0f, 4, null);
            Actor actor = progressBar4;
            Color color5 = Color.GRAY.cpy();
            Intrinsics.checkNotNullExpressionValue(color5, "cpy(...)");
            this.add((Actor)Scene2dExtensionsKt.addBorder$default(actor, 1.0f, color5, false, 4, null)).padLeft(0.0f).padRight(5.0f);
        }
        Table rightSide = new Table();
        rightSide.add((Actor)this.text).width(140.0f).top().left().padRight(15.0f);
        rightSide.add((Actor)this.turns).width(40.0f).top().left().padRight(10.0f).row();
        this.addTechEnabledIcons(techName, rightSide);
        Scene2dExtensionsKt.centerY((Actor)rightSide, this);
        this.add((Actor)rightSide).expandX().left();
        this.pack();
        this.backgroundImage.setSize(this.getWidth() - 3.0f, this.getHeight() - 3.0f);
        this.backgroundImage.setAlign(1);
        Scene2dExtensionsKt.center((Actor)this.backgroundImage, this);
        this.pack();
    }

    public /* synthetic */ TechButton(String string, TechManager techManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, techManager, bl);
    }

    @NotNull
    public final Label getText$core() {
        return this.text;
    }

    @NotNull
    public final Label getTurns$core() {
        return this.turns;
    }

    public final void setButtonColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        this.backgroundImage.setColor(color);
        this.pack();
    }

    /*
     * WARNING - void declaration
     */
    private final void addTechEnabledIcons(String techName, Table rightSide) {
        void $this$forEach$iv;
        Color color;
        Table techEnabledIcons = new Table().align(8);
        Color color2 = color = Color.BLACK.cpy();
        String string = BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleSmallShape();
        String string2 = "TechPickerScreen/TechButtonIconsOutline";
        SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
        Table table2 = techEnabledIcons;
        boolean $i$a$-apply-TechButton$addTechEnabledIcons$22 = false;
        $this$addTechEnabledIcons_u24lambda_u242.a = 0.7f;
        Unit unit = Unit.INSTANCE;
        table2.setBackground(skinStrings.getUiBackground(string2, string, color));
        techEnabledIcons.pad(2.0f, 10.0f, 2.0f, 0.0f);
        techEnabledIcons.defaults().padRight(5.0f);
        Civilization civ = this.techManager.getCivInfo();
        Technology technology2 = civ.getGameInfo().getRuleset().getTechnologies().get(techName);
        Intrinsics.checkNotNull(technology2);
        Technology tech = technology2;
        Sequence<Group> $i$a$-apply-TechButton$addTechEnabledIcons$22 = SequencesKt.take(TechnologyDescriptions.INSTANCE.getTechEnabledIcons(tech, civ, 30.0f), 5);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Group it = (Group)element$iv;
            boolean bl = false;
            techEnabledIcons.add((Actor)it);
        }
        rightSide.add((Actor)techEnabledIcons).colspan(2).minWidth(195.0f).prefWidth(195.0f).maxWidth(195.0f).expandX().left().row();
    }
}

