/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.pickerscreens.TechButton;
import com.unciv.utils.Concurrency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0002J\u0010\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0005H\u0002J\b\u0010/\u001a\u00020+H\u0002J\b\u00100\u001a\u00020\u001fH\u0016J\u0016\u00101\u001a\u00020\u001a2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a03H\u0002J0\u00104\u001a\u00020+2\b\u0010.\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00105\u001a\u00020\u00072\b\b\u0002\u00106\u001a\u00020\u00072\b\b\u0002\u00107\u001a\u00020\u0007H\u0002J\u0010\u00108\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0005H\u0002J\b\u00109\u001a\u00020+H\u0002J\b\u0010:\u001a\u00020+H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020#0\"j\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020#`$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0010j\b\u0012\u0004\u0012\u00020\u001a`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/unciv/ui/screens/pickerscreens/TechPickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "centerOnTech", "Lcom/unciv/models/ruleset/tech/Technology;", "freeTechPick", "", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/models/ruleset/tech/Technology;Z)V", "getCivInfo$core", "()Lcom/unciv/logic/civilization/Civilization;", "civTech", "Lcom/unciv/logic/civilization/managers/TechManager;", "currentTechColor", "Lcom/badlogic/gdx/graphics/Color;", "eraLabels", "Ljava/util/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "Lkotlin/collections/ArrayList;", "lines", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "orderIndicators", "queuedTechColor", "researchableTechColor", "researchableTechs", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "researchedFutureTechColor", "researchedTechColor", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "selectedTech", "techNameToButton", "Ljava/util/HashMap;", "Lcom/unciv/ui/screens/pickerscreens/TechButton;", "Lkotlin/collections/HashMap;", "techTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "tempTechsToResearch", "turnsToTech", "", "addConnectingLines", "", "addOrderIndicators", "centerOnTechnology", "tech", "createTechTable", "getCivilopediaRuleset", "getTechProgressLabel", "techs", "", "selectTechnology", "queue", "center", "switchFromWorldScreen", "selectTechnologyForFreeTech", "setButtonsInfo", "tryExit", "core"})
@SourceDebugExtension(value={"SMAP\nTechPickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TechPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/TechPickerScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,468:1\n1#2:469\n766#3:470\n857#3,2:471\n1208#3,2:473\n1238#3,4:475\n766#3:479\n857#3,2:480\n1855#3,2:482\n766#3:484\n857#3,2:485\n1549#3:487\n1620#3,3:488\n*S KotlinDebug\n*F\n+ 1 TechPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/TechPickerScreen\n*L\n59#1:470\n59#1:471,2\n67#1:473,2\n67#1:475,4\n348#1:479\n348#1:480,2\n349#1:482,2\n412#1:484\n412#1:485,2\n427#1:487\n427#1:488,3\n*E\n"})
public final class TechPickerScreen
extends PickerScreen {
    @NotNull
    private final Civilization civInfo;
    private final boolean freeTechPick;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private HashMap<String, TechButton> techNameToButton;
    @Nullable
    private Technology selectedTech;
    @NotNull
    private TechManager civTech;
    @NotNull
    private ArrayList<String> tempTechsToResearch;
    @NotNull
    private Group lines;
    @NotNull
    private Group orderIndicators;
    @NotNull
    private ArrayList<Label> eraLabels;
    @NotNull
    private final Table techTable;
    @NotNull
    private HashSet<String> researchableTechs;
    @NotNull
    private final Color currentTechColor;
    @NotNull
    private final Color researchedTechColor;
    @NotNull
    private final Color researchableTechColor;
    @NotNull
    private final Color queuedTechColor;
    @NotNull
    private final Color researchedFutureTechColor;
    @NotNull
    private final Map<String, String> turnsToTech;

    /*
     * WARNING - void declaration
     */
    public TechPickerScreen(@NotNull Civilization civInfo, @Nullable Technology centerOnTech, boolean freeTechPick) {
        Technology tech;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$orderIndicators_u24lambda_u241;
        Group $this$lines_u24lambda_u240;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        super(false, 1, null);
        this.civInfo = civInfo;
        this.freeTechPick = freeTechPick;
        this.ruleset = this.civInfo.getGameInfo().getRuleset();
        this.techNameToButton = new HashMap();
        this.civTech = this.civInfo.getTech();
        Object object = new Group();
        Group group = object;
        TechPickerScreen techPickerScreen = this;
        boolean bl = false;
        $this$lines_u24lambda_u240.setTransform(false);
        techPickerScreen.lines = object;
        object = new Group();
        $this$lines_u24lambda_u240 = object;
        techPickerScreen = this;
        boolean $i$a$-apply-TechPickerScreen$orderIndicators$22 = false;
        $this$orderIndicators_u24lambda_u241.setTransform(false);
        techPickerScreen.orderIndicators = object;
        this.eraLabels = new ArrayList();
        this.techTable = new Table();
        Set<String> set2 = this.ruleset.getTechnologies().keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        object = set2;
        techPickerScreen = this;
        boolean $i$f$filter = false;
        void $i$a$-apply-TechPickerScreen$orderIndicators$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            if (!this.civTech.canBeResearched(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        techPickerScreen.researchableTechs = CollectionsKt.toHashSet((List)destination$iv$iv);
        this.currentTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/CurrentTechColor", Scene2dExtensionsKt.colorFromRGB(72, 147, 175));
        this.researchedTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/ResearchedTechColor", Scene2dExtensionsKt.colorFromRGB(255, 215, 0));
        this.researchableTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/ResearchableTechColor", Scene2dExtensionsKt.colorFromRGB(28, 170, 0));
        this.queuedTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/QueuedTechColor", Scene2dExtensionsKt.colorFromRGB(14, 92, 86));
        this.researchedFutureTechColor = BaseScreen.Companion.getSkinStrings().getUIColor("TechPickerScreen/ResearchedFutureTechColor", Scene2dExtensionsKt.colorFromRGB(127, 50, 0));
        Collection<Technology> collection = this.ruleset.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        $this$filter$iv = collection;
        techPickerScreen = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Technology bl2 = (Technology)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl3 = false;
            Technology it = (Technology)element$iv$iv;
            String string = it.getName();
            boolean bl4 = false;
            String string2 = this.civTech.turnsToTech(it.getName());
            map2.put(string, string2);
        }
        techPickerScreen.turnsToTech = destination$iv$iv2;
        this.setDefaultCloseAction();
        this.getScrollPane().setOverscroll(false, false);
        ActivationExtensionsKt.onClick(this.getDescriptionLabel(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                if (selectedTech != null) {
                    Technology technology2 = selectedTech;
                    Intrinsics.checkNotNull(technology2);
                    this.openCivilopedia(technology2.makeLink());
                }
            }
        });
        this.tempTechsToResearch = new ArrayList(this.civTech.getTechsToResearch());
        this.createTechTable();
        this.setButtonsInfo();
        this.techTable.addActor(this.lines);
        this.techTable.addActor(this.orderIndicators);
        this.getTopTable().add((Actor)this.techTable);
        this.techTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "TechPickerScreen/Background", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getPickerPane().getBottomTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "TechPickerScreen/BottomTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getRightSideButton().setText(TranslationsKt.tr$default("Pick a tech", false, 1, null));
        ActivationExtensionsKt.onClick(this.getRightSideButton(), UncivSound.Companion.getPaper(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.tryExit();
            }
        });
        Technology technology2 = centerOnTech;
        if (technology2 == null) {
            technology2 = this.civInfo.getTech().currentTechnology();
        }
        if ((tech = technology2) != null) {
            if (this.civInfo.getTech().isResearched(tech.getName()) || this.civInfo.getTech().getTechsToResearch().size() <= 1) {
                TechPickerScreen.selectTechnology$default(this, tech, false, true, false, 8, null);
            } else {
                this.centerOnTechnology(tech);
            }
        } else {
            String firstAvailable = (String)CollectionsKt.firstOrNull((Iterable)this.researchableTechs);
            Technology firstAvailableTech = (Technology)((Map)this.ruleset.getTechnologies()).get(firstAvailable);
            if (firstAvailableTech != null) {
                this.centerOnTechnology(firstAvailableTech);
            }
        }
    }

    public /* synthetic */ TechPickerScreen(Civilization civilization, Technology technology2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            technology2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(civilization, technology2, bl);
    }

    @NotNull
    public final Civilization getCivInfo$core() {
        return this.civInfo;
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.ruleset;
    }

    private final void tryExit() {
        if (this.freeTechPick) {
            Technology technology2 = this.selectedTech;
            Intrinsics.checkNotNull(technology2);
            String freeTech = technology2.getName();
            if (!this.researchableTechs.contains(freeTech)) {
                return;
            }
            Technology technology3 = this.selectedTech;
            Intrinsics.checkNotNull(technology3);
            this.civTech.getFreeTechnology(technology3.getName());
        } else {
            this.civTech.setTechsToResearch(this.tempTechsToResearch);
        }
        this.civTech.updateResearchProgress();
        this.getGame().getSettings().addCompletedTutorialTask("Pick technology");
        this.getGame().popScreen();
    }

    /*
     * WARNING - void declaration
     */
    private final void createTechTable() {
        void var6_23;
        int n;
        int it532;
        for (Label label2 : this.eraLabels) {
            label2.remove();
        }
        this.eraLabels.clear();
        Collection<Technology> collection = this.ruleset.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Collection<Technology> allTechs = collection;
        if (allTechs.isEmpty()) {
            return;
        }
        Iterator iterator2 = ((Iterable)allTechs).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Technology it6225222 = (Technology)iterator2.next();
        boolean bl = false;
        TechColumn techColumn2 = it6225222.getColumn();
        Intrinsics.checkNotNull(techColumn2);
        int it6225222 = techColumn2.getColumnNumber();
        while (iterator2.hasNext()) {
            Technology technology2 = (Technology)iterator2.next();
            boolean bl2 = false;
            TechColumn techColumn3 = technology2.getColumn();
            Intrinsics.checkNotNull(techColumn3);
            int n2 = techColumn3.getColumnNumber();
            if (it6225222 >= n2) continue;
            it6225222 = n2;
        }
        int columns = it6225222 + 1;
        Iterator it6225222 = ((Iterable)allTechs).iterator();
        if (!it6225222.hasNext()) {
            throw new NoSuchElementException();
        }
        Technology technology3 = (Technology)it6225222.next();
        boolean bl2 = false;
        int n3 = technology3.getRow();
        while (it6225222.hasNext()) {
            Technology it532 = (Technology)it6225222.next();
            boolean bl3 = false;
            it532 = it532.getRow();
            if (n >= it532) continue;
            n = it532;
        }
        void rows = n + true;
        int it6225222 = 0;
        Technology[][] technologyArrayArray = new Technology[columns][];
        while (it6225222 < columns) {
            it532 = it6225222++;
            technologyArrayArray[it532] = new Technology[rows];
        }
        Technology[][] techMatrix = technologyArrayArray;
        for (Technology technology4 : allTechs) {
            TechColumn techColumn4 = technology4.getColumn();
            Intrinsics.checkNotNull(techColumn4);
            techMatrix[techColumn4.getColumnNumber()][technology4.getRow() - 1] = technology4;
        }
        LinkedHashMap erasNamesToColumns = new LinkedHashMap();
        for (Technology tech : allTechs) {
            String era2 = tech.era();
            if (!erasNamesToColumns.containsKey(era2)) {
                ((Map)erasNamesToColumns).put(era2, new ArrayList());
            }
            TechColumn techColumn5 = tech.getColumn();
            Intrinsics.checkNotNull(techColumn5);
            int columnNumber = techColumn5.getColumnNumber();
            Object v = erasNamesToColumns.get(era2);
            Intrinsics.checkNotNull(v);
            if (((ArrayList)v).contains(columnNumber)) continue;
            Object v2 = erasNamesToColumns.get(era2);
            Intrinsics.checkNotNull(v2);
            ((ArrayList)v2).add(columnNumber);
        }
        for (Map.Entry tech : ((Map)erasNamesToColumns).entrySet()) {
            Label label2;
            Color color;
            String era3 = (String)tech.getKey();
            ArrayList eraColumns = (ArrayList)tech.getValue();
            int columnSpan = eraColumns.size();
            if (Intrinsics.areEqual(this.civTech.getEra().getName(), era3)) {
                color = this.queuedTechColor;
            } else {
                Era era2 = this.ruleset.getEras().get(era3);
                Intrinsics.checkNotNull(era2);
                color = era2.getEraNumber() < this.civTech.getEra().getEraNumber() ? Scene2dExtensionsKt.colorFromRGB(255, 175, 0) : Color.BLACK.cpy();
            }
            Color color2 = color;
            Table table1 = new Table().pad(1.0f);
            Table table2 = new Table();
            table1.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "General/Border", null, Color.WHITE, 2, null));
            table2.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "General/Border", null, color2, 2, null));
            Label $this$createTechTable_u24lambda_u247 = label2 = Scene2dExtensionsKt.toLabel(era3);
            boolean bl3 = false;
            $this$createTechTable_u24lambda_u247.setAlignment(1);
            Era era4 = this.ruleset.getEras().get(era3);
            Intrinsics.checkNotNull(era4);
            if (era4.getEraNumber() < this.civTech.getEra().getEraNumber()) {
                $this$createTechTable_u24lambda_u247.setColor(Scene2dExtensionsKt.colorFromRGB(120, 46, 16));
            }
            Label label4 = label2;
            this.eraLabels.add(label4);
            table2.add((Actor)label4).growX();
            table1.add((Actor)table2).growX();
            this.techTable.add((Actor)table1).fill().colspan(columnSpan);
        }
        boolean bl4 = false;
        while (var6_23 < rows) {
            this.techTable.row();
            int n4 = ((Object[])techMatrix).length;
            for (int columnIndex = 0; columnIndex < n4; ++columnIndex) {
                Technology tech = techMatrix[columnIndex][var6_23];
                Table table2 = new Table().pad(2.0f).padRight(60.0f).padLeft(20.0f);
                if (var6_23 == false) {
                    table2.padTop(7.0f);
                }
                ArrayList arrayList = (ArrayList)erasNamesToColumns.get(this.civTech.getEra().getName());
                boolean bl5 = arrayList != null ? arrayList.contains(columnIndex) : false;
                if (bl5) {
                    table2.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "TechPickerScreen/Background", null, Scene2dExtensionsKt.darken(this.queuedTechColor, 0.5f), 2, null));
                }
                if (tech == null) {
                    this.techTable.add((Actor)table2).fill();
                    continue;
                }
                TechButton techButton = new TechButton(tech.getName(), this.civTech, false);
                table2.add((Actor)techButton);
                ((Map)this.techNameToButton).put(tech.getName(), techButton);
                ActivationExtensionsKt.onClick(techButton, new Function0<Unit>(this, tech){
                    final /* synthetic */ TechPickerScreen this$0;
                    final /* synthetic */ Technology $tech;
                    {
                        this.this$0 = $receiver;
                        this.$tech = $tech;
                        super(0);
                    }

                    public final void invoke() {
                        TechPickerScreen.selectTechnology$default(this.this$0, this.$tech, false, false, false, 8, null);
                    }
                });
                ActivationExtensionsKt.onRightClick$default(techButton, null, new Function0<Unit>(this, tech){
                    final /* synthetic */ TechPickerScreen this$0;
                    final /* synthetic */ Technology $tech;
                    {
                        this.this$0 = $receiver;
                        this.$tech = $tech;
                        super(0);
                    }

                    public final void invoke() {
                        TechPickerScreen.selectTechnology$default(this.this$0, this.$tech, true, false, false, 8, null);
                    }
                }, 1, null);
                ActivationExtensionsKt.onDoubleClick(techButton, UncivSound.Companion.getPaper(), new Function0<Unit>(this){
                    final /* synthetic */ TechPickerScreen this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        TechPickerScreen.access$tryExit(this.this$0);
                    }
                });
                this.techTable.add((Actor)table2).fillX();
            }
            ++var6_23;
        }
    }

    private final void setButtonsInfo() {
        for (Map.Entry entry : ((Map)this.techNameToButton).entrySet()) {
            String techName = (String)entry.getKey();
            TechButton techButton = (TechButton)entry.getValue();
            boolean isResearched = this.civTech.isResearched(techName);
            Color color = isResearched && !Intrinsics.areEqual(techName, "Future Tech") ? this.researchedTechColor : (isResearched ? this.researchedFutureTechColor : (Intrinsics.areEqual(CollectionsKt.firstOrNull((List)this.tempTechsToResearch), techName) && !this.freeTechPick ? this.currentTechColor : (this.researchableTechs.contains(techName) ? this.researchableTechColor : (this.tempTechsToResearch.contains(techName) ? this.queuedTechColor : Color.BLACK.cpy()))));
            Intrinsics.checkNotNull(color);
            techButton.setButtonColor(color);
            if (isResearched && !Intrinsics.areEqual(techName, "Future Tech")) {
                techButton.getText$core().setColor(Scene2dExtensionsKt.colorFromRGB(154, 98, 16));
            }
            if (!isResearched || Intrinsics.areEqual(techName, "Future Tech")) {
                techButton.getTurns$core().setText(this.turnsToTech.get(techName) + TranslationsKt.tr$default("\u23f3", false, 1, null));
            }
            techButton.getText$core().setText(TranslationsKt.tr(techName, true));
        }
        this.addConnectingLines();
        this.addOrderIndicators();
    }

    /*
     * Unable to fully structure code
     */
    private final void addConnectingLines() {
        this.techTable.pack();
        this.getScrollPane().updateVisualScroll();
        this.lines.clear();
        for (Label eraLabel : this.eraLabels) {
            coords = new Vector2(0.0f, 0.0f);
            eraLabel.localToStageCoordinates(coords);
            this.techTable.stageToLocalCoordinates(coords);
            line = ImageGetter.INSTANCE.getLine(coords.x - 1.0f, coords.y, coords.x - 1.0f, coords.y - 1000.0f, 1.0f);
            var6_10 = var5_7 = Color.GRAY.cpy();
            var21_6 = line;
            $i$a$-apply-TechPickerScreen$addConnectingLines$1 = false;
            $this$addConnectingLines_u24lambda_u248.a = 0.6f;
            var21_6.setColor(var5_7);
            line.toBack();
            this.lines.addActor(line);
        }
        for (Technology tech : this.ruleset.getTechnologies().values()) {
            if (!this.techNameToButton.containsKey(tech.getName())) {
                new ToastPopup("Tech " + tech.getName() + " appears to be missing - perhaps two techs have the same row & column", this, 0L, 4, null);
                continue;
            }
            Intrinsics.checkNotNull(this.techNameToButton.get(tech.getName()));
            for (String prerequisite : tech.getPrerequisites()) {
                if (!this.techNameToButton.containsKey(prerequisite)) {
                    new ToastPopup("Tech " + prerequisite + ". prerequisite of " + tech.getName() + ", appears to be missing - perhaps two techs have the same row & column", this, 0L, 4, null);
                    continue;
                }
                Intrinsics.checkNotNull(this.techNameToButton.get(prerequisite));
                techButtonCoords = new Vector2(0.0f, techButton.getHeight() / (float)2);
                techButton.localToStageCoordinates(techButtonCoords);
                this.techTable.stageToLocalCoordinates(techButtonCoords);
                prerequisiteCoords = new Vector2(prerequisiteButton.getWidth(), prerequisiteButton.getHeight() / (float)2);
                prerequisiteButton.localToStageCoordinates(prerequisiteCoords);
                this.techTable.stageToLocalCoordinates(prerequisiteCoords);
                if (this.civTech.isResearched(tech.getName()) && !tech.isContinuallyResearchable()) {
                    v0 = Color.WHITE.cpy();
                } else {
                    Intrinsics.checkNotNull(prerequisite);
                    v0 = this.civTech.isResearched(prerequisite) != false ? this.researchableTechColor : (this.tempTechsToResearch.contains(tech.getName()) != false ? this.currentTechColor : Color.WHITE.cpy());
                }
                lineColor = v0;
                if (!this.tempTechsToResearch.contains(tech.getName())) ** GOTO lbl-1000
                Intrinsics.checkNotNull(prerequisite);
                if (!this.civTech.isResearched(prerequisite)) {
                    v1 = 4.0f;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = lineSize = 2.0f;
                }
                if (!(techButtonCoords.y == prerequisiteCoords.y)) {
                    r = 6.0f;
                    deltaX = techButtonCoords.x - prerequisiteCoords.x;
                    deltaY = techButtonCoords.y - prerequisiteCoords.y;
                    halfLength = deltaX / 2.0f;
                    $this$addConnectingLines_u24lambda_u249 = var16_28 = ImageGetter.INSTANCE.getWhiteDot();
                    $i$a$-apply-TechPickerScreen$addConnectingLines$line$1 = false;
                    $this$addConnectingLines_u24lambda_u249.setWidth(halfLength - r - lineSize / (float)2);
                    $this$addConnectingLines_u24lambda_u249.setHeight(lineSize);
                    $this$addConnectingLines_u24lambda_u249.setX(prerequisiteCoords.x);
                    $this$addConnectingLines_u24lambda_u249.setY(prerequisiteCoords.y - lineSize / (float)2);
                    line = var16_28;
                    $this$addConnectingLines_u24lambda_u2410 = $this$addConnectingLines_u24lambda_u249 = ImageGetter.INSTANCE.getWhiteDot();
                    $i$a$-apply-TechPickerScreen$addConnectingLines$line1$1 = false;
                    $this$addConnectingLines_u24lambda_u2410.setWidth(halfLength - r - lineSize / (float)2);
                    $this$addConnectingLines_u24lambda_u2410.setHeight(lineSize);
                    $this$addConnectingLines_u24lambda_u2410.setX(techButtonCoords.x - $this$addConnectingLines_u24lambda_u2410.getWidth());
                    $this$addConnectingLines_u24lambda_u2410.setY(techButtonCoords.y - lineSize / (float)2);
                    line1 = $this$addConnectingLines_u24lambda_u249;
                    $this$addConnectingLines_u24lambda_u2411 = $this$addConnectingLines_u24lambda_u2410 = ImageGetter.INSTANCE.getWhiteDot();
                    $i$a$-apply-TechPickerScreen$addConnectingLines$line2$1 = false;
                    $this$addConnectingLines_u24lambda_u2411.setWidth(lineSize);
                    $this$addConnectingLines_u24lambda_u2411.setHeight(Math.abs(deltaY) - (float)2 * r - lineSize);
                    $this$addConnectingLines_u24lambda_u2411.setX(techButtonCoords.x - halfLength - lineSize / (float)2);
                    $this$addConnectingLines_u24lambda_u2411.setY(techButtonCoords.y + (deltaY > 0.0f ? -$this$addConnectingLines_u24lambda_u2411.getHeight() - r - lineSize / (float)2 : r + lineSize / (float)2));
                    line2 = $this$addConnectingLines_u24lambda_u2410;
                    line3 = null;
                    line4 = null;
                    if (deltaY < 0.0f) {
                        line3 = ImageGetter.INSTANCE.getLine(line2.getX() + lineSize / (float)2 + 0.3f, line2.getY() + line2.getHeight() - lineSize / (float)2, line.getX() + line.getWidth() - lineSize / (float)2, line.getY() + lineSize / (float)2 + 0.3f, lineSize);
                        line4 = ImageGetter.INSTANCE.getLine(line2.getX() + lineSize / (float)2 - 0.3f, line2.getY() + lineSize / (float)2, line1.getX() + lineSize / (float)2, line1.getY() + lineSize / (float)2 - 0.3f, lineSize);
                    } else {
                        line3 = ImageGetter.INSTANCE.getLine(line2.getX() + lineSize / (float)2 + 0.3f, line2.getY() + lineSize / (float)2, line.getX() + line.getWidth() - lineSize / (float)2, line.getY() + lineSize / (float)2 - 0.3f, lineSize);
                        line4 = ImageGetter.INSTANCE.getLine(line2.getX() + lineSize / (float)2 - 0.3f, line2.getY() + line2.getHeight() - lineSize / (float)2, line1.getX() + lineSize / (float)2, line1.getY() + lineSize / (float)2 + 0.3f, lineSize);
                    }
                    line.setColor(lineColor);
                    line1.setColor(lineColor);
                    line2.setColor(lineColor);
                    line3.setColor(lineColor);
                    line4.setColor(lineColor);
                    this.lines.addActor(line);
                    this.lines.addActor(line1);
                    this.lines.addActor(line2);
                    this.lines.addActor(line3);
                    this.lines.addActor(line4);
                    continue;
                }
                $this$addConnectingLines_u24lambda_u2412 = var12_22 = ImageGetter.INSTANCE.getWhiteDot();
                $i$a$-apply-TechPickerScreen$addConnectingLines$line$2 = false;
                $this$addConnectingLines_u24lambda_u2412.setWidth(techButtonCoords.x - prerequisiteCoords.x);
                $this$addConnectingLines_u24lambda_u2412.setHeight(lineSize);
                $this$addConnectingLines_u24lambda_u2412.setX(prerequisiteCoords.x);
                $this$addConnectingLines_u24lambda_u2412.setY(prerequisiteCoords.y - lineSize / (float)2);
                line = var12_22;
                line.setColor(lineColor);
                this.lines.addActor(line);
            }
        }
        v2 = this.lines.getChildren();
        Intrinsics.checkNotNullExpressionValue(v2, "getChildren(...)");
        $this$filter$iv = v2;
        $i$f$filter = false;
        techButton = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Actor)element$iv$iv;
            $i$a$-filter-TechPickerScreen$addConnectingLines$2 = false;
            if (!(Intrinsics.areEqual(it.getColor(), this.currentTechColor) != false && Intrinsics.areEqual(it.getColor(), Color.WHITE.cpy()) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (Actor)element$iv;
            $i$a$-forEach-TechPickerScreen$addConnectingLines$3 = false;
            it.toFront();
        }
    }

    private final void addOrderIndicators() {
        this.orderIndicators.clear();
        for (Map.Entry entry : ((Map)this.techNameToButton).entrySet()) {
            String techName = (String)entry.getKey();
            TechButton techButton = (TechButton)entry.getValue();
            Vector2 techButtonCoords = new Vector2(0.0f, techButton.getHeight() / (float)2);
            techButton.localToStageCoordinates(techButtonCoords);
            this.techTable.stageToLocalCoordinates(techButtonCoords);
            if (!this.tempTechsToResearch.contains(techName) || this.tempTechsToResearch.size() <= 1) continue;
            int index = this.tempTechsToResearch.indexOf(techName) + 1;
            Actor actor = Scene2dExtensionsKt.toLabel$default(String.valueOf(index), null, 18, 0, false, 13, null);
            Label $this$addOrderIndicators_u24lambda_u2415 = actor;
            boolean bl = false;
            $this$addOrderIndicators_u24lambda_u2415.setAlignment(1);
            Actor $this$addOrderIndicators_u24lambda_u2416 = actor = Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.surroundWithCircle$default(actor, 28.0f, false, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), null, 10, null), 30.0f, false, null, null, 12, null);
            boolean bl2 = false;
            $this$addOrderIndicators_u24lambda_u2416.setPosition(techButtonCoords.x - $this$addOrderIndicators_u24lambda_u2416.getWidth(), techButtonCoords.y - $this$addOrderIndicators_u24lambda_u2416.getHeight() / (float)2);
            Actor orderIndicator = actor;
            this.orderIndicators.addActor(orderIndicator);
        }
        this.orderIndicators.toFront();
    }

    /*
     * WARNING - void declaration
     */
    private final void selectTechnology(Technology tech, boolean queue, boolean center, boolean switchFromWorldScreen) {
        Iterator iterator2;
        Technology previousSelectedTech = this.selectedTech;
        this.selectedTech = tech;
        Technology technology2 = tech;
        this.getDescriptionLabel().setText(technology2 != null ? technology2.getDescription(this.civInfo) : null);
        if (!switchFromWorldScreen) {
            return;
        }
        if (tech == null) {
            return;
        }
        if (center) {
            this.centerOnTechnology(tech);
        }
        if (this.freeTechPick) {
            this.selectTechnologyForFreeTech(tech);
            this.setButtonsInfo();
            return;
        }
        if (this.civInfo.getGameInfo().getGameParameters().getGodMode() && !this.civInfo.getTech().isResearched(tech.getName()) && Intrinsics.areEqual(this.selectedTech, previousSelectedTech)) {
            TechManager.addTechnology$default(this.civInfo.getTech(), tech.getName(), false, 2, null);
        }
        if (this.civTech.isResearched(tech.getName()) && !tech.isContinuallyResearchable()) {
            this.getRightSideButton().setText(TranslationsKt.tr$default("Pick a tech", false, 1, null));
            Scene2dExtensionsKt.disable(this.getRightSideButton());
            this.setButtonsInfo();
            return;
        }
        if (!GUI.INSTANCE.isAllowedChangeState()) {
            Scene2dExtensionsKt.disable(this.getRightSideButton());
            return;
        }
        List<Technology> pathToTech = this.civTech.getRequiredTechsToDestination(tech);
        for (Technology requiredTech : pathToTech) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = requiredTech.getUniqueObjects();
            boolean $i$f$filter = false;
            Iterator iterator3 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Unique it = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == UniqueType.OnlyAvailable && !Unique.conditionalsApply$default(it, this.civInfo, null, 2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterator2 = ((List)destination$iv$iv).iterator();
            if (!iterator2.hasNext()) continue;
            Unique unique = (Unique)iterator2.next();
            this.getRightSideButton().setText(TranslationsKt.tr$default(unique.getDisplayText(), false, 1, null));
            Scene2dExtensionsKt.disable(this.getRightSideButton());
            return;
        }
        if (queue) {
            for (Technology pathTech : pathToTech) {
                if (this.tempTechsToResearch.contains(pathTech.getName())) continue;
                this.tempTechsToResearch.add(pathTech.getName());
            }
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.tempTechsToResearch.clear();
            Iterable iterable = pathToTech;
            ArrayList<String> arrayList = this.tempTechsToResearch;
            boolean $i$f$map = false;
            iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Technology $i$f$filterTo = (Technology)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            arrayList.addAll((List)destination$iv$iv);
        }
        if (CollectionsKt.any((Iterable)this.tempTechsToResearch)) {
            String label2 = TranslationsKt.tr$default("Research [" + this.tempTechsToResearch.get(0) + ']', false, 1, null);
            String techProgression = this.getTechProgressLabel((List<String>)this.tempTechsToResearch);
            this.pick(label2 + '\n' + techProgression);
        } else {
            this.getRightSideButton().setText(TranslationsKt.tr$default("Unavailable", false, 1, null));
            Scene2dExtensionsKt.disable(this.getRightSideButton());
        }
        this.setButtonsInfo();
    }

    static /* synthetic */ void selectTechnology$default(TechPickerScreen techPickerScreen, Technology technology2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        techPickerScreen.selectTechnology(technology2, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private final String getTechProgressLabel(List<String> techs) {
        int n;
        int n2;
        String string;
        Object object2;
        Iterable iterable = techs;
        int n3 = 0;
        for (Object object2 : iterable) {
            void tech;
            string = (String)object2;
            n2 = n3;
            boolean bl = false;
            n = this.civTech.researchOfTech((String)tech);
            n3 = n2 + n;
        }
        int progress = n3 + this.civTech.getOverflowScience(CollectionsKt.first(techs));
        Iterable iterable2 = techs;
        int n4 = 0;
        object2 = iterable2.iterator();
        while (object2.hasNext()) {
            void tech;
            String bl = string = object2.next();
            n2 = n4;
            boolean bl2 = false;
            n = this.civInfo.getTech().costOfTech((String)tech);
            n4 = n2 + n;
        }
        int techCost = n4;
        return "" + '(' + progress + '/' + techCost + ')';
    }

    private final void centerOnTechnology(Technology tech) {
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, tech, null){
            int label;
            final /* synthetic */ TechPickerScreen this$0;
            final /* synthetic */ Technology $tech;
            {
                this.this$0 = $receiver;
                this.$tech = $tech;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        Group group = (TechButton)TechPickerScreen.access$getTechNameToButton$p(this.this$0).get(this.$tech.getName());
                        if (group != null && (group = group.getParent()) != null) {
                            Group group2 = group;
                            TechPickerScreen techPickerScreen = this.this$0;
                            Group it = group2;
                            boolean bl = false;
                            techPickerScreen.getScrollPane().scrollTo(it.getX(), it.getY(), it.getWidth(), it.getHeight(), true, true);
                            techPickerScreen.getScrollPane().updateVisualScroll();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void selectTechnologyForFreeTech(Technology tech) {
        if (this.researchableTechs.contains(tech.getName())) {
            String label2 = TranslationsKt.tr$default("Pick [" + tech.getName() + "] as free tech", false, 1, null);
            String techProgression = this.getTechProgressLabel(CollectionsKt.listOf(tech.getName()));
            this.pick(label2 + '\n' + techProgression);
        } else {
            this.getRightSideButton().setText(TranslationsKt.tr$default("Pick a free tech", false, 1, null));
            Scene2dExtensionsKt.disable(this.getRightSideButton());
        }
    }

    public static final /* synthetic */ HashMap access$getTechNameToButton$p(TechPickerScreen $this) {
        return $this.techNameToButton;
    }
}

