/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0002J\f\u0010\u0010\u001a\u00020\n*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\n*\u00020\u0011H\u0002J\f\u0010\u0013\u001a\u00020\n*\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/unciv/ui/screens/savescreens/SaveGameScreen;", "Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "(Lcom/unciv/logic/GameInfo;)V", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "gameNameTextField", "Lcom/unciv/ui/components/widgets/UncivTextField;", "copyToClipboardHandler", "", "doubleClickAction", "onExistingSaveSelected", "saveGameFile", "Lcom/badlogic/gdx/files/FileHandle;", "saveGame", "addGameNameField", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "addSaveToCustomLocation", "initRightSideTable", "Companion", "core"})
public final class SaveGameScreen
extends LoadOrSaveScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final UncivTextField gameNameTextField;
    @NotNull
    public static final String nameFieldLabelText = "Saved game name";
    @NotNull
    public static final String savingText = "Saving...";
    @NotNull
    public static final String saveToCustomText = "Save to custom location";

    public SaveGameScreen(@NotNull GameInfo gameInfo2) {
        Intrinsics.checkNotNullParameter(gameInfo2, "gameInfo");
        super("Current saves");
        this.gameInfo = gameInfo2;
        this.gameNameTextField = new UncivTextField(nameFieldLabelText, null, null, 6, null);
        this.setDefaultCloseAction();
        this.initRightSideTable(this.getRightSideTable());
        this.getRightSideButton().setText(TranslationsKt.tr$default("Save game", false, 1, null));
        ActivationExtensionsKt.onActivation(this.getRightSideButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                UncivFiles uncivFiles = this.getGame().getFiles();
                String string = gameNameTextField.getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                if (uncivFiles.getSave(string).exists()) {
                    this.doubleClickAction();
                } else {
                    this.saveGame();
                }
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.getRightSideButton()).add(KeyCharAndCode.Companion.getRETURN());
        Scene2dExtensionsKt.enable(this.getRightSideButton());
    }

    @NotNull
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    private final void initRightSideTable(Table $this$initRightSideTable) {
        this.addGameNameField($this$initRightSideTable);
        TextButton copyJsonButton = Scene2dExtensionsKt.toTextButton$default("Copy to clipboard", null, false, 3, null);
        ActivationExtensionsKt.onActivation(copyJsonButton, new Function0<Unit>(this){
            final /* synthetic */ SaveGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SaveGameScreen.access$copyToClipboardHandler(this.this$0);
            }
        });
        KeyCharAndCode ctrlC = KeyCharAndCode.Companion.ctrl('c');
        ActivationExtensionsKt.getKeyShortcuts(copyJsonButton).add(ctrlC);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)copyJsonButton, ctrlC, 0.0f, 2, null);
        $this$initRightSideTable.add((Actor)copyJsonButton).row();
        this.addSaveToCustomLocation($this$initRightSideTable);
        $this$initRightSideTable.add((Actor)this.getDeleteSaveButton()).row();
        $this$initRightSideTable.add((Actor)this.getShowAutosavesCheckbox()).row();
    }

    private final void addGameNameField(Table $this$addGameNameField) {
        this.gameNameTextField.setTextFieldFilter(SaveGameScreen::addGameNameField$lambda$0);
        String defaultSaveName = TranslationsKt.tr('[' + this.gameInfo.getCurrentPlayer() + "] - [" + this.gameInfo.getTurns() + "] turns", true);
        this.gameNameTextField.setText(defaultSaveName);
        this.gameNameTextField.setSelection(0, defaultSaveName.length());
        $this$addGameNameField.add((Actor)Scene2dExtensionsKt.toLabel(nameFieldLabelText)).row();
        $this$addGameNameField.add((Actor)this.gameNameTextField).width(300.0f).row();
    }

    private final void copyToClipboardHandler() {
        Concurrency.run$default(Concurrency.INSTANCE, "Copy game to clipboard", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SaveGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            Gdx.app.getClipboard().setContents(UncivFiles.Companion.gameInfoToString$default(UncivFiles.Companion, this.this$0.getGameInfo(), Boxing.boxBoolean(true), false, 4, null));
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ SaveGameScreen this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            new ToastPopup("Could not save game to clipboard!", this.this$0, 0L, 4, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void addSaveToCustomLocation(Table $this$addSaveToCustomLocation) {
        TextButton saveToCustomLocation = Scene2dExtensionsKt.toTextButton$default(saveToCustomText, null, false, 3, null);
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        Label errorLabel = Scene2dExtensionsKt.toLabel$default("", color, 0, 0, false, 14, null);
        ActivationExtensionsKt.onClick(saveToCustomLocation, new Function0<Unit>(errorLabel, saveToCustomLocation, this){
            final /* synthetic */ Label $errorLabel;
            final /* synthetic */ TextButton $saveToCustomLocation;
            final /* synthetic */ SaveGameScreen this$0;
            {
                this.$errorLabel = $errorLabel;
                this.$saveToCustomLocation = $saveToCustomLocation;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$errorLabel.setText("");
                this.$saveToCustomLocation.setText(TranslationsKt.tr$default("Saving...", false, 1, null));
                Scene2dExtensionsKt.disable(this.$saveToCustomLocation);
                Concurrency.INSTANCE.runOnNonDaemonThreadPool("Save to custom location", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$errorLabel, this.$saveToCustomLocation, null){
                    int label;
                    final /* synthetic */ SaveGameScreen this$0;
                    final /* synthetic */ Label $errorLabel;
                    final /* synthetic */ TextButton $saveToCustomLocation;
                    {
                        this.this$0 = $receiver;
                        this.$errorLabel = $errorLabel;
                        this.$saveToCustomLocation = $saveToCustomLocation;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                UncivFiles uncivFiles = this.this$0.getGame().getFiles();
                                GameInfo gameInfo2 = this.this$0.getGameInfo();
                                String string = SaveGameScreen.access$getGameNameTextField$p(this.this$0).getText();
                                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                                uncivFiles.saveGameToCustomLocation(gameInfo2, string, new Function0<Unit>(this.this$0){
                                    final /* synthetic */ SaveGameScreen this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.this$0.getGame().popScreen();
                                    }
                                }, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(this.$errorLabel, this.$saveToCustomLocation){
                                    final /* synthetic */ Label $errorLabel;
                                    final /* synthetic */ TextButton $saveToCustomLocation;
                                    {
                                        this.$errorLabel = $errorLabel;
                                        this.$saveToCustomLocation = $saveToCustomLocation;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Exception it) {
                                        Intrinsics.checkNotNullParameter(it, "it");
                                        if (!(it instanceof PlatformSaverLoader.Cancelled)) {
                                            this.$errorLabel.setText(TranslationsKt.tr$default("Could not save game to custom location!", false, 1, null));
                                            it.printStackTrace();
                                        }
                                        this.$saveToCustomLocation.setText(TranslationsKt.tr$default("Save to custom location", false, 1, null));
                                        Scene2dExtensionsKt.enable(this.$saveToCustomLocation);
                                    }
                                });
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            }
        });
        $this$addSaveToCustomLocation.add((Actor)saveToCustomLocation).row();
        $this$addSaveToCustomLocation.add((Actor)errorLabel).row();
    }

    private final void saveGame() {
        this.getRightSideButton().setText(TranslationsKt.tr$default(savingText, false, 1, null));
        Concurrency.INSTANCE.runOnNonDaemonThreadPool("SaveGame", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SaveGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$runOnNonDaemonThreadPool = (CoroutineScope)this.L$0;
                        UncivFiles uncivFiles = this.this$0.getGame().getFiles();
                        GameInfo gameInfo2 = this.this$0.getGameInfo();
                        String string = SaveGameScreen.access$getGameNameTextField$p(this.this$0).getText();
                        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                        uncivFiles.saveGame(gameInfo2, string, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>($this$runOnNonDaemonThreadPool, this.this$0){
                            final /* synthetic */ CoroutineScope $$this$runOnNonDaemonThreadPool;
                            final /* synthetic */ SaveGameScreen this$0;
                            {
                                this.$$this$runOnNonDaemonThreadPool = $$this$runOnNonDaemonThreadPool;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@Nullable Exception it) {
                                ConcurrencyKt.launchOnGLThread$default(this.$$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, this.this$0, null){
                                    int label;
                                    final /* synthetic */ Exception $it;
                                    final /* synthetic */ SaveGameScreen this$0;
                                    {
                                        this.$it = $it;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                if (this.$it != null) {
                                                    new ToastPopup("Could not save game!", this.this$0, 0L, 4, null);
                                                } else {
                                                    UncivGame.Companion.getCurrent().popScreen();
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                            }
                        });
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void onExistingSaveSelected(@NotNull FileHandle saveGameFile) {
        Intrinsics.checkNotNullParameter(saveGameFile, "saveGameFile");
        this.gameNameTextField.setText(saveGameFile.name());
    }

    @Override
    public void doubleClickAction() {
        Popup.open$default(new ConfirmPopup(this, "Overwrite existing file?", "Overwrite", false, null, (Function0)new Function0<Unit>(this){
            final /* synthetic */ SaveGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SaveGameScreen.access$saveGame(this.this$0);
            }
        }, 24, null), false, 1, null);
    }

    private static final boolean addGameNameField$lambda$0(TextField textField, char c) {
        return c != '\\' && c != '/';
    }

    public static final /* synthetic */ void access$copyToClipboardHandler(SaveGameScreen $this) {
        $this.copyToClipboardHandler();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/savescreens/SaveGameScreen$Companion;", "", "()V", "nameFieldLabelText", "", "saveToCustomText", "savingText", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

