/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.RepeatAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.files.UncivFiles;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0014\u0010\u0019\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bJ\u0016\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\u00020\n*\u00020\u00032\u0006\u0010!\u001a\u00020\u000fH\u0002J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00032\u0006\u0010\"\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/unciv/ui/screens/savescreens/VerticalFileListScrollPane;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "existingSavesTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Table;)V", "onChangeListener", "Lkotlin/Function1;", "Lcom/badlogic/gdx/files/FileHandle;", "", "previousSelection", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "savesPerButton", "", "getVerticalSpan", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "onArrowKey", "direction", "", "onChange", "action", "onHomeEndKey", "onPageKey", "selectExistingSave", "textButton", "update", "files", "Lkotlin/sequences/Sequence;", "updateSaveGames", "Lcom/unciv/logic/files/UncivFiles;", "showAutosaves", "", "getButtonAt", "y", "button", "core"})
@SourceDebugExtension(value={"SMAP\nVerticalFileListScrollPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalFileListScrollPane.kt\ncom/unciv/ui/screens/savescreens/VerticalFileListScrollPane\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,151:1\n614#2:152\n*S KotlinDebug\n*F\n+ 1 VerticalFileListScrollPane.kt\ncom/unciv/ui/screens/savescreens/VerticalFileListScrollPane\n*L\n52#1:152\n*E\n"})
public final class VerticalFileListScrollPane
extends AutoScrollPane {
    @NotNull
    private final Table existingSavesTable;
    @NotNull
    private final Map<TextButton, FileHandle> savesPerButton;
    @Nullable
    private TextButton previousSelection;
    @Nullable
    private Function1<? super FileHandle, Unit> onChangeListener;

    public VerticalFileListScrollPane(@NotNull Table existingSavesTable) {
        Intrinsics.checkNotNullParameter(existingSavesTable, "existingSavesTable");
        super((Actor)existingSavesTable, null, 2, null);
        this.existingSavesTable = existingSavesTable;
        this.savesPerButton = new LinkedHashMap();
        ActivationExtensionsKt.getKeyShortcuts(this).add(19, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onArrowKey(-1);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(20, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onArrowKey(1);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(92, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onPageKey(-1);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(93, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onPageKey(1);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(3, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onHomeEndKey(0);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(123, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onHomeEndKey(1);
            }
        });
    }

    public /* synthetic */ VerticalFileListScrollPane(Table table2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            table2 = new Table();
        }
        this(table2);
    }

    public final void onChange(@NotNull Function1<? super FileHandle, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        this.onChangeListener = action2;
    }

    public final void updateSaveGames(@NotNull UncivFiles files2, boolean showAutosaves) {
        Intrinsics.checkNotNullParameter(files2, "files");
        Sequence<FileHandle> $this$sortedByDescending$iv = files2.getSaves(showAutosaves);
        boolean $i$f$sortedByDescending = false;
        this.update(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                FileHandle it = (FileHandle)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (FileHandle)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.lastModified());
            }
        }));
    }

    public final void update(@NotNull Sequence<? extends FileHandle> files2) {
        Intrinsics.checkNotNullParameter(files2, "files");
        this.existingSavesTable.clear();
        this.previousSelection = null;
        Image loadImage = ImageGetter.INSTANCE.getImage("OtherIcons/Load");
        loadImage.setSize(50.0f, 50.0f);
        loadImage.setOrigin(1);
        RepeatAction loadAnimation = Actions.forever(Actions.rotateBy(360.0f, 2.0f));
        loadImage.addAction(loadAnimation);
        this.existingSavesTable.add((Actor)loadImage).size(50.0f).center();
        Concurrency.run$default(Concurrency.INSTANCE, "GetSaves", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(files2, loadAnimation, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Sequence<FileHandle> $files;
            final /* synthetic */ RepeatAction $loadAnimation;
            final /* synthetic */ VerticalFileListScrollPane this$0;
            {
                this.$files = $files;
                this.$loadAnimation = $loadAnimation;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        List<FileHandle> saves = SequencesKt.toList(this.$files);
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$loadAnimation, this.this$0, saves, null){
                            int label;
                            final /* synthetic */ RepeatAction $loadAnimation;
                            final /* synthetic */ VerticalFileListScrollPane this$0;
                            final /* synthetic */ List<FileHandle> $saves;
                            {
                                this.$loadAnimation = $loadAnimation;
                                this.this$0 = $receiver;
                                this.$saves = $saves;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        this.$loadAnimation.reset();
                                        VerticalFileListScrollPane.access$getExistingSavesTable$p(this.this$0).clear();
                                        VerticalFileListScrollPane.access$getSavesPerButton$p(this.this$0).clear();
                                        for (FileHandle saveGameFile : this.$saves) {
                                            TextButton textButton = new TextButton(saveGameFile.name(), BaseScreen.Companion.getSkin());
                                            VerticalFileListScrollPane.access$getSavesPerButton$p(this.this$0).put(textButton, saveGameFile);
                                            ActivationExtensionsKt.onClick(textButton, new Function0<Unit>(this.this$0, textButton){
                                                final /* synthetic */ VerticalFileListScrollPane this$0;
                                                final /* synthetic */ TextButton $textButton;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$textButton = $textButton;
                                                    super(0);
                                                }

                                                public final void invoke() {
                                                    VerticalFileListScrollPane.access$selectExistingSave(this.this$0, this.$textButton);
                                                }
                                            });
                                            VerticalFileListScrollPane.access$getExistingSavesTable$p(this.this$0).add((Actor)textButton).pad(5.0f).row();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void selectExistingSave(TextButton textButton) {
        block2: {
            TextButton textButton2 = this.previousSelection;
            if (textButton2 != null) {
                textButton2.setColor(Color.WHITE);
            }
            textButton.setColor(Color.GREEN);
            this.previousSelection = textButton;
            FileHandle fileHandle = this.savesPerButton.get(textButton);
            if (fileHandle == null) {
                return;
            }
            FileHandle saveGameFile = fileHandle;
            Function1<? super FileHandle, Unit> function1 = this.onChangeListener;
            if (function1 == null) break block2;
            function1.invoke(saveGameFile);
        }
    }

    private final ClosedFloatingPointRange<Float> getVerticalSpan(Table $this$getVerticalSpan, TextButton button) {
        float invertedY = $this$getVerticalSpan.getHeight() - button.getY();
        return RangesKt.rangeTo(invertedY - button.getHeight(), invertedY);
    }

    private final ClosedFloatingPointRange<Float> getVerticalSpan() {
        return RangesKt.rangeTo(this.getScrollY(), this.getScrollY() + this.getHeight());
    }

    private final TextButton getButtonAt(Table $this$getButtonAt, float y) {
        Object t = $this$getButtonAt.getCells().get($this$getButtonAt.getRow($this$getButtonAt.getHeight() - y)).getActor();
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.TextButton");
        return (TextButton)t;
    }

    private final void onArrowKey(int direction) {
        if (this.existingSavesTable.getRows() == 0) {
            return;
        }
        int rowIndex = this.previousSelection == null ? (direction == 1 ? -1 : 0) : this.existingSavesTable.getCell((Actor)this.previousSelection).getRow();
        int it = rowIndex + direction;
        boolean bl = false;
        int newRow = it < 0 ? this.existingSavesTable.getRows() - 1 : (it >= this.existingSavesTable.getRows() ? 0 : it);
        Object t = this.existingSavesTable.getCells().get(newRow).getActor();
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.TextButton");
        TextButton button = (TextButton)t;
        this.selectExistingSave(button);
        ClosedFloatingPointRange<Float> buttonSpan = this.getVerticalSpan(this.existingSavesTable, button);
        ClosedFloatingPointRange<Float> scrollSpan = this.getVerticalSpan();
        if (((Number)buttonSpan.getStart()).floatValue() < ((Number)scrollSpan.getStart()).floatValue()) {
            this.setScrollY(((Number)buttonSpan.getStart()).floatValue());
        }
        if (((Number)buttonSpan.getEndInclusive()).floatValue() > ((Number)scrollSpan.getEndInclusive()).floatValue()) {
            this.setScrollY(((Number)buttonSpan.getEndInclusive()).floatValue() - this.getHeight());
        }
    }

    private final void onPageKey(int direction) {
        float f;
        this.setScrollY(this.getScrollY() + (this.getHeight() - 60.0f) * (float)direction);
        TextButton textButton = this.previousSelection;
        if (textButton == null) {
            return;
        }
        float buttonHeight = textButton.getHeight();
        TextButton textButton2 = this.previousSelection;
        Intrinsics.checkNotNull(textButton2);
        ClosedFloatingPointRange<Float> buttonSpan = this.getVerticalSpan(this.existingSavesTable, textButton2);
        ClosedFloatingPointRange<Float> scrollSpan = this.getVerticalSpan();
        if (((Number)buttonSpan.getStart()).floatValue() < ((Number)scrollSpan.getStart()).floatValue()) {
            f = ((Number)scrollSpan.getStart()).floatValue() + buttonHeight;
        } else if (((Number)buttonSpan.getEndInclusive()).floatValue() > ((Number)scrollSpan.getEndInclusive()).floatValue()) {
            f = ((Number)scrollSpan.getEndInclusive()).floatValue() - buttonHeight;
        } else {
            return;
        }
        float newButtonY = f;
        this.selectExistingSave(this.getButtonAt(this.existingSavesTable, newButtonY));
    }

    private final void onHomeEndKey(int direction) {
        this.setScrollY((float)direction * this.getMaxY());
        if (this.existingSavesTable.getRows() == 0) {
            return;
        }
        int row = (this.existingSavesTable.getRows() - 1) * direction;
        Object t = this.existingSavesTable.getCells().get(row).getActor();
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.TextButton");
        this.selectExistingSave((TextButton)t);
    }

    public VerticalFileListScrollPane() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Table access$getExistingSavesTable$p(VerticalFileListScrollPane $this) {
        return $this.existingSavesTable;
    }

    public static final /* synthetic */ Map access$getSavesPerButton$p(VerticalFileListScrollPane $this) {
        return $this.savesPerButton;
    }

    public static final /* synthetic */ void access$selectExistingSave(VerticalFileListScrollPane $this, TextButton textButton) {
        $this.selectExistingSave(textButton);
    }
}

