/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.OnClickListener;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.victoryscreen.DataPoint;
import com.unciv.ui.screens.victoryscreen.LineChart;
import com.unciv.ui.screens.victoryscreen.RankingType;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCharts;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCivGroup;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001c\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0$0#2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010%\u001a\u00020\u001aH\u0002J\b\u0010&\u001a\u00020\u001aH\u0002J\b\u0010'\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCharts;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "civButtonsScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "civButtonsTable", "controlsColumn", "gameInfo", "Lcom/unciv/logic/GameInfo;", "lineChart", "Lcom/unciv/ui/screens/victoryscreen/LineChart;", "markerIcon", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "rankingType", "Lcom/unciv/ui/screens/victoryscreen/RankingType;", "rankingTypeSelect", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "selectedCiv", "Lcom/unciv/logic/civilization/Civilization;", "viewingCiv", "zoomAtX", "Lkotlin/ranges/IntRange;", "activated", "", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "deactivated", "getLineChartData", "", "Lcom/unciv/ui/screens/victoryscreen/DataPoint;", "update", "updateChart", "updateControls", "core"})
@SourceDebugExtension(value={"SMAP\nVictoryScreenCharts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VictoryScreenCharts.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenCharts\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n1549#2:128\n1620#2,3:129\n1238#2,4:150\n603#3:132\n614#3:133\n1003#3:134\n1037#3,3:135\n1040#3,3:145\n372#4,7:138\n453#4:148\n403#4:149\n76#5:154\n96#5,2:155\n125#5:157\n152#5,3:158\n98#5,3:161\n*S KotlinDebug\n*F\n+ 1 VictoryScreenCharts.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenCharts\n*L\n28#1:128\n28#1:129,3\n109#1:150,4\n76#1:132\n77#1:133\n108#1:134\n108#1:135,3\n108#1:145,3\n108#1:138,7\n109#1:148\n109#1:149\n110#1:154\n110#1:155,2\n111#1:157\n111#1:158,3\n110#1:161,3\n*E\n"})
public final class VictoryScreenCharts
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private RankingType rankingType;
    @NotNull
    private Civilization selectedCiv;
    @NotNull
    private final Civilization viewingCiv;
    @NotNull
    private final TranslatedSelectBox rankingTypeSelect;
    @NotNull
    private final Table civButtonsTable;
    @NotNull
    private final AutoScrollPane civButtonsScroll;
    @NotNull
    private final Table controlsColumn;
    @NotNull
    private final Image markerIcon;
    @NotNull
    private LineChart lineChart;
    @Nullable
    private IntRange zoomAtX;

    /*
     * WARNING - void declaration
     */
    public VictoryScreenCharts(@NotNull WorldScreen worldScreen) {
        void $this$markerIcon_u24lambda_u241;
        void $this$mapTo$iv$iv;
        Image $this$map$iv;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.gameInfo = worldScreen.getGameInfo();
        this.rankingType = RankingType.Score;
        this.selectedCiv = worldScreen.getSelectedCiv();
        this.viewingCiv = worldScreen.getViewingCiv();
        Iterable iterable = RankingType.getEntries();
        VictoryScreenCharts victoryScreenCharts = this;
        boolean $i$f$map22 = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RankingType rankingType = (RankingType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLabel());
        }
        String string = this.rankingType.name();
        Collection collection = (List)destination$iv$iv;
        victoryScreenCharts.rankingTypeSelect = new TranslatedSelectBox(collection, string);
        this.civButtonsTable = new Table();
        this.civButtonsScroll = new AutoScrollPane((Actor)this.civButtonsTable, null, 2, null);
        this.controlsColumn = new Table();
        Image $i$f$map22 = $this$map$iv = ImageGetter.INSTANCE.getImage("OtherIcons/Star");
        victoryScreenCharts = this;
        boolean bl = false;
        $this$markerIcon_u24lambda_u241.setColor(Color.GOLD);
        $this$markerIcon_u24lambda_u241.setAlign(1);
        victoryScreenCharts.markerIcon = $this$map$iv;
        this.lineChart = new LineChart(this.viewingCiv);
        this.civButtonsScroll.setScrollingDisabled(true, false);
        this.civButtonsTable.defaults().space(20.0f).fillX();
        this.controlsColumn.defaults().space(20.0f).fillX();
        this.controlsColumn.add((Actor)this.rankingTypeSelect).right().row();
        this.controlsColumn.add((Actor)this.civButtonsScroll).fillY();
        this.defaults().fill().pad(20.0f);
        this.add((Actor)this.controlsColumn);
        this.updateControls();
        this.add((Actor)this.lineChart).growX().top().padLeft(0.0f);
        OnClickListener onChartClick2 = new OnClickListener(null, new Function3<InputEvent, Float, Float, Unit>(this){
            final /* synthetic */ VictoryScreenCharts this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@Nullable InputEvent inputEvent, float x, float f) {
                VictoryScreenCharts.access$setZoomAtX$p(this.this$0, VictoryScreenCharts.access$getZoomAtX$p(this.this$0) == null ? VictoryScreenCharts.access$getLineChart$p(this.this$0).getTurnAt(x) : null);
                VictoryScreenCharts.access$updateChart(this.this$0);
            }
        }, 0, 0.0f, 13, null);
        this.lineChart.addListener(onChartClick2);
        ActivationExtensionsKt.onChange(this.rankingTypeSelect, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                RankingType rankingType;
                Object v0;
                VictoryScreenCharts victoryScreenCharts;
                block2: {
                    void $this$firstOrNull$iv;
                    Iterable iterable = RankingType.getEntries();
                    VictoryScreenCharts victoryScreenCharts2 = this;
                    victoryScreenCharts = this;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        RankingType it2 = (RankingType)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it2.getLabel(), ((TranslatedSelectBox.TranslatedString)victoryScreenCharts2.rankingTypeSelect.getSelected()).getValue())) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((rankingType = (RankingType)v0) == null) {
                    rankingType = RankingType.Score;
                }
                victoryScreenCharts.rankingType = rankingType;
                this.update();
            }
        });
    }

    private final void update() {
        this.updateControls();
        this.updateChart();
    }

    private final void updateControls() {
        this.civButtonsTable.clear();
        Sequence $this$sortedBy$iv = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.gameInfo.getCivilizations()), updateControls.sortedCivs.1.INSTANCE), (Function1)new Function1<Civilization, VictoryScreen.CivWithStat>(this){
            final /* synthetic */ VictoryScreenCharts this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final VictoryScreen.CivWithStat invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return new VictoryScreen.CivWithStat(it, VictoryScreenCharts.access$getRankingType$p(this.this$0));
            }
        });
        boolean $i$f$sortedBy = false;
        Sequence $this$sortedByDescending$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                VictoryScreen.CivWithStat it = (VictoryScreen.CivWithStat)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getCiv().getCivName());
                it = (VictoryScreen.CivWithStat)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getCiv().getCivName()));
            }
        });
        boolean $i$f$sortedByDescending = false;
        Sequence sortedCivs2 = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                VictoryScreen.CivWithStat it = (VictoryScreen.CivWithStat)b;
                boolean bl = false;
                int n = it.getCiv().isDefeated() ? Integer.MIN_VALUE : it.getValue();
                it = (VictoryScreen.CivWithStat)a;
                Comparable comparable = Integer.valueOf(n);
                bl = false;
                return ComparisonsKt.compareValues(comparable, it.getCiv().isDefeated() ? Integer.MIN_VALUE : it.getValue());
            }
        });
        Iterator iterator2 = sortedCivs2.iterator();
        while (iterator2.hasNext()) {
            VictoryScreen.CivWithStat civEntry = (VictoryScreen.CivWithStat)iterator2.next();
            if (!Intrinsics.areEqual(civEntry.getCiv(), this.selectedCiv)) {
                this.civButtonsTable.add();
            } else {
                this.civButtonsTable.add((Actor)this.markerIcon).size(24.0f).right();
            }
            VictoryScreenCivGroup button = new VictoryScreenCivGroup(civEntry, this.viewingCiv, VictoryScreenCivGroup.DefeatedPlayerStyle.REGULAR);
            button.setTouchable(Touchable.enabled);
            this.civButtonsTable.add((Actor)button).row();
            ActivationExtensionsKt.onClick(button, new Function0<Unit>(this, civEntry){
                final /* synthetic */ VictoryScreenCharts this$0;
                final /* synthetic */ VictoryScreen.CivWithStat $civEntry;
                {
                    this.this$0 = $receiver;
                    this.$civEntry = $civEntry;
                    super(0);
                }

                public final void invoke() {
                    VictoryScreenCharts.access$setSelectedCiv$p(this.this$0, this.$civEntry.getCiv());
                    VictoryScreenCharts.access$update(this.this$0);
                }
            });
        }
        this.civButtonsTable.add().padBottom(20.0f).row();
        this.civButtonsTable.pack();
        this.civButtonsScroll.layout();
    }

    private final void updateChart() {
        this.lineChart.update(this.getLineChartData(this.rankingType), this.selectedCiv);
        Scene2dExtensionsKt.packIfNeeded(this);
    }

    /*
     * WARNING - void declaration
     */
    private final List<DataPoint<Integer>> getLineChartData(RankingType rankingType) {
        void $this$flatMapTo$iv$iv;
        Map $this$mapValuesTo$iv$iv;
        Object object;
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Sequence $this$groupBy$iv = SequencesKt.flatMapIterable(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.gameInfo.getCivilizations()), getLineChartData.1.INSTANCE), (Function1)new Function1<Civilization, List<? extends Pair<? extends Integer, ? extends Pair<? extends Civilization, ? extends Integer>>>>(this, rankingType){
            final /* synthetic */ VictoryScreenCharts this$0;
            final /* synthetic */ RankingType $rankingType;
            {
                this.this$0 = $receiver;
                this.$rankingType = $rankingType;
                super(1);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @NotNull
            public final List<Pair<Integer, Pair<Civilization, Integer>>> invoke(@NotNull Civilization civ) {
                Intrinsics.checkNotNullParameter(civ, "civ");
                var2_2 = civ.getStatsHistory();
                var3_3 /* !! */  = this.this$0;
                $i$f$filterKeys = false;
                result$iv = new LinkedHashMap<K, V>();
                for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                    it = ((Number)entry$iv.getKey()).intValue();
                    $i$a$-filterKeys-VictoryScreenCharts$getLineChartData$2$1 = false;
                    if (VictoryScreenCharts.access$getZoomAtX$p(var3_3 /* !! */ ) == null) ** GOTO lbl-1000
                    Intrinsics.checkNotNull(VictoryScreenCharts.access$getZoomAtX$p(var3_3 /* !! */ ));
                    var11_15 = var10_14.getFirst();
                    v0 = it <= var10_14.getLast() ? var11_15 <= it : false;
                    if (v0) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    if (!v1) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $this$filterKeys$iv = result$iv;
                var3_3 /* !! */  = this.$rankingType;
                $i$f$filterValues = false;
                result$iv = new LinkedHashMap<K, V>();
                for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
                    it = (Map)entry$iv.getValue();
                    $i$a$-filterValues-VictoryScreenCharts$getLineChartData$2$2 = false;
                    if (!it.containsKey(var3_3 /* !! */ )) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                $this$filterValues$iv = result$iv;
                var3_3 /* !! */  = this.$rankingType;
                $i$f$map = false;
                result$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                $i$f$mapTo = false;
                for (Map.Entry<K, V> item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                    var10_14 = item$iv$iv;
                    var14_18 = destination$iv$iv;
                    $i$a$-map-VictoryScreenCharts$getLineChartData$2$3 = false;
                    turn = ((Number)var10_14.getKey()).intValue();
                    data = (Map)var10_14.getValue();
                    var14_18.add(new Pair<Integer, Pair<Civilization, V>>(turn, new Pair<Civilization, V>(civ, MapsKt.getValue(data, var3_3 /* !! */ ))));
                }
                return (List)destination$iv$iv;
            }
        });
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object object2;
            Object element$iv$iv = iterator2.next();
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-VictoryScreenCharts$getLineChartData$52 = false;
            key$iv$iv = ((Number)it2.getFirst()).intValue();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            Pair $i$a$-groupBy-VictoryScreenCharts$getLineChartData$52 = (Pair)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add((Pair)it.getSecond());
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void group;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl3 = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl2 = false;
            Map map2 = MapsKt.toMap((Iterable)group.getValue());
            object.put(k, map2);
        }
        Map $this$flatMap$iv = destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapValuesTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry turn = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            Map $this$map$iv = (Map)turn.getValue();
            boolean $i$f$map = false;
            Map bl3 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Civilization civ = (Civilization)entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                collection.add(new DataPoint<Integer>((Integer)turn.getKey(), value, civ));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(true);
        this.controlsColumn.setHeight(this.getParent().getHeight());
        this.lineChart.setHeight(this.getParent().getHeight());
        this.update();
        this.civButtonsTable.invalidateHierarchy();
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(false);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.DefaultImpls.getFixedContent(this);
    }

    public static final /* synthetic */ RankingType access$getRankingType$p(VictoryScreenCharts $this) {
        return $this.rankingType;
    }

    public static final /* synthetic */ void access$setSelectedCiv$p(VictoryScreenCharts $this, Civilization civilization) {
        $this.selectedCiv = civilization;
    }

    public static final /* synthetic */ IntRange access$getZoomAtX$p(VictoryScreenCharts $this) {
        return $this.zoomAtX;
    }

    public static final /* synthetic */ void access$setZoomAtX$p(VictoryScreenCharts $this, IntRange intRange) {
        $this.zoomAtX = intRange;
    }

    public static final /* synthetic */ LineChart access$getLineChart$p(VictoryScreenCharts $this) {
        return $this.lineChart;
    }

    public static final /* synthetic */ void access$updateChart(VictoryScreenCharts $this) {
        $this.updateChart();
    }
}

