/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fB-\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivGroup;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "civEntry", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$CivWithStat;", "currentPlayer", "Lcom/unciv/logic/civilization/Civilization;", "defeatedPlayerStyle", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivGroup$DefeatedPlayerStyle;", "(Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$CivWithStat;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivGroup$DefeatedPlayerStyle;)V", "civ", "additionalInfo", "", "(Lcom/unciv/logic/civilization/Civilization;Ljava/lang/String;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivGroup$DefeatedPlayerStyle;)V", "separator", "(Lcom/unciv/logic/civilization/Civilization;Ljava/lang/String;Ljava/lang/String;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivGroup$DefeatedPlayerStyle;)V", "Companion", "DefeatedPlayerStyle", "core"})
public final class VictoryScreenCivGroup
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public VictoryScreenCivGroup(@NotNull Civilization civ, @NotNull String separator, @NotNull String additionalInfo, @NotNull Civilization currentPlayer, @NotNull DefeatedPlayerStyle defeatedPlayerStyle) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(additionalInfo, "additionalInfo");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        Intrinsics.checkNotNullParameter((Object)defeatedPlayerStyle, "defeatedPlayerStyle");
        String labelText = currentPlayer.knows(civ) || Intrinsics.areEqual(currentPlayer, civ) || civ.isDefeated() || currentPlayer.isDefeated() ? (((CharSequence)additionalInfo).length() == 0 ? civ.getCivName() : '{' + civ.getCivName() + '}' + separator + '{' + additionalInfo + '}') : "???";
        Triple<Actor, Color, Color> civInfo = Companion.getCivImageAndColors(civ, currentPlayer, defeatedPlayerStyle);
        this.add(civInfo.getFirst()).size(30.0f);
        Color backgroundColor = civInfo.getSecond();
        Color labelColor = civInfo.getThird();
        this.setBackground(BaseScreen.Companion.getSkinStrings().getUiBackground("VictoryScreen/CivGroup", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), backgroundColor));
        Label label2 = Scene2dExtensionsKt.toLabel$default(labelText, labelColor, 0, 0, true, 6, null);
        label2.setAlignment(1);
        this.add((Actor)label2).padLeft(10.0f);
    }

    public VictoryScreenCivGroup(@NotNull VictoryScreen.CivWithStat civEntry, @NotNull Civilization currentPlayer, @NotNull DefeatedPlayerStyle defeatedPlayerStyle) {
        Intrinsics.checkNotNullParameter(civEntry, "civEntry");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        Intrinsics.checkNotNullParameter((Object)defeatedPlayerStyle, "defeatedPlayerStyle");
        this(civEntry.getCiv(), ": ", civEntry.getCiv().isDefeated() ? "" : String.valueOf(civEntry.getValue()), currentPlayer, defeatedPlayerStyle);
    }

    public /* synthetic */ VictoryScreenCivGroup(VictoryScreen.CivWithStat civWithStat, Civilization civilization, DefeatedPlayerStyle defeatedPlayerStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            defeatedPlayerStyle = DefeatedPlayerStyle.GREYED_OUT;
        }
        this(civWithStat, civilization, defeatedPlayerStyle);
    }

    public VictoryScreenCivGroup(@NotNull Civilization civ, @NotNull String additionalInfo, @NotNull Civilization currentPlayer, @NotNull DefeatedPlayerStyle defeatedPlayerStyle) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(additionalInfo, "additionalInfo");
        Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
        Intrinsics.checkNotNullParameter((Object)defeatedPlayerStyle, "defeatedPlayerStyle");
        this(civ, "\n", TranslationsKt.tr$default(additionalInfo, false, 1, null), currentPlayer, defeatedPlayerStyle);
    }

    public /* synthetic */ VictoryScreenCivGroup(Civilization civilization, String string, Civilization civilization2, DefeatedPlayerStyle defeatedPlayerStyle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            defeatedPlayerStyle = DefeatedPlayerStyle.GREYED_OUT;
        }
        this(civilization, string, civilization2, defeatedPlayerStyle);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivGroup$Companion;", "", "()V", "getCivImageAndColors", "Lkotlin/Triple;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lcom/badlogic/gdx/graphics/Color;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "currentPlayer", "defeatedPlayerStyle", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivGroup$DefeatedPlayerStyle;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Triple<Actor, Color, Color> getCivImageAndColors(@NotNull Civilization civ, @NotNull Civilization currentPlayer, @NotNull DefeatedPlayerStyle defeatedPlayerStyle) {
            Intrinsics.checkNotNullParameter(civ, "civ");
            Intrinsics.checkNotNullParameter(currentPlayer, "currentPlayer");
            Intrinsics.checkNotNullParameter((Object)defeatedPlayerStyle, "defeatedPlayerStyle");
            if (civ.isDefeated() && defeatedPlayerStyle == DefeatedPlayerStyle.GREYED_OUT) {
                Image icon = ImageGetter.INSTANCE.getImage("OtherIcons/DisbandUnit");
                Scene2dExtensionsKt.setSize(icon, 30.0f);
                return new Triple<Actor, Color, Color>(icon, Color.LIGHT_GRAY, Color.BLACK);
            }
            if (currentPlayer.isSpectator() || civ.isDefeated() && defeatedPlayerStyle == DefeatedPlayerStyle.REGULAR || Intrinsics.areEqual(currentPlayer, civ) || currentPlayer.knows(civ) || currentPlayer.isDefeated() || currentPlayer.getVictoryManager().hasWon()) {
                return new Triple<Actor, Color, Color>(ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 30.0f), civ.getNation().getOuterColor(), civ.getNation().getInnerColor());
            }
            return new Triple<Actor, Color, Color>(ImageGetter.INSTANCE.getRandomNationPortrait(30.0f), Color.LIGHT_GRAY, Color.BLACK);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivGroup$DefeatedPlayerStyle;", "", "(Ljava/lang/String;I)V", "REGULAR", "GREYED_OUT", "core"})
    public static final class DefeatedPlayerStyle
    extends Enum<DefeatedPlayerStyle> {
        public static final /* enum */ DefeatedPlayerStyle REGULAR = new DefeatedPlayerStyle();
        public static final /* enum */ DefeatedPlayerStyle GREYED_OUT = new DefeatedPlayerStyle();
        private static final /* synthetic */ DefeatedPlayerStyle[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DefeatedPlayerStyle[] values() {
            return (DefeatedPlayerStyle[])$VALUES.clone();
        }

        public static DefeatedPlayerStyle valueOf(String value) {
            return Enum.valueOf(DefeatedPlayerStyle.class, value);
        }

        @NotNull
        public static EnumEntries<DefeatedPlayerStyle> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = defeatedPlayerStyleArray = new DefeatedPlayerStyle[]{DefeatedPlayerStyle.REGULAR, DefeatedPlayerStyle.GREYED_OUT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

