/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.VictoryData;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreenIllustrations;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0003+,-B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J \u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\u0006\u0010 \u001a\u00020\u000bH\u0002J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u00132\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u0019H\u0002J\b\u0010(\u001a\u00020\u0013H\u0002J\u0018\u0010)\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\nH\u0002R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "completionPercentages", "", "Lcom/unciv/logic/civilization/Civilization;", "Lcom/unciv/models/ruleset/Victory;", "", "game", "Lcom/unciv/logic/GameInfo;", "holder", "Lcom/badlogic/gdx/scenes/scene2d/ui/Stack;", "selectedCiv", "selectedVictory", "", "tabs", "Lcom/unciv/ui/components/widgets/TabbedPager;", "victories", "", "activated", "", "index", "caption", "pager", "deactivated", "getImages", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "victory", "getWonOrLostStack", "image", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "text", "color", "Lcom/badlogic/gdx/graphics/Color;", "select", "selectVictory", "victoryCompletePercent", "civ", "Companion", "FadeTo", "ImageWithFixedPrefSize", "core"})
@SourceDebugExtension(value={"SMAP\nVictoryScreenIllustrations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VictoryScreenIllustrations.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n766#2:320\n857#2,2:321\n1045#2:323\n766#2:324\n857#2,2:325\n1271#2,2:327\n1285#2,2:329\n1271#2,2:331\n1285#2,4:333\n1288#2:337\n288#2,2:338\n1774#2,4:340\n1774#2,4:344\n1774#2,4:351\n1774#2,4:355\n1774#2,4:360\n1268#3,3:348\n1#4:359\n*S KotlinDebug\n*F\n+ 1 VictoryScreenIllustrations.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations\n*L\n77#1:320\n77#1:321,2\n78#1:323\n81#1:324\n81#1:325,2\n82#1:327,2\n82#1:329,2\n83#1:331,2\n83#1:333,4\n82#1:337\n110#1:338,2\n233#1:340,4\n234#1:344,4\n241#1:351,4\n248#1:355,4\n250#1:360,4\n240#1:348,3\n*E\n"})
public final class VictoryScreenIllustrations
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameInfo game;
    @NotNull
    private final List<Victory> victories;
    @NotNull
    private final Civilization selectedCiv;
    @NotNull
    private final Map<Civilization, Map<Victory, Integer>> completionPercentages;
    @NotNull
    private final TabbedPager tabs;
    @NotNull
    private final Stack holder;
    @NotNull
    private String selectedVictory;
    private static final float fadeDuration = 1.2f;
    @NotNull
    private static final String basePath = "VictoryIllustrations";
    @NotNull
    private static final String iconPath = "VictoryTypeIcons";
    @NotNull
    private static final List<String> enablingImages;

    /*
     * WARNING - void declaration
     */
    public VictoryScreenIllustrations(@NotNull VictoryScreen parent, @NotNull WorldScreen worldScreen) {
        void $this$associateWith$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(BaseScreen.Companion.getSkin());
        this.game = worldScreen.getGameInfo();
        Iterable iterable = this.game.getEnabledVictories().values();
        VictoryScreenIllustrations victoryScreenIllustrations = this;
        boolean $i$f$filter = false;
        void var5_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Victory)element$iv$iv;
            boolean bl = false;
            if (!VictoryScreenIllustrations.Companion.hasIllustrations((Victory)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        victoryScreenIllustrations.victories = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Victory it = (Victory)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)TranslationsKt.tr(it.getName(), true));
                it = (Victory)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)TranslationsKt.tr(it.getName(), true)));
            }
        });
        this.selectedCiv = worldScreen.getSelectedCiv();
        $this$sortedBy$iv = this.game.getCivilizations();
        victoryScreenIllustrations = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(((Civilization)it).isMajorCiv() && ((Civilization)it).isAlive() || Intrinsics.areEqual(it, this.selectedCiv))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Iterable $this$associateWith$iv2 = this.victories;
            boolean $i$f$associateWith2 = false;
            LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv2, 10)), 16));
            Iterable $this$associateWithTo$iv$iv2 = $this$associateWith$iv2;
            boolean $i$f$associateWithTo2 = false;
            for (Object element$iv$iv2 : $this$associateWithTo$iv$iv2) {
                void civ;
                void it2;
                Victory victory = (Victory)element$iv$iv2;
                Object t2 = element$iv$iv2;
                Map map3 = result$iv2;
                boolean bl2 = false;
                Integer n = this.victoryCompletePercent((Victory)it2, (Civilization)civ);
                map3.put(t2, n);
            }
            Map map4 = result$iv2;
            map2.put(t, map4);
        }
        victoryScreenIllustrations.completionPercentages = result$iv;
        Color color = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
        this.tabs = new TabbedPager(0.0f, 0.0f, 0.0f, 0.0f, 0, null, null, color, 0.0f, null, parent, this.victories.size(), 895, null);
        this.holder = new Stack();
        this.selectedVictory = this.selectVictory();
        this.top();
        this.holder.setTouchable(Touchable.disabled);
        for (Victory victory : this.victories) {
            String iconName = "VictoryTypeIcons/" + victory.getName();
            ImageWithFixedPrefSize icon = VictoryScreenIllustrations.Companion.getImageOrNull(iconName);
            KeyCharAndCode key = new KeyCharAndCode(StringsKt.first(victory.getName()));
            TabbedPager.addPage$default(this.tabs, victory.getName(), this.holder, icon, 20.0f, 0, false, false, key, 0, false, 880, null);
        }
        TabbedPager.selectPage$default(this.tabs, this.selectedVictory, false, 2, null);
        this.add((Actor)this.tabs).top().grow();
    }

    private final void select() {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.victories;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Victory it = (Victory)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), this.selectedVictory)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Victory victory = v0;
        if (victory == null) {
            return;
        }
        Victory victory2 = victory;
        this.tabs.onSelection(null);
        float maxHeight = this.getStage().getHeight() - 265.0f;
        FadeTo fadeAction = new FadeTo(this.holder, this.getImages(victory2), maxHeight);
        this.tabs.replacePage(this.tabs.getActivePage(), (Actor)this.holder);
        this.holder.addAction(fadeAction);
        this.tabs.onSelection((Function3<? super Integer, ? super String, ? super TabbedPager, Unit>)new Function3<Integer, String, TabbedPager, Unit>(this){
            final /* synthetic */ VictoryScreenIllustrations this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(int n, @NotNull String name2, @NotNull TabbedPager tabbedPager) {
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(tabbedPager, "<anonymous parameter 2>");
                VictoryScreenIllustrations.access$setSelectedVictory$p(this.this$0, name2);
                VictoryScreenIllustrations.access$select(this.this$0);
            }
        });
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(true);
        this.select();
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(false);
        this.holder.clear();
    }

    private final String selectVictory() {
        if (this.game.getVictoryData() != null) {
            VictoryData victoryData = this.game.getVictoryData();
            Intrinsics.checkNotNull(victoryData);
            return victoryData.getVictoryType();
        }
        Comparator comparator = new Comparator(this){
            final /* synthetic */ VictoryScreenIllustrations this$0;
            {
                this.this$0 = victoryScreenIllustrations;
            }

            public final int compare(T a, T b) {
                Victory victory = (Victory)b;
                boolean bl = false;
                Object object = (Map)VictoryScreenIllustrations.access$getCompletionPercentages$p(this.this$0).get(VictoryScreenIllustrations.access$getSelectedCiv$p(this.this$0));
                Comparable comparable = object != null && (object = (Integer)object.get(victory)) != null ? (Comparable)object : (Comparable)Integer.valueOf(0);
                victory = (Victory)a;
                Comparable comparable2 = comparable;
                bl = false;
                Object object2 = (Map)VictoryScreenIllustrations.access$getCompletionPercentages$p(this.this$0).get(VictoryScreenIllustrations.access$getSelectedCiv$p(this.this$0));
                return ComparisonsKt.compareValues(comparable2, object2 != null && (object2 = (Integer)object2.get(victory)) != null ? (Comparable)object2 : (Comparable)Integer.valueOf(0));
            }
        };
        Victory victory = (Victory)SequencesKt.firstOrNull(SequencesKt.sortedWith(CollectionsKt.asSequence((Iterable)this.victories), new Comparator(comparator, this){
            final /* synthetic */ Comparator $this_thenByDescending;
            final /* synthetic */ VictoryScreenIllustrations this$0;
            {
                this.$this_thenByDescending = $receiver;
                this.this$0 = victoryScreenIllustrations;
            }

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Object object;
                    Object it;
                    Object object2;
                    boolean bl;
                    Civilization it2;
                    void $this$filterTo$iv$iv;
                    Victory victory = (Victory)b;
                    boolean bl2 = false;
                    Iterable $this$filter$iv = VictoryScreenIllustrations.access$getGame$p(this.this$0).getCivilizations();
                    boolean $i$f$filter22 = false;
                    Object object3 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (Civilization)element$iv$iv;
                        bl = false;
                        if (!(!Intrinsics.areEqual(it2, VictoryScreenIllustrations.access$getSelectedCiv$p(this.this$0)) && it2.isMajorCiv() && it2.isAlive())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterator<T> $i$f$filter22 = ((Iterable)((List)destination$iv$iv)).iterator();
                    if (!$i$f$filter22.hasNext()) {
                        object2 = null;
                    } else {
                        it = (Civilization)$i$f$filter22.next();
                        boolean bl3 = false;
                        it = VictoryScreenIllustrations.access$victoryCompletePercent(this.this$0, victory, (Civilization)it);
                        while ($i$f$filter22.hasNext()) {
                            Object it3 = (Civilization)$i$f$filter22.next();
                            $i$a$-maxOfOrNull-VictoryScreenIllustrations$selectVictory$victory$2$2 = false;
                            if (it.compareTo(it3 = (Comparable)Integer.valueOf(VictoryScreenIllustrations.access$victoryCompletePercent(this.this$0, victory, (Civilization)it3))) >= 0) continue;
                            it = it3;
                        }
                        object2 = it;
                    }
                    Integer n2 = (Integer)object2;
                    victory = (Victory)a;
                    Comparable comparable = n2 != null ? (Comparable)n2 : (Comparable)Integer.valueOf(0);
                    bl2 = false;
                    $this$filter$iv = VictoryScreenIllustrations.access$getGame$p(this.this$0).getCivilizations();
                    boolean $i$f$filter = false;
                    it = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (Civilization)element$iv$iv;
                        bl = false;
                        if (!(!Intrinsics.areEqual(it2, VictoryScreenIllustrations.access$getSelectedCiv$p(this.this$0)) && it2.isMajorCiv() && it2.isAlive())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterator<T> iterator2 = ((Iterable)((List)destination$iv$iv)).iterator();
                    if (!iterator2.hasNext()) {
                        object = null;
                    } else {
                        it = (Civilization)iterator2.next();
                        boolean bl4 = false;
                        object3 = VictoryScreenIllustrations.access$victoryCompletePercent(this.this$0, victory, (Civilization)it);
                        while (iterator2.hasNext()) {
                            Civilization it4 = (Civilization)iterator2.next();
                            $i$a$-maxOfOrNull-VictoryScreenIllustrations$selectVictory$victory$2$2 = false;
                            Comparable comparable2 = Integer.valueOf(VictoryScreenIllustrations.access$victoryCompletePercent(this.this$0, victory, it4));
                            if (object3.compareTo(comparable2) >= 0) continue;
                            object3 = comparable2;
                        }
                        object = object3;
                    }
                    Integer n3 = (Integer)object;
                    n = ComparisonsKt.compareValues(comparable, n3 != null ? (Comparable)n3 : (Comparable)Integer.valueOf(0));
                }
                return n;
            }
        }));
        if (victory == null) {
            victory = CollectionsKt.first(this.victories);
        }
        Victory victory2 = victory;
        return victory2.getName();
    }

    private final int victoryCompletePercent(Victory victory, Civilization civ) {
        int points = 0;
        int total = 0;
        for (Milestone milestone : victory.getMilestoneObjects()) {
            int n;
            boolean completed = milestone.hasBeenCompletedBy(civ);
            MilestoneType milestoneType = milestone.getType();
            switch (milestoneType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[milestoneType.ordinal()]) {
                case 1: {
                    total += victory.getRequiredSpaceshipParts().size();
                    n = civ.getVictoryManager().getCurrentsSpaceshipParts().sumValues();
                    break;
                }
                case 2: {
                    int n2;
                    IsPartOfGameInfoSerialization it;
                    Object element$iv;
                    Iterator iterator2;
                    int count$iv;
                    Object $this$count$iv;
                    boolean $i$f$count;
                    int n3;
                    int n4;
                    int n5 = total;
                    if (this.selectedCiv.hideCivCount()) {
                        n4 = this.game.getGameParameters().getMaxNumberOfPlayers();
                    } else {
                        int n6;
                        Iterable iterable = this.game.getCivilizations();
                        n3 = n5;
                        $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n6 = 0;
                        } else {
                            count$iv = 0;
                            iterator2 = $this$count$iv.iterator();
                            while (iterator2.hasNext()) {
                                element$iv = iterator2.next();
                                it = (Civilization)element$iv;
                                boolean bl = false;
                                if (!((Civilization)it).isMajorCiv() || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n6 = count$iv;
                        }
                        n2 = n6;
                        n5 = n3;
                        n4 = n2;
                    }
                    total = n5 + n4;
                    $this$count$iv = this.game.getCivilizations();
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                        break;
                    }
                    count$iv = 0;
                    iterator2 = $this$count$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        it = (Civilization)element$iv;
                        boolean bl = false;
                        if (!(!Intrinsics.areEqual(it, civ) && ((Civilization)it).isMajorCiv() && civ.knows((Civilization)it) && ((Civilization)it).isDefeated()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                    break;
                }
                case 3: {
                    int n7;
                    int n2;
                    IsPartOfGameInfoSerialization it;
                    int count$iv;
                    Object $this$count$iv;
                    int n3;
                    int n8 = total;
                    if (this.selectedCiv.hideCivCount()) {
                        n7 = this.game.getGameParameters().getMaxNumberOfPlayers();
                    } else {
                        $this$count$iv = this.game.getCities();
                        n3 = n8;
                        boolean $i$f$count = false;
                        count$iv = 0;
                        Iterator iterator3 = $this$count$iv.iterator();
                        while (iterator3.hasNext()) {
                            Object element$iv = iterator3.next();
                            it = (City)element$iv;
                            boolean bl = false;
                            if (!((City)it).isOriginalCapital() || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n2 = count$iv;
                        n8 = n3;
                        n7 = n2;
                    }
                    total = n8 + n7;
                    $this$count$iv = civ.getCities();
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                        break;
                    }
                    count$iv = 0;
                    Iterator iterator4 = $this$count$iv.iterator();
                    while (iterator4.hasNext()) {
                        Object element$iv = iterator4.next();
                        it = (City)element$iv;
                        boolean bl = false;
                        if (!((City)it).isOriginalCapital() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                    break;
                }
                case 4: {
                    total += Integer.parseInt(milestone.getParams().get(0));
                    n = civ.getPolicies().getCompletedBranches().size();
                    break;
                }
                case 5: {
                    Religion religion;
                    int n9;
                    IsPartOfGameInfoSerialization it;
                    int count$iv;
                    Object $this$count$iv = this.game.getCivilizations();
                    int n3 = total;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n9 = 0;
                    } else {
                        count$iv = 0;
                        Iterator iterator5 = $this$count$iv.iterator();
                        while (iterator5.hasNext()) {
                            Object element$iv = iterator5.next();
                            it = (Civilization)element$iv;
                            boolean bl = false;
                            if (!(((Civilization)it).isMajorCiv() && ((Civilization)it).isAlive()) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n9 = count$iv;
                    }
                    int n2 = n9;
                    total = n3 + n2;
                    if (civ.getReligionManager().getReligion() != null) {
                        Religion count$iv2;
                        Religion it2 = count$iv2;
                        boolean bl = false;
                        religion = !it2.isPantheon() ? count$iv2 : null;
                    } else {
                        religion = null;
                    }
                    Religion religion2 = religion;
                    Iterable $this$count$iv2 = this.game.getCivilizations();
                    boolean $i$f$count2 = false;
                    if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                        n = 0;
                        break;
                    }
                    int count$iv3 = 0;
                    for (Object element$iv : $this$count$iv2) {
                        Civilization it3 = (Civilization)element$iv;
                        boolean bl = false;
                        boolean bl2 = religion2 != null && it3.isMajorCiv() && it3.isAlive() && civ.knows(it3) && it3.getReligionManager().isMajorityReligionForCiv(religion2);
                        if (!bl2 || ++count$iv3 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv3;
                    break;
                }
                case 6: {
                    total += this.game.getGameParameters().getMaxTurns();
                    n = RangesKt.coerceAtMost(this.game.getTurns(), this.game.getGameParameters().getMaxTurns());
                    break;
                }
                default: {
                    total += 2;
                    n = completed ? 2 : 0;
                }
            }
            int milestonePoints = n;
            points += milestonePoints;
        }
        return points * 100 / total;
    }

    private final List<Actor> getImages(Victory victory) {
        VictoryData victoryData = this.game.getVictoryData();
        if (victoryData != null) {
            String string;
            VictoryData $this$getImages_u24lambda_u2418 = victoryData;
            boolean bl = false;
            if (Intrinsics.areEqual(victory.getName(), $this$getImages_u24lambda_u2418.getVictoryType()) && Intrinsics.areEqual(this.selectedCiv.getCivName(), $this$getImages_u24lambda_u2418.getWinningCiv())) {
                ImageWithFixedPrefSize image2 = VictoryScreenIllustrations.Companion.getImageOrNull(victory, "Won");
                Image image3 = image2;
                String string2 = victory.getVictoryString();
                Color color = Color.GOLD;
                Intrinsics.checkNotNullExpressionValue(color, "GOLD");
                return this.getWonOrLostStack(image3, string2, color);
            }
            ImageWithFixedPrefSize image4 = VictoryScreenIllustrations.Companion.getImageOrNull(victory, "Lost");
            String string3 = string = victory.getDefeatString();
            Image image5 = image4;
            VictoryScreenIllustrations victoryScreenIllustrations = this;
            boolean bl2 = false;
            boolean bl3 = Intrinsics.areEqual(victory.getName(), $this$getImages_u24lambda_u2418.getVictoryType());
            String string4 = bl3 ? string : null;
            Color color = Color.MAROON;
            Intrinsics.checkNotNullExpressionValue(color, "MAROON");
            return victoryScreenIllustrations.getWonOrLostStack(image5, string4, color);
        }
        List result2 = new ArrayList();
        VictoryScreenIllustrations.Companion.addImageIf(result2, victory, "Background", getImages.2.INSTANCE);
        for (Milestone milestone : victory.getMilestoneObjects()) {
            String element = StringsKt.replace$default(StringsKt.replace$default(milestone.getUniqueDescription(), "[", "", false, 4, null), "]", "", false, 4, null);
            VictoryScreenIllustrations.Companion.addImageIf(result2, victory, element, new Function0<Boolean>(milestone, this){
                final /* synthetic */ Milestone $milestone;
                final /* synthetic */ VictoryScreenIllustrations this$0;
                {
                    this.$milestone = $milestone;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return this.$milestone.hasBeenCompletedBy(VictoryScreenIllustrations.access$getSelectedCiv$p(this.this$0));
                }
            });
            if (milestone.getType() != MilestoneType.AddedSSPartsInCapital) continue;
            block1: for (Map.Entry entry : ((Map)victory.getRequiredSpaceshipPartsAsCounter()).entrySet()) {
                String key = (String)entry.getKey();
                int required = ((Number)entry.getValue()).intValue();
                int built = ((Number)this.selectedCiv.getVictoryManager().getCurrentsSpaceshipParts().get((Object)key)).intValue();
                VictoryScreenIllustrations.Companion.addImageIf(result2, victory, key, new Function0<Boolean>(built){
                    final /* synthetic */ int $built;
                    {
                        this.$built = $built;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return this.$built > 0;
                    }
                });
                int i = 1;
                if (i > required) continue;
                while (true) {
                    VictoryScreenIllustrations.Companion.addImageIf(result2, victory, key + ' ' + i, new Function0<Boolean>(built, i){
                        final /* synthetic */ int $built;
                        final /* synthetic */ int $i;
                        {
                            this.$built = $built;
                            this.$i = $i;
                            super(0);
                        }

                        @NotNull
                        public final Boolean invoke() {
                            return this.$built >= this.$i;
                        }
                    });
                    if (i == required) continue block1;
                    ++i;
                }
            }
        }
        return result2;
    }

    private final List<Actor> getWonOrLostStack(Image image2, String text2, Color color) {
        Object object;
        Object object2 = text2;
        if (object2 != null && (object2 = Scene2dExtensionsKt.toLabel$default((String)object2, color, 24, 4, false, 8, null)) != null) {
            Object object3;
            Object $this$getWonOrLostStack_u24lambda_u2419 = object3 = object2;
            boolean bl = false;
            ((Label)$this$getWonOrLostStack_u24lambda_u2419).setWrap(true);
            object = object3;
        } else {
            object = null;
        }
        Object label2 = object;
        Widget[] widgetArray = new Widget[]{image2, label2};
        return CollectionsKt.listOfNotNull(widgetArray);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.DefaultImpls.getFixedContent(this);
    }

    public static final /* synthetic */ void access$setSelectedVictory$p(VictoryScreenIllustrations $this, String string) {
        $this.selectedVictory = string;
    }

    public static final /* synthetic */ void access$select(VictoryScreenIllustrations $this) {
        $this.select();
    }

    public static final /* synthetic */ Civilization access$getSelectedCiv$p(VictoryScreenIllustrations $this) {
        return $this.selectedCiv;
    }

    public static final /* synthetic */ Map access$getCompletionPercentages$p(VictoryScreenIllustrations $this) {
        return $this.completionPercentages;
    }

    public static final /* synthetic */ int access$victoryCompletePercent(VictoryScreenIllustrations $this, Victory victory, Civilization civ) {
        return $this.victoryCompletePercent(victory, civ);
    }

    public static final /* synthetic */ GameInfo access$getGame$p(VictoryScreenIllustrations $this) {
        return $this.game;
    }

    static {
        String[] stringArray = new String[]{"Won", "Lost", "Background"};
        enablingImages = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J0\u0010\u0016\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u000b*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$Companion;", "", "()V", "basePath", "", "enablingImages", "", "fadeDuration", "", "iconPath", "enablePage", "", "game", "Lcom/unciv/logic/GameInfo;", "enablePage$core", "getImageName", "victory", "Lcom/unciv/models/ruleset/Victory;", "element", "getImageOrNull", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$ImageWithFixedPrefSize;", "name", "addImageIf", "", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "test", "Lkotlin/Function0;", "hasIllustrations", "core"})
    @SourceDebugExtension(value={"SMAP\nVictoryScreenIllustrations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VictoryScreenIllustrations.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n1747#2,3:320\n1747#2,3:323\n*S KotlinDebug\n*F\n+ 1 VictoryScreenIllustrations.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$Companion\n*L\n46#1:320,3\n49#1:323,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean enablePage$core(@NotNull GameInfo game) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(game, "game");
                Iterable $this$any$iv = game.getEnabledVictories().values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Victory it = (Victory)element$iv;
                        boolean bl2 = false;
                        if (!Companion.hasIllustrations(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean hasIllustrations(Victory $this$hasIllustrations) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = enablingImages;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String element = (String)element$iv;
                        boolean bl2 = false;
                        if (!ImageGetter.INSTANCE.imageExists(Companion.getImageName($this$hasIllustrations, element))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final String getImageName(Victory victory, String element) {
            return "VictoryIllustrations/" + victory.getName() + '/' + element;
        }

        private final ImageWithFixedPrefSize getImageOrNull(String name2) {
            return ImageGetter.INSTANCE.imageExists(name2) ? new ImageWithFixedPrefSize(ImageGetter.INSTANCE.getDrawable(name2)) : null;
        }

        private final ImageWithFixedPrefSize getImageOrNull(Victory victory, String element) {
            return this.getImageOrNull(this.getImageName(victory, element));
        }

        private final void addImageIf(List<Actor> $this$addImageIf, Victory victory, String element, Function0<Boolean> test) {
            if (!test.invoke().booleanValue()) {
                return;
            }
            ImageWithFixedPrefSize image2 = this.getImageOrNull(victory, element);
            if (image2 != null) {
                $this$addImageIf.add(image2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tH\u0014J\"\u0010\u0012\u001a\u00020\u000e*\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$FadeTo;", "Lcom/badlogic/gdx/scenes/scene2d/actions/TemporalAction;", "Lcom/badlogic/gdx/utils/Disposable;", "holder", "Lcom/badlogic/gdx/scenes/scene2d/ui/Stack;", "newActors", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "maxHeight", "", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Stack;Ljava/util/List;F)V", "fadeOutFrom", "oldActors", "dispose", "", "end", "update", "percent", "addAndSize", "actors", "core"})
    @SourceDebugExtension(value={"SMAP\nVictoryScreenIllustrations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VictoryScreenIllustrations.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$FadeTo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,319:1\n800#2,11:320\n1855#2,2:331\n*S KotlinDebug\n*F\n+ 1 VictoryScreenIllustrations.kt\ncom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$FadeTo\n*L\n151#1:320,11\n151#1:331,2\n*E\n"})
    private static final class FadeTo
    extends TemporalAction
    implements Disposable {
        @NotNull
        private final Stack holder;
        @NotNull
        private final List<Actor> newActors;
        @Nullable
        private List<? extends Actor> oldActors;
        private final float fadeOutFrom;

        /*
         * WARNING - void declaration
         */
        public FadeTo(@NotNull Stack holder, @NotNull List<? extends Actor> newActors, float maxHeight) {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(holder, "holder");
            Intrinsics.checkNotNullParameter(newActors, "newActors");
            super(1.2f);
            this.holder = holder;
            this.newActors = newActors;
            SnapshotArray<Actor> snapshotArray = this.holder.getChildren();
            Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
            List<? extends Actor> list2 = this.oldActors = CollectionsKt.toList((Iterable)snapshotArray);
            Intrinsics.checkNotNull(list2);
            Object object = CollectionsKt.firstOrNull(list2);
            this.fadeOutFrom = object != null && (object = ((Actor)object).getColor()) != null ? ((Color)object).a : 1.0f;
            Array<Action> array = this.holder.getActions();
            Intrinsics.checkNotNullExpressionValue(array, "getActions(...)");
            Iterable $this$filterIsInstance$iv = array;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FadeTo)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FadeTo it = (FadeTo)element$iv;
                boolean bl = false;
                it.dispose();
            }
            this.addAndSize(this.holder, this.newActors, maxHeight);
            this.holder.invalidateHierarchy();
        }

        @Override
        public void dispose() {
            this.finish();
            this.end();
        }

        @Override
        protected void update(float percent) {
            float alpha = Interpolation.fade.apply(percent);
            for (Actor actor : this.newActors) {
                actor.getColor().a = alpha;
            }
            if (this.oldActors == null) {
                return;
            }
            float oldAlpha = Interpolation.fade.apply(1.0f - percent) * this.fadeOutFrom;
            List<? extends Actor> list2 = this.oldActors;
            Intrinsics.checkNotNull(list2);
            for (Actor actor : list2) {
                actor.getColor().a = oldAlpha;
            }
        }

        @Override
        protected void end() {
            List<? extends Actor> list2 = this.oldActors;
            if (list2 == null) {
                return;
            }
            List<? extends Actor> toRemove = list2;
            this.oldActors = null;
            for (Actor actor : toRemove) {
                this.holder.removeActor(actor);
            }
        }

        private final void addAndSize(Stack $this$addAndSize, List<? extends Actor> actors, float maxHeight) {
            for (Actor actor : actors) {
                actor.getColor().a = 0.0f;
                @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"com/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$FadeTo$addAndSize$Rectangle", "", "region", "Lcom/badlogic/gdx/graphics/g2d/TextureRegion;", "(Lcom/badlogic/gdx/graphics/g2d/TextureRegion;)V", "width", "", "height", "(FF)V", "getHeight", "()F", "setHeight", "(F)V", "getWidth", "setWidth", "core"})
                public final class Rectangle {
                    private float width;
                    private float height;

                    public Rectangle(float width, float height) {
                        this.width = width;
                        this.height = height;
                    }

                    public final float getWidth() {
                        return this.width;
                    }

                    public final void setWidth(float f) {
                        this.width = f;
                    }

                    public final float getHeight() {
                        return this.height;
                    }

                    public final void setHeight(float f) {
                        this.height = f;
                    }

                    public Rectangle(@NotNull TextureRegion region) {
                        Intrinsics.checkNotNullParameter(region, "region");
                        this(region.getRegionWidth(), region.getRegionHeight());
                    }
                }
                Rectangle imageArea = new Rectangle($this$addAndSize.getWidth() - 30.0f, maxHeight - 30.0f);
                if (actor instanceof ImageWithFixedPrefSize) {
                    Drawable drawable = ((ImageWithFixedPrefSize)actor).getDrawable();
                    Intrinsics.checkNotNull(drawable, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable");
                    TextureRegion textureRegion = ((TextureRegionDrawable)drawable).getRegion();
                    Intrinsics.checkNotNullExpressionValue(textureRegion, "getRegion(...)");
                    Rectangle pixelArea = new Rectangle(textureRegion);
                    if (pixelArea.getWidth() * imageArea.getHeight() > imageArea.getWidth() * pixelArea.getHeight()) {
                        imageArea.setHeight(imageArea.getWidth() * pixelArea.getHeight() / pixelArea.getWidth());
                    } else {
                        imageArea.setWidth(imageArea.getHeight() * pixelArea.getWidth() / pixelArea.getHeight());
                    }
                    ((ImageWithFixedPrefSize)actor).setPrefSize(imageArea.getWidth(), imageArea.getHeight());
                }
                actor.setSize(imageArea.getWidth(), imageArea.getHeight());
                $this$addAndSize.add(actor);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations$ImageWithFixedPrefSize;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "drawable", "Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;", "(Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;)V", "prefH", "", "prefW", "getPrefHeight", "getPrefWidth", "setPrefSize", "", "w", "h", "core"})
    private static final class ImageWithFixedPrefSize
    extends Image {
        private float prefW;
        private float prefH;

        public ImageWithFixedPrefSize(@NotNull Drawable drawable) {
            Intrinsics.checkNotNullParameter(drawable, "drawable");
            super(drawable);
            this.prefW = this.getPrefWidth();
            this.prefH = this.getPrefHeight();
        }

        public final void setPrefSize(float w, float h) {
            this.prefW = w;
            this.prefH = h;
        }

        @Override
        public float getPrefWidth() {
            return this.prefW;
        }

        @Override
        public float getPrefHeight() {
            return this.prefH;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MilestoneType.values().length];
            try {
                nArray[MilestoneType.AddedSSPartsInCapital.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.DestroyAllPlayers.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.CaptureAllCapitals.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.CompletePolicyBranches.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.WorldReligion.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.ScoreAfterTimeOut.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

