/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Align;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002J8\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/screens/worldscreen/BackgroundActor;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "background", "Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;", "align", "", "(Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;I)V", "getBackground", "()Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;", "heightMultiplier", "", "noClip", "", "widthMultiplier", "xOffset", "yOffset", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "drawBackground", "x", "y", "w", "h", "hit", "touchable", "core"})
public final class BackgroundActor
extends Actor {
    @NotNull
    private final Drawable background;
    private final float widthMultiplier;
    private final float heightMultiplier;
    private final boolean noClip;
    private final float xOffset;
    private final float yOffset;

    public BackgroundActor(@NotNull Drawable background, int align2) {
        Intrinsics.checkNotNullParameter(background, "background");
        this.background = background;
        this.widthMultiplier = Align.isCenterHorizontal(align2) ? 1.0f : 2.0f;
        this.heightMultiplier = Align.isCenterVertical(align2) ? 1.0f : 2.0f;
        this.noClip = Align.isCenterHorizontal(align2) && Align.isCenterVertical(align2);
        this.xOffset = Align.isLeft(align2) ? 0.5f : 0.0f;
        this.yOffset = Align.isBottom(align2) ? 0.5f : 0.0f;
        this.setTouchable(Touchable.disabled);
    }

    @NotNull
    public final Drawable getBackground() {
        return this.background;
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        if (batch == null) {
            return;
        }
        if (this.noClip) {
            this.drawBackground(batch, parentAlpha);
            return;
        }
        batch.flush();
        if (!this.clipBegin()) {
            return;
        }
        float w = this.getWidth() * this.widthMultiplier;
        float h = this.getHeight() * this.heightMultiplier;
        this.drawBackground(batch, parentAlpha, this.getX() - this.xOffset * w, this.getY() - this.yOffset * h, w, h);
        batch.flush();
        this.clipEnd();
    }

    private final void drawBackground(Batch batch, float parentAlpha) {
        this.drawBackground(batch, parentAlpha, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private final void drawBackground(Batch batch, float parentAlpha, float x, float y, float w, float h) {
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.background.draw(batch, x, y, w, h);
    }
}

