/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.GameInfo;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.worldscreen.RenderEvent;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/screens/worldscreen/RenderEvent;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "event", "Lcom/unciv/models/ruleset/Event;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "onChoice", "Lkotlin/Function1;", "Lcom/unciv/models/ruleset/EventChoice;", "", "(Lcom/unciv/models/ruleset/Event;Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lkotlin/jvm/functions/Function1;)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "isValid", "", "()Z", "getOnChoice", "()Lkotlin/jvm/functions/Function1;", "stageWidth", "", "getStageWidth", "()F", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "addChoice", "choice", "openCivilopedia", "link", "", "core"})
public final class RenderEvent
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final Function1<EventChoice, Unit> onChoice;
    private final boolean isValid;

    /*
     * WARNING - void declaration
     */
    public RenderEvent(@NotNull Event event, @NotNull WorldScreen worldScreen, @NotNull Function1<? super EventChoice, Unit> onChoice) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(onChoice, "onChoice");
        this.worldScreen = worldScreen;
        this.onChoice = onChoice;
        this.defaults().fillX().center().pad(5.0f);
        StateForConditionals stateForConditionals = new StateForConditionals(this.getGameInfo().getCurrentPlayerCiv(), null, null, null, null, null, null, null, null, false, 1022, null);
        Collection<EventChoice> choices = event.getMatchingChoices(stateForConditionals);
        boolean bl = this.isValid = choices != null;
        if (this.isValid) {
            if (((CharSequence)event.getText()).length() > 0) {
                void $this$_init__u24lambda_u240;
                Object object;
                Object object2 = object = new WrappableLabel(event.getText(), this.getStageWidth() * 0.5f, null, 0, false, 28, null);
                RenderEvent renderEvent2 = this;
                boolean bl2 = false;
                $this$_init__u24lambda_u240.setWrap(true);
                $this$_init__u24lambda_u240.setAlignment(1);
                $this$_init__u24lambda_u240.optimizePrefWidth();
                renderEvent2.add((Actor)object).row();
            }
            if (!((Collection)event.getCivilopediaText()).isEmpty()) {
                this.add((Actor)event.renderCivilopediaText(this.getStageWidth() * 0.5f, (Function1<? super String, Unit>)new Function1<String, Unit>((Object)this){

                    @Override
                    public final void invoke(@NotNull String p0) {
                        Intrinsics.checkNotNullParameter(p0, "p0");
                        ((RenderEvent)this.receiver).openCivilopedia(p0);
                    }
                })).row();
            }
            Collection<EventChoice> collection = choices;
            Intrinsics.checkNotNull(collection);
            for (EventChoice choice : collection) {
                this.addChoice(choice);
            }
        }
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    @NotNull
    public final Function1<EventChoice, Unit> getOnChoice() {
        return this.onChoice;
    }

    private final GameInfo getGameInfo() {
        return this.worldScreen.getGameInfo();
    }

    private final float getStageWidth() {
        return this.worldScreen.getStage().getWidth();
    }

    public final boolean isValid() {
        return this.isValid;
    }

    private final void addChoice(EventChoice choice) {
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        TextButton button = Scene2dExtensionsKt.toTextButton$default(choice.getText(), null, false, 3, null);
        ActivationExtensionsKt.onActivation(button, new Function0<Unit>(this, choice){
            final /* synthetic */ RenderEvent this$0;
            final /* synthetic */ EventChoice $choice;
            {
                this.this$0 = $receiver;
                this.$choice = $choice;
                super(0);
            }

            public final void invoke() {
                this.this$0.getOnChoice().invoke(this.$choice);
                this.$choice.triggerChoice(RenderEvent.access$getGameInfo(this.this$0).getCurrentPlayerCiv());
            }
        });
        KeyCharAndCode key = KeyCharAndCode.Companion.parse(choice.getKeyShortcut());
        if (!Intrinsics.areEqual(key, KeyCharAndCode.Companion.getUNKNOWN())) {
            ActivationExtensionsKt.getKeyShortcuts(button).add(key);
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)button, key, 0.0f, 2, null);
        }
        this.add((Actor)button).row();
        Iterable lines2 = SequencesKt.asIterable(SequencesKt.plus(CollectionsKt.asSequence((Iterable)choice.getCivilopediaText()), SequencesKt.map(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)choice.getTriggeredUniqueObjects()), addChoice.lines.1.INSTANCE), addChoice.lines.2.INSTANCE)));
        this.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, lines2, this.getStageWidth() * 0.5f, 0.0f, null, new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                RenderEvent.access$openCivilopedia((RenderEvent)this.receiver, p0);
            }
        }, 12, null)).row();
    }

    private final void openCivilopedia(String link) {
        this.worldScreen.openCivilopedia(link);
    }

    public static final /* synthetic */ GameInfo access$getGameInfo(RenderEvent $this) {
        return $this.getGameInfo();
    }
}

