/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.ExploredRegion;
import com.unciv.logic.map.MapPathing;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.UncivSound;
import com.unciv.models.UnitActionType;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.MapArrowType;
import com.unciv.ui.components.MiscArrowTypes;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActivationTypes;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.ClickableCircle;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileGroupMap;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayerMisc;
import com.unciv.ui.components.tilegroups.layers.UnitSpriteSlot;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.UncivStage;
import com.unciv.ui.screens.overviewscreen.EspionageOverviewScreen;
import com.unciv.ui.screens.worldscreen.UndoHandler;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.bottombar.BattleTableHelpers;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\n\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u000eH\u0016J\u001e\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020>J\u0018\u0010?\u001a\u0002082\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0018H\u0002J\u0016\u0010C\u001a\u0002082\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020+J\u001c\u0010G\u001a\u0002082\u0006\u0010B\u001a\u00020\u00182\n\b\u0002\u0010H\u001a\u0004\u0018\u00010IH\u0002J\u001e\u0010J\u001a\u0002082\f\u0010K\u001a\b\u0012\u0004\u0012\u000200012\u0006\u0010B\u001a\u00020\u0018H\u0002J\u0018\u0010L\u001a\u0002082\u0006\u0010M\u001a\u0002002\u0006\u0010B\u001a\u00020\u0018H\u0002J\u0018\u0010N\u001a\u0002082\u0006\u0010M\u001a\u0002002\u0006\u0010B\u001a\u00020\u0018H\u0002J\r\u0010O\u001a\u000208H\u0000\u00a2\u0006\u0002\bPJ.\u0010Q\u001a\u0002082\u0006\u0010R\u001a\u00020\u00182\u0006\u0010M\u001a\u0002002\u0006\u0010S\u001a\u00020\u00182\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001801H\u0002J\b\u0010U\u001a\u000208H\u0002J\b\u0010V\u001a\u000208H\u0016J\u0018\u0010W\u001a\u0002082\u0006\u0010M\u001a\u0002002\u0006\u0010S\u001a\u00020\u0018H\u0002J\u001a\u0010X\u001a\u0002082\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010[\u001a\u00020\u000eH\u0016J\u0010\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010`\u001a\u00020]2\u0006\u0010^\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020]2\u0006\u0010^\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020]2\u0006\u0010^\u001a\u00020eH\u0002J\u000e\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iJ\u0010\u0010j\u001a\u0002082\u0006\u0010k\u001a\u000200H\u0002J\u001e\u0010l\u001a\u0002082\f\u0010K\u001a\b\u0012\u0004\u0012\u000200012\u0006\u0010S\u001a\u00020\u0018H\u0002J\u000e\u0010m\u001a\u0002082\u0006\u0010B\u001a\u00020\u0018J\u0018\u0010n\u001a\u0002082\u0006\u0010k\u001a\u0002002\u0006\u0010B\u001a\u00020\u0018H\u0002J\b\u0010o\u001a\u000208H\u0016J\u0006\u0010p\u001a\u000208J\u0006\u0010q\u001a\u000208J\u0010\u0010r\u001a\u00020\u000e2\u0006\u0010s\u001a\u00020\u000eH\u0016J\u0010\u0010t\u001a\u00020\u000e2\u0006\u0010u\u001a\u00020\u000eH\u0016J.\u0010v\u001a\u00020g2\u0006\u0010w\u001a\u00020x2\b\b\u0002\u0010y\u001a\u00020g2\b\b\u0002\u0010z\u001a\u00020g2\n\b\u0002\u0010{\u001a\u0004\u0018\u000100J\b\u0010|\u001a\u000208H\u0002J\u0018\u0010}\u001a\u0002082\u0006\u0010M\u001a\u0002002\u0006\u0010S\u001a\u00020\u0018H\u0002JJ\u0010~\u001a\u0002082\r\u0010\u007f\u001a\t\u0012\u0004\u0012\u0002000\u0080\u00012\u000e\u0010\u0081\u0001\u001a\t\u0012\u0004\u0012\u0002000\u0080\u00012\u001b\u0010\u0082\u0001\u001a\u0016\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020x\u0012\u0004\u0012\u00020x0\u0083\u00010\u0080\u0001H\u0000\u00a2\u0006\u0003\b\u0084\u0001J\u0012\u0010\u0085\u0001\u001a\u0002082\u0007\u0010\u0086\u0001\u001a\u00020\u000eH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082.\u00a2\u0006\u0002\n\u0000R-\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020!0#j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020!`$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R$\u0010)\u001a\u0012\u0012\u0004\u0012\u00020+0*j\b\u0012\u0004\u0012\u00020+`,X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R<\u0010/\u001a*\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0018010#j\u0014\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001801`$X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010&RF\u00103\u001a4\u0012\u0004\u0012\u000200\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180*0#j\u001e\u0012\u0004\u0012\u000200\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00180*j\b\u0012\u0004\u0012\u00020\u0018`,`$X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006\u008c\u0001"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "tileMap", "Lcom/unciv/logic/map/TileMap;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lcom/unciv/logic/map/TileMap;)V", "blinkAction", "Lcom/badlogic/gdx/scenes/scene2d/Action;", "getBlinkAction", "()Lcom/badlogic/gdx/scenes/scene2d/Action;", "setBlinkAction", "(Lcom/badlogic/gdx/scenes/scene2d/Action;)V", "buttonSize", "", "getButtonSize", "()F", "currentTileSetStrings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "getCurrentTileSetStrings", "()Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "setCurrentTileSetStrings", "(Lcom/unciv/ui/components/tilegroups/TileSetStrings;)V", "selectedTile", "Lcom/unciv/logic/map/tile/Tile;", "getSelectedTile$core", "()Lcom/unciv/logic/map/tile/Tile;", "setSelectedTile$core", "(Lcom/unciv/logic/map/tile/Tile;)V", "smallerCircleSizes", "getSmallerCircleSizes", "tileGroupMap", "Lcom/unciv/ui/components/tilegroups/TileGroupMap;", "Lcom/unciv/ui/components/tilegroups/WorldTileGroup;", "tileGroups", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getTileGroups", "()Ljava/util/HashMap;", "getTileMap$core", "()Lcom/unciv/logic/map/TileMap;", "unitActionOverlays", "Ljava/util/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/collections/ArrayList;", "getUnitActionOverlays$core", "()Ljava/util/ArrayList;", "unitConnectRoadPaths", "Lcom/unciv/logic/map/mapunit/MapUnit;", "", "getUnitConnectRoadPaths$core", "unitMovementPaths", "getUnitMovementPaths$core", "getWorldScreen$core", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "act", "", "delta", "addArrow", "fromTile", "toTile", "arrowType", "Lcom/unciv/ui/components/MapArrowType;", "addMovingSpyOverlay", "spy", "Lcom/unciv/models/Spy;", "tile", "addOverlayOnTileGroup", "group", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "actor", "addTileOverlays", "buttonDto", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$ButtonDto;", "addTileOverlaysWithUnitMovement", "selectedUnits", "addTileOverlaysWithUnitRoadConnecting", "selectedUnit", "addTileOverlaysWithUnitSwapping", "addTiles", "addTiles$core", "animateMovement", "previousTile", "targetTile", "pathToTile", "clampCityButtonSize", "clear", "connectRoadToTargetTile", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "getConnectRoadButton", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "dto", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$ConnectRoadButtonDto;", "getMoveHereButton", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$MoveHereButtonDto;", "getMoveSpyButton", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$MoveSpyButtonDto;", "getSwapWithButton", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$SwapWithButtonDto;", "isMapRevealEnabled", "", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "markUnitMoveTutorialComplete", "unit", "moveUnitToTargetTile", "onTileClicked", "onTileRightClicked", "reloadMaxZoom", "removeUnitActionOverlay", "resetArrows", "restrictX", "deltaX", "restrictY", "deltaY", "setCenterPosition", "vector", "Lcom/badlogic/gdx/math/Vector2;", "immediately", "selectUnit", "forceSelectUnit", "setupZoomPanListeners", "swapMoveUnitToTargetTile", "updateMovementOverlay", "pastVisibleUnits", "Lkotlin/sequences/Sequence;", "targetVisibleUnits", "visibleAttacks", "Lkotlin/Pair;", "updateMovementOverlay$core", "zoom", "zoomScale", "ButtonDto", "ConnectRoadButtonDto", "MoveHereButtonDto", "MoveSpyButtonDto", "SwapWithButtonDto", "core"})
@SourceDebugExtension(value={"SMAP\nWorldMapHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldMapHolder.kt\ncom/unciv/ui/screens/worldscreen/WorldMapHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,864:1\n1549#2:865\n1620#2,3:866\n1747#2,3:871\n1747#2,3:874\n1747#2,3:877\n288#2,2:880\n1549#2:883\n1620#2,3:884\n1726#2,3:889\n766#2:892\n857#2,2:893\n288#2,2:895\n1224#3,2:869\n1#4:882\n37#5,2:887\n*S KotlinDebug\n*F\n+ 1 WorldMapHolder.kt\ncom/unciv/ui/screens/worldscreen/WorldMapHolder\n*L\n118#1:865\n118#1:866,3\n173#1:871,3\n175#1:874,3\n183#1:877,3\n244#1:880,2\n360#1:883\n360#1:884,3\n556#1:889,3\n580#1:892\n580#1:893,2\n748#1:895,2\n151#1:869,2\n366#1:887,2\n*E\n"})
public final class WorldMapHolder
extends ZoomableScrollPane {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final TileMap tileMap;
    @Nullable
    private Tile selectedTile;
    @NotNull
    private final HashMap<Tile, WorldTileGroup> tileGroups;
    @NotNull
    private final ArrayList<Actor> unitActionOverlays;
    @NotNull
    private final HashMap<MapUnit, ArrayList<Tile>> unitMovementPaths;
    @NotNull
    private final HashMap<MapUnit, List<Tile>> unitConnectRoadPaths;
    private TileGroupMap<WorldTileGroup> tileGroupMap;
    public TileSetStrings currentTileSetStrings;
    private final float buttonSize;
    private final float smallerCircleSizes;
    @Nullable
    private Action blinkAction;

    public WorldMapHolder(@NotNull WorldScreen worldScreen, @NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        super(20.0f, 20.0f, 0.0f, 0.0f, 12, null);
        this.worldScreen = worldScreen;
        this.tileMap = tileMap;
        this.tileGroups = new HashMap();
        this.unitActionOverlays = new ArrayList();
        this.unitMovementPaths = new HashMap();
        this.unitConnectRoadPaths = new HashMap();
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            this.setFlingTime(0.0f);
        }
        this.setContinuousScrollingX(this.tileMap.getMapParameters().getWorldWrap());
        this.setupZoomPanListeners();
        this.buttonSize = 60.0f;
        this.smallerCircleSizes = 25.0f;
    }

    @NotNull
    public final WorldScreen getWorldScreen$core() {
        return this.worldScreen;
    }

    @NotNull
    public final TileMap getTileMap$core() {
        return this.tileMap;
    }

    @Nullable
    public final Tile getSelectedTile$core() {
        return this.selectedTile;
    }

    public final void setSelectedTile$core(@Nullable Tile tile) {
        this.selectedTile = tile;
    }

    @NotNull
    public final HashMap<Tile, WorldTileGroup> getTileGroups() {
        return this.tileGroups;
    }

    @NotNull
    public final ArrayList<Actor> getUnitActionOverlays$core() {
        return this.unitActionOverlays;
    }

    @NotNull
    public final HashMap<MapUnit, ArrayList<Tile>> getUnitMovementPaths$core() {
        return this.unitMovementPaths;
    }

    @NotNull
    public final HashMap<MapUnit, List<Tile>> getUnitConnectRoadPaths$core() {
        return this.unitConnectRoadPaths;
    }

    @NotNull
    public final TileSetStrings getCurrentTileSetStrings() {
        TileSetStrings tileSetStrings = this.currentTileSetStrings;
        if (tileSetStrings != null) {
            return tileSetStrings;
        }
        Intrinsics.throwUninitializedPropertyAccessException("currentTileSetStrings");
        return null;
    }

    public final void setCurrentTileSetStrings(@NotNull TileSetStrings tileSetStrings) {
        Intrinsics.checkNotNullParameter(tileSetStrings, "<set-?>");
        this.currentTileSetStrings = tileSetStrings;
    }

    private final void setupZoomPanListeners() {
        this.setOnPanStartListener(new Function0<Unit>(this){
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorldMapHolder.access$setupZoomPanListeners$setActHit(this.this$0);
            }
        });
        this.setOnPanStopListener(new Function0<Unit>(this){
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorldMapHolder.access$setupZoomPanListeners$setActHit(this.this$0);
            }
        });
        this.setOnZoomStartListener(new Function0<Unit>(this){
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorldMapHolder.access$setupZoomPanListeners$setActHit(this.this$0);
            }
        });
        this.setOnZoomStopListener(new Function0<Unit>(this){
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorldMapHolder.access$setupZoomPanListeners$setActHit(this.this$0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final void addTiles$core() {
        void $this$mapTo$iv$iv;
        TileSetStrings tileSetStrings = new TileSetStrings(null, null, 0, 7, null);
        this.setCurrentTileSetStrings(tileSetStrings);
        Iterable $this$map$iv = this.tileMap.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tile tile = (Tile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new WorldTileGroup((Tile)it, tileSetStrings));
        }
        List tileGroupsNew = (List)destination$iv$iv;
        this.tileGroupMap = new TileGroupMap(this, tileGroupsNew, this.getContinuousScrollingX(), null, 8, null);
        for (WorldTileGroup tileGroup : tileGroupsNew) {
            ((Map)this.tileGroups).put(tileGroup.getTile(), tileGroup);
            ActivationExtensionsKt.onClick(tileGroup.getLayerCityButton(), UncivSound.Companion.getSilent(), new Function0<Unit>(this, tileGroup){
                final /* synthetic */ WorldMapHolder this$0;
                final /* synthetic */ WorldTileGroup $tileGroup;
                {
                    this.this$0 = $receiver;
                    this.$tileGroup = $tileGroup;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.onTileClicked(this.$tileGroup.getTile());
                }
            });
            ActivationExtensionsKt.onClick(tileGroup, new Function0<Unit>(this, tileGroup){
                final /* synthetic */ WorldMapHolder this$0;
                final /* synthetic */ WorldTileGroup $tileGroup;
                {
                    this.this$0 = $receiver;
                    this.$tileGroup = $tileGroup;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.onTileClicked(this.$tileGroup.getTile());
                }
            });
            ActivationExtensionsKt.onActivation$default(tileGroup, Gdx.app.getType() == Application.ApplicationType.Android ? ActivationTypes.Longpress : ActivationTypes.RightClick, null, true, new Function0<Unit>(this, tileGroup){
                final /* synthetic */ WorldMapHolder this$0;
                final /* synthetic */ WorldTileGroup $tileGroup;
                {
                    this.this$0 = $receiver;
                    this.$tileGroup = $tileGroup;
                    super(0);
                }

                public final void invoke() {
                    if (!UncivGame.Companion.getCurrent().getSettings().getLongTapMove()) {
                        return;
                    }
                    MapUnit mapUnit = this.this$0.getWorldScreen$core().getBottomUnitTable$core().getSelectedUnit();
                    if (mapUnit == null) {
                        return;
                    }
                    MapUnit unit = mapUnit;
                    Concurrency.run$default(Concurrency.INSTANCE, "WorldScreenClick", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, unit, this.$tileGroup, null){
                        int label;
                        final /* synthetic */ WorldMapHolder this$0;
                        final /* synthetic */ MapUnit $unit;
                        final /* synthetic */ WorldTileGroup $tileGroup;
                        {
                            this.this$0 = $receiver;
                            this.$unit = $unit;
                            this.$tileGroup = $tileGroup;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    WorldMapHolder.access$onTileRightClicked(this.this$0, this.$unit, this.$tileGroup.getTile());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 2, null);
                }
            }, 2, null);
        }
        TileGroupMap<WorldTileGroup> tileGroupMap = this.tileGroupMap;
        if (tileGroupMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap = null;
        }
        this.setActor(tileGroupMap);
        this.setSize(this.worldScreen.getStage().getWidth(), this.worldScreen.getStage().getHeight());
        this.layout();
    }

    public final void onTileClicked(@NotNull Tile tile) {
        boolean movingSpyOnMap;
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!this.worldScreen.getViewingCiv().hasExplored(tile)) {
            boolean bl;
            block30: {
                Sequence<Tile> $this$all$iv = tile.getNeighbors();
                boolean $i$f$all = false;
                Iterator<Tile> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.worldScreen.getViewingCiv().hasExplored(it)) continue;
                    bl = false;
                    break block30;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        this.removeUnitActionOverlay();
        this.selectedTile = tile;
        this.unitMovementPaths.clear();
        this.unitConnectRoadPaths.clear();
        UnitTable unitTable = this.worldScreen.getBottomUnitTable$core();
        List<MapUnit> previousSelectedUnits = CollectionsKt.toList((Iterable)unitTable.getSelectedUnits());
        City previousSelectedCity = unitTable.getSelectedCity();
        boolean previousSelectedUnitIsSwapping = unitTable.getSelectedUnitIsSwapping();
        boolean previousSelectedUnitIsConnectingRoad = unitTable.getSelectedUnitIsConnectingRoad();
        boolean bl = movingSpyOnMap = unitTable.getSelectedSpy() != null;
        if (!movingSpyOnMap) {
            UnitTable.tileSelected$default(unitTable, tile, null, 2, null);
        }
        MapUnit newSelectedUnit = unitTable.getSelectedUnit();
        if (previousSelectedCity != null && !Intrinsics.areEqual(tile, previousSelectedCity.getCenterTile()) && !movingSpyOnMap) {
            WorldTileGroup worldTileGroup = this.tileGroups.get(previousSelectedCity.getCenterTile());
            Intrinsics.checkNotNull(worldTileGroup);
            worldTileGroup.getLayerCityButton().moveUp();
        }
        if (!((Collection)previousSelectedUnits).isEmpty()) {
            boolean canPerformActionsOnTile;
            boolean existsUnitNotPreparingAirSweep;
            boolean isPlayerTurn;
            boolean isTileDifferent;
            block33: {
                boolean bl3;
                block32: {
                    boolean bl4;
                    boolean bl5;
                    block31: {
                        Iterable $this$any$iv = previousSelectedUnits;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                MapUnit it = (MapUnit)element$iv;
                                boolean bl6 = false;
                                if (!(!Intrinsics.areEqual(it.getTile(), tile))) continue;
                                bl5 = true;
                                break block31;
                            }
                            bl5 = false;
                        }
                    }
                    isTileDifferent = bl5;
                    isPlayerTurn = this.worldScreen.isPlayersTurn();
                    Iterable $this$any$iv = previousSelectedUnits;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MapUnit it = (MapUnit)element$iv;
                            boolean bl7 = false;
                            if (!(!it.isPreparingAirSweep())) continue;
                            bl4 = true;
                            break block32;
                        }
                        bl4 = existsUnitNotPreparingAirSweep = false;
                    }
                }
                if (previousSelectedUnitIsSwapping) {
                    bl3 = ((MapUnit)CollectionsKt.first(previousSelectedUnits)).getMovement().canUnitSwapTo(tile);
                } else if (previousSelectedUnitIsConnectingRoad) {
                    bl3 = true;
                } else {
                    Iterable $this$any$iv = previousSelectedUnits;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MapUnit it = (MapUnit)element$iv;
                            boolean bl8 = false;
                            boolean bl9 = UnitMovement.canMoveTo$default(it.getMovement(), tile, false, false, false, 14, null) || it.getMovement().isUnknownTileWeShouldAssumeToBePassable(tile) && !it.getBaseUnit().getMovesLikeAirUnits();
                            if (!bl9) continue;
                            bl3 = true;
                            break block33;
                        }
                        bl3 = canPerformActionsOnTile = false;
                    }
                }
            }
            if (isTileDifferent && isPlayerTurn && canPerformActionsOnTile && existsUnitNotPreparingAirSweep) {
                if (previousSelectedUnitIsSwapping) {
                    this.addTileOverlaysWithUnitSwapping((MapUnit)CollectionsKt.first(previousSelectedUnits), tile);
                } else if (previousSelectedUnitIsConnectingRoad) {
                    this.addTileOverlaysWithUnitRoadConnecting((MapUnit)CollectionsKt.first(previousSelectedUnits), tile);
                } else {
                    this.addTileOverlaysWithUnitMovement(previousSelectedUnits, tile);
                }
            }
        } else if (movingSpyOnMap) {
            Spy spy = unitTable.getSelectedSpy();
            Intrinsics.checkNotNull(spy);
            this.addMovingSpyOverlay(spy, tile);
        } else {
            WorldMapHolder.addTileOverlays$default(this, tile, null, 2, null);
        }
        if (newSelectedUnit == null || newSelectedUnit.isCivilian()) {
            Tile tile2 = this.selectedTile;
            Intrinsics.checkNotNull(tile2);
            Sequence<MapUnit> unitsInTile = tile2.getUnits();
            if (previousSelectedCity != null && previousSelectedCity.canBombard()) {
                Tile tile3 = this.selectedTile;
                Intrinsics.checkNotNull(tile3);
                if (SequencesKt.contains(tile3.getTilesInDistance(2), previousSelectedCity.getCenterTile()) && SequencesKt.any(unitsInTile) && SequencesKt.first(unitsInTile).getCiv().isAtWarWith(this.worldScreen.getViewingCiv())) {
                    unitTable.citySelected(previousSelectedCity);
                }
            }
        }
        this.worldScreen.getViewingCiv().getTacticalAI().showZonesDebug(tile);
        this.worldScreen.setShouldUpdate(true);
    }

    /*
     * WARNING - void declaration
     */
    private final void onTileRightClicked(MapUnit unit, Tile tile) {
        this.removeUnitActionOverlay();
        this.selectedTile = tile;
        this.unitMovementPaths.clear();
        this.unitConnectRoadPaths.clear();
        if (!this.worldScreen.getCanChangeState()) {
            return;
        }
        boolean localShouldUpdate = this.worldScreen.getShouldUpdate();
        this.worldScreen.setShouldUpdate(false);
        if (this.worldScreen.getBottomUnitTable$core().getSelectedUnitIsSwapping()) {
            if (unit.getMovement().canUnitSwapTo(tile)) {
                this.swapMoveUnitToTargetTile(unit, tile);
                localShouldUpdate = true;
            }
        } else {
            Object v0;
            block10: {
                void $this$firstOrNull$iv;
                Iterable iterable = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), null, false, 12, null);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AttackableTile it = (AttackableTile)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getTileToAttack(), tile)) continue;
                    v0 = element$iv;
                    break block10;
                }
                v0 = null;
            }
            AttackableTile attackableTile = v0;
            if (unit.canAttack() && attackableTile != null) {
                MapUnitCombatant attacker = new MapUnitCombatant(unit);
                if (!Battle.movePreparingAttack$default(Battle.INSTANCE, attacker, attackableTile, false, 4, null)) {
                    return;
                }
                SoundPlayer.INSTANCE.play(attacker.getAttackSound());
                Battle.DamageDealt damageDealt = Battle.INSTANCE.attackOrNuke(attacker, attackableTile);
                int damageToDefender = damageDealt.component1();
                int damageToAttacker = damageDealt.component2();
                if (attackableTile.getCombatant() != null) {
                    BattleTableHelpers.INSTANCE.battleAnimation(this.worldScreen, attacker, damageToAttacker, attackableTile.getCombatant(), damageToDefender);
                }
                localShouldUpdate = true;
            } else if (unit.getMovement().canReach(tile)) {
                this.moveUnitToTargetTile(CollectionsKt.listOf(unit), tile);
                localShouldUpdate = true;
            }
        }
        this.worldScreen.setShouldUpdate(localShouldUpdate);
    }

    private final void markUnitMoveTutorialComplete(MapUnit unit) {
        String key = unit.getBaseUnit().getMovesLikeAirUnits() ? "Move an air unit" : "Move unit";
        UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask(key);
    }

    private final void moveUnitToTargetTile(List<MapUnit> selectedUnits, Tile targetTile) {
        MapUnit selectedUnit = CollectionsKt.first(selectedUnits);
        this.markUnitMoveTutorialComplete(selectedUnit);
        Concurrency.run$default(Concurrency.INSTANCE, "TileToMoveTo", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectedUnit, targetTile, this, selectedUnits, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $selectedUnit;
            final /* synthetic */ Tile $targetTile;
            final /* synthetic */ WorldMapHolder this$0;
            final /* synthetic */ List<MapUnit> $selectedUnits;
            {
                this.$selectedUnit = $selectedUnit;
                this.$targetTile = $targetTile;
                this.this$0 = $receiver;
                this.$selectedUnits = $selectedUnits;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        List<Tile> pathToTile;
                        Tile tileToMoveTo2;
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            tileToMoveTo2 = this.$selectedUnit.getMovement().getTileToMoveToThisTurn(this.$targetTile);
                            pathToTile = UnitMovement.getDistanceToTiles$default(this.$selectedUnit.getMovement(), false, null, null, false, 15, null).getPathToTile(tileToMoveTo2);
                        }
                        catch (Exception ex) {
                            if (!(ex instanceof UnitMovement.UnreachableDestinationException)) {
                                Log.INSTANCE.error("Exception in getTileToMoveToThisTurn", ex);
                            }
                            return Unit.INSTANCE;
                        }
                        UndoHandler.Companion.recordUndoCheckpoint(this.this$0.getWorldScreen$core());
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$selectedUnit, tileToMoveTo2, this.$targetTile, this.this$0, pathToTile, this.$selectedUnits, null){
                            int label;
                            final /* synthetic */ MapUnit $selectedUnit;
                            final /* synthetic */ Tile $tileToMoveTo;
                            final /* synthetic */ Tile $targetTile;
                            final /* synthetic */ WorldMapHolder this$0;
                            final /* synthetic */ List<Tile> $pathToTile;
                            final /* synthetic */ List<MapUnit> $selectedUnits;
                            {
                                this.$selectedUnit = $selectedUnit;
                                this.$tileToMoveTo = $tileToMoveTo;
                                this.$targetTile = $targetTile;
                                this.this$0 = $receiver;
                                this.$pathToTile = $pathToTile;
                                this.$selectedUnits = $selectedUnits;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        try {
                                            Tile previousTile = this.$selectedUnit.getCurrentTile();
                                            UnitMovement.moveToTile$default(this.$selectedUnit.getMovement(), this.$tileToMoveTo, false, 2, null);
                                            if (this.$selectedUnit.isExploring() || this.$selectedUnit.isMoving()) {
                                                this.$selectedUnit.setAction(null);
                                            }
                                            SoundPlayer.INSTANCE.play(UncivSound.Companion.getWhoosh());
                                            if (!Intrinsics.areEqual(this.$selectedUnit.getCurrentTile(), this.$targetTile)) {
                                                this.$selectedUnit.setAction("moveTo " + (int)this.$targetTile.getPosition().x + ',' + (int)this.$targetTile.getPosition().y);
                                            }
                                            if (this.$selectedUnit.getCurrentMovement() > 0.0f) {
                                                UnitTable.selectUnit$default(this.this$0.getWorldScreen$core().getBottomUnitTable$core(), this.$selectedUnit, false, 2, null);
                                            }
                                            this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                            WorldMapHolder.access$animateMovement(this.this$0, previousTile, this.$selectedUnit, this.$tileToMoveTo, this.$pathToTile);
                                            if (this.$selectedUnits.size() > 1) {
                                                WorldMapHolder.access$moveUnitToTargetTile(this.this$0, this.$selectedUnits.subList(1, this.$selectedUnits.size()), this.$targetTile);
                                            } else {
                                                this.this$0.removeUnitActionOverlay();
                                            }
                                            if (UncivGame.Companion.getCurrent().getSettings().getAutoUnitCycle() && this.$selectedUnit.getCurrentMovement() == 0.0f) {
                                                this.this$0.getWorldScreen$core().switchToNextUnit();
                                            }
                                        }
                                        catch (Exception ex) {
                                            Log.INSTANCE.error("Exception in moveUnitToTargetTile", ex);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void animateMovement(Tile previousTile, MapUnit selectedUnit, Tile targetTile, List<Tile> pathToTile) {
        void $this$toTypedArray$iv;
        Collection<MoveToAction> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        WorldTileGroup worldTileGroup = this.tileGroups.get(previousTile);
        Intrinsics.checkNotNull(worldTileGroup);
        WorldTileGroup tileGroup = worldTileGroup;
        Group group = new Group();
        Group $this$animateMovement_u24lambda_u246 = group;
        boolean bl = false;
        $this$animateMovement_u24lambda_u246.setPosition(tileGroup.getX(), tileGroup.getY());
        Group unitSpriteAndIcon = group;
        UnitSpriteSlot unitSpriteSlot = tileGroup.getLayerUnitArt().getSpriteSlot(selectedUnit);
        for (Actor spriteImage : unitSpriteSlot.getChildren()) {
            unitSpriteAndIcon.addActor(spriteImage);
        }
        tileGroup.getParent().addActor(unitSpriteAndIcon);
        WorldTileGroup worldTileGroup2 = this.tileGroups.get(targetTile);
        Intrinsics.checkNotNull(worldTileGroup2);
        UnitSpriteSlot targetTileSpriteSlot = worldTileGroup2.getLayerUnitArt().getSpriteSlot(selectedUnit);
        targetTileSpriteSlot.setVisible(false);
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        Iterable iterable = pathToTile;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        Group group2 = unitSpriteAndIcon;
        boolean $i$f$map = false;
        void var12_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tile;
            Tile tile2 = (Tile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            WorldTileGroup worldTileGroup3 = this.tileGroups.get(tile);
            Intrinsics.checkNotNull(worldTileGroup3);
            float f = worldTileGroup3.getX();
            WorldTileGroup worldTileGroup4 = this.tileGroups.get(tile);
            Intrinsics.checkNotNull(worldTileGroup4);
            collection.add(Actions.moveTo(f, worldTileGroup4.getY(), 0.5f / (float)pathToTile.size()));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder2.addSpread(thisCollection$iv.toArray(new MoveToAction[0]));
        spreadBuilder.add(Actions.run(() -> WorldMapHolder.animateMovement$lambda$8(targetTileSpriteSlot, this)));
        spreadBuilder.add(Actions.removeActor());
        group2.addAction(Actions.sequence((Action[])spreadBuilder.toArray(new Action[spreadBuilder.size()])));
    }

    private final void swapMoveUnitToTargetTile(MapUnit selectedUnit, Tile targetTile) {
        this.markUnitMoveTutorialComplete(selectedUnit);
        selectedUnit.getMovement().swapMoveToTile(targetTile);
        if (selectedUnit.isExploring() || selectedUnit.isMoving()) {
            selectedUnit.setAction(null);
        }
        SoundPlayer.INSTANCE.play(UncivSound.Companion.getSwap());
        if (selectedUnit.getCurrentMovement() > 0.0f) {
            UnitTable.selectUnit$default(this.worldScreen.getBottomUnitTable$core(), selectedUnit, false, 2, null);
        }
        this.worldScreen.setShouldUpdate(true);
        this.removeUnitActionOverlay();
    }

    private final void connectRoadToTargetTile(MapUnit selectedUnit, Tile targetTile) {
        selectedUnit.setAutomatedRoadConnectionDestination(targetTile.getPosition());
        selectedUnit.setAutomatedRoadConnectionPath(null);
        selectedUnit.setAction(UnitActionType.ConnectRoad.getValue());
        selectedUnit.setAutomated(true);
        UnitAutomation.INSTANCE.automateUnitMoves(selectedUnit);
        SoundPlayer.INSTANCE.play(new UncivSound("wagon"));
        this.worldScreen.setShouldUpdate(true);
        this.removeUnitActionOverlay();
        this.worldScreen.getBottomUnitTable$core().setSelectedUnitIsConnectingRoad(false);
    }

    private final void addTileOverlaysWithUnitMovement(List<MapUnit> selectedUnits, Tile tile) {
        Concurrency.run$default(Concurrency.INSTANCE, "TurnsToGetThere", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectedUnits, tile, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<MapUnit> $selectedUnits;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.$selectedUnits = $selectedUnits;
                this.$tile = $tile;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        HashMap<MapUnit, Integer> unitToTurnsToTile = new HashMap<MapUnit, Integer>();
                        for (MapUnit unit : this.$selectedUnits) {
                            int n;
                            ArrayList<E> shortestPath = new ArrayList<E>();
                            if (unit.getBaseUnit().getMovesLikeAirUnits()) {
                                n = unit.getMovement().canReach(this.$tile) ? 1 : 0;
                            } else if (unit.isPreparingParadrop()) {
                                n = unit.getMovement().canReach(this.$tile) ? 1 : 0;
                            } else {
                                shortestPath.addAll(UnitMovement.getShortestPath$default(unit.getMovement(), this.$tile, false, 2, null));
                                n = shortestPath.size();
                            }
                            int turnsToGetThere = n;
                            ((Map)this.this$0.getUnitMovementPaths$core()).put(unit, shortestPath);
                            Integer n2 = Boxing.boxInt(turnsToGetThere);
                            ((Map)unitToTurnsToTile).put(unit, n2);
                        }
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(unitToTurnsToTile, this.this$0, this.$tile, null){
                            int label;
                            final /* synthetic */ HashMap<MapUnit, Integer> $unitToTurnsToTile;
                            final /* synthetic */ WorldMapHolder this$0;
                            final /* synthetic */ Tile $tile;
                            {
                                this.$unitToTurnsToTile = $unitToTurnsToTile;
                                this.this$0 = $receiver;
                                this.$tile = $tile;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$filterTo$iv$iv;
                                        ResultKt.throwOnFailure(object);
                                        Map $this$filter$iv = this.$unitToTurnsToTile;
                                        boolean $i$f$filter = false;
                                        Map map2 = $this$filter$iv;
                                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                                        boolean $i$f$filterTo = false;
                                        Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                                        while (iterator2.hasNext()) {
                                            Map.Entry<K, V> element$iv$iv;
                                            Map.Entry<K, V> it = element$iv$iv = iterator2.next();
                                            boolean bl = false;
                                            if (!(((Number)it.getValue()).intValue() != 0)) continue;
                                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                        }
                                        Map map3 = destination$iv$iv;
                                        HashMap<MapUnit, Integer> unitsWhoCanMoveThere = new HashMap<MapUnit, Integer>(map3);
                                        if (unitsWhoCanMoveThere.isEmpty()) {
                                            WorldMapHolder.addTileOverlays$default(this.this$0, this.$tile, null, 2, null);
                                            this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                            return Unit.INSTANCE;
                                        }
                                        Collection<V> collection = unitsWhoCanMoveThere.values();
                                        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                                        T t = CollectionsKt.maxOrNull((Iterable)collection);
                                        Intrinsics.checkNotNull(t);
                                        int turnsToGetThere = ((Number)t).intValue();
                                        if (UncivGame.Companion.getCurrent().getSettings().getSingleTapMove() && turnsToGetThere == 1) {
                                            Set<K> set2 = unitsWhoCanMoveThere.keySet();
                                            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
                                            MapUnit selectedUnit = (MapUnit)CollectionsKt.first((Iterable)set2);
                                            for (MapUnit unit : unitsWhoCanMoveThere.keySet()) {
                                                unit.getMovement().headTowards(this.$tile);
                                            }
                                            UnitTable.selectUnit$default(this.this$0.getWorldScreen$core().getBottomUnitTable$core(), selectedUnit, false, 2, null);
                                        } else {
                                            MoveHereButtonDto moveHereButtonDto = new MoveHereButtonDto(unitsWhoCanMoveThere, this.$tile);
                                            WorldMapHolder.access$addTileOverlays(this.this$0, this.$tile, moveHereButtonDto);
                                        }
                                        this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void addTileOverlaysWithUnitSwapping(MapUnit selectedUnit, Tile tile) {
        if (!selectedUnit.getMovement().canUnitSwapTo(tile)) {
            WorldMapHolder.addTileOverlays$default(this, tile, null, 2, null);
            this.worldScreen.setShouldUpdate(true);
            return;
        }
        if (UncivGame.Companion.getCurrent().getSettings().getSingleTapMove()) {
            this.swapMoveUnitToTargetTile(selectedUnit, tile);
        } else {
            SwapWithButtonDto swapWithButtonDto = new SwapWithButtonDto(selectedUnit, tile);
            this.addTileOverlays(tile, swapWithButtonDto);
        }
        this.worldScreen.setShouldUpdate(true);
    }

    private final void addTileOverlaysWithUnitRoadConnecting(MapUnit selectedUnit, Tile tile) {
        Concurrency.run$default(Concurrency.INSTANCE, "ConnectRoad", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tile, selectedUnit, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ MapUnit $selectedUnit;
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.$tile = $tile;
                this.$selectedUnit = $selectedUnit;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean validTile;
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        boolean bl = validTile = this.$tile.isLand() && !this.$tile.isImpassible() && this.$selectedUnit.getCiv().hasExplored(this.$tile);
                        if (validTile) {
                            List<Tile> roadPath = MapPathing.INSTANCE.getRoadPath(this.$selectedUnit, this.$selectedUnit.getCurrentTile(), this.$tile);
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(roadPath, this.this$0, this.$tile, this.$selectedUnit, null){
                                int label;
                                final /* synthetic */ List<Tile> $roadPath;
                                final /* synthetic */ WorldMapHolder this$0;
                                final /* synthetic */ Tile $tile;
                                final /* synthetic */ MapUnit $selectedUnit;
                                {
                                    this.$roadPath = $roadPath;
                                    this.this$0 = $receiver;
                                    this.$tile = $tile;
                                    this.$selectedUnit = $selectedUnit;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            if (this.$roadPath == null) {
                                                WorldMapHolder.addTileOverlays$default(this.this$0, this.$tile, null, 2, null);
                                                this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                                return Unit.INSTANCE;
                                            }
                                            ((Map)this.this$0.getUnitConnectRoadPaths$core()).put(this.$selectedUnit, this.$roadPath);
                                            ConnectRoadButtonDto connectRoadButtonDto = new ConnectRoadButtonDto(this.$selectedUnit, this.$tile);
                                            WorldMapHolder.access$addTileOverlays(this.this$0, this.$tile, connectRoadButtonDto);
                                            this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void addMovingSpyOverlay(Spy spy, Tile tile) {
        if (!tile.isCityCenter()) ** GOTO lbl-1000
        v0 = tile.getCity();
        Intrinsics.checkNotNull(v0);
        if (spy.canMoveTo(v0)) {
            v1 = tile.getCity();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        city = v1;
        this.addTileOverlays(tile, new MoveSpyButtonDto(spy, city));
        this.worldScreen.setShouldUpdate(true);
    }

    private final void addTileOverlays(Tile tile, ButtonDto buttonDto) {
        Object object = new Table();
        Table $this$addTileOverlays_u24lambda_u249 = object;
        boolean bl = false;
        $this$addTileOverlays_u24lambda_u249.defaults().pad(10.0f);
        Table table2 = object;
        if (buttonDto != null && this.worldScreen.getCanChangeState()) {
            object = buttonDto;
            table2.add((Actor)(object instanceof MoveHereButtonDto ? this.getMoveHereButton((MoveHereButtonDto)buttonDto) : (object instanceof SwapWithButtonDto ? this.getSwapWithButton((SwapWithButtonDto)buttonDto) : (object instanceof ConnectRoadButtonDto ? this.getConnectRoadButton((ConnectRoadButtonDto)buttonDto) : (object instanceof MoveSpyButtonDto ? this.getMoveSpyButton((MoveSpyButtonDto)buttonDto) : null)))));
        }
        ArrayList unitList = new ArrayList();
        if (tile.isCityCenter() && (Intrinsics.areEqual(tile.getOwner(), this.worldScreen.getViewingCiv()) || this.worldScreen.getViewingCiv().isSpectator())) {
            Collection collection = unitList;
            City city2 = tile.getCity();
            Intrinsics.checkNotNull(city2);
            CollectionsKt.addAll(collection, city2.getCenterTile().getUnits());
        } else if (!((Collection)tile.getAirUnits()).isEmpty() && (Intrinsics.areEqual(((MapUnit)CollectionsKt.first((List)tile.getAirUnits())).getCiv(), this.worldScreen.getViewingCiv()) || this.worldScreen.getViewingCiv().isSpectator())) {
            CollectionsKt.addAll((Collection)unitList, tile.getUnits());
        }
        for (MapUnit unit : unitList) {
            Color color;
            Intrinsics.checkNotNull(unit);
            IconCircleGroup unitIconGroup = Scene2dExtensionsKt.surroundWithCircle$default(new UnitIconGroup(unit, 48.0f), 68.0f, false, null, null, 12, null);
            Color color2 = color = Color.GRAY.cpy();
            Image image2 = unitIconGroup.getCircle();
            boolean bl2 = false;
            $this$addTileOverlays_u24lambda_u2410.a = 0.5f;
            image2.setColor(color);
            if (unit.getCurrentMovement() == 0.0f) {
                unitIconGroup.getColor().a = 0.66f;
            }
            ClickableCircle clickableCircle = new ClickableCircle(68.0f);
            clickableCircle.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick(clickableCircle, new Function0<Unit>(this, unit){
                final /* synthetic */ WorldMapHolder this$0;
                final /* synthetic */ MapUnit $unit;
                {
                    this.this$0 = $receiver;
                    this.$unit = $unit;
                    super(0);
                }

                public final void invoke() {
                    UnitTable unitTable = this.this$0.getWorldScreen$core().getBottomUnitTable$core();
                    Input input2 = Gdx.input;
                    Intrinsics.checkNotNullExpressionValue(input2, "input");
                    unitTable.selectUnit(this.$unit, Scene2dExtensionsKt.isShiftKeyPressed(input2));
                    this.this$0.getWorldScreen$core().setShouldUpdate(true);
                    this.this$0.removeUnitActionOverlay();
                }
            });
            unitIconGroup.addActor(clickableCircle);
            table2.add((Actor)unitIconGroup);
        }
        WorldTileGroup worldTileGroup = this.tileGroups.get(tile);
        Intrinsics.checkNotNull(worldTileGroup);
        this.addOverlayOnTileGroup(worldTileGroup, table2);
        table2.moveBy(0.0f, 48.0f);
    }

    static /* synthetic */ void addTileOverlays$default(WorldMapHolder worldMapHolder, Tile tile, ButtonDto buttonDto, int n, Object object) {
        if ((n & 2) != 0) {
            buttonDto = null;
        }
        worldMapHolder.addTileOverlays(tile, buttonDto);
    }

    public final float getButtonSize() {
        return this.buttonSize;
    }

    public final float getSmallerCircleSizes() {
        return this.smallerCircleSizes;
    }

    /*
     * WARNING - void declaration
     */
    private final Group getMoveHereButton(MoveHereButtonDto dto) {
        void $this$filterTo$iv$iv;
        Group group;
        Actor $this$getMoveHereButton_u24lambda_u2413;
        Actor actor;
        boolean isParadrop;
        block11: {
            boolean bl;
            Set<MapUnit> set2 = dto.getUnitToTurnsToDestination().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            Iterable $this$all$iv = set2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MapUnit it = (MapUnit)element$iv;
                    boolean bl2 = false;
                    if (it.isPreparingParadrop()) continue;
                    bl = false;
                    break block11;
                }
                bl = isParadrop = true;
            }
        }
        if (isParadrop) {
            actor = ImageGetter.INSTANCE.getUnitActionPortrait("Paradrop", this.buttonSize / (float)2);
        } else {
            Image $i$f$all;
            Image $this$getMoveHereButton_u24lambda_u2412 = $i$f$all = ImageGetter.INSTANCE.getStatIcon("Movement");
            boolean bl = false;
            $this$getMoveHereButton_u24lambda_u2412.setColor(Color.BLACK);
            $this$getMoveHereButton_u24lambda_u2412.setWidth(this.buttonSize / (float)2);
            $this$getMoveHereButton_u24lambda_u2412.setHeight(this.buttonSize / (float)2);
            actor = $i$f$all;
        }
        Actor image2 = actor;
        Actor actor2 = Scene2dExtensionsKt.surroundWithCircle$default(image2, this.buttonSize - (float)2, false, null, null, 12, null);
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color, "BLACK");
        IconCircleGroup moveHereButton = Scene2dExtensionsKt.surroundWithCircle$default(actor2, this.buttonSize, false, color, null, 8, null);
        if (!isParadrop) {
            Collection<Integer> collection = dto.getUnitToTurnsToDestination().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Object t = CollectionsKt.maxOrNull((Iterable)collection);
            Intrinsics.checkNotNull(t);
            Label bl = Scene2dExtensionsKt.toLabel$default(String.valueOf(((Number)t).intValue()), null, 14, 0, false, 13, null);
            $this$getMoveHereButton_u24lambda_u2413 = bl;
            boolean bl3 = false;
            ((Label)$this$getMoveHereButton_u24lambda_u2413).setAlignment(1);
            IconCircleGroup numberCircle = Scene2dExtensionsKt.surroundWithCircle$default(Scene2dExtensionsKt.surroundWithCircle$default(bl, this.smallerCircleSizes - (float)2, false, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.3f), null, 10, null), this.smallerCircleSizes, false, null, null, 12, null);
            moveHereButton.addActor(numberCircle);
        }
        Set<MapUnit> set3 = dto.getUnitToTurnsToDestination().keySet();
        Intrinsics.checkNotNullExpressionValue(set3, "<get-keys>(...)");
        Object t = CollectionsKt.first((Iterable)set3);
        Intrinsics.checkNotNullExpressionValue(t, "first(...)");
        MapUnit firstUnit = (MapUnit)t;
        if (dto.getUnitToTurnsToDestination().size() == 1) {
            group = new UnitIconGroup(firstUnit, this.smallerCircleSizes);
        } else {
            $this$getMoveHereButton_u24lambda_u2413 = Scene2dExtensionsKt.toLabel$default(String.valueOf(dto.getUnitToTurnsToDestination().size()), firstUnit.getCiv().getNation().getInnerColor(), 0, 0, false, 14, null);
            Label $this$getMoveHereButton_u24lambda_u2414 = $this$getMoveHereButton_u24lambda_u2413;
            boolean bl = false;
            $this$getMoveHereButton_u24lambda_u2414.setAlignment(1);
            Actor $this$getMoveHereButton_u24lambda_u2415 = $this$getMoveHereButton_u24lambda_u2413 = Scene2dExtensionsKt.surroundWithCircle$default($this$getMoveHereButton_u24lambda_u2413, this.smallerCircleSizes, false, null, null, 14, null);
            boolean bl4 = false;
            ((IconCircleGroup)$this$getMoveHereButton_u24lambda_u2415).getCircle().setColor(firstUnit.getCiv().getNation().getOuterColor());
            group = (Group)$this$getMoveHereButton_u24lambda_u2413;
        }
        Group unitIcon = group;
        unitIcon.setY(this.buttonSize - unitIcon.getHeight());
        moveHereButton.addActor(unitIcon);
        Set<MapUnit> set4 = dto.getUnitToTurnsToDestination().keySet();
        Intrinsics.checkNotNullExpressionValue(set4, "<get-keys>(...)");
        Iterable $this$filter$iv = set4;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MapUnit it = (MapUnit)element$iv$iv;
            boolean bl = false;
            if (!(it.getCurrentMovement() > 0.0f)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unitsThatCanMove = (List)destination$iv$iv;
        if (unitsThatCanMove.isEmpty()) {
            moveHereButton.getColor().a = 0.5f;
        } else {
            ActivationExtensionsKt.onActivation(moveHereButton, UncivSound.Companion.getSilent(), new Function0<Unit>(this, (List<MapUnit>)unitsThatCanMove, dto){
                final /* synthetic */ WorldMapHolder this$0;
                final /* synthetic */ List<MapUnit> $unitsThatCanMove;
                final /* synthetic */ MoveHereButtonDto $dto;
                {
                    this.this$0 = $receiver;
                    this.$unitsThatCanMove = $unitsThatCanMove;
                    this.$dto = $dto;
                    super(0);
                }

                public final void invoke() {
                    WorldMapHolder.access$moveUnitToTargetTile(this.this$0, this.$unitsThatCanMove, this.$dto.getTile());
                }
            });
            ActivationExtensionsKt.getKeyShortcuts(moveHereButton).add(KeyCharAndCode.Companion.getTAB());
        }
        return moveHereButton;
    }

    /*
     * WARNING - void declaration
     */
    private final Group getSwapWithButton(SwapWithButtonDto dto) {
        void $this$getSwapWithButton_u24lambda_u2417;
        Image image2;
        Group swapWithButton = new Group();
        swapWithButton.setSize(this.buttonSize, this.buttonSize);
        swapWithButton.addActor(ImageGetter.getCircle$default(ImageGetter.INSTANCE, null, Float.valueOf(this.buttonSize), 1, null));
        Image image3 = image2 = ImageGetter.INSTANCE.getImage("OtherIcons/Swap");
        Group group = swapWithButton;
        boolean bl = false;
        $this$getSwapWithButton_u24lambda_u2417.setColor(Color.BLACK);
        Scene2dExtensionsKt.setSize((Image)$this$getSwapWithButton_u24lambda_u2417, this.buttonSize / (float)2);
        Scene2dExtensionsKt.center((Actor)$this$getSwapWithButton_u24lambda_u2417, swapWithButton);
        group.addActor(image2);
        UnitIconGroup unitIcon = new UnitIconGroup(dto.getUnit(), this.smallerCircleSizes);
        unitIcon.setY(this.buttonSize - unitIcon.getHeight());
        swapWithButton.addActor(unitIcon);
        ActivationExtensionsKt.onActivation(swapWithButton, UncivSound.Companion.getSilent(), new Function0<Unit>(this, dto){
            final /* synthetic */ WorldMapHolder this$0;
            final /* synthetic */ SwapWithButtonDto $dto;
            {
                this.this$0 = $receiver;
                this.$dto = $dto;
                super(0);
            }

            public final void invoke() {
                WorldMapHolder.access$swapMoveUnitToTargetTile(this.this$0, this.$dto.getUnit(), this.$dto.getTile());
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(swapWithButton).add(KeyCharAndCode.Companion.getTAB());
        return swapWithButton;
    }

    /*
     * WARNING - void declaration
     */
    private final Group getConnectRoadButton(ConnectRoadButtonDto dto) {
        void $this$getConnectRoadButton_u24lambda_u2418;
        Portrait portrait;
        Group connectRoadButton = new Group();
        connectRoadButton.setSize(this.buttonSize, this.buttonSize);
        Portrait portrait2 = portrait = ImageGetter.INSTANCE.getUnitActionPortrait("RoadConnection", this.buttonSize * 0.8f);
        Group group = connectRoadButton;
        boolean bl = false;
        Scene2dExtensionsKt.center((Actor)$this$getConnectRoadButton_u24lambda_u2418, connectRoadButton);
        group.addActor(portrait);
        UnitIconGroup unitIcon = new UnitIconGroup(dto.getUnit(), this.smallerCircleSizes);
        unitIcon.setY(this.buttonSize - unitIcon.getHeight());
        connectRoadButton.addActor(unitIcon);
        ActivationExtensionsKt.onActivation(connectRoadButton, UncivSound.Companion.getSilent(), new Function0<Unit>(this, dto){
            final /* synthetic */ WorldMapHolder this$0;
            final /* synthetic */ ConnectRoadButtonDto $dto;
            {
                this.this$0 = $receiver;
                this.$dto = $dto;
                super(0);
            }

            public final void invoke() {
                WorldMapHolder.access$connectRoadToTargetTile(this.this$0, this.$dto.getUnit(), this.$dto.getTile());
            }
        });
        ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(connectRoadButton), KeyboardBinding.ConnectRoad, 0, 2, null);
        return connectRoadButton;
    }

    /*
     * WARNING - void declaration
     */
    private final Group getMoveSpyButton(MoveSpyButtonDto dto) {
        Group spyActionButton = new Group();
        spyActionButton.setSize(this.buttonSize, this.buttonSize);
        spyActionButton.addActor(ImageGetter.getCircle$default(ImageGetter.INSTANCE, null, Float.valueOf(this.buttonSize), 1, null));
        if (dto.getCity() != null) {
            void $this$getMoveSpyButton_u24lambda_u2419;
            Image image2;
            Image image3 = image2 = ImageGetter.INSTANCE.getStatIcon("Movement");
            Group group = spyActionButton;
            boolean bl = false;
            $this$getMoveSpyButton_u24lambda_u2419.setName("Button");
            $this$getMoveSpyButton_u24lambda_u2419.setColor(Color.BLACK);
            Scene2dExtensionsKt.setSize((Image)$this$getMoveSpyButton_u24lambda_u2419, this.buttonSize / (float)2);
            Scene2dExtensionsKt.center((Actor)$this$getMoveSpyButton_u24lambda_u2419, spyActionButton);
            group.addActor(image2);
        } else {
            void $this$getMoveSpyButton_u24lambda_u2420;
            Image image4;
            Image $this$getMoveSpyButton_u24lambda_u2419 = image4 = ImageGetter.INSTANCE.getImage("OtherIcons/Close");
            Group group = spyActionButton;
            boolean bl = false;
            $this$getMoveSpyButton_u24lambda_u2420.setName("Button");
            $this$getMoveSpyButton_u24lambda_u2420.setColor(Color.RED);
            Scene2dExtensionsKt.setSize((Image)$this$getMoveSpyButton_u24lambda_u2420, this.buttonSize / (float)2);
            Scene2dExtensionsKt.center((Actor)$this$getMoveSpyButton_u24lambda_u2420, spyActionButton);
            group.addActor(image4);
        }
        ActivationExtensionsKt.onActivation(spyActionButton, UncivSound.Companion.getSilent(), new Function0<Unit>(dto, this){
            final /* synthetic */ MoveSpyButtonDto $dto;
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.$dto = $dto;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.$dto.getCity() != null) {
                    this.$dto.getSpy().moveTo(this.$dto.getCity());
                    this.this$0.getWorldScreen$core().getGame().pushScreen(new EspionageOverviewScreen(this.this$0.getWorldScreen$core().getSelectedCiv(), this.this$0.getWorldScreen$core()));
                } else {
                    this.this$0.getWorldScreen$core().getGame().pushScreen(new EspionageOverviewScreen(this.this$0.getWorldScreen$core().getSelectedCiv(), this.this$0.getWorldScreen$core()));
                    this.this$0.getWorldScreen$core().getBottomUnitTable$core().setSelectedSpy(null);
                }
                this.this$0.removeUnitActionOverlay();
                this.this$0.setSelectedTile$core(null);
                this.this$0.getWorldScreen$core().setShouldUpdate(true);
                this.this$0.getWorldScreen$core().getBottomUnitTable$core().selectSpy(null);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(spyActionButton).add(KeyCharAndCode.Companion.getTAB());
        ActivationExtensionsKt.getKeyShortcuts(spyActionButton).add(KeyCharAndCode.Companion.getRETURN());
        ActivationExtensionsKt.getKeyShortcuts(spyActionButton).add(KeyCharAndCode.Companion.getNUMPAD_ENTER());
        return spyActionButton;
    }

    public final void addOverlayOnTileGroup(@NotNull TileGroup group, @NotNull Actor actor) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(actor, "actor");
        Scene2dExtensionsKt.center(actor, group);
        actor.setX(actor.getX() + group.getX());
        actor.setY(actor.getY() + group.getY());
        group.getParent().addActor(actor);
        actor.toFront();
        actor.setY(actor.getY() + actor.getHeight());
        actor.setOrigin(4);
        this.unitActionOverlays.add(actor);
    }

    public final boolean isMapRevealEnabled(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return !viewingCiv.getGameInfo().getGameParameters().isOnlineMultiplayer() && viewingCiv.isCurrentPlayer() && viewingCiv.isDefeated();
    }

    public final void resetArrows() {
        Iterator iterator2 = MapsKt.asSequence((Map)this.tileGroups).iterator();
        while (iterator2.hasNext()) {
            Map.Entry tile = iterator2.next();
            ((WorldTileGroup)tile.getValue()).getLayerMisc().resetArrows();
        }
    }

    public final void addArrow(@NotNull Tile fromTile, @NotNull Tile toTile, @NotNull MapArrowType arrowType) {
        block0: {
            Intrinsics.checkNotNullParameter(fromTile, "fromTile");
            Intrinsics.checkNotNullParameter(toTile, "toTile");
            Intrinsics.checkNotNullParameter(arrowType, "arrowType");
            Group group = this.tileGroups.get(fromTile);
            if (group == null || (group = ((TileGroup)group).getLayerMisc()) == null) break block0;
            ((TileLayerMisc)group).addArrow(toTile, arrowType);
        }
    }

    public final void updateMovementOverlay$core(@NotNull Sequence<MapUnit> pastVisibleUnits, @NotNull Sequence<MapUnit> targetVisibleUnits, @NotNull Sequence<? extends Pair<? extends Vector2, ? extends Vector2>> visibleAttacks) {
        MapUnit unit;
        Intrinsics.checkNotNullParameter(pastVisibleUnits, "pastVisibleUnits");
        Intrinsics.checkNotNullParameter(targetVisibleUnits, "targetVisibleUnits");
        Intrinsics.checkNotNullParameter(visibleAttacks, "visibleAttacks");
        Iterator<Object> iterator2 = pastVisibleUnits.iterator();
        while (iterator2.hasNext()) {
            MapUnit.UnitMovementMemory previous;
            Iterator<MapUnit.UnitMovementMemory> stepIter;
            unit = iterator2.next();
            if (unit.getMovementMemories().isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue(unit.getMovementMemories().iterator(), "iterator(...)");
            Intrinsics.checkNotNullExpressionValue(stepIter.next(), "next(...)");
            while (stepIter.hasNext()) {
                MapUnit.UnitMovementMemory next;
                Intrinsics.checkNotNullExpressionValue(stepIter.next(), "next(...)");
                this.addArrow(this.tileMap.get(previous.getPosition()), this.tileMap.get(next.getPosition()), next.getType());
                previous = next;
            }
            this.addArrow(this.tileMap.get(previous.getPosition()), unit.getTile(), unit.getMostRecentMoveType());
        }
        iterator2 = targetVisibleUnits.iterator();
        while (iterator2.hasNext()) {
            unit = iterator2.next();
            if (!unit.isMoving()) continue;
            Tile toTile = unit.getMovementDestination();
            this.addArrow(unit.getTile(), toTile, MiscArrowTypes.UnitMoving);
        }
        iterator2 = visibleAttacks.iterator();
        while (iterator2.hasNext()) {
            Pair pair = (Pair)iterator2.next();
            Vector2 from = (Vector2)pair.component1();
            Vector2 to = (Vector2)pair.component2();
            this.addArrow(this.tileMap.get(from), this.tileMap.get(to), MiscArrowTypes.UnitHasAttacked);
        }
    }

    @Nullable
    public final Action getBlinkAction() {
        return this.blinkAction;
    }

    public final void setBlinkAction(@Nullable Action action2) {
        this.blinkAction = action2;
    }

    public final boolean setCenterPosition(@NotNull Vector2 vector, boolean immediately, boolean selectUnit, @Nullable MapUnit forceSelectUnit) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter(vector, "vector");
            Collection<WorldTileGroup> collection = this.tileGroups.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WorldTileGroup it = (WorldTileGroup)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getTile().getPosition(), vector)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        WorldTileGroup worldTileGroup = v1;
        if (worldTileGroup == null) {
            return false;
        }
        WorldTileGroup tileGroup = worldTileGroup;
        this.selectedTile = tileGroup.getTile();
        if (selectUnit || forceSelectUnit != null) {
            UnitTable unitTable = this.worldScreen.getBottomUnitTable$core();
            Tile tile = this.selectedTile;
            Intrinsics.checkNotNull(tile);
            unitTable.tileSelected(tile, forceSelectUnit);
        }
        if (!this.scrollTo(tileGroup.getX() + tileGroup.getWidth() / (float)2, this.getMaxY() - (tileGroup.getY() + tileGroup.getWidth() / (float)2), immediately)) {
            return false;
        }
        this.removeAction(this.blinkAction);
        this.blinkAction = Actions.repeat(3, Actions.sequence((Action)Actions.run(() -> WorldMapHolder.setCenterPosition$lambda$22(tileGroup)), (Action)Actions.delay(0.3f), (Action)Actions.run(() -> WorldMapHolder.setCenterPosition$lambda$23(tileGroup)), (Action)Actions.delay(0.3f)));
        this.addAction(this.blinkAction);
        this.worldScreen.setShouldUpdate(true);
        return true;
    }

    public static /* synthetic */ boolean setCenterPosition$default(WorldMapHolder worldMapHolder, Vector2 vector2, boolean bl, boolean bl2, MapUnit mapUnit, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            mapUnit = null;
        }
        return worldMapHolder.setCenterPosition(vector2, bl, bl2, mapUnit);
    }

    @Override
    public void zoom(float zoomScale) {
        super.zoom(zoomScale);
        this.clampCityButtonSize();
    }

    private final void clampCityButtonSize() {
        block4: {
            float clampedCityButtonZoom;
            block3: {
                clampedCityButtonZoom = 1.0f / this.getScaleX();
                if (!(clampedCityButtonZoom >= 1.0f)) break block3;
                for (WorldTileGroup tileGroup : this.tileGroups.values()) {
                    tileGroup.getLayerCityButton().setTransform(false);
                }
                break block4;
            }
            if (!(clampedCityButtonZoom >= this.getMinZoom())) break block4;
            for (WorldTileGroup tileGroup : this.tileGroups.values()) {
                if (tileGroup.getLayerCityButton().hasChildren()) {
                    tileGroup.getLayerCityButton().setTransform(true);
                }
                tileGroup.getLayerCityButton().setScale(clampedCityButtonZoom);
            }
        }
    }

    public final void removeUnitActionOverlay() {
        for (Actor overlay : this.unitActionOverlays) {
            overlay.remove();
        }
        this.unitActionOverlays.clear();
    }

    @Override
    public void reloadMaxZoom() {
        boolean enableZoomLimit;
        float maxWorldZoomOut = UncivGame.Companion.getCurrent().getSettings().getMaxWorldZoomOut();
        int mapRadius = this.tileMap.getMapParameters().getMapSize().getRadius();
        boolean bl = enableZoomLimit = mapRadius < 21 && maxWorldZoomOut < 3.0f || mapRadius > 20 && maxWorldZoomOut < 4.0f;
        if (enableZoomLimit) {
            float pad = this.getContinuousScrollingX() ? this.getWidth() / (float)mapRadius * 0.7f : 0.0f;
            this.setMinZoom(Float.max((this.getWidth() + pad) * this.getScaleX() / this.getMaxX(), 1.0f / maxWorldZoomOut));
            this.setMaxZoom(Float.max(2.0f * this.getMinZoom(), maxWorldZoomOut));
        } else {
            super.reloadMaxZoom();
        }
    }

    @Override
    public float restrictX(float deltaX) {
        float result2 = this.getScrollX() - deltaX;
        if (this.worldScreen.getViewingCiv().isSpectator()) {
            return result2;
        }
        ExploredRegion exploredRegion = this.worldScreen.getViewingCiv().getExploredRegion();
        if (exploredRegion.shouldRecalculateCoords()) {
            exploredRegion.calculateStageCoords(this.getMaxX(), this.getMaxY());
        }
        if (!exploredRegion.shouldRestrictX()) {
            return result2;
        }
        float leftX = exploredRegion.getLeftX();
        float rightX2 = exploredRegion.getRightX();
        if (deltaX < 0.0f && this.getScrollX() <= rightX2 && result2 > rightX2) {
            result2 = rightX2;
        } else if (deltaX > 0.0f && this.getScrollX() >= leftX && result2 < leftX) {
            result2 = leftX;
        }
        return result2;
    }

    @Override
    public float restrictY(float deltaY) {
        float result2 = this.getScrollY() + deltaY;
        if (this.worldScreen.getViewingCiv().isSpectator()) {
            return result2;
        }
        ExploredRegion exploredRegion = this.worldScreen.getViewingCiv().getExploredRegion();
        if (exploredRegion.shouldRecalculateCoords()) {
            exploredRegion.calculateStageCoords(this.getMaxX(), this.getMaxY());
        }
        float topY2 = exploredRegion.getTopY();
        float bottomY = exploredRegion.getBottomY();
        if (result2 < topY2) {
            result2 = topY2;
        } else if (result2 > bottomY) {
            result2 = bottomY;
        }
        return result2;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }

    @Override
    public void clear() {
        super.clear();
    }

    private static final void setupZoomPanListeners$setActHit(WorldMapHolder this$0) {
        boolean isEnabled = !this$0.isZooming() && !this$0.isPanning();
        Stage stage = this$0.getStage();
        Intrinsics.checkNotNull(stage, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.UncivStage");
        ((UncivStage)stage).setPerformPointerEnterExitEvents(isEnabled);
        TileGroupMap<WorldTileGroup> tileGroupMap = this$0.tileGroupMap;
        if (tileGroupMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap = null;
        }
        tileGroupMap.setShouldAct(isEnabled);
        TileGroupMap<WorldTileGroup> tileGroupMap2 = this$0.tileGroupMap;
        if (tileGroupMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap2 = null;
        }
        tileGroupMap2.setShouldHit(isEnabled);
    }

    private static final void animateMovement$lambda$8(UnitSpriteSlot $targetTileSpriteSlot, WorldMapHolder this$0) {
        Intrinsics.checkNotNullParameter($targetTileSpriteSlot, "$targetTileSpriteSlot");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        $targetTileSpriteSlot.setVisible(true);
        this$0.worldScreen.setShouldUpdate(true);
    }

    private static final void setCenterPosition$lambda$22(WorldTileGroup $tileGroup) {
        Intrinsics.checkNotNullParameter($tileGroup, "$tileGroup");
        $tileGroup.getLayerOverlay().hideHighlight();
    }

    private static final void setCenterPosition$lambda$23(WorldTileGroup $tileGroup) {
        Intrinsics.checkNotNullParameter($tileGroup, "$tileGroup");
        $tileGroup.getLayerOverlay().showHighlight();
    }

    public static final /* synthetic */ void access$setupZoomPanListeners$setActHit(WorldMapHolder this$0) {
        WorldMapHolder.setupZoomPanListeners$setActHit(this$0);
    }

    public static final /* synthetic */ void access$onTileRightClicked(WorldMapHolder $this, MapUnit unit, Tile tile) {
        $this.onTileRightClicked(unit, tile);
    }

    public static final /* synthetic */ void access$animateMovement(WorldMapHolder $this, Tile previousTile, MapUnit selectedUnit, Tile targetTile, List pathToTile) {
        $this.animateMovement(previousTile, selectedUnit, targetTile, pathToTile);
    }

    public static final /* synthetic */ void access$moveUnitToTargetTile(WorldMapHolder $this, List selectedUnits, Tile targetTile) {
        $this.moveUnitToTargetTile(selectedUnits, targetTile);
    }

    public static final /* synthetic */ void access$addTileOverlays(WorldMapHolder $this, Tile tile, ButtonDto buttonDto) {
        $this.addTileOverlays(tile, buttonDto);
    }

    public static final /* synthetic */ void access$swapMoveUnitToTargetTile(WorldMapHolder $this, MapUnit selectedUnit, Tile targetTile) {
        $this.swapMoveUnitToTargetTile(selectedUnit, targetTile);
    }

    public static final /* synthetic */ void access$connectRoadToTargetTile(WorldMapHolder $this, MapUnit selectedUnit, Tile targetTile) {
        $this.connectRoadToTargetTile(selectedUnit, targetTile);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$ButtonDto;", "", "core"})
    public static interface ButtonDto {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$ConnectRoadButtonDto;", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$ButtonDto;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/logic/map/mapunit/MapUnit;Lcom/unciv/logic/map/tile/Tile;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "core"})
    public static final class ConnectRoadButtonDto
    implements ButtonDto {
        @NotNull
        private final MapUnit unit;
        @NotNull
        private final Tile tile;

        public ConnectRoadButtonDto(@NotNull MapUnit unit, @NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            this.unit = unit;
            this.tile = tile;
        }

        @NotNull
        public final MapUnit getUnit() {
            return this.unit;
        }

        @NotNull
        public final Tile getTile() {
            return this.tile;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B1\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR-\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$MoveHereButtonDto;", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$ButtonDto;", "unitToTurnsToDestination", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/mapunit/MapUnit;", "", "Lkotlin/collections/HashMap;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Ljava/util/HashMap;Lcom/unciv/logic/map/tile/Tile;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getUnitToTurnsToDestination", "()Ljava/util/HashMap;", "core"})
    public static final class MoveHereButtonDto
    implements ButtonDto {
        @NotNull
        private final HashMap<MapUnit, Integer> unitToTurnsToDestination;
        @NotNull
        private final Tile tile;

        public MoveHereButtonDto(@NotNull HashMap<MapUnit, Integer> unitToTurnsToDestination, @NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(unitToTurnsToDestination, "unitToTurnsToDestination");
            Intrinsics.checkNotNullParameter(tile, "tile");
            this.unitToTurnsToDestination = unitToTurnsToDestination;
            this.tile = tile;
        }

        @NotNull
        public final HashMap<MapUnit, Integer> getUnitToTurnsToDestination() {
            return this.unitToTurnsToDestination;
        }

        @NotNull
        public final Tile getTile() {
            return this.tile;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$MoveSpyButtonDto;", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$ButtonDto;", "spy", "Lcom/unciv/models/Spy;", "city", "Lcom/unciv/logic/city/City;", "(Lcom/unciv/models/Spy;Lcom/unciv/logic/city/City;)V", "getCity", "()Lcom/unciv/logic/city/City;", "getSpy", "()Lcom/unciv/models/Spy;", "core"})
    public static final class MoveSpyButtonDto
    implements ButtonDto {
        @NotNull
        private final Spy spy;
        @Nullable
        private final City city;

        public MoveSpyButtonDto(@NotNull Spy spy, @Nullable City city2) {
            Intrinsics.checkNotNullParameter(spy, "spy");
            this.spy = spy;
            this.city = city2;
        }

        @NotNull
        public final Spy getSpy() {
            return this.spy;
        }

        @Nullable
        public final City getCity() {
            return this.city;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$SwapWithButtonDto;", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder$ButtonDto;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/logic/map/mapunit/MapUnit;Lcom/unciv/logic/map/tile/Tile;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "core"})
    public static final class SwapWithButtonDto
    implements ButtonDto {
        @NotNull
        private final MapUnit unit;
        @NotNull
        private final Tile tile;

        public SwapWithButtonDto(@NotNull MapUnit unit, @NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            this.unit = unit;
            this.tile = tile;
        }

        @NotNull
        public final MapUnit getUnit() {
            return this.unit;
        }

        @NotNull
        public final Tile getTile() {
            return this.tile;
        }
    }
}

