/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.unciv.UncivGame;
import com.unciv.logic.automation.unit.CityLocationTileRanker;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.MapPathing;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayerOverlay;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/worldscreen/WorldMapTileUpdater;", "", "()V", "updateBombardableTilesForSelectedCity", "", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "city", "Lcom/unciv/logic/city/City;", "updateTiles", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "updateTilesForSelectedSpy", "spy", "Lcom/unciv/models/Spy;", "updateTilesForSelectedUnit", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "core"})
@SourceDebugExtension(value={"SMAP\nWorldMapTileUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldMapTileUpdater.kt\ncom/unciv/ui/screens/worldscreen/WorldMapTileUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,263:1\n1855#2,2:264\n766#2:266\n857#2,2:267\n777#2:269\n788#2:270\n1864#2,2:271\n789#2,2:273\n1866#2:275\n791#2:276\n1549#2:277\n1620#2,3:278\n766#2:281\n857#2,2:282\n1655#2,8:284\n614#3:292\n1313#3,2:293\n*S KotlinDebug\n*F\n+ 1 WorldMapTileUpdater.kt\ncom/unciv/ui/screens/worldscreen/WorldMapTileUpdater\n*L\n24#1:264,2\n106#1:266\n106#1:267,2\n184#1:269\n184#1:270\n184#1:271,2\n184#1:273,2\n184#1:275\n184#1:276\n186#1:277\n186#1:278,3\n214#1:281\n214#1:282,2\n215#1:284,8\n234#1:292\n234#1:293,2\n*E\n"})
public final class WorldMapTileUpdater {
    @NotNull
    public static final WorldMapTileUpdater INSTANCE = new WorldMapTileUpdater();

    private WorldMapTileUpdater() {
    }

    public final void updateTiles(@NotNull WorldMapHolder $this$updateTiles, @NotNull Civilization viewingCiv) {
        Group group;
        Intrinsics.checkNotNullParameter($this$updateTiles, "<this>");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        if ($this$updateTiles.isMapRevealEnabled(viewingCiv)) {
            Collection<WorldTileGroup> collection = $this$updateTiles.getTileGroups().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WorldTileGroup it = (WorldTileGroup)element$iv;
                boolean bl = false;
                Tile.setExplored$default(it.getTile(), viewingCiv, true, null, 4, null);
                it.setForceVisible(true);
            }
        }
        LocalUniqueCache uniqueCache = new LocalUniqueCache(true);
        for (WorldTileGroup tileGroup : $this$updateTiles.getTileGroups().values()) {
            tileGroup.update(viewingCiv, uniqueCache);
        }
        UnitTable unitTable = $this$updateTiles.getWorldScreen$core().getBottomUnitTable$core();
        if (unitTable.getSelectedSpy() != null) {
            Spy spy = unitTable.getSelectedSpy();
            Intrinsics.checkNotNull(spy);
            this.updateTilesForSelectedSpy($this$updateTiles, spy);
        } else if (unitTable.getSelectedCity() != null) {
            City city2 = unitTable.getSelectedCity();
            Intrinsics.checkNotNull(city2);
            City city3 = city2;
            this.updateBombardableTilesForSelectedCity($this$updateTiles, city3);
            if (unitTable.getSelectedUnitIsConnectingRoad()) {
                MapUnit mapUnit = unitTable.getSelectedUnits().get(0);
                Intrinsics.checkNotNullExpressionValue(mapUnit, "get(...)");
                this.updateTilesForSelectedUnit($this$updateTiles, mapUnit);
            }
        } else if (unitTable.getSelectedUnit() != null) {
            for (MapUnit unit : unitTable.getSelectedUnits()) {
                Intrinsics.checkNotNull(unit);
                this.updateTilesForSelectedUnit($this$updateTiles, unit);
            }
        } else if (!((Collection)$this$updateTiles.getUnitActionOverlays$core()).isEmpty()) {
            $this$updateTiles.removeUnitActionOverlay();
        }
        if ((group = (WorldTileGroup)((Map)$this$updateTiles.getTileGroups()).get($this$updateTiles.getSelectedTile$core())) != null && (group = group.getLayerOverlay()) != null) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            TileLayerOverlay.showHighlight$default((TileLayerOverlay)group, color, 0.0f, 2, null);
        }
        $this$updateTiles.zoom($this$updateTiles.getScaleX());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void updateTilesForSelectedUnit(WorldMapHolder $this$updateTilesForSelectedUnit, MapUnit unit) {
        v0 = $this$updateTilesForSelectedUnit.getTileGroups().get(unit.getTile());
        if (v0 == null) {
            return;
        }
        tileGroup = v0;
        if (!unit.getBaseUnit().getMovesLikeAirUnits()) {
            tileGroup.getLayerUnitFlag().selectFlag(unit);
        }
        if (unit.isMilitary()) {
            for (WorldTileGroup group : $this$updateTilesForSelectedUnit.getTileGroups().values()) {
                group.getLayerMisc().dimPopulation(true);
                shownImprovement = group.getTile().getShownImprovement(unit.getCiv());
                if (shownImprovement == null || Intrinsics.areEqual(shownImprovement, "Barbarian encampment")) continue;
                v1 = unit.getCiv().getGameInfo().getRuleset().getTileImprovements().get(shownImprovement);
                Intrinsics.checkNotNull(v1);
                if (v1.isAncientRuinsEquivalent()) continue;
                group.getLayerMisc().dimImprovement(true);
            }
        }
        if ($this$updateTilesForSelectedUnit.getWorldScreen$core().getBottomUnitTable$core().getSelectedUnitIsSwapping()) {
            unitSwappableTiles = unit.getMovement().getUnitSwappableTiles();
            swapUnitsTileOverlayColor = Color.PURPLE;
            shownImprovement = unitSwappableTiles.iterator();
            while (shownImprovement.hasNext()) {
                tile = shownImprovement.next();
                v2 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                Intrinsics.checkNotNull(v2);
                v3 = v2.getLayerOverlay();
                Intrinsics.checkNotNull(swapUnitsTileOverlayColor);
                v3.showHighlight(swapUnitsTileOverlayColor, UncivGame.Companion.getCurrent().getSettings().getSingleTapMove() != false ? 0.7f : 0.3f);
            }
            return;
        }
        if ($this$updateTilesForSelectedUnit.getWorldScreen$core().getBottomUnitTable$core().getSelectedUnitIsConnectingRoad()) {
            if (unit.getCurrentTile().getRuleset().getRoadImprovement() == null) {
                return;
            }
            $this$filter$iv = unit.getCiv().getGameInfo().getTileMap().getTileList();
            $i$f$filter = false;
            tile = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-WorldMapTileUpdater$updateTilesForSelectedUnit$validTiles$1 = false;
                if (!MapPathing.INSTANCE.isValidRoadPathTile(unit, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            validTiles = (List)destination$iv$iv;
            connectRoadTileOverlayColor = Color.RED;
            for (Object tile : validTiles) {
                v4 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                Intrinsics.checkNotNull(v4);
                v5 = v4.getLayerOverlay();
                Intrinsics.checkNotNull(connectRoadTileOverlayColor);
                v5.showHighlight(connectRoadTileOverlayColor, 0.3f);
            }
            if ($this$updateTilesForSelectedUnit.getUnitConnectRoadPaths$core().containsKey(unit)) {
                v6 = $this$updateTilesForSelectedUnit.getUnitConnectRoadPaths$core().get(unit);
                Intrinsics.checkNotNull(v6);
                for (Object tile : v6) {
                    v7 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                    Intrinsics.checkNotNull(v7);
                    v8 = v7.getLayerOverlay();
                    v9 = Color.ORANGE;
                    Intrinsics.checkNotNullExpressionValue(v9, "ORANGE");
                    v8.showHighlight(v9, 0.8f);
                }
            }
            return;
        }
        isAirUnit = unit.getBaseUnit().getMovesLikeAirUnits();
        moveTileOverlayColor = unit.isPreparingParadrop() != false ? Color.BLUE : Color.WHITE;
        tilesInMoveRange = UnitMovement.getReachableTilesInCurrentTurn$default(unit.getMovement(), false, 1, null);
        nukeBlastRadius = unit.isNuclearWeapon() != false && $this$updateTilesForSelectedUnit.getSelectedTile$core() != null && Intrinsics.areEqual($this$updateTilesForSelectedUnit.getSelectedTile$core(), unit.getTile()) == false ? unit.getNukeBlastRadius() : -1;
        destination$iv$iv = tilesInMoveRange.iterator();
        while (destination$iv$iv.hasNext()) {
            block38: {
                tile = (Tile)destination$iv$iv.next();
                Intrinsics.checkNotNull($this$updateTilesForSelectedUnit.getTileGroups().get(tile));
                if (!isAirUnit || unit.isPreparingAirSweep()) break block38;
                if (nukeBlastRadius < 0) ** GOTO lbl-1000
                v10 = $this$updateTilesForSelectedUnit.getSelectedTile$core();
                Intrinsics.checkNotNull(v10);
                if (tile.aerialDistanceTo(v10) <= nukeBlastRadius) {
                    v11 = group.getLayerMisc();
                    v12 = Color.FIREBRICK;
                    Intrinsics.checkNotNullExpressionValue(v12, "FIREBRICK");
                    v11.overlayTerrain(v12, 0.6f);
                } else if (tile.aerialDistanceTo(unit.getTile()) <= unit.getRange()) {
                    v13 = group.getLayerMisc();
                    v14 = Color.RED;
                    Intrinsics.checkNotNullExpressionValue(v14, "RED");
                    v13.overlayTerrain(v14);
                } else if (tile.isExplored($this$updateTilesForSelectedUnit.getWorldScreen$core().getViewingCiv()) && tile.aerialDistanceTo(unit.getTile()) <= unit.getRange() * 2) {
                    v15 = group.getLayerMisc();
                    element$iv$iv = UnitMovement.canMoveTo$default(unit.getMovement(), (Tile)tile, false, false, false, 14, null) != false ? Color.WHITE : Color.BLUE;
                    Intrinsics.checkNotNull(element$iv$iv);
                    v15.overlayTerrain(element$iv$iv);
                }
            }
            if (!UnitMovement.canMoveTo$default(unit.getMovement(), (Tile)tile, false, false, false, 14, null) && (!unit.getMovement().isUnknownTileWeShouldAssumeToBePassable((Tile)tile) || unit.getBaseUnit().getMovesLikeAirUnits())) continue;
            alpha = UncivGame.Companion.getCurrent().getSettings().getSingleTapMove() != false ? 0.7f : 0.3f;
            v16 = group.getLayerOverlay();
            Intrinsics.checkNotNull(moveTileOverlayColor);
            v16.showHighlight(moveTileOverlayColor, alpha);
        }
        if (unit.getCache().getCannotMove() && isAirUnit && !unit.isPreparingAirSweep()) {
            tilesInAttackRange = unit.getTile().getTilesInDistanceRange(new IntRange(1, unit.getRange()));
            tile = tilesInAttackRange.iterator();
            while (tile.hasNext()) {
                tile = (Tile)tile.next();
                v17 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                Intrinsics.checkNotNull(v17);
                v18 = v17.getLayerOverlay();
                v19 = Color.RED;
                Intrinsics.checkNotNullExpressionValue(v19, "RED");
                v18.showHighlight(v19, 0.3f);
            }
        }
        if ($this$updateTilesForSelectedUnit.getUnitMovementPaths$core().containsKey(unit)) {
            v20 = $this$updateTilesForSelectedUnit.getUnitMovementPaths$core().get(unit);
            Intrinsics.checkNotNull(v20);
            for (Object tile : v20) {
                v21 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                Intrinsics.checkNotNull(v21);
                v22 = v21.getLayerOverlay();
                v23 = Color.SKY;
                Intrinsics.checkNotNullExpressionValue(v23, "SKY");
                v22.showHighlight(v23, 0.8f);
            }
        }
        if (unit.isAutomatingRoadConnection()) {
            if (unit.getAutomatedRoadConnectionPath() == null) {
                return;
            }
            v24 = unit.getAutomatedRoadConnectionPath();
            Intrinsics.checkNotNull(v24);
            currTileIndex = v24.indexOf(unit.getCurrentTile().getPosition());
            if (currTileIndex != -1) {
                v25 = unit.getAutomatedRoadConnectionPath();
                Intrinsics.checkNotNull(v25);
                $this$filterIndexed$iv = v25;
                $i$f$filterIndexed = false;
                it = $this$filterIndexed$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterIndexedTo = false;
                $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                $i$f$forEachIndexed = false;
                index$iv$iv$iv = 0;
                var18_48 = $this$forEachIndexed$iv$iv$iv.iterator();
                while (var18_48.hasNext()) {
                    item$iv$iv$iv = var18_48.next();
                    if ((var20_51 = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var21_52 = item$iv$iv$iv;
                    index$iv$iv = var20_51;
                    $i$a$-forEachIndexed-CollectionsKt___CollectionsKt$filterIndexedTo$1$iv$iv = false;
                    (Vector2)element$iv$iv;
                    index = index$iv$iv;
                    $i$a$-filterIndexed-WorldMapTileUpdater$updateTilesForSelectedUnit$futureTiles$1 = false;
                    if (!(index > currTileIndex)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIndexed$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterIndexedTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    index$iv$iv$iv = (Vector2)item$iv$iv;
                    var26_57 = destination$iv$iv;
                    $i$a$-map-WorldMapTileUpdater$updateTilesForSelectedUnit$futureTiles$2 = false;
                    var26_57.add($this$updateTilesForSelectedUnit.getTileMap$core().get((Vector2)tilePos));
                }
                futureTiles = (List)destination$iv$iv;
                for (Tile tile : futureTiles) {
                    v26 = $this$updateTilesForSelectedUnit.getTileGroups().get(tile);
                    Intrinsics.checkNotNull(v26);
                    v27 = v26.getLayerOverlay();
                    v28 = Color.ORANGE;
                    Intrinsics.checkNotNullExpressionValue(v28, "ORANGE");
                    v27.showHighlight(v28, UncivGame.Companion.getCurrent().getSettings().getSingleTapMove() != false ? 0.7f : 0.3f);
                }
            }
        }
        if (unit.isMoving()) {
            v29 = $this$updateTilesForSelectedUnit.getTileGroups().get(unit.getMovementDestination());
            Intrinsics.checkNotNull(v29);
            v30 = v29.getLayerOverlay();
            v31 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(v31, "WHITE");
            v30.showHighlight(v31, 0.7f);
        }
        if (unit.isMilitary()) {
            if (nukeBlastRadius >= 0) {
                v32 = $this$updateTilesForSelectedUnit.getSelectedTile$core();
                Intrinsics.checkNotNull(v32);
                v33 = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(v32.getTilesInDistance(nukeBlastRadius), (Function1)new Function1<Tile, Boolean>(unit){
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.$unit = $unit;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Tile targetTile) {
                        boolean bl;
                        block6: {
                            block5: {
                                block4: {
                                    boolean bl2;
                                    block3: {
                                        void $this$any$iv;
                                        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
                                        if (!targetTile.isVisible(this.$unit.getCiv())) break block4;
                                        Sequence<MapUnit> sequence = targetTile.getUnits();
                                        MapUnit mapUnit = this.$unit;
                                        boolean $i$f$any = false;
                                        for (T element$iv : $this$any$iv) {
                                            MapUnit it = (MapUnit)element$iv;
                                            boolean bl3 = false;
                                            if (!(!it.isInvisible(mapUnit.getCiv()))) continue;
                                            bl2 = true;
                                            break block3;
                                        }
                                        bl2 = false;
                                    }
                                    if (bl2) break block5;
                                }
                                if (!targetTile.isCityCenter() || !this.$unit.getCiv().hasExplored(targetTile)) break block6;
                            }
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                }), (Function1)new Function1<Tile, AttackableTile>(unit){
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.$unit = $unit;
                        super(1);
                    }

                    @NotNull
                    public final AttackableTile invoke(@NotNull Tile it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return new AttackableTile(this.$unit.getTile(), it, 1.0f, null);
                    }
                }));
            } else {
                futureTiles = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), null, false, 12, null);
                $i$f$filter = false;
                tile = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AttackableTile)element$iv$iv;
                    $i$a$-filter-WorldMapTileUpdater$updateTilesForSelectedUnit$attackableTiles$3 = false;
                    if (!it.getTileToAttack().isVisible(unit.getCiv())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$distinctBy = false;
                set$iv = new HashSet<Tile>();
                list$iv = new ArrayList<T>();
                $i$f$filterTo = $this$distinctBy$iv.iterator();
                while ($i$f$filterTo.hasNext()) {
                    e$iv = $i$f$filterTo.next();
                    it = (AttackableTile)e$iv;
                    $i$a$-distinctBy-WorldMapTileUpdater$updateTilesForSelectedUnit$attackableTiles$4 = false;
                    key$iv = it.getTileToAttack();
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                v33 = list$iv;
            }
            attackableTiles = v33;
            for (AttackableTile attackableTile : attackableTiles) {
                Intrinsics.checkNotNull($this$updateTilesForSelectedUnit.getTileGroups().get(attackableTile.getTileToAttack()));
                TileLayerOverlay.showHighlight$default(tileGroupToAttack.getLayerOverlay(), Scene2dExtensionsKt.colorFromRGB(237, 41, 57), 0.0f, 2, null);
                tileGroupToAttack.getLayerOverlay().showCrosshair(Intrinsics.areEqual(attackableTile.getTileToAttackFrom(), unit.getCurrentTile()) == false ? 0.5f : 1.0f);
            }
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.FoundCity, null, false, 6, null) && UncivGame.Companion.getCurrent().getSettings().getShowSettlersSuggestedCityLocations()) {
            $this$sortedByDescending$iv = SequencesKt.filter(MapsKt.asSequence((Map)CityLocationTileRanker.getBestTilesToFoundCity$default(CityLocationTileRanker.INSTANCE, unit, null, 50.0f, 2, null).getTileRankMap()), (Function1)new Function1<Map.Entry<? extends Tile, ? extends Float>, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Map.Entry<Tile, Float> it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getKey().isExplored(this.$unit.getCiv());
                }
            });
            $i$f$sortedByDescending = false;
            $this$forEach$iv = SequencesKt.take(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = (Float)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getValue()));
                }
            }), 3);
            $i$f$forEach = false;
            var10_25 = $this$forEach$iv.iterator();
            while (var10_25.hasNext()) {
                element$iv = var10_25.next();
                it = element$iv;
                $i$a$-forEach-WorldMapTileUpdater$updateTilesForSelectedUnit$3 = false;
                v34 = $this$updateTilesForSelectedUnit.getTileGroups().get(it.getKey());
                Intrinsics.checkNotNull(v34);
                v34.getLayerOverlay().showGoodCityLocationIndicator();
            }
        }
    }

    private final void updateTilesForSelectedSpy(WorldMapHolder $this$updateTilesForSelectedSpy, Spy spy) {
        for (WorldTileGroup group : $this$updateTilesForSelectedSpy.getTileGroups().values()) {
            group.getLayerOverlay().reset();
            if (!group.getTile().isCityCenter()) {
                group.getLayerMisc().dimImprovement(true);
            }
            group.getLayerCityButton().moveDown();
        }
        Iterator<Object> iterator2 = $this$updateTilesForSelectedSpy.getWorldScreen$core().getGameInfo().getCities().iterator();
        while (iterator2.hasNext()) {
            City city2 = (City)iterator2.next();
            if (!spy.canMoveTo(city2)) continue;
            WorldTileGroup worldTileGroup = $this$updateTilesForSelectedSpy.getTileGroups().get(city2.getCenterTile());
            Intrinsics.checkNotNull(worldTileGroup);
            TileLayerOverlay tileLayerOverlay = worldTileGroup.getLayerOverlay();
            Color color = Color.CYAN;
            Intrinsics.checkNotNullExpressionValue(color, "CYAN");
            tileLayerOverlay.showHighlight(color, 0.7f);
        }
    }

    private final void updateBombardableTilesForSelectedCity(WorldMapHolder $this$updateBombardableTilesForSelectedCity, City city2) {
        if (!city2.canBombard()) {
            return;
        }
        Iterator<Tile> iterator2 = TargetHelper.INSTANCE.getBombardableTiles(city2).iterator();
        while (iterator2.hasNext()) {
            WorldTileGroup group;
            Tile attackableTile = iterator2.next();
            Intrinsics.checkNotNull($this$updateBombardableTilesForSelectedCity.getTileGroups().get(attackableTile));
            TileLayerOverlay.showHighlight$default(group.getLayerOverlay(), Scene2dExtensionsKt.colorFromRGB(237, 41, 57), 0.0f, 2, null);
            TileLayerOverlay.showCrosshair$default(group.getLayerOverlay(), 0.0f, 1, null);
        }
    }
}

