/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.minimap;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.ExploredRegion;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.images.ClippingImage;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTile;
import com.unciv.ui.screens.worldscreen.minimap.MinimapTileUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0018H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0002J\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0013H\u0016J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0007J \u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/unciv/ui/screens/worldscreen/minimap/Minimap;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "mapHolder", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "minimapSize", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;ILcom/unciv/logic/civilization/Civilization;)V", "lastViewingCiv", "getMapHolder", "()Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "minimapTiles", "", "Lcom/unciv/ui/screens/worldscreen/minimap/MinimapTile;", "scrollPositionIndicators", "Lcom/unciv/ui/images/ClippingImage;", "tileLayer", "tileMapHeight", "", "tileMapWidth", "tileSize", "calcMinTileSize", "calcMinimapSize", "Lcom/badlogic/gdx/math/Vector2;", "calcTileSize", "createMinimapTiles", "createScrollPositionIndicators", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "update", "viewingCiv", "updateScrollPosition", "worldWidth", "worldHeight", "worldViewport", "Lcom/badlogic/gdx/math/Rectangle;", "core"})
@SourceDebugExtension(value={"SMAP\nMinimap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Minimap.kt\ncom/unciv/ui/screens/worldscreen/minimap/Minimap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1855#2,2:254\n1#3:256\n*S KotlinDebug\n*F\n+ 1 Minimap.kt\ncom/unciv/ui/screens/worldscreen/minimap/Minimap\n*L\n58#1:254,2\n*E\n"})
public final class Minimap
extends Group {
    @NotNull
    private final WorldMapHolder mapHolder;
    @Nullable
    private final Civilization civInfo;
    @NotNull
    private final Group tileLayer;
    @NotNull
    private final List<MinimapTile> minimapTiles;
    @NotNull
    private final List<ClippingImage> scrollPositionIndicators;
    @Nullable
    private Civilization lastViewingCiv;
    private float tileSize;
    private float tileMapWidth;
    private float tileMapHeight;

    /*
     * WARNING - void declaration
     */
    public Minimap(@NotNull WorldMapHolder mapHolder2, int minimapSize, @Nullable Civilization civInfo) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(mapHolder2, "mapHolder");
        this.mapHolder = mapHolder2;
        this.civInfo = civInfo;
        this.tileLayer = new Group();
        this.setTransform(false);
        Vector2 stageMinimapSize = this.calcMinimapSize(minimapSize);
        this.setSize(stageMinimapSize.x, stageMinimapSize.y);
        this.tileSize = this.calcTileSize(stageMinimapSize);
        this.minimapTiles = this.createMinimapTiles(this.tileSize);
        Rectangle tileExtension = MinimapTileUtil.INSTANCE.spreadOutMinimapTiles(this.tileLayer, this.minimapTiles, this.tileSize);
        this.tileLayer.setSize(this.getWidth(), this.getHeight());
        this.tileMapWidth = tileExtension.width;
        this.tileMapHeight = tileExtension.height;
        float padX = (stageMinimapSize.x - this.tileMapWidth) * 0.5f - tileExtension.x;
        float padY = (stageMinimapSize.y - this.tileMapHeight) * 0.5f - tileExtension.y;
        for (Actor group : this.tileLayer.getChildren()) {
            group.moveBy(padX, padY);
        }
        this.scrollPositionIndicators = this.createScrollPositionIndicators();
        Iterable iterable = this.scrollPositionIndicators;
        Group group = this.tileLayer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Actor p0 = (Actor)element$iv;
            boolean bl = false;
            group.addActor(p0);
        }
        this.addActor(this.tileLayer);
        this.mapHolder.setOnViewportChangedListener((Function3<? super Float, ? super Float, ? super Rectangle, Unit>)new Function3<Float, Float, Rectangle, Unit>((Object)this){

            @Override
            public final void invoke(float p0, float p1, @NotNull Rectangle p2) {
                Intrinsics.checkNotNullParameter(p2, "p2");
                ((Minimap)this.receiver).updateScrollPosition(p0, p1, p2);
            }
        });
    }

    @NotNull
    public final WorldMapHolder getMapHolder() {
        return this.mapHolder;
    }

    private final float calcTileSize(Vector2 minimapSize) {
        float height = 0.0f;
        float width = 0.0f;
        MapParameters mapParameters = this.mapHolder.getTileMap$core().getMapParameters();
        if (this.civInfo != null) {
            height = this.civInfo.getExploredRegion().getHeight();
            width = this.civInfo.getExploredRegion().getWidth();
        } else if (!Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            float diameter;
            height = diameter = (float)mapParameters.getMapSize().getRadius() * 2.0f + 1.0f;
            width = diameter;
        } else {
            height = mapParameters.getMapSize().getHeight();
            width = mapParameters.getMapSize().getWidth();
        }
        float result2 = Math.min(minimapSize.y / (height + 1.5f) / (float)Math.sqrt(3.0f) * 4.0f, minimapSize.x / (width + 0.5f) / 0.75f);
        return result2;
    }

    private final float calcMinTileSize(int minimapSize) {
        MapParameters $this$calcMinTileSize_u24lambda_u240 = this.mapHolder.getTileMap$core().getMapParameters();
        boolean bl = false;
        int effectiveRadius = !Intrinsics.areEqual($this$calcMinTileSize_u24lambda_u240.getShape(), "Rectangular") ? $this$calcMinTileSize_u24lambda_u240.getMapSize().getRadius() : Math.max($this$calcMinTileSize_u24lambda_u240.getMapSize().getHeight(), $this$calcMinTileSize_u24lambda_u240.getMapSize().getWidth() * 3 / 4) * MapSize.Companion.getHuge().getRadius() / MapSize.Companion.getHuge().getHeight();
        int mapSizePercent = minimapSize < 22 ? minimapSize + 9 : minimapSize * 5 - 75;
        Stage it = this.mapHolder.getWorldScreen$core().getStage();
        boolean bl2 = false;
        float smallerWorldDimension = Math.min(it.getWidth(), it.getHeight());
        return smallerWorldDimension * (float)mapSizePercent / (float)100 / (float)effectiveRadius;
    }

    private final Vector2 calcMinimapSize(int minimapSize) {
        float minimapTileSize = this.calcMinTileSize(minimapSize);
        float height = 0.0f;
        float width = 0.0f;
        MapParameters mapParameters = this.mapHolder.getTileMap$core().getMapParameters();
        if (!Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            float diameter;
            height = diameter = (float)mapParameters.getMapSize().getRadius() * 2.0f + 1.0f;
            width = diameter;
        } else {
            height = mapParameters.getMapSize().getHeight();
            width = mapParameters.getMapSize().getWidth();
        }
        width = mapParameters.getWorldWrap() ? (width - 1.0f) * minimapTileSize * 0.75f : width * minimapTileSize * 0.75f;
        return new Vector2(width, height *= minimapTileSize * (float)Math.sqrt(3.0f) * 0.5f);
    }

    private final List<ClippingImage> createScrollPositionIndicators() {
        int indicatorAmount = this.mapHolder.getContinuousScrollingX() ? 3 : 1;
        ArrayList<ClippingImage> arrayList = new ArrayList<ClippingImage>(indicatorAmount);
        int n = 0;
        while (n < indicatorAmount) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<ClippingImage> arrayList2 = arrayList;
            boolean bl = false;
            ClippingImage indicator = new ClippingImage(ImageGetter.INSTANCE.getDrawable("OtherIcons/Camera"));
            indicator.setTouchable(Touchable.disabled);
            arrayList2.add(indicator);
        }
        return arrayList;
    }

    private final List<MinimapTile> createMinimapTiles(float tileSize) {
        ArrayList<MinimapTile> tiles2 = new ArrayList<MinimapTile>();
        float pad = !Intrinsics.areEqual(this.mapHolder.getTileMap$core().getMapParameters().getShape(), "Rectangular") ? (float)this.mapHolder.getTileMap$core().getMapParameters().getMapSize().getRadius() * tileSize * 1.5f : ((float)this.mapHolder.getTileMap$core().getMapParameters().getMapSize().getWidth() - 1.0f) * tileSize * 0.75f;
        float leftSide = this.civInfo != null ? this.civInfo.getExploredRegion().getMinimapLeft(tileSize) : -3.4028235E38f;
        for (Tile tileInfo : this.mapHolder.getTileMap$core().getValues()) {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = this.civInfo;
            if (isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getExploredRegion()) != null ? !((ExploredRegion)isPartOfGameInfoSerialization).isPositionInRegion(tileInfo.getPosition()) : false) continue;
            MinimapTile minimapTile2 = new MinimapTile(tileInfo, tileSize, new Function0<Unit>(this, tileInfo){
                final /* synthetic */ Minimap this$0;
                final /* synthetic */ Tile $tileInfo;
                {
                    this.this$0 = $receiver;
                    this.$tileInfo = $tileInfo;
                    super(0);
                }

                public final void invoke() {
                    WorldMapHolder.setCenterPosition$default(this.this$0.getMapHolder(), this.$tileInfo.getPosition(), false, false, null, 14, null);
                }
            });
            if (minimapTile2.getImage().getX() < leftSide) {
                Image image2 = minimapTile2.getImage();
                image2.setX(image2.getX() + pad);
            }
            tiles2.add(minimapTile2);
        }
        return tiles2;
    }

    private final void updateScrollPosition(float worldWidth, float worldHeight, Rectangle worldViewport) {
        Rectangle rectangle;
        Rectangle exploredRectangle;
        Vector2 worldToMiniFactor = null;
        Rectangle miniViewport = worldViewport;
        if (this.civInfo != null) {
            if (this.civInfo.getExploredRegion().shouldRecalculateCoords()) {
                this.civInfo.getExploredRegion().calculateStageCoords(worldWidth, worldHeight);
            }
            exploredRectangle = this.civInfo.getExploredRegion().getRectangle();
            worldToMiniFactor = new Vector2(this.tileMapWidth / exploredRectangle.width, this.tileMapHeight / exploredRectangle.height);
            rectangle = miniViewport;
            rectangle.x -= exploredRectangle.x;
            rectangle = miniViewport;
            rectangle.y -= exploredRectangle.y;
        } else {
            worldToMiniFactor = new Vector2(this.tileLayer.getWidth() / worldWidth, this.tileLayer.getHeight() / worldHeight);
        }
        exploredRectangle = miniViewport = Minimap.updateScrollPosition$times(miniViewport, worldToMiniFactor);
        exploredRectangle.x += (this.tileLayer.getWidth() - this.tileMapWidth) * 0.5f;
        exploredRectangle = miniViewport;
        exploredRectangle.y += (this.tileLayer.getHeight() - this.tileMapHeight) * 0.5f;
        Minimap.updateScrollPosition$setViewport(this.scrollPositionIndicators.get(0), miniViewport);
        if (this.scrollPositionIndicators.size() != 1) {
            float offset = worldWidth * worldToMiniFactor.x;
            rectangle = miniViewport;
            rectangle.x -= offset;
            Minimap.updateScrollPosition$setViewport(this.scrollPositionIndicators.get(1), miniViewport);
            rectangle = miniViewport;
            rectangle.x += offset * 2.0f;
            Minimap.updateScrollPosition$setViewport(this.scrollPositionIndicators.get(2), miniViewport);
        }
    }

    public final void update(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        for (MinimapTile minimapTile2 : this.minimapTiles) {
            boolean revealStatusChanged;
            boolean ownerChanged;
            Tile tileInfo = minimapTile2.getTile();
            boolean bl = ownerChanged = !Intrinsics.areEqual(minimapTile2.getOwningCiv(), tileInfo.getOwner());
            if (ownerChanged) {
                minimapTile2.setOwningCiv(tileInfo.getOwner());
            }
            boolean shouldBeUnrevealed = !viewingCiv.hasExplored(tileInfo) && !viewingCiv.isSpectator();
            boolean bl2 = revealStatusChanged = minimapTile2.isUnrevealed() != shouldBeUnrevealed;
            if (revealStatusChanged || ownerChanged) {
                MinimapTile.updateColor$default(minimapTile2, shouldBeUnrevealed, null, 2, null);
            }
            if (shouldBeUnrevealed || !ownerChanged) continue;
            if (tileInfo.isCityCenter()) {
                MinimapTile.updateCityCircle$default(minimapTile2, null, 1, null).updateActorsIn(this);
            }
            MinimapTile.updateBorders$default(minimapTile2, null, 1, null).updateActorsIn(this);
        }
        this.lastViewingCiv = viewingCiv;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    private static final Rectangle updateScrollPosition$times(Rectangle $this$updateScrollPosition_u24times, Vector2 other) {
        Intrinsics.checkNotNullParameter($this$updateScrollPosition_u24times, "<this>");
        return new Rectangle($this$updateScrollPosition_u24times.x * other.x, $this$updateScrollPosition_u24times.y * other.y, $this$updateScrollPosition_u24times.width * other.x, $this$updateScrollPosition_u24times.height * other.y);
    }

    private static final void updateScrollPosition$setViewport(Actor $this$updateScrollPosition_u24setViewport, Rectangle rect) {
        $this$updateScrollPosition_u24setViewport.setX(rect.x);
        $this$updateScrollPosition_u24setViewport.setY(rect.y);
        $this$updateScrollPosition_u24setViewport.setWidth(rect.width);
        $this$updateScrollPosition_u24setViewport.setHeight(rect.height);
    }
}

