/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.minimap;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.ExploredRegion;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.minimap.MapOverlayToggleButton;
import com.unciv.ui.screens.worldscreen.minimap.Minimap;
import com.unciv.ui.screens.worldscreen.minimap.MinimapHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0001H\u0002J\b\u0010\"\u001a\u00020\u0001H\u0002J\u0012\u0010#\u001a\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006("}, d2={"Lcom/unciv/ui/screens/worldscreen/minimap/MinimapHolder;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "mapHolder", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "(Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;)V", "getMapHolder", "()Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "minimap", "Lcom/unciv/ui/screens/worldscreen/minimap/Minimap;", "getMinimap", "()Lcom/unciv/ui/screens/worldscreen/minimap/Minimap;", "setMinimap", "(Lcom/unciv/ui/screens/worldscreen/minimap/Minimap;)V", "minimapSize", "", "movementsImageButton", "Lcom/unciv/ui/screens/worldscreen/minimap/MapOverlayToggleButton;", "getMovementsImageButton", "()Lcom/unciv/ui/screens/worldscreen/minimap/MapOverlayToggleButton;", "populationImageButton", "getPopulationImageButton", "resourceImageButton", "getResourceImageButton", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "yieldImageButton", "getYieldImageButton", "draw", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "", "getToggleIcons", "getWrappedMinimap", "rebuild", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "rebuildIfSizeChanged", "update", "core"})
@SourceDebugExtension(value={"SMAP\nMinimapHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinimapHolder.kt\ncom/unciv/ui/screens/worldscreen/minimap/MinimapHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class MinimapHolder
extends Table {
    @NotNull
    private final WorldMapHolder mapHolder;
    @NotNull
    private final WorldScreen worldScreen;
    private int minimapSize;
    public Minimap minimap;
    @NotNull
    private final MapOverlayToggleButton movementsImageButton;
    @NotNull
    private final MapOverlayToggleButton yieldImageButton;
    @NotNull
    private final MapOverlayToggleButton populationImageButton;
    @NotNull
    private final MapOverlayToggleButton resourceImageButton;

    public MinimapHolder(@NotNull WorldMapHolder mapHolder2) {
        Intrinsics.checkNotNullParameter(mapHolder2, "mapHolder");
        this.mapHolder = mapHolder2;
        this.worldScreen = this.mapHolder.getWorldScreen$core();
        this.minimapSize = Integer.MIN_VALUE;
        this.movementsImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleMovement", 0.0f, movementsImageButton.1.INSTANCE, movementsImageButton.2.INSTANCE, 2, null);
        this.yieldImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleYields", 0.0f, yieldImageButton.1.INSTANCE, yieldImageButton.2.INSTANCE, 2, null);
        this.populationImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleWorkedTiles", 0.0f, populationImageButton.1.INSTANCE, populationImageButton.2.INSTANCE, 2, null);
        this.resourceImageButton = new MapOverlayToggleButton("TileIcons/MapOverlayToggleResources", 0.0f, resourceImageButton.1.INSTANCE, resourceImageButton.2.INSTANCE, 2, null);
    }

    @NotNull
    public final WorldMapHolder getMapHolder() {
        return this.mapHolder;
    }

    @NotNull
    public final Minimap getMinimap() {
        Minimap minimap = this.minimap;
        if (minimap != null) {
            return minimap;
        }
        Intrinsics.throwUninitializedPropertyAccessException("minimap");
        return null;
    }

    public final void setMinimap(@NotNull Minimap minimap) {
        Intrinsics.checkNotNullParameter(minimap, "<set-?>");
        this.minimap = minimap;
    }

    @NotNull
    public final MapOverlayToggleButton getMovementsImageButton() {
        return this.movementsImageButton;
    }

    @NotNull
    public final MapOverlayToggleButton getYieldImageButton() {
        return this.yieldImageButton;
    }

    @NotNull
    public final MapOverlayToggleButton getPopulationImageButton() {
        return this.populationImageButton;
    }

    @NotNull
    public final MapOverlayToggleButton getResourceImageButton() {
        return this.resourceImageButton;
    }

    private final void rebuildIfSizeChanged(Civilization civInfo) {
        Civilization civilization;
        Civilization it = civilization = civInfo;
        boolean bl = false;
        Civilization civ = !GUI.INSTANCE.getViewingPlayer().isSpectator() ? civilization : null;
        int newMinimapSize = this.worldScreen.getGame().getSettings().getMinimapSize();
        if (newMinimapSize == this.minimapSize) {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = civ;
            if (!(isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getExploredRegion()) != null ? ((ExploredRegion)isPartOfGameInfoSerialization).shouldUpdateMinimap() : false)) {
                return;
            }
        }
        this.minimapSize = newMinimapSize;
        this.rebuild(civ);
    }

    private final void rebuild(Civilization civInfo) {
        this.clear();
        this.setMinimap(new Minimap(this.mapHolder, this.minimapSize, civInfo));
        this.add((Actor)this.getToggleIcons()).align(4);
        this.add((Actor)this.getWrappedMinimap());
        this.pack();
        if (this.getStage() != null) {
            this.setX(this.getStage().getWidth() - this.getWidth());
        }
    }

    private final Table getWrappedMinimap() {
        Table internalMinimapWrapper = new Table();
        internalMinimapWrapper.add((Actor)this.getMinimap());
        internalMinimapWrapper.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/Minimap/Background", null, Color.GRAY, 2, null));
        internalMinimapWrapper.pack();
        Table externalMinimapWrapper = new Table();
        externalMinimapWrapper.add((Actor)internalMinimapWrapper).pad(5.0f);
        externalMinimapWrapper.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/Minimap/Border", null, Color.WHITE, 2, null));
        externalMinimapWrapper.pack();
        return externalMinimapWrapper;
    }

    private final Table getToggleIcons() {
        Table toggleIconTable = new Table();
        toggleIconTable.add((Actor)this.movementsImageButton).row();
        toggleIconTable.add((Actor)this.yieldImageButton).row();
        toggleIconTable.add((Actor)this.populationImageButton).row();
        toggleIconTable.add((Actor)this.resourceImageButton).row();
        return toggleIconTable;
    }

    public final void update(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.rebuildIfSizeChanged(civInfo);
        this.setVisible(UncivGame.Companion.getCurrent().getSettings().getShowMinimap());
        if (this.isVisible()) {
            this.getMinimap().update(civInfo);
            this.movementsImageButton.update();
            this.yieldImageButton.update();
            this.populationImageButton.update();
            this.resourceImageButton.update();
        }
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }
}

