/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.status;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.status.AutoPlayMenu;
import com.unciv.ui.screens.worldscreen.status.NextTurnButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/screens/worldscreen/status/AutoPlayStatusButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "Lcom/badlogic/gdx/utils/Disposable;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "nextTurnButton", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lcom/unciv/ui/screens/worldscreen/status/NextTurnButton;)V", "autoPlayImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "createAutoplayImage", "dispose", "", "core"})
public final class AutoPlayStatusButton
extends Button
implements Disposable {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final Image autoPlayImage;

    public AutoPlayStatusButton(@NotNull WorldScreen worldScreen, final @NotNull NextTurnButton nextTurnButton) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(nextTurnButton, "nextTurnButton");
        super(BaseScreen.Companion.getSkin());
        this.worldScreen = worldScreen;
        this.autoPlayImage = this.createAutoplayImage();
        Actor[] actorArray = new Actor[]{this.autoPlayImage};
        this.add((Actor)new Stack(actorArray)).pad(5.0f);
        ActivationExtensionsKt.onActivation$default(this, null, KeyboardBinding.AutoPlayMenu, new Function0<Unit>(){

            @Override
            public final void invoke() {
                if (this.getWorldScreen().getAutoPlay().isAutoPlaying()) {
                    this.getWorldScreen().getAutoPlay().stopAutoPlay();
                } else if (this.getWorldScreen().isPlayersTurn()) {
                    Stage stage = this.getStage();
                    Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
                    new AutoPlayMenu(stage, (Actor)this, nextTurnButton, this.getWorldScreen());
                }
            }
        }, 1, null);
        Function0 directAutoPlay2 = new Function0<Unit>(this, nextTurnButton){
            final /* synthetic */ AutoPlayStatusButton this$0;
            final /* synthetic */ NextTurnButton $nextTurnButton;
            {
                this.this$0 = $receiver;
                this.$nextTurnButton = $nextTurnButton;
                super(0);
            }

            public final void invoke() {
                if (!this.this$0.getWorldScreen().getGameInfo().getGameParameters().isOnlineMultiplayer() && Intrinsics.areEqual(this.this$0.getWorldScreen().getViewingCiv(), this.this$0.getWorldScreen().getGameInfo().getCurrentPlayerCiv())) {
                    this.this$0.getWorldScreen().getAutoPlay().startMultiturnAutoPlay();
                    this.$nextTurnButton.update();
                }
            }
        };
        ActivationExtensionsKt.onRightClick$default(this, null, directAutoPlay2, 1, null);
        KeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(this), KeyboardBinding.AutoPlay, 0, directAutoPlay2, 2, null);
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    private final Image createAutoplayImage() {
        Image img = ImageGetter.INSTANCE.getImage("OtherIcons/NationSwap");
        Scene2dExtensionsKt.setSize(img, 40.0f);
        return img;
    }

    @Override
    public void dispose() {
        if (this.isPressed() && this.worldScreen.getAutoPlay().isAutoPlaying()) {
            this.worldScreen.getAutoPlay().stopAutoPlay();
        }
    }
}

