/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.topbar;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.GoldenAgeManager;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ScalingTableWrapper;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.pickerscreens.PolicyPickerScreen;
import com.unciv.ui.screens.pickerscreens.TechPickerScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.topbar.WorldScreenTopBar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarStats;", "Lcom/unciv/ui/components/widgets/ScalingTableWrapper;", "topbar", "Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;", "(Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBar;)V", "cultureLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "faithLabel", "goldLabel", "happinessColor", "Lcom/badlogic/gdx/graphics/Color;", "happinessContainer", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "happinessImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "happinessLabel", "malcontentColor", "malcontentImage", "scienceLabel", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getCultureText", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "nextTurnStats", "Lcom/unciv/models/stats/Stats;", "getHappinessText", "rateLabel", "value", "", "update", "", "Companion", "core"})
public final class WorldScreenTopBarStats
extends ScalingTableWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Label goldLabel;
    @NotNull
    private final Label scienceLabel;
    @NotNull
    private final Label happinessLabel;
    @NotNull
    private final Label cultureLabel;
    @NotNull
    private final Label faithLabel;
    @NotNull
    private final Group happinessContainer;
    @NotNull
    private final Color malcontentColor;
    @NotNull
    private final Color happinessColor;
    @NotNull
    private final Image malcontentImage;
    @NotNull
    private final Image happinessImage;
    @NotNull
    private final WorldScreen worldScreen;
    public static final float defaultImageSize = 20.0f;
    public static final float defaultHorizontalPad = 3.0f;
    public static final float defaultTopPad = 8.0f;
    public static final float defaultBottomPad = 3.0f;
    public static final float defaultImageBottomPad = 6.0f;
    public static final float padRightBetweenStats = 20.0f;

    public WorldScreenTopBarStats(@NotNull WorldScreenTopBar topbar) {
        Intrinsics.checkNotNullParameter(topbar, "topbar");
        super(0.0f, 1, null);
        this.goldLabel = Scene2dExtensionsKt.toLabel$default("0", Scene2dExtensionsKt.colorFromRGB(225, 217, 71), 0, 0, false, 14, null);
        this.scienceLabel = Scene2dExtensionsKt.toLabel$default("0", Scene2dExtensionsKt.colorFromRGB(78, 140, 151), 0, 0, false, 14, null);
        this.happinessLabel = Scene2dExtensionsKt.toLabel("0");
        this.cultureLabel = Scene2dExtensionsKt.toLabel$default("0", Scene2dExtensionsKt.colorFromRGB(210, 94, 210), 0, 0, false, 14, null);
        this.faithLabel = Scene2dExtensionsKt.toLabel$default("0", Scene2dExtensionsKt.colorFromRGB(168, 196, 241), 0, 0, false, 14, null);
        this.happinessContainer = new Group();
        this.malcontentColor = Scene2dExtensionsKt.colorFromRGB(239, 83, 80);
        this.happinessColor = Scene2dExtensionsKt.colorFromRGB(92, 194, 77);
        this.malcontentImage = ImageGetter.INSTANCE.getStatIcon("Malcontent");
        this.happinessImage = ImageGetter.INSTANCE.getStatIcon("Happiness");
        this.worldScreen = topbar.getWorldScreen$core();
        this.setTransform(false);
        this.defaults().pad(8.0f, 3.0f, 3.0f, 3.0f);
        WorldScreenTopBarStats._init_$addStat$1$default(this, this.goldLabel, "Gold", EmpireOverviewCategories.Stats, false, 16, null);
        WorldScreenTopBarStats._init_$addStat$default(this, this.scienceLabel, "Science", false, new Function0<BaseScreen>(){

            @Override
            @Nullable
            public final BaseScreen invoke() {
                return new TechPickerScreen(worldScreen.getSelectedCiv(), null, false, 6, null);
            }
        }, 8, null);
        this.add(this.happinessContainer).padBottom(6.0f).size(20.0f);
        this.add(this.happinessLabel).padRight(20.0f);
        Function0 invokeResourcesPage2 = new Function0<Unit>(this){
            final /* synthetic */ WorldScreenTopBarStats this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                WorldScreenTopBarStats.access$getWorldScreen$p(this.this$0).openEmpireOverview(EmpireOverviewCategories.Resources);
            }
        };
        ActivationExtensionsKt.onClick(this.happinessContainer, invokeResourcesPage2);
        ActivationExtensionsKt.onClick(this.happinessLabel, invokeResourcesPage2);
        WorldScreenTopBarStats._init_$addStat$default(this, this.cultureLabel, "Culture", false, new Function0<BaseScreen>(){

            @Override
            @Nullable
            public final BaseScreen invoke() {
                return worldScreen.getGameInfo().getRuleset().getPolicyBranches().isEmpty() ? null : (BaseScreen)new PolicyPickerScreen(worldScreen.getSelectedCiv(), worldScreen.getCanChangeState(), null, 4, null);
            }
        }, 8, null);
        if (this.worldScreen.getGameInfo().isReligionEnabled()) {
            WorldScreenTopBarStats._init_$addStat$1(this, this.faithLabel, "Faith", EmpireOverviewCategories.Religion, true);
        } else {
            this.add(Scene2dExtensionsKt.toLabel("Religion: Off"));
        }
    }

    private final String rateLabel(float value) {
        return FormattingExtensionsKt.toStringSigned(MathKt.roundToInt(value));
    }

    public final void update(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.resetScale();
        Stats nextTurnStats = civInfo.getStats().getStatsForNextTurn();
        String goldPerTurn = " (" + this.rateLabel(nextTurnStats.getGold()) + ')';
        this.goldLabel.setText(TranslationsKt.tr(civInfo.getGold()) + goldPerTurn);
        this.scienceLabel.setText(this.rateLabel(nextTurnStats.getScience()));
        this.happinessLabel.setText(this.getHappinessText(civInfo));
        if (civInfo.getHappiness() < 0) {
            Scene2dExtensionsKt.setFontColor(this.happinessLabel, this.malcontentColor);
            this.happinessContainer.clearChildren();
            this.happinessContainer.addActor(this.malcontentImage);
        } else {
            Scene2dExtensionsKt.setFontColor(this.happinessLabel, this.happinessColor);
            this.happinessContainer.clearChildren();
            this.happinessContainer.addActor(this.happinessImage);
        }
        this.cultureLabel.setText(this.getCultureText(civInfo, nextTurnStats));
        this.faithLabel.setText(TranslationsKt.tr(civInfo.getReligionManager().getStoredFaith()) + " (" + this.rateLabel(nextTurnStats.getFaith()) + ')');
        this.scaleTo(this.worldScreen.getStage().getWidth());
    }

    private final String getCultureText(Civilization civInfo, Stats nextTurnStats) {
        String cultureString = this.rateLabel(nextTurnStats.getCulture());
        float turnsToNextPolicy = (float)(civInfo.getPolicies().getCultureNeededForNextPolicy() - civInfo.getPolicies().getStoredCulture()) / nextTurnStats.getCulture();
        cultureString = cultureString + (turnsToNextPolicy <= 0.0f ? " (!)" : (nextTurnStats.getCulture() <= 0.0f ? " (\u221e)" : " (" + TranslationsKt.tr((int)Math.ceil(turnsToNextPolicy)) + ')'));
        return cultureString;
    }

    private final String getHappinessText(Civilization civInfo) {
        String happinessText = TranslationsKt.tr(civInfo.getHappiness());
        GoldenAgeManager goldenAges = civInfo.getGoldenAges();
        happinessText = happinessText + (goldenAges.isGoldenAge() ? TranslationsKt.tr$default("    {GOLDEN AGE}(" + goldenAges.getTurnsLeftForCurrentGoldenAge() + ')', false, 1, null) : " (" + TranslationsKt.tr(goldenAges.getStoredHappiness()) + '/' + TranslationsKt.tr(goldenAges.happinessRequiredForNextGoldenAge()) + ')');
        return happinessText;
    }

    private static final void _init_$addStat(WorldScreenTopBarStats this$0, Label label2, String icon, boolean isLast, Function0<? extends BaseScreen> screenFactory) {
        Cell<Actor> cell2;
        Image image2 = ImageGetter.INSTANCE.getStatIcon(icon);
        Function0 action2 = new Function0<Unit>(screenFactory, this$0){
            final /* synthetic */ Function0<BaseScreen> $screenFactory;
            final /* synthetic */ WorldScreenTopBarStats this$0;
            {
                this.$screenFactory = $screenFactory;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BaseScreen screen = this.$screenFactory.invoke();
                if (screen != null) {
                    WorldScreenTopBarStats.access$getWorldScreen$p(this.this$0).getGame().pushScreen(screen);
                }
            }
        };
        ActivationExtensionsKt.onClick(label2, action2);
        ActivationExtensionsKt.onClick(image2, action2);
        this$0.add(label2);
        Cell<Actor> $this$addStat_u24lambda_u240 = cell2 = this$0.add(image2).padBottom(6.0f).size(20.0f);
        boolean bl = false;
        if (!isLast) {
            $this$addStat_u24lambda_u240.padRight(20.0f);
        }
    }

    static /* synthetic */ void _init_$addStat$default(WorldScreenTopBarStats worldScreenTopBarStats, Label label2, String string, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        WorldScreenTopBarStats._init_$addStat(worldScreenTopBarStats, label2, string, bl, function0);
    }

    private static final void _init_$addStat$1(WorldScreenTopBarStats this$0, Label label2, String icon, EmpireOverviewCategories overviewPage, boolean isLast) {
        WorldScreenTopBarStats._init_$addStat(this$0, label2, icon, isLast, (Function0<? extends BaseScreen>)new Function0<BaseScreen>(this$0, overviewPage){
            final /* synthetic */ WorldScreenTopBarStats this$0;
            final /* synthetic */ EmpireOverviewCategories $overviewPage;
            {
                this.this$0 = $receiver;
                this.$overviewPage = $overviewPage;
                super(0);
            }

            @Nullable
            public final BaseScreen invoke() {
                return new EmpireOverviewScreen(WorldScreenTopBarStats.access$getWorldScreen$p(this.this$0).getSelectedCiv(), this.$overviewPage, null, 4, null);
            }
        });
    }

    static /* synthetic */ void _init_$addStat$1$default(WorldScreenTopBarStats worldScreenTopBarStats, Label label2, String string, EmpireOverviewCategories empireOverviewCategories, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        WorldScreenTopBarStats._init_$addStat$1(worldScreenTopBarStats, label2, string, empireOverviewCategories, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/worldscreen/topbar/WorldScreenTopBarStats$Companion;", "", "()V", "defaultBottomPad", "", "defaultHorizontalPad", "defaultImageBottomPad", "defaultImageSize", "defaultTopPad", "padRightBetweenStats", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

