/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/IdleUnitButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "unitTable", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "tileMapHolder", "Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;", "previous", "", "(Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;Lcom/unciv/ui/screens/worldscreen/WorldMapHolder;Z)V", "image", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getImage", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getPrevious", "()Z", "getUnitTable$core", "()Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "disable", "", "enable", "core"})
public final class IdleUnitButton
extends Table {
    @NotNull
    private final UnitTable unitTable;
    @NotNull
    private final WorldMapHolder tileMapHolder;
    private final boolean previous;
    @NotNull
    private final Image image;

    public IdleUnitButton(@NotNull UnitTable unitTable, @NotNull WorldMapHolder tileMapHolder, boolean previous) {
        Intrinsics.checkNotNullParameter(unitTable, "unitTable");
        Intrinsics.checkNotNullParameter(tileMapHolder, "tileMapHolder");
        this.unitTable = unitTable;
        this.tileMapHolder = tileMapHolder;
        this.previous = previous;
        this.image = ImageGetter.INSTANCE.getImage("OtherIcons/BackArrow");
        float imageSize = 25.0f;
        if (!this.previous) {
            this.image.setSize(imageSize, imageSize);
            this.image.setOrigin(1);
            this.image.rotateBy(180.0f);
        }
        Cell<Actor> cell2 = this.add((Actor)this.image).size(imageSize);
        Intrinsics.checkNotNullExpressionValue(cell2, "size(...)");
        Scene2dExtensionsKt.pad(cell2, 10.0f, 20.0f);
        this.enable();
        ActivationExtensionsKt.onClick(this, new Function0<Unit>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public final void invoke() {
                idleUnits = this.getUnitTable$core().getWorldScreen().getViewingCiv().getUnits().getIdleUnits();
                if (SequencesKt.none(idleUnits)) {
                    return;
                }
                unitToSelect = null;
                if (this.getUnitTable$core().getSelectedUnit() == null) ** GOTO lbl-1000
                v0 = this.getUnitTable$core().getSelectedUnit();
                Intrinsics.checkNotNull(v0);
                if (!SequencesKt.contains(idleUnits, v0)) lbl-1000:
                // 2 sources

                {
                    unitToSelect = SequencesKt.first(idleUnits);
                } else {
                    v1 = this.getUnitTable$core().getSelectedUnit();
                    Intrinsics.checkNotNull(v1);
                    index = SequencesKt.indexOf(idleUnits, v1);
                    index = this.getPrevious() ? --index : ++index;
                    index += SequencesKt.count(idleUnits);
                    unitToSelect = SequencesKt.elementAt(idleUnits, index %= SequencesKt.count(idleUnits));
                }
                unitToSelect.setDue(false);
                WorldMapHolder.setCenterPosition$default(IdleUnitButton.access$getTileMapHolder$p(this), unitToSelect.getCurrentTile().getPosition(), false, false, null, 14, null);
                UnitTable.selectUnit$default(this.getUnitTable$core(), unitToSelect, false, 2, null);
                this.getUnitTable$core().getWorldScreen().setShouldUpdate(true);
            }
        });
    }

    @NotNull
    public final UnitTable getUnitTable$core() {
        return this.unitTable;
    }

    public final boolean getPrevious() {
        return this.previous;
    }

    @NotNull
    public final Image getImage() {
        return this.image;
    }

    public final void enable() {
        this.image.setColor(Color.WHITE);
        this.setTouchable(Touchable.enabled);
    }

    public final void disable() {
        this.image.setColor(Color.GRAY);
        this.setTouchable(Touchable.disabled);
    }

    public static final /* synthetic */ WorldMapHolder access$getTileMapHolder$p(IdleUnitButton $this) {
        return $this.tileMapHolder;
    }
}

