/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.CityRenamePopup;
import com.unciv.ui.screens.pickerscreens.PromotionPickerScreen;
import com.unciv.ui.screens.pickerscreens.UnitRenamePopup;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.IdleUnitButton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0018H\u0002J\u000e\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\fJ\u0010\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\u0012J\u001c\u0010=\u001a\u00020;2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010>\u001a\u00020\u001cJ\u001a\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u0018J\u0006\u0010C\u001a\u00020;R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R!\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u00180&j\b\u0012\u0004\u0012\u00020\u0018`'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006D"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "bg", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "nextIdleUnitButton", "Lcom/unciv/ui/screens/worldscreen/unit/IdleUnitButton;", "prevIdleUnitButton", "promotionsTable", "selectedCity", "Lcom/unciv/logic/city/City;", "getSelectedCity", "()Lcom/unciv/logic/city/City;", "setSelectedCity", "(Lcom/unciv/logic/city/City;)V", "selectedSpy", "Lcom/unciv/models/Spy;", "getSelectedSpy", "()Lcom/unciv/models/Spy;", "setSelectedSpy", "(Lcom/unciv/models/Spy;)V", "selectedUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getSelectedUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "selectedUnitHasChanged", "", "selectedUnitIsConnectingRoad", "getSelectedUnitIsConnectingRoad", "()Z", "setSelectedUnitIsConnectingRoad", "(Z)V", "selectedUnitIsSwapping", "getSelectedUnitIsSwapping", "setSelectedUnitIsSwapping", "selectedUnits", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSelectedUnits", "()Ljava/util/ArrayList;", "separator", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getSeparator", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "unitDescriptionTable", "unitIconHolder", "unitIconNameGroup", "unitNameLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "buildNameLabelText", "", "unit", "citySelected", "city", "selectSpy", "", "spy", "selectUnit", "append", "tileSelected", "selectedTile", "Lcom/unciv/logic/map/tile/Tile;", "forceSelectUnit", "update", "core"})
public final class UnitTable
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final IdleUnitButton prevIdleUnitButton;
    @NotNull
    private final IdleUnitButton nextIdleUnitButton;
    @NotNull
    private final Table unitIconHolder;
    @NotNull
    private final Label unitNameLabel;
    @NotNull
    private final Table unitIconNameGroup;
    @NotNull
    private final Table promotionsTable;
    @NotNull
    private final Table unitDescriptionTable;
    @NotNull
    private final ArrayList<MapUnit> selectedUnits;
    private boolean selectedUnitIsSwapping;
    private boolean selectedUnitIsConnectingRoad;
    @Nullable
    private City selectedCity;
    private boolean selectedUnitHasChanged;
    @NotNull
    private final Actor separator;
    @Nullable
    private Spy selectedSpy;
    @NotNull
    private Image bg;

    /*
     * WARNING - void declaration
     */
    public UnitTable(@NotNull WorldScreen worldScreen) {
        void $this$_init__u24lambda_u241;
        Table table2;
        Table table3;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.worldScreen = worldScreen;
        this.prevIdleUnitButton = new IdleUnitButton(this, this.worldScreen.getMapHolder(), true);
        this.nextIdleUnitButton = new IdleUnitButton(this, this.worldScreen.getMapHolder(), false);
        this.unitIconHolder = new Table();
        this.unitNameLabel = Scene2dExtensionsKt.toLabel("");
        this.unitIconNameGroup = new Table();
        this.promotionsTable = new Table();
        this.unitDescriptionTable = new Table(BaseScreen.Companion.getSkin());
        this.selectedUnits = new ArrayList();
        this.bg = new Image(BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/UnitTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f)));
        this.pad(5.0f);
        this.setTouchable(Touchable.enabled);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/UnitTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), null, 4, null));
        this.addActor(this.bg);
        this.promotionsTable.setTouchable(Touchable.enabled);
        Color color = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
        Color color2 = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color2, "RED");
        Group deselectUnitButton2 = Scene2dExtensionsKt.getCloseButton(50.0f, 20.0f, color, color2, new Function0<Unit>(this){
            final /* synthetic */ UnitTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                UnitTable.selectUnit$default(this.this$0, null, false, 3, null);
                this.this$0.getWorldScreen().setShouldUpdate(true);
                this.this$0.setVisible(false);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(deselectUnitButton2).clear();
        this.add((Actor)deselectUnitButton2).left();
        Table table4 = table3 = new Table();
        UnitTable unitTable = this;
        boolean bl = false;
        Table $this$lambda_u241_u24lambda_u240 = table2 = new Table();
        boolean bl2 = false;
        $this$lambda_u241_u24lambda_u240.add((Actor)this.prevIdleUnitButton);
        this.unitIconNameGroup.add((Actor)this.unitIconHolder);
        this.unitIconNameGroup.add((Actor)this.unitNameLabel).pad(5.0f);
        this.unitIconHolder.setTouchable(Touchable.enabled);
        this.unitNameLabel.setTouchable(Touchable.enabled);
        $this$lambda_u241_u24lambda_u240.add((Actor)this.unitIconNameGroup);
        $this$lambda_u241_u24lambda_u240.add((Actor)this.nextIdleUnitButton);
        Table moveBetweenUnitsTable = table2;
        $this$_init__u24lambda_u241.add((Actor)moveBetweenUnitsTable).fill().row();
        Object t = Scene2dExtensionsKt.addSeparator$default((Table)$this$_init__u24lambda_u241, null, 0, 0.0f, 7, null).padBottom(5.0f).getActor();
        Intrinsics.checkNotNull(t);
        this.separator = t;
        $this$_init__u24lambda_u241.add((Actor)this.promotionsTable).row();
        $this$_init__u24lambda_u241.add((Actor)this.unitDescriptionTable);
        $this$_init__u24lambda_u241.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick((Actor)$this$_init__u24lambda_u241, new Function0<Unit>(this){
            final /* synthetic */ UnitTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Object position;
                Object object = this.this$0.getSelectedUnit();
                if (object == null || (object = ((MapUnit)object).getCurrentTile()) == null || (object = ((Tile)object).getPosition()) == null) {
                    City city2 = this.this$0.getSelectedCity();
                    object = city2 != null ? city2.getLocation() : null;
                }
                if ((position = object) != null) {
                    WorldMapHolder.setCenterPosition$default(this.this$0.getWorldScreen().getMapHolder(), (Vector2)position, false, false, null, 8, null);
                }
            }
        });
        unitTable.add((Actor)table3).expand();
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    @Nullable
    public final MapUnit getSelectedUnit() {
        return (MapUnit)CollectionsKt.firstOrNull((List)this.selectedUnits);
    }

    @NotNull
    public final ArrayList<MapUnit> getSelectedUnits() {
        return this.selectedUnits;
    }

    public final boolean getSelectedUnitIsSwapping() {
        return this.selectedUnitIsSwapping;
    }

    public final void setSelectedUnitIsSwapping(boolean bl) {
        this.selectedUnitIsSwapping = bl;
    }

    public final boolean getSelectedUnitIsConnectingRoad() {
        return this.selectedUnitIsConnectingRoad;
    }

    public final void setSelectedUnitIsConnectingRoad(boolean bl) {
        this.selectedUnitIsConnectingRoad = bl;
    }

    public final void selectUnit(@Nullable MapUnit unit, boolean append2) {
        if (!append2) {
            this.selectedUnits.clear();
        }
        this.selectedCity = null;
        if (unit != null) {
            this.selectedUnits.add(unit);
            unit.actionsOnDeselect();
        }
        this.selectedUnitIsSwapping = false;
        this.selectedUnitIsConnectingRoad = false;
        this.selectedSpy = null;
    }

    public static /* synthetic */ void selectUnit$default(UnitTable unitTable, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            mapUnit = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        unitTable.selectUnit(mapUnit, bl);
    }

    @Nullable
    public final City getSelectedCity() {
        return this.selectedCity;
    }

    public final void setSelectedCity(@Nullable City city2) {
        this.selectedCity = city2;
    }

    @NotNull
    public final Actor getSeparator() {
        return this.separator;
    }

    @Nullable
    public final Spy getSelectedSpy() {
        return this.selectedSpy;
    }

    public final void setSelectedSpy(@Nullable Spy spy) {
        this.selectedSpy = spy;
    }

    public final void selectSpy(@Nullable Spy spy) {
        this.selectedSpy = spy;
        this.selectedCity = null;
        this.selectedUnits.clear();
        this.selectedUnitIsSwapping = false;
        this.selectedUnitIsConnectingRoad = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void update() {
        Table table2;
        Object nameLabelText;
        if (this.getSelectedUnit() != null) {
            this.setVisible(true);
            MapUnit mapUnit = this.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (!Intrinsics.areEqual(mapUnit.getCiv(), this.worldScreen.getViewingCiv()) && !this.worldScreen.getViewingCiv().isSpectator()) {
                UnitTable.selectUnit$default(this, null, false, 3, null);
                this.selectedUnitHasChanged = true;
            } else {
                MapUnit mapUnit2 = this.getSelectedUnit();
                Intrinsics.checkNotNull(mapUnit2);
                Sequence<MapUnit> sequence = mapUnit2.getTile().getUnits();
                MapUnit mapUnit3 = this.getSelectedUnit();
                Intrinsics.checkNotNull(mapUnit3);
                if (!SequencesKt.contains(sequence, mapUnit3)) {
                    UnitTable.selectUnit$default(this, null, false, 3, null);
                    this.selectedUnitHasChanged = true;
                }
            }
        }
        if (SequencesKt.any(this.worldScreen.getViewingCiv().getUnits().getIdleUnits())) {
            this.prevIdleUnitButton.enable();
            this.nextIdleUnitButton.enable();
        } else {
            this.prevIdleUnitButton.disable();
            this.nextIdleUnitButton.disable();
        }
        if (this.getSelectedUnit() != null) {
            if (this.selectedUnits.size() == 1) {
                int interceptionRange;
                this.separator.setVisible(true);
                MapUnit mapUnit = this.getSelectedUnit();
                Intrinsics.checkNotNull(mapUnit);
                MapUnit unit = mapUnit;
                nameLabelText = this.buildNameLabelText(unit);
                if (!Intrinsics.areEqual(nameLabelText, this.unitNameLabel.getText().toString())) {
                    this.unitNameLabel.setText((CharSequence)nameLabelText);
                    this.selectedUnitHasChanged = true;
                }
                this.unitNameLabel.clearListeners();
                ActivationExtensionsKt.onClick(this.unitNameLabel, new Function0<Unit>(this, unit){
                    final /* synthetic */ UnitTable this$0;
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.this$0 = $receiver;
                        this.$unit = $unit;
                        super(0);
                    }

                    public final void invoke() {
                        if (!this.this$0.getWorldScreen().getCanChangeState()) {
                            return;
                        }
                        new UnitRenamePopup(this.this$0.getWorldScreen(), this.$unit, new Function0<Unit>(this.this$0, this.$unit){
                            final /* synthetic */ UnitTable this$0;
                            final /* synthetic */ MapUnit $unit;
                            {
                                this.this$0 = $receiver;
                                this.$unit = $unit;
                                super(0);
                            }

                            public final void invoke() {
                                UnitTable.access$getUnitNameLabel$p(this.this$0).setText(UnitTable.access$buildNameLabelText(this.this$0, this.$unit));
                                UnitTable.access$setSelectedUnitHasChanged$p(this.this$0, true);
                            }
                        });
                    }
                });
                this.unitDescriptionTable.clear();
                this.unitDescriptionTable.defaults().pad(2.0f);
                this.unitDescriptionTable.add((Actor)ImageGetter.INSTANCE.getStatIcon("Movement")).size(20.0f);
                this.unitDescriptionTable.add(unit.getMovementString()).padRight(10.0f);
                if (!unit.isCivilian()) {
                    this.unitDescriptionTable.add((Actor)ImageGetter.INSTANCE.getStatIcon("Strength")).size(20.0f);
                    this.unitDescriptionTable.add(String.valueOf(unit.getBaseUnit().getStrength())).padRight(10.0f);
                }
                if (unit.getBaseUnit().getRangedStrength() != 0) {
                    this.unitDescriptionTable.add((Actor)ImageGetter.INSTANCE.getStatIcon("RangedStrength")).size(20.0f);
                    this.unitDescriptionTable.add(String.valueOf(unit.getBaseUnit().getRangedStrength())).padRight(10.0f);
                }
                if (unit.getBaseUnit().isRanged()) {
                    this.unitDescriptionTable.add((Actor)ImageGetter.INSTANCE.getStatIcon("Range")).size(20.0f);
                    this.unitDescriptionTable.add(String.valueOf(unit.getRange())).padRight(10.0f);
                }
                if ((interceptionRange = unit.getInterceptionRange()) > 0) {
                    this.unitDescriptionTable.add((Actor)ImageGetter.INSTANCE.getStatIcon("InterceptRange")).size(20.0f);
                    this.unitDescriptionTable.add(String.valueOf(interceptionRange)).padRight(10.0f);
                }
                if (!unit.isCivilian()) {
                    void $this$update_u24lambda_u242;
                    Label label2;
                    Label label3 = label2 = Scene2dExtensionsKt.toLabel("XP");
                    table2 = this.unitDescriptionTable;
                    boolean bl = false;
                    ActivationExtensionsKt.onClick((Actor)$this$update_u24lambda_u242, new Function0<Unit>(this, unit){
                        final /* synthetic */ UnitTable this$0;
                        final /* synthetic */ MapUnit $unit;
                        {
                            this.this$0 = $receiver;
                            this.$unit = $unit;
                            super(0);
                        }

                        public final void invoke() {
                            if (this.this$0.getSelectedUnit() == null) {
                                return;
                            }
                            this.this$0.getWorldScreen().getGame().pushScreen(new PromotionPickerScreen(this.$unit, false, null, 6, null));
                        }
                    });
                    table2.add((Actor)label2);
                    this.unitDescriptionTable.add("" + unit.getPromotions().getXP() + '/' + unit.getPromotions().xpForNextPromotion());
                }
                if (unit.getBaseUnit().getReligiousStrength() > 0) {
                    this.unitDescriptionTable.add((Actor)ImageGetter.INSTANCE.getStatIcon("ReligiousStrength")).size(20.0f);
                    this.unitDescriptionTable.add(String.valueOf(unit.getBaseUnit().getReligiousStrength() - unit.getReligiousStrengthLost()));
                }
                if (unit.getPromotions().getPromotions().size() != this.promotionsTable.getChildren().size) {
                    this.selectedUnitHasChanged = true;
                }
            } else {
                this.unitNameLabel.setText("");
                this.unitDescriptionTable.clear();
            }
        } else if (this.selectedCity != null) {
            this.setVisible(true);
            this.separator.setVisible(true);
            City city2 = this.selectedCity;
            Intrinsics.checkNotNull(city2);
            City city3 = city2;
            nameLabelText = TranslationsKt.tr$default(city3.getName(), false, 1, null);
            if (city3.getHealth() < city3.getMaxHealth$core()) {
                nameLabelText = (String)nameLabelText + " (" + TranslationsKt.tr(city3.getHealth()) + ')';
            }
            this.unitNameLabel.setText((CharSequence)nameLabelText);
            this.unitNameLabel.clearListeners();
            ActivationExtensionsKt.onClick(this.unitNameLabel, new Function0<Unit>(this, city3){
                final /* synthetic */ UnitTable this$0;
                final /* synthetic */ City $city;
                {
                    this.this$0 = $receiver;
                    this.$city = $city;
                    super(0);
                }

                public final void invoke() {
                    if (!this.this$0.getWorldScreen().getCanChangeState()) {
                        return;
                    }
                    new CityRenamePopup(this.this$0.getWorldScreen(), this.$city, new Function0<Unit>(this.this$0, this.$city){
                        final /* synthetic */ UnitTable this$0;
                        final /* synthetic */ City $city;
                        {
                            this.this$0 = $receiver;
                            this.$city = $city;
                            super(0);
                        }

                        public final void invoke() {
                            UnitTable.access$getUnitNameLabel$p(this.this$0).setText(TranslationsKt.tr$default(this.$city.getName(), false, 1, null));
                            this.this$0.getWorldScreen().setShouldUpdate(true);
                        }
                    });
                }
            });
            this.unitDescriptionTable.clear();
            this.unitDescriptionTable.defaults().pad(2.0f).padRight(5.0f);
            this.unitDescriptionTable.add(TranslationsKt.tr$default("Strength", false, 1, null));
            this.unitDescriptionTable.add(String.valueOf(ICombatant.DefaultImpls.getDefendingStrength$default(new CityCombatant(city3), false, 1, null))).row();
            this.unitDescriptionTable.add(TranslationsKt.tr$default("Bombard strength", false, 1, null));
            this.unitDescriptionTable.add(String.valueOf(new CityCombatant(city3).getAttackingStrength())).row();
            this.selectedUnitHasChanged = true;
        } else if (this.selectedSpy != null) {
            Color color;
            void $this$update_u24lambda_u243;
            Spy spy = this.selectedSpy;
            Intrinsics.checkNotNull(spy);
            Spy spy2 = spy;
            this.setVisible(true);
            this.unitNameLabel.clearListeners();
            this.unitNameLabel.setText(spy2.getName());
            this.unitDescriptionTable.clear();
            this.unitIconHolder.clear();
            Object interceptionRange = nameLabelText = ImageGetter.INSTANCE.getImage("OtherIcons/Spy_White");
            table2 = this.unitIconHolder;
            boolean bl = false;
            $this$update_u24lambda_u243.setColor(Color.WHITE);
            table2.add((Actor)nameLabelText).size(30.0f);
            this.separator.setVisible(true);
            switch (spy2.getRank()) {
                case 1: {
                    color = Color.BROWN;
                    break;
                }
                case 2: {
                    color = Color.LIGHT_GRAY;
                    break;
                }
                case 3: {
                    color = Color.GOLD;
                    break;
                }
                default: {
                    color = Color.BLACK;
                }
            }
            Color color2 = color;
            int n = spy2.getRank();
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl2 = false;
                Image star = ImageGetter.INSTANCE.getImage("OtherIcons/Star");
                star.setColor(color2);
                this.unitDescriptionTable.add((Actor)star).size(20.0f).pad(1.0f);
            }
        } else {
            this.setVisible(false);
        }
        if (!this.selectedUnitHasChanged) {
            return;
        }
        this.unitIconHolder.clear();
        this.promotionsTable.clear();
        this.unitDescriptionTable.clearListeners();
        this.separator.setWidth(0.0f);
        if (this.getSelectedUnit() != null) {
            if (this.selectedUnits.size() == 1) {
                MapUnit mapUnit = this.getSelectedUnit();
                Intrinsics.checkNotNull(mapUnit);
                this.unitIconHolder.add((Actor)new UnitIconGroup(mapUnit, 30.0f)).pad(5.0f);
                MapUnit mapUnit4 = this.getSelectedUnit();
                Intrinsics.checkNotNull(mapUnit4);
                Iterator<Object> iterator2 = mapUnit4.getPromotions().getPromotions(true).iterator();
                while (iterator2.hasNext()) {
                    Promotion promotion2 = (Promotion)iterator2.next();
                    this.promotionsTable.add((Actor)ImageGetter.getPromotionPortrait$default(ImageGetter.INSTANCE, promotion2.getName(), 0.0f, 2, null)).padBottom(2.0f);
                }
                ActivationExtensionsKt.onClick(this.promotionsTable, new Function0<Unit>(this){
                    final /* synthetic */ UnitTable this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        block3: {
                            block2: {
                                if (this.this$0.getSelectedUnit() == null) break block2;
                                MapUnit mapUnit = this.this$0.getSelectedUnit();
                                Intrinsics.checkNotNull(mapUnit);
                                if (!mapUnit.getPromotions().getPromotions().isEmpty()) break block3;
                            }
                            return;
                        }
                        UncivGame uncivGame = this.this$0.getWorldScreen().getGame();
                        MapUnit mapUnit = this.this$0.getSelectedUnit();
                        Intrinsics.checkNotNull(mapUnit);
                        uncivGame.pushScreen(new PromotionPickerScreen(mapUnit, false, null, 6, null));
                    }
                });
                ActivationExtensionsKt.onClick(this.unitIconHolder, new Function0<Unit>(this){
                    final /* synthetic */ UnitTable this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        WorldScreen worldScreen = this.this$0.getWorldScreen();
                        MapUnit mapUnit = this.this$0.getSelectedUnit();
                        Intrinsics.checkNotNull(mapUnit);
                        worldScreen.openCivilopedia(mapUnit.getBaseUnit().makeLink());
                    }
                });
            } else {
                for (MapUnit unit : this.selectedUnits) {
                    Intrinsics.checkNotNull(unit);
                    this.unitIconHolder.add((Actor)new UnitIconGroup(unit, 30.0f)).pad(5.0f);
                }
            }
        }
        this.pack();
        this.bg.setSize(this.getWidth() - 3.0f, this.getHeight() - 3.0f);
        Scene2dExtensionsKt.center((Actor)this.bg, this);
        this.selectedUnitHasChanged = false;
    }

    private final String buildNameLabelText(MapUnit unit) {
        String nameLabelText = TranslationsKt.tr(unit.displayName(), true);
        if (unit.getHealth() < 100) {
            nameLabelText = nameLabelText + " (" + TranslationsKt.tr(unit.getHealth()) + ')';
        }
        return nameLabelText;
    }

    public final boolean citySelected(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        if (this.selectedUnitIsConnectingRoad) {
            UnitTable.selectUnit$default(this, this.selectedUnits.get(0), false, 2, null);
            this.selectedUnitIsConnectingRoad = true;
        } else {
            UnitTable.selectUnit$default(this, null, false, 3, null);
        }
        if (Intrinsics.areEqual(city2, this.selectedCity)) {
            return false;
        }
        this.selectedCity = city2;
        this.selectedUnitHasChanged = true;
        this.worldScreen.setShouldUpdate(true);
        return true;
    }

    public final void tileSelected(@NotNull Tile selectedTile, @Nullable MapUnit forceSelectUnit) {
        Intrinsics.checkNotNullParameter(selectedTile, "selectedTile");
        MapUnit previouslySelectedUnit = this.getSelectedUnit();
        int previousNumberOfSelectedUnits = this.selectedUnits.size();
        if (this.selectedUnitIsSwapping && this.getSelectedUnit() != null) {
            MapUnit mapUnit = this.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (mapUnit.getMovement().canUnitSwapTo(selectedTile)) {
                return;
            }
        }
        if (this.getSelectedUnit() != null) {
            MapUnit mapUnit = this.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (mapUnit.isPreparingAirSweep()) {
                return;
            }
        }
        MapUnit civUnit = selectedTile.getCivilianUnit();
        MapUnit milUnit = selectedTile.getMilitaryUnit();
        MapUnit curUnit = this.getSelectedUnit();
        MapUnit nextUnit = null;
        MapUnit priorityUnit = milUnit != null && UnitTable.tileSelected$isEligible(milUnit, this) ? milUnit : (civUnit != null && UnitTable.tileSelected$isEligible(civUnit, this) ? civUnit : null);
        nextUnit = curUnit == null ? priorityUnit : (Intrinsics.areEqual(curUnit, civUnit) && milUnit != null && UnitTable.tileSelected$isEligible(milUnit, this) ? null : (Intrinsics.areEqual(curUnit, milUnit) && civUnit != null && UnitTable.tileSelected$isEligible(civUnit, this) ? civUnit : priorityUnit));
        if (forceSelectUnit != null) {
            UnitTable.selectUnit$default(this, forceSelectUnit, false, 2, null);
        } else if (selectedTile.isCityCenter() && (Intrinsics.areEqual(selectedTile.getOwner(), this.worldScreen.getViewingCiv()) || this.worldScreen.getViewingCiv().isSpectator())) {
            City city2 = selectedTile.getCity();
            Intrinsics.checkNotNull(city2);
            this.citySelected(city2);
        } else {
            MapUnit mapUnit = nextUnit;
            if (mapUnit != null) {
                Input input2 = Gdx.input;
                Intrinsics.checkNotNullExpressionValue(input2, "input");
                this.selectUnit(mapUnit, Scene2dExtensionsKt.isShiftKeyPressed(input2));
            } else {
                MapUnit mapUnit2 = previouslySelectedUnit;
                if (Intrinsics.areEqual(selectedTile, mapUnit2 != null ? mapUnit2.getCurrentTile() : null)) {
                    UnitTable.selectUnit$default(this, null, false, 3, null);
                    this.setVisible(false);
                }
            }
        }
        if (!Intrinsics.areEqual(this.getSelectedUnit(), previouslySelectedUnit) || this.selectedUnits.size() != previousNumberOfSelectedUnits) {
            this.selectedUnitHasChanged = true;
        }
    }

    public static /* synthetic */ void tileSelected$default(UnitTable unitTable, Tile tile, MapUnit mapUnit, int n, Object object) {
        if ((n & 2) != 0) {
            mapUnit = null;
        }
        unitTable.tileSelected(tile, mapUnit);
    }

    private static final boolean tileSelected$isEligible(MapUnit $this$tileSelected_u24isEligible, UnitTable this$0) {
        return (Intrinsics.areEqual($this$tileSelected_u24isEligible.getCiv(), this$0.worldScreen.getViewingCiv()) || this$0.worldScreen.getViewingCiv().isSpectator()) && !this$0.selectedUnits.contains($this$tileSelected_u24isEligible);
    }

    public static final /* synthetic */ Label access$getUnitNameLabel$p(UnitTable $this) {
        return $this.unitNameLabel;
    }

    public static final /* synthetic */ String access$buildNameLabelText(UnitTable $this, MapUnit unit) {
        return $this.buildNameLabelText(unit);
    }

    public static final /* synthetic */ void access$setSelectedUnitHasChanged$p(UnitTable $this, boolean bl) {
        $this.selectedUnitHasChanged = bl;
    }
}

