/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.actions;

import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UncivSound;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000bJ#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsPillage;", "", "()V", "canPillage", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getPillageAction", "Lcom/unciv/models/UnitAction;", "getPillageAction$core", "getPillageActions", "Lkotlin/sequences/Sequence;", "getPillageActions$core", "pillageLooting", "", "core"})
@SourceDebugExtension(value={"SMAP\nUnitActionsPillage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitActionsPillage.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsPillage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1#2:128\n2333#3,14:129\n*S KotlinDebug\n*F\n+ 1 UnitActionsPillage.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsPillage\n*L\n73#1:129,14\n*E\n"})
public final class UnitActionsPillage {
    @NotNull
    public static final UnitActionsPillage INSTANCE = new UnitActionsPillage();

    private UnitActionsPillage() {
    }

    @NotNull
    public final Sequence<UnitAction> getPillageActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        UnitAction unitAction2 = this.getPillageAction$core(unit, tile);
        if (unitAction2 == null) {
            return SequencesKt.emptySequence();
        }
        UnitAction pillageAction = unitAction2;
        if (pillageAction.getAction() == null || unit.getCiv().isAIOrAutoPlaying()) {
            UnitAction[] unitActionArray = new UnitAction[]{pillageAction};
            return SequencesKt.sequenceOf(unitActionArray);
        }
        UnitAction[] unitActionArray = new UnitAction[]{new UnitAction(UnitActionType.Pillage, 65.0f, pillageAction.getTitle(), false, null, new Function0<Unit>(tile, pillageAction){
            final /* synthetic */ Tile $tile;
            final /* synthetic */ UnitAction $pillageAction;
            {
                this.$tile = $tile;
                this.$pillageAction = $pillageAction;
                super(0);
            }

            public final void invoke() {
                StringBuilder stringBuilder = new StringBuilder().append("Are you sure you want to pillage this [");
                String string = this.$tile.getImprovementToPillageName();
                Intrinsics.checkNotNull(string);
                String pillageText = stringBuilder.append(string).append("]?").toString();
                Popup.open$default(new ConfirmPopup(GUI.INSTANCE.getWorldScreen(), pillageText, "Pillage", true, null, (Function0)new Function0<Unit>(this.$pillageAction){
                    final /* synthetic */ UnitAction $pillageAction;
                    {
                        this.$pillageAction = $pillageAction;
                        super(0);
                    }

                    public final void invoke() {
                        this.$pillageAction.getAction().invoke();
                        GUI.INSTANCE.setUpdateWorldOnNextRender();
                    }
                }, 16, null), false, 1, null);
            }
        }, 24, null)};
        return SequencesKt.sequenceOf(unitActionArray);
    }

    @Nullable
    public final UnitAction getPillageAction$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        String improvementName = unit.getCurrentTile().getImprovementToPillageName();
        if (unit.isCivilian() || improvementName == null || Intrinsics.areEqual(tile.getOwner(), unit.getCiv())) {
            return null;
        }
        Function0<Unit> function0 = new Function0<Unit>(unit, tile){
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Tile $tile;
            {
                this.$unit = $unit;
                this.$tile = $tile;
                super(0);
            }

            public final void invoke() {
                boolean freePillage;
                Object object;
                String string = this.$unit.getCurrentTile().getImprovementToPillageName();
                Intrinsics.checkNotNull(string);
                String pillagedImprovement = string;
                boolean pillagingImprovement = this.$unit.getCurrentTile().canPillageTileImprovement();
                String pillageText = "An enemy [" + this.$unit.getBaseUnit().getName() + "] has pillaged our [" + pillagedImprovement + ']';
                String icon = "ImprovementIcons/" + pillagedImprovement;
                Civilization civilization = this.$tile.getOwner();
                if (civilization != null) {
                    String[] stringArray = new String[]{icon, "OtherIcons/Pillage", this.$unit.getBaseUnit().getName()};
                    civilization.addNotification(pillageText, this.$tile.getPosition(), Notification.NotificationCategory.War, stringArray);
                }
                UnitActionsPillage.access$pillageLooting(UnitActionsPillage.INSTANCE, this.$tile, this.$unit);
                this.$tile.setPillaged();
                if (this.$tile.getResource() != null && (object = this.$tile.getOwner()) != null && (object = ((Civilization)object).getCache()) != null) {
                    ((CivInfoTransientCache)object).updateCivResources();
                }
                if (!(freePillage = MapUnit.hasUnique$default(this.$unit, UniqueType.NoMovementToPillage, null, true, 2, null))) {
                    this.$unit.useMovementPoints(1.0f);
                }
                if (pillagingImprovement) {
                    this.$unit.healBy(25);
                }
            }
        };
        Function0 function02 = function0;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string = (Object)((Object)UnitActionType.Pillage) + " [" + improvementName + ']';
        float f = 65.0f;
        UnitActionType unitActionType = UnitActionType.Pillage;
        boolean bl2 = false;
        boolean bl3 = unit.getCurrentMovement() > 0.0f && INSTANCE.canPillage(unit, tile);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 24;
        Function0 function03 = bl3 ? function0 : null;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return new UnitAction(unitActionType2, f2, string2, bl4, uncivSound2, function03, n, defaultConstructorMarker);
    }

    private final void pillageLooting(Tile tile, MapUnit unit) {
        float value;
        Object minElem$iv;
        Object object;
        Iterable $this$minByOrNull$iv = unit.getCiv().getCities();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            object = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                object = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCenterTile().aerialDistanceTo(tile);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-minByOrNull-UnitActionsPillage$pillageLooting$closestCity$1 = false;
                    int v$iv = it2.getCenterTile().aerialDistanceTo(tile);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                object = minElem$iv;
            }
        }
        City closestCity = (City)object;
        TileImprovement tileImprovement = tile.getImprovementToPillage();
        Intrinsics.checkNotNull(tileImprovement);
        TileImprovement improvement2 = tileImprovement;
        Stats pillageYield = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        StateForConditionals stateForConditionals = new StateForConditionals(unit);
        minElem$iv = improvement2.getMatchingUniques(UniqueType.PillageYieldRandom, stateForConditionals).iterator();
        while (minElem$iv.hasNext()) {
            Unique unique = (Unique)minElem$iv.next();
            for (Stats.StatValuePair statValuePair : unique.getStats()) {
                Stat stat = statValuePair.component1();
                value = statValuePair.component2();
                int looted = Random.Default.nextInt((int)(value + 1.0f)) + Random.Default.nextInt((int)(value + 1.0f));
                pillageYield.add(stat, looted);
            }
        }
        minElem$iv = improvement2.getMatchingUniques(UniqueType.PillageYieldFixed, stateForConditionals).iterator();
        while (minElem$iv.hasNext()) {
            Unique unique = (Unique)minElem$iv.next();
            pillageYield.add(unique.getStats());
        }
        if (pillageYield.isEmpty()) {
            return;
        }
        Stats globalPillageYield = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Stats toCityPillageYield = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        for (Stats.StatValuePair statValuePair : pillageYield) {
            Stat stat = statValuePair.component1();
            value = statValuePair.component2();
            if (Stat.Companion.getStatsWithCivWideField().contains((Object)stat)) {
                unit.getCiv().addStat(stat, (int)value);
                globalPillageYield.set(stat, globalPillageYield.get(stat) + value);
                continue;
            }
            if (closestCity == null) continue;
            closestCity.addStat(stat, (int)value);
            toCityPillageYield.set(stat, toCityPillageYield.get(stat) + value);
        }
        City city2 = closestCity;
        UnitActionsPillage.pillageLooting$notify(toCityPillageYield, improvement2, unit, tile, " which has been sent to [" + (city2 != null ? city2.getName() : null) + ']');
        UnitActionsPillage.pillageLooting$notify(globalPillageYield, improvement2, unit, tile, "");
    }

    public final boolean canPillage(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (unit.isTransported()) {
            return false;
        }
        if (!tile.canPillageTile()) {
            return false;
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.CannotPillage, null, false, 6, null)) {
            return false;
        }
        Civilization tileOwner = tile.getOwner();
        return tileOwner == null || unit.getCiv().isAtWarWith(tileOwner);
    }

    private static final void pillageLooting$notify(Stats $this$pillageLooting_u24notify, TileImprovement improvement2, MapUnit $unit, Tile $tile, String suffix) {
        if ($this$pillageLooting_u24notify.isEmpty()) {
            return;
        }
        String text2 = "We have looted [" + $this$pillageLooting_u24notify.toStringWithoutIcons() + "] from a [" + improvement2.getName() + ']' + suffix;
        String[] stringArray = new String[]{"ImprovementIcons/" + improvement2.getName(), "OtherIcons/Pillage"};
        $unit.getCiv().addNotification(text2, $tile.getPosition(), Notification.NotificationCategory.War, stringArray);
    }

    public static final /* synthetic */ void access$pillageLooting(UnitActionsPillage $this, Tile tile, MapUnit unit) {
        $this.pillageLooting(tile, unit);
    }
}

