/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.actions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.UpgradeUnitAction;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.popups.UnitUpgradeMenu;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActions;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "buttonsPerPage", "", "currentPage", "numPages", "shownForUnitHash", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "activateAction", "", "unitAction", "Lcom/unciv/models/UnitAction;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "changePage", "delta", "getUnitActionButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "update", "updateButtonsPerPage", "button", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUnitActionsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitActionsTable.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,186:1\n614#2:187\n*S KotlinDebug\n*F\n+ 1 UnitActionsTable.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable\n*L\n78#1:187\n*E\n"})
public final class UnitActionsTable
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorldScreen worldScreen;
    private int currentPage;
    private int buttonsPerPage;
    private int numPages;
    private int shownForUnitHash;
    private static final int maxAllowedPages = 10;
    private static final int minButtonsPerPage = 3;
    private static final int maxButtonsPerPage = 7;
    private static final int maxSinglePageButtons = 5;
    private static final float padBetweenButtons = 2.0f;

    public UnitActionsTable(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.worldScreen = worldScreen;
        this.buttonsPerPage = Integer.MAX_VALUE;
        this.numPages = 2;
        this.defaults().left().padLeft(2.0f).padBottom(2.0f);
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    public final void changePage(int delta, @NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (delta == 0 || this.numPages <= 1) {
            return;
        }
        this.currentPage = (this.currentPage + delta) % this.numPages;
        this.update(unit);
    }

    public final void update(@Nullable MapUnit unit) {
        int page;
        int newUnitHash;
        MapUnit mapUnit = unit;
        int n = newUnitHash = mapUnit != null ? mapUnit.hashCode() : 0;
        if (this.shownForUnitHash != newUnitHash) {
            this.currentPage = 0;
            this.shownForUnitHash = newUnitHash;
        }
        this.clear();
        ActivationExtensionsKt.getKeyShortcuts(this).clear();
        if (unit == null) {
            return;
        }
        if (!this.worldScreen.getCanChangeState()) {
            return;
        }
        this.numPages = 0;
        int n2 = 0;
        ArrayDeque[] arrayDequeArray = new ArrayDeque[10];
        while (n2 < 10) {
            int n3 = n2++;
            arrayDequeArray[n3] = new ArrayDeque();
        }
        ArrayDeque[] pageActionBuckets = arrayDequeArray;
        Pair<UnitAction, UnitAction> pair = UnitActions.INSTANCE.getPagingActions$core(unit, this);
        UnitAction nextPageAction = pair.component1();
        UnitAction previousPageAction = pair.component2();
        Button nextPageButton = this.getUnitActionButton(unit, nextPageAction);
        Button previousPageButton = this.getUnitActionButton(unit, previousPageAction);
        this.updateButtonsPerPage(nextPageButton);
        Object $this$sortedByDescending$iv = UnitActions.INSTANCE.getUnitActions(unit);
        boolean $i$f$sortedByDescending = false;
        Sequence<UnitAction> sortedUnitActions = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                UnitAction it = (UnitAction)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getUseFrequency());
                it = (UnitAction)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(it.getUseFrequency()));
            }
        });
        $this$sortedByDescending$iv = sortedUnitActions.iterator();
        while ($this$sortedByDescending$iv.hasNext()) {
            int actionPage;
            UnitAction unitAction2 = (UnitAction)$this$sortedByDescending$iv.next();
            for (actionPage = UnitActions.INSTANCE.getActionDefaultPage(unit, unitAction2.getType()); actionPage < 10 && UnitActionsTable.update$freeSlotsOnPage(this, pageActionBuckets, actionPage) <= 0; ++actionPage) {
            }
            if (actionPage >= 10) break;
            if (actionPage >= this.numPages) {
                this.numPages = actionPage + 1;
            }
            pageActionBuckets[actionPage].addLast(unitAction2);
        }
        for (page = 0; page < 9; ++page) {
            while (UnitActionsTable.update$freeSlotsOnPage(this, pageActionBuckets, page) < 0) {
                UnitAction element = (UnitAction)pageActionBuckets[page].removeLast();
                pageActionBuckets[page + 1].addFirst(element);
                if (this.numPages >= page + 2) continue;
                this.numPages = page + 2;
            }
        }
        if (this.numPages == 2 && this.buttonsPerPage >= 5 && pageActionBuckets[0].size() + pageActionBuckets[1].size() <= 5) {
            pageActionBuckets[0].addAll(pageActionBuckets[1]);
            pageActionBuckets[1].clear();
            this.numPages = 1;
        }
        page = this.numPages;
        int element = this.currentPage;
        if (!(0 <= element ? element < page : false)) {
            this.currentPage = 0;
        }
        for (UnitAction unitAction3 : pageActionBuckets[this.currentPage]) {
            Button button = this.getUnitActionButton(unit, unitAction3);
            if (unitAction3 instanceof UpgradeUnitAction) {
                button.setDisabled(false);
                button.setTouchable(Touchable.enabled);
                ActivationExtensionsKt.onRightClick$default(button, null, new Function0<Unit>(this, button, unit, unitAction3){
                    final /* synthetic */ UnitActionsTable this$0;
                    final /* synthetic */ Button $button;
                    final /* synthetic */ MapUnit $unit;
                    final /* synthetic */ UnitAction $unitAction;
                    {
                        this.this$0 = $receiver;
                        this.$button = $button;
                        this.$unit = $unit;
                        this.$unitAction = $unitAction;
                        super(0);
                    }

                    public final void invoke() {
                        new UnitUpgradeMenu(this.this$0.getWorldScreen().getStage(), (Actor)this.$button, this.$unit, (UpgradeUnitAction)this.$unitAction, this.$unitAction.getAction() != null, true, new Function0<Unit>(this.this$0){
                            final /* synthetic */ UnitActionsTable this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.getWorldScreen().setShouldUpdate(true);
                            }
                        });
                    }
                }, 1, null);
            }
            this.add((Actor)button).colspan(2).row();
        }
        if (this.currentPage > 0) {
            this.add((Actor)previousPageButton);
        }
        if (this.currentPage < this.numPages - 1) {
            this.add((Actor)nextPageButton);
        }
        this.pack();
        int n4 = pageActionBuckets.length;
        for (page = 0; page < n4; ++page) {
            if (page == this.currentPage) continue;
            for (UnitAction unitAction4 : pageActionBuckets[page]) {
                if (unitAction4.getAction() == null) continue;
                KeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(this), unitAction4.getType().getBinding(), 0, new Function0<Unit>(this, unitAction4, unit){
                    final /* synthetic */ UnitActionsTable this$0;
                    final /* synthetic */ UnitAction $unitAction;
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.this$0 = $receiver;
                        this.$unitAction = $unitAction;
                        this.$unit = $unit;
                        super(0);
                    }

                    public final void invoke() {
                        UnitActionsTable.access$activateAction(this.this$0, this.$unitAction, this.$unit);
                    }
                }, 2, null);
            }
        }
    }

    private final void updateButtonsPerPage(Button button) {
        float upperLimit = this.worldScreen.getTechPolicyAndDiplomacy$core().getY();
        float lowerLimit = this.getY();
        float availableHeight = upperLimit - lowerLimit - 2.0f;
        float buttonHeight = button.getHeight() + 2.0f;
        this.buttonsPerPage = RangesKt.coerceIn((int)(availableHeight / buttonHeight), 3, 7);
    }

    private final Button getUnitActionButton(MapUnit unit, UnitAction unitAction2) {
        Actor icon = unitAction2.getIcon();
        KeyboardBinding binding = unitAction2.getType().getBinding();
        Color fontColor = unitAction2.isCurrentAction() ? Color.YELLOW : Color.WHITE;
        String string = unitAction2.getTitle();
        Intrinsics.checkNotNull(fontColor);
        IconTextButton actionButton = new IconTextButton(string, icon, 0, fontColor, 4, null);
        if (unitAction2.getType() == UnitActionType.Promote && unitAction2.getAction() != null) {
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            actionButton.setColor(Scene2dExtensionsKt.brighten(color, 0.5f));
        }
        actionButton.pack();
        if (unitAction2.getAction() == null) {
            Scene2dExtensionsKt.disable(actionButton);
        } else {
            ActivationExtensionsKt.onActivation(actionButton, unitAction2.getUncivSound(), binding, new Function0<Unit>(this, unitAction2, unit){
                final /* synthetic */ UnitActionsTable this$0;
                final /* synthetic */ UnitAction $unitAction;
                final /* synthetic */ MapUnit $unit;
                {
                    this.this$0 = $receiver;
                    this.$unitAction = $unitAction;
                    this.$unit = $unit;
                    super(0);
                }

                public final void invoke() {
                    UnitActionsTable.access$activateAction(this.this$0, this.$unitAction, this.$unit);
                }
            });
        }
        return actionButton;
    }

    private final void activateAction(UnitAction unitAction2, MapUnit unit) {
        Function0<Unit> function0 = unitAction2.getAction();
        Intrinsics.checkNotNull(function0);
        function0.invoke();
        this.worldScreen.setShouldUpdate(true);
        this.worldScreen.getMapHolder().removeUnitActionOverlay();
        if (!UncivGame.Companion.getCurrent().getSettings().getAutoUnitCycle()) {
            return;
        }
        if (unit.isDestroyed() || unitAction2.getType().isSkippingToNextUnit() && (unit.isMoving() && unit.getCurrentMovement() == 0.0f || !unit.isMoving())) {
            this.worldScreen.switchToNextUnit();
        }
    }

    private static final int update$freeSlotsOnPage(UnitActionsTable this$0, ArrayDeque<UnitAction>[] pageActionBuckets, int page) {
        return this$0.buttonsPerPage - pageActionBuckets[page].size() - (this$0.numPages > 1 ? 1 : 0);
    }

    public static final /* synthetic */ void access$activateAction(UnitActionsTable $this, UnitAction unitAction2, MapUnit unit) {
        $this.activateAction(unitAction2, unit);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsTable$Companion;", "", "()V", "maxAllowedPages", "", "maxButtonsPerPage", "maxSinglePageButtons", "minButtonsPerPage", "padBetweenButtons", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

