/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.utils;

import com.unciv.utils.DefaultLogBackend;
import com.unciv.utils.LogBackend;
import com.unciv.utils.LogKt;
import com.unciv.utils.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J+\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J3\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J+\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u000bJ\u0010\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/unciv/utils/Log;", "", "()V", "backend", "Lcom/unciv/utils/LogBackend;", "getBackend", "()Lcom/unciv/utils/LogBackend;", "setBackend", "(Lcom/unciv/utils/LogBackend;)V", "disableLogsFrom", "", "", "getDisableLogsFrom", "()Ljava/util/Set;", "enableLogsFrom", "getEnableLogsFrom", "debug", "", "tag", "Lcom/unciv/utils/Tag;", "msg", "params", "", "(Lcom/unciv/utils/Tag;Ljava/lang/String;[Ljava/lang/Object;)V", "throwable", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "error", "getSystemInfo", "shouldLog", "", "core"})
@SourceDebugExtension(value={"SMAP\nLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Log.kt\ncom/unciv/utils/Log\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n819#2:251\n847#2,2:252\n819#2:254\n847#2,2:255\n*S KotlinDebug\n*F\n+ 1 Log.kt\ncom/unciv/utils/Log\n*L\n27#1:251\n27#1:252,2\n38#1:254\n38#1:255,2\n*E\n"})
public final class Log {
    @NotNull
    public static final Log INSTANCE;
    @NotNull
    private static final Set<String> disableLogsFrom;
    @NotNull
    private static final Set<String> enableLogsFrom;
    @NotNull
    private static LogBackend backend;

    private Log() {
    }

    @NotNull
    public final Set<String> getDisableLogsFrom() {
        return disableLogsFrom;
    }

    @NotNull
    public final Set<String> getEnableLogsFrom() {
        return enableLogsFrom;
    }

    @NotNull
    public final LogBackend getBackend() {
        return backend;
    }

    public final void setBackend(@NotNull LogBackend logBackend) {
        Intrinsics.checkNotNullParameter(logBackend, "<set-?>");
        backend = logBackend;
    }

    public final boolean shouldLog(@NotNull Tag tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        return !backend.isRelease() && !LogKt.access$isTagDisabled(tag);
    }

    public static /* synthetic */ boolean shouldLog$default(Log log, Tag tag, int n, Object object) {
        if ((n & 1) != 0) {
            tag = LogKt.access$getTag();
        }
        return log.shouldLog(tag);
    }

    public final void debug(@NotNull String msg, Object ... params) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(params, "params");
        if (backend.isRelease()) {
            return;
        }
        this.debug(LogKt.access$getTag(), msg, Arrays.copyOf(params, params.length));
    }

    public final void debug(@NotNull Tag tag, @NotNull String msg, Object ... params) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(params, "params");
        if (!this.shouldLog(tag)) {
            return;
        }
        Object[] formatArgs = LogKt.access$replaceLambdasWithValues(params);
        LogKt.access$doLog(new Function3<Tag, String, String, Unit>((Object)backend){

            public final void invoke(@NotNull Tag p0, @NotNull String p1, @NotNull String p2) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                ((LogBackend)this.receiver).debug(p0, p1, p2);
            }
        }, tag, msg, Arrays.copyOf(formatArgs, formatArgs.length));
    }

    public final void debug(@NotNull String msg, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        if (backend.isRelease()) {
            return;
        }
        this.debug(LogKt.access$getTag(), msg, throwable);
    }

    public final void debug(@NotNull Tag tag, @NotNull String msg, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        if (!this.shouldLog(tag)) {
            return;
        }
        LogKt.access$doLog(new Function3<Tag, String, String, Unit>((Object)backend){

            public final void invoke(@NotNull Tag p0, @NotNull String p1, @NotNull String p2) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                ((LogBackend)this.receiver).debug(p0, p1, p2);
            }
        }, tag, LogKt.access$buildThrowableMessage(msg, throwable), new Object[0]);
    }

    public final void error(@NotNull String msg, Object ... params) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(params, "params");
        this.error(LogKt.access$getTag(), msg, Arrays.copyOf(params, params.length));
    }

    public final void error(@NotNull Tag tag, @NotNull String msg, Object ... params) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(params, "params");
        Object[] formatArgs = LogKt.access$replaceLambdasWithValues(params);
        LogKt.access$doLog(new Function3<Tag, String, String, Unit>((Object)backend){

            public final void invoke(@NotNull Tag p0, @NotNull String p1, @NotNull String p2) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                ((LogBackend)this.receiver).error(p0, p1, p2);
            }
        }, tag, msg, Arrays.copyOf(formatArgs, formatArgs.length));
    }

    public final void error(@NotNull String msg, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        this.error(LogKt.access$getTag(), msg, throwable);
    }

    public final void error(@NotNull Tag tag, @NotNull String msg, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(msg, "msg");
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        LogKt.access$doLog(new Function3<Tag, String, String, Unit>((Object)backend){

            public final void invoke(@NotNull Tag p0, @NotNull String p1, @NotNull String p2) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                ((LogBackend)this.receiver).error(p0, p1, p2);
            }
        }, tag, LogKt.access$buildThrowableMessage(msg, throwable), new Object[0]);
    }

    @NotNull
    public final String getSystemInfo() {
        return backend.getSystemInfo();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String it;
        Object element$iv$iv;
        Object $this$filterNotTo$iv$iv;
        INSTANCE = new Log();
        Object object = System.getProperty("noLog");
        Object object2 = object == null ? "Battle,Music,Sounds,Translations,WorkerAutomation,assignRegions" : object;
        object = new char[1];
        object[0] = 44;
        Object $this$filterNot$iv = StringsKt.split$default((CharSequence)object2, (char[])object, false, 0, 6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        disableLogsFrom = CollectionsKt.toMutableSet((List)destination$iv$iv);
        $this$filterNot$iv = System.getProperty("onlyLog");
        Object object3 = $this$filterNot$iv == null ? "" : $this$filterNot$iv;
        $this$filterNot$iv = new char[1];
        $this$filterNot$iv[0] = 44;
        $this$filterNot$iv = StringsKt.split$default((CharSequence)object3, (char[])$this$filterNot$iv, false, 0, 6, null);
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        iterator2 = $this$filterNotTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        enableLogsFrom = CollectionsKt.toMutableSet((List)var3_3);
        backend = new DefaultLogBackend();
    }
}

