/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;

public final class StandardNames {
    @NotNull
    public static final StandardNames INSTANCE = new StandardNames();
    @JvmField
    @NotNull
    public static final Name BACKING_FIELD;
    @JvmField
    @NotNull
    public static final Name DEFAULT_VALUE_PARAMETER;
    @JvmField
    @NotNull
    public static final Name ENUM_VALUES;
    @JvmField
    @NotNull
    public static final Name ENUM_ENTRIES;
    @JvmField
    @NotNull
    public static final Name ENUM_VALUE_OF;
    @JvmField
    @NotNull
    public static final Name DATA_CLASS_COPY;
    @JvmField
    @NotNull
    public static final String DATA_CLASS_COMPONENT_PREFIX;
    @JvmField
    @NotNull
    public static final Name HASHCODE_NAME;
    @JvmField
    @NotNull
    public static final Name CHAR_CODE;
    @JvmField
    @NotNull
    public static final Name NAME;
    @JvmField
    @NotNull
    public static final Name MAIN;
    @JvmField
    @NotNull
    public static final Name NEXT_CHAR;
    @JvmField
    @NotNull
    public static final Name IMPLICIT_LAMBDA_PARAMETER_NAME;
    @JvmField
    @NotNull
    public static final Name CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME;
    @JvmField
    @NotNull
    public static final FqName DYNAMIC_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName RESULT_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    @JvmField
    @NotNull
    public static final List<String> PREFIXES;
    @JvmField
    @NotNull
    public static final Name BUILT_INS_PACKAGE_NAME;
    @JvmField
    @NotNull
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName KOTLIN_INTERNAL_FQ_NAME;
    @NotNull
    private static final FqName NON_EXISTENT_CLASS;
    @JvmField
    @NotNull
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES;

    private StandardNames() {
    }

    @JvmStatic
    @NotNull
    public static final String getFunctionName(int parameterCount) {
        return "Function" + parameterCount;
    }

    @JvmStatic
    @NotNull
    public static final ClassId getFunctionClassId(int parameterCount) {
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(StandardNames.getFunctionName(parameterCount)));
    }

    @JvmStatic
    @NotNull
    public static final String getSuspendFunctionName(int parameterCount) {
        return FunctionTypeKind.SuspendFunction.INSTANCE.getClassNamePrefix() + parameterCount;
    }

    @JvmStatic
    public static final boolean isPrimitiveArray(@NotNull FqNameUnsafe arrayFqName) {
        Intrinsics.checkNotNullParameter(arrayFqName, "arrayFqName");
        return FqNames.arrayClassFqNameToPrimitiveType.get(arrayFqName) != null;
    }

    @JvmStatic
    @NotNull
    public static final FqName getPrimitiveFqName(@NotNull PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)primitiveType, "primitiveType");
        FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
        Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
        return fqName2;
    }

    static {
        Name name2 = Name.identifier("field");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        BACKING_FIELD = name2;
        Name name3 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        DEFAULT_VALUE_PARAMETER = name3;
        Name name4 = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        ENUM_VALUES = name4;
        Name name5 = Name.identifier("entries");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
        ENUM_ENTRIES = name5;
        Name name6 = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue(name6, "identifier(...)");
        ENUM_VALUE_OF = name6;
        Name name7 = Name.identifier("copy");
        Intrinsics.checkNotNullExpressionValue(name7, "identifier(...)");
        DATA_CLASS_COPY = name7;
        DATA_CLASS_COMPONENT_PREFIX = "component";
        Name name8 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue(name8, "identifier(...)");
        HASHCODE_NAME = name8;
        Name name9 = Name.identifier("code");
        Intrinsics.checkNotNullExpressionValue(name9, "identifier(...)");
        CHAR_CODE = name9;
        Name name10 = Name.identifier("name");
        Intrinsics.checkNotNullExpressionValue(name10, "identifier(...)");
        NAME = name10;
        Name name11 = Name.identifier("main");
        Intrinsics.checkNotNullExpressionValue(name11, "identifier(...)");
        MAIN = name11;
        Name name12 = Name.identifier("nextChar");
        Intrinsics.checkNotNullExpressionValue(name12, "identifier(...)");
        NEXT_CHAR = name12;
        Name name13 = Name.identifier("it");
        Intrinsics.checkNotNullExpressionValue(name13, "identifier(...)");
        IMPLICIT_LAMBDA_PARAMETER_NAME = name13;
        Name name14 = Name.identifier("count");
        Intrinsics.checkNotNullExpressionValue(name14, "identifier(...)");
        CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME = name14;
        DYNAMIC_FQ_NAME = new FqName("<dynamic>");
        COROUTINES_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines");
        COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.jvm.internal");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.intrinsics");
        FqName fqName2 = COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
        CONTINUATION_INTERFACE_FQ_NAME = fqName2;
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        Object[] objectArray = new String[]{"KProperty", "KMutableProperty", "KFunction", "KSuspendFunction"};
        PREFIXES = kotlin.collections.CollectionsKt.listOf(objectArray);
        Name name15 = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue(name15, "identifier(...)");
        BUILT_INS_PACKAGE_NAME = name15;
        FqName fqName3 = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
        Intrinsics.checkNotNullExpressionValue(fqName3, "topLevel(...)");
        BUILT_INS_PACKAGE_FQ_NAME = fqName3;
        FqName fqName4 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue(fqName4, "child(...)");
        ANNOTATION_PACKAGE_FQ_NAME = fqName4;
        FqName fqName5 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("collections"));
        Intrinsics.checkNotNullExpressionValue(fqName5, "child(...)");
        COLLECTIONS_PACKAGE_FQ_NAME = fqName5;
        FqName fqName6 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("ranges"));
        Intrinsics.checkNotNullExpressionValue(fqName6, "child(...)");
        RANGES_PACKAGE_FQ_NAME = fqName6;
        FqName fqName7 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("text"));
        Intrinsics.checkNotNullExpressionValue(fqName7, "child(...)");
        TEXT_PACKAGE_FQ_NAME = fqName7;
        FqName fqName8 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("internal"));
        Intrinsics.checkNotNullExpressionValue(fqName8, "child(...)");
        KOTLIN_INTERNAL_FQ_NAME = fqName8;
        NON_EXISTENT_CLASS = new FqName("error.NonExistentClass");
        objectArray = new FqName[]{BUILT_INS_PACKAGE_FQ_NAME, COLLECTIONS_PACKAGE_FQ_NAME, RANGES_PACKAGE_FQ_NAME, ANNOTATION_PACKAGE_FQ_NAME, KOTLIN_REFLECT_FQ_NAME, KOTLIN_INTERNAL_FQ_NAME, COROUTINES_PACKAGE_FQ_NAME};
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf(objectArray);
    }

    @SourceDebugExtension(value={"SMAP\nStandardNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardNames.kt\norg/jetbrains/kotlin/builtins/StandardNames$FqNames\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,302:1\n11400#2,3:303\n11400#2,3:306\n*S KotlinDebug\n*F\n+ 1 StandardNames.kt\norg/jetbrains/kotlin/builtins/StandardNames$FqNames\n*L\n198#1:303,3\n202#1:306,3\n*E\n"})
    public static final class FqNames {
        @NotNull
        public static final FqNames INSTANCE;
        @JvmField
        @NotNull
        public static final FqNameUnsafe any;
        @JvmField
        @NotNull
        public static final FqNameUnsafe nothing;
        @JvmField
        @NotNull
        public static final FqNameUnsafe cloneable;
        @JvmField
        @NotNull
        public static final FqName suppress;
        @JvmField
        @NotNull
        public static final FqNameUnsafe unit;
        @JvmField
        @NotNull
        public static final FqNameUnsafe charSequence;
        @JvmField
        @NotNull
        public static final FqNameUnsafe string;
        @JvmField
        @NotNull
        public static final FqNameUnsafe array;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _boolean;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _char;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _byte;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _short;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _int;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _long;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _float;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _double;
        @JvmField
        @NotNull
        public static final FqNameUnsafe number;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _enum;
        @JvmField
        @NotNull
        public static final FqNameUnsafe functionSupertype;
        @JvmField
        @NotNull
        public static final FqName throwable;
        @JvmField
        @NotNull
        public static final FqName comparable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe intRange;
        @JvmField
        @NotNull
        public static final FqNameUnsafe longRange;
        @JvmField
        @NotNull
        public static final FqName deprecated;
        @JvmField
        @NotNull
        public static final FqName deprecatedSinceKotlin;
        @JvmField
        @NotNull
        public static final FqName deprecationLevel;
        @JvmField
        @NotNull
        public static final FqName replaceWith;
        @JvmField
        @NotNull
        public static final FqName extensionFunctionType;
        @JvmField
        @NotNull
        public static final FqName contextFunctionTypeParams;
        @JvmField
        @NotNull
        public static final FqName parameterName;
        @JvmField
        @NotNull
        public static final ClassId parameterNameClassId;
        @JvmField
        @NotNull
        public static final FqName annotation;
        @JvmField
        @NotNull
        public static final FqName target;
        @JvmField
        @NotNull
        public static final ClassId targetClassId;
        @JvmField
        @NotNull
        public static final FqName annotationTarget;
        @JvmField
        @NotNull
        public static final FqName annotationRetention;
        @JvmField
        @NotNull
        public static final FqName retention;
        @JvmField
        @NotNull
        public static final ClassId retentionClassId;
        @JvmField
        @NotNull
        public static final FqName repeatable;
        @JvmField
        @NotNull
        public static final ClassId repeatableClassId;
        @JvmField
        @NotNull
        public static final FqName mustBeDocumented;
        @JvmField
        @NotNull
        public static final FqName unsafeVariance;
        @JvmField
        @NotNull
        public static final FqName publishedApi;
        @JvmField
        @NotNull
        public static final FqName accessibleLateinitPropertyLiteral;
        @JvmField
        @NotNull
        public static final FqName iterator;
        @JvmField
        @NotNull
        public static final FqName iterable;
        @JvmField
        @NotNull
        public static final FqName collection;
        @JvmField
        @NotNull
        public static final FqName list;
        @JvmField
        @NotNull
        public static final FqName listIterator;
        @JvmField
        @NotNull
        public static final FqName set;
        @JvmField
        @NotNull
        public static final FqName map;
        @JvmField
        @NotNull
        public static final FqName mapEntry;
        @JvmField
        @NotNull
        public static final FqName mutableIterator;
        @JvmField
        @NotNull
        public static final FqName mutableIterable;
        @JvmField
        @NotNull
        public static final FqName mutableCollection;
        @JvmField
        @NotNull
        public static final FqName mutableList;
        @JvmField
        @NotNull
        public static final FqName mutableListIterator;
        @JvmField
        @NotNull
        public static final FqName mutableSet;
        @JvmField
        @NotNull
        public static final FqName mutableMap;
        @JvmField
        @NotNull
        public static final FqName mutableMapEntry;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kClass;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kType;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kCallable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kPropertyFqName;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutablePropertyFqName;
        @JvmField
        @NotNull
        public static final ClassId kProperty;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kDeclarationContainer;
        @JvmField
        @NotNull
        public static final FqName uByteFqName;
        @JvmField
        @NotNull
        public static final FqName uShortFqName;
        @JvmField
        @NotNull
        public static final FqName uIntFqName;
        @JvmField
        @NotNull
        public static final FqName uLongFqName;
        @JvmField
        @NotNull
        public static final ClassId uByte;
        @JvmField
        @NotNull
        public static final ClassId uShort;
        @JvmField
        @NotNull
        public static final ClassId uInt;
        @JvmField
        @NotNull
        public static final ClassId uLong;
        @JvmField
        @NotNull
        public static final FqName uByteArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uShortArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uIntArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uLongArrayFqName;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveTypeShortNames;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveArrayTypeShortNames;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType;

        private FqNames() {
        }

        private final FqNameUnsafe fqNameUnsafe(String simpleName2) {
            FqNameUnsafe fqNameUnsafe = this.fqName(simpleName2).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "toUnsafe(...)");
            return fqNameUnsafe;
        }

        private final FqName fqName(String simpleName2) {
            FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
            return fqName2;
        }

        private final FqName collectionsFqName(String simpleName2) {
            FqName fqName2 = COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
            return fqName2;
        }

        private final FqNameUnsafe rangesFqName(String simpleName2) {
            FqNameUnsafe fqNameUnsafe = RANGES_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "toUnsafe(...)");
            return fqNameUnsafe;
        }

        @JvmStatic
        @NotNull
        public static final FqNameUnsafe reflect(@NotNull String simpleName2) {
            Intrinsics.checkNotNullParameter(simpleName2, "simpleName");
            FqNameUnsafe fqNameUnsafe = KOTLIN_REFLECT_FQ_NAME.child(Name.identifier(simpleName2)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "toUnsafe(...)");
            return fqNameUnsafe;
        }

        private final FqName annotationName(String simpleName2) {
            FqName fqName2 = ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
            return fqName2;
        }

        private final FqName internalName(String simpleName2) {
            FqName fqName2 = KOTLIN_INTERNAL_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
            return fqName2;
        }

        static {
            Map map2;
            PrimitiveType it;
            Collection collection;
            PrimitiveType item$iv;
            int n;
            Cloneable cloneable2;
            INSTANCE = new FqNames();
            any = INSTANCE.fqNameUnsafe("Any");
            nothing = INSTANCE.fqNameUnsafe("Nothing");
            cloneable = INSTANCE.fqNameUnsafe("Cloneable");
            suppress = INSTANCE.fqName("Suppress");
            unit = INSTANCE.fqNameUnsafe("Unit");
            charSequence = INSTANCE.fqNameUnsafe("CharSequence");
            string = INSTANCE.fqNameUnsafe("String");
            array = INSTANCE.fqNameUnsafe("Array");
            _boolean = INSTANCE.fqNameUnsafe("Boolean");
            _char = INSTANCE.fqNameUnsafe("Char");
            _byte = INSTANCE.fqNameUnsafe("Byte");
            _short = INSTANCE.fqNameUnsafe("Short");
            _int = INSTANCE.fqNameUnsafe("Int");
            _long = INSTANCE.fqNameUnsafe("Long");
            _float = INSTANCE.fqNameUnsafe("Float");
            _double = INSTANCE.fqNameUnsafe("Double");
            number = INSTANCE.fqNameUnsafe("Number");
            _enum = INSTANCE.fqNameUnsafe("Enum");
            functionSupertype = INSTANCE.fqNameUnsafe("Function");
            throwable = INSTANCE.fqName("Throwable");
            comparable = INSTANCE.fqName("Comparable");
            intRange = INSTANCE.rangesFqName("IntRange");
            longRange = INSTANCE.rangesFqName("LongRange");
            deprecated = INSTANCE.fqName("Deprecated");
            deprecatedSinceKotlin = INSTANCE.fqName("DeprecatedSinceKotlin");
            deprecationLevel = INSTANCE.fqName("DeprecationLevel");
            replaceWith = INSTANCE.fqName("ReplaceWith");
            extensionFunctionType = INSTANCE.fqName("ExtensionFunctionType");
            contextFunctionTypeParams = INSTANCE.fqName("ContextFunctionTypeParams");
            parameterName = INSTANCE.fqName("ParameterName");
            ClassId classId = ClassId.topLevel(parameterName);
            Intrinsics.checkNotNullExpressionValue(classId, "topLevel(...)");
            parameterNameClassId = classId;
            annotation = INSTANCE.fqName("Annotation");
            target = INSTANCE.annotationName("Target");
            ClassId classId2 = ClassId.topLevel(target);
            Intrinsics.checkNotNullExpressionValue(classId2, "topLevel(...)");
            targetClassId = classId2;
            annotationTarget = INSTANCE.annotationName("AnnotationTarget");
            annotationRetention = INSTANCE.annotationName("AnnotationRetention");
            retention = INSTANCE.annotationName("Retention");
            ClassId classId3 = ClassId.topLevel(retention);
            Intrinsics.checkNotNullExpressionValue(classId3, "topLevel(...)");
            retentionClassId = classId3;
            repeatable = INSTANCE.annotationName("Repeatable");
            ClassId classId4 = ClassId.topLevel(repeatable);
            Intrinsics.checkNotNullExpressionValue(classId4, "topLevel(...)");
            repeatableClassId = classId4;
            mustBeDocumented = INSTANCE.annotationName("MustBeDocumented");
            unsafeVariance = INSTANCE.fqName("UnsafeVariance");
            publishedApi = INSTANCE.fqName("PublishedApi");
            accessibleLateinitPropertyLiteral = INSTANCE.internalName("AccessibleLateinitPropertyLiteral");
            iterator = INSTANCE.collectionsFqName("Iterator");
            iterable = INSTANCE.collectionsFqName("Iterable");
            FqNames.collection = INSTANCE.collectionsFqName("Collection");
            list = INSTANCE.collectionsFqName("List");
            listIterator = INSTANCE.collectionsFqName("ListIterator");
            set = INSTANCE.collectionsFqName("Set");
            map = INSTANCE.collectionsFqName("Map");
            FqName fqName2 = map.child(Name.identifier("Entry"));
            Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
            mapEntry = fqName2;
            mutableIterator = INSTANCE.collectionsFqName("MutableIterator");
            mutableIterable = INSTANCE.collectionsFqName("MutableIterable");
            mutableCollection = INSTANCE.collectionsFqName("MutableCollection");
            mutableList = INSTANCE.collectionsFqName("MutableList");
            mutableListIterator = INSTANCE.collectionsFqName("MutableListIterator");
            mutableSet = INSTANCE.collectionsFqName("MutableSet");
            mutableMap = INSTANCE.collectionsFqName("MutableMap");
            FqName fqName3 = mutableMap.child(Name.identifier("MutableEntry"));
            Intrinsics.checkNotNullExpressionValue(fqName3, "child(...)");
            mutableMapEntry = fqName3;
            kClass = FqNames.reflect("KClass");
            kType = FqNames.reflect("KType");
            kCallable = FqNames.reflect("KCallable");
            kProperty0 = FqNames.reflect("KProperty0");
            kProperty1 = FqNames.reflect("KProperty1");
            kProperty2 = FqNames.reflect("KProperty2");
            kMutableProperty0 = FqNames.reflect("KMutableProperty0");
            kMutableProperty1 = FqNames.reflect("KMutableProperty1");
            kMutableProperty2 = FqNames.reflect("KMutableProperty2");
            kPropertyFqName = FqNames.reflect("KProperty");
            kMutablePropertyFqName = FqNames.reflect("KMutableProperty");
            ClassId classId5 = ClassId.topLevel(kPropertyFqName.toSafe());
            Intrinsics.checkNotNullExpressionValue(classId5, "topLevel(...)");
            kProperty = classId5;
            kDeclarationContainer = FqNames.reflect("KDeclarationContainer");
            uByteFqName = INSTANCE.fqName("UByte");
            uShortFqName = INSTANCE.fqName("UShort");
            uIntFqName = INSTANCE.fqName("UInt");
            uLongFqName = INSTANCE.fqName("ULong");
            ClassId classId6 = ClassId.topLevel(uByteFqName);
            Intrinsics.checkNotNullExpressionValue(classId6, "topLevel(...)");
            uByte = classId6;
            ClassId classId7 = ClassId.topLevel(uShortFqName);
            Intrinsics.checkNotNullExpressionValue(classId7, "topLevel(...)");
            uShort = classId7;
            ClassId classId8 = ClassId.topLevel(uIntFqName);
            Intrinsics.checkNotNullExpressionValue(classId8, "topLevel(...)");
            uInt = classId8;
            ClassId classId9 = ClassId.topLevel(uLongFqName);
            Intrinsics.checkNotNullExpressionValue(classId9, "topLevel(...)");
            uLong = classId9;
            uByteArrayFqName = INSTANCE.fqName("UByteArray");
            uShortArrayFqName = INSTANCE.fqName("UShortArray");
            uIntArrayFqName = INSTANCE.fqName("UIntArray");
            uLongArrayFqName = INSTANCE.fqName("ULongArray");
            HashSet $this$primitiveTypeShortNames_u24lambda_u241 = cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            boolean bl = false;
            PrimitiveType[] $this$mapTo$iv = PrimitiveType.values();
            boolean $i$f$mapTo = false;
            int n2 = $this$mapTo$iv.length;
            for (n = 0; n < n2; ++n) {
                PrimitiveType primitiveType = item$iv = $this$mapTo$iv[n];
                collection = $this$primitiveTypeShortNames_u24lambda_u241;
                boolean bl2 = false;
                collection.add(it.getTypeName());
            }
            primitiveTypeShortNames = cloneable2;
            HashSet $this$primitiveArrayTypeShortNames_u24lambda_u243 = cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            boolean bl3 = false;
            $this$mapTo$iv = PrimitiveType.values();
            $i$f$mapTo = false;
            n2 = $this$mapTo$iv.length;
            for (n = 0; n < n2; ++n) {
                it = item$iv = $this$mapTo$iv[n];
                collection = $this$primitiveArrayTypeShortNames_u24lambda_u243;
                boolean bl4 = false;
                collection.add(it.getArrayTypeName());
            }
            primitiveArrayTypeShortNames = cloneable2;
            Cloneable $this$fqNameToPrimitiveType_u24lambda_u244 = cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            boolean bl5 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                map2 = (Map)((Object)$this$fqNameToPrimitiveType_u24lambda_u244);
                String string = primitiveType.getTypeName().asString();
                Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
                map2.put(INSTANCE.fqNameUnsafe(string), primitiveType);
            }
            fqNameToPrimitiveType = (Map)((Object)cloneable2);
            Cloneable $this$arrayClassFqNameToPrimitiveType_u24lambda_u245 = cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            boolean bl6 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                map2 = (Map)((Object)$this$arrayClassFqNameToPrimitiveType_u24lambda_u245);
                String string = primitiveType.getArrayTypeName().asString();
                Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
                map2.put(INSTANCE.fqNameUnsafe(string), primitiveType);
            }
            arrayClassFqNameToPrimitiveType = (Map)((Object)cloneable2);
        }
    }
}

