/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

public final class OperatorNameConventions {
    @NotNull
    public static final OperatorNameConventions INSTANCE = new OperatorNameConventions();
    @JvmField
    @NotNull
    public static final Name GET_VALUE;
    @JvmField
    @NotNull
    public static final Name SET_VALUE;
    @JvmField
    @NotNull
    public static final Name PROVIDE_DELEGATE;
    @JvmField
    @NotNull
    public static final Name EQUALS;
    @JvmField
    @NotNull
    public static final Name HASH_CODE;
    @JvmField
    @NotNull
    public static final Name COMPARE_TO;
    @JvmField
    @NotNull
    public static final Name CONTAINS;
    @JvmField
    @NotNull
    public static final Name INVOKE;
    @JvmField
    @NotNull
    public static final Name ITERATOR;
    @JvmField
    @NotNull
    public static final Name GET;
    @JvmField
    @NotNull
    public static final Name SET;
    @JvmField
    @NotNull
    public static final Name NEXT;
    @JvmField
    @NotNull
    public static final Name HAS_NEXT;
    @JvmField
    @NotNull
    public static final Name TO_STRING;
    @JvmField
    @NotNull
    public static final Regex COMPONENT_REGEX;
    @JvmField
    @NotNull
    public static final Name AND;
    @JvmField
    @NotNull
    public static final Name OR;
    @JvmField
    @NotNull
    public static final Name XOR;
    @JvmField
    @NotNull
    public static final Name INV;
    @JvmField
    @NotNull
    public static final Name SHL;
    @JvmField
    @NotNull
    public static final Name SHR;
    @JvmField
    @NotNull
    public static final Name USHR;
    @JvmField
    @NotNull
    public static final Name INC;
    @JvmField
    @NotNull
    public static final Name DEC;
    @JvmField
    @NotNull
    public static final Name PLUS;
    @JvmField
    @NotNull
    public static final Name MINUS;
    @JvmField
    @NotNull
    public static final Name NOT;
    @JvmField
    @NotNull
    public static final Name UNARY_MINUS;
    @JvmField
    @NotNull
    public static final Name UNARY_PLUS;
    @JvmField
    @NotNull
    public static final Name TIMES;
    @JvmField
    @NotNull
    public static final Name DIV;
    @JvmField
    @NotNull
    public static final Name MOD;
    @JvmField
    @NotNull
    public static final Name REM;
    @JvmField
    @NotNull
    public static final Name RANGE_TO;
    @JvmField
    @NotNull
    public static final Name RANGE_UNTIL;
    @JvmField
    @NotNull
    public static final Name TIMES_ASSIGN;
    @JvmField
    @NotNull
    public static final Name DIV_ASSIGN;
    @JvmField
    @NotNull
    public static final Name MOD_ASSIGN;
    @JvmField
    @NotNull
    public static final Name REM_ASSIGN;
    @JvmField
    @NotNull
    public static final Name PLUS_ASSIGN;
    @JvmField
    @NotNull
    public static final Name MINUS_ASSIGN;
    @JvmField
    @NotNull
    public static final Set<Name> UNARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> SIMPLE_UNARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> BINARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> BITWISE_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> ALL_BINARY_OPERATION_NAMES;
    @JvmField
    @NotNull
    public static final Set<Name> ASSIGNMENT_OPERATIONS;
    @JvmField
    @NotNull
    public static final Set<Name> DELEGATED_PROPERTY_OPERATORS;
    @JvmField
    @NotNull
    public static final Map<Name, Name> MOD_OPERATORS_REPLACEMENT;
    @JvmField
    @NotNull
    public static final Set<Name> STATEMENT_LIKE_OPERATORS;

    private OperatorNameConventions() {
    }

    static {
        Name name2 = Name.identifier("getValue");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        GET_VALUE = name2;
        Name name3 = Name.identifier("setValue");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        SET_VALUE = name3;
        Name name4 = Name.identifier("provideDelegate");
        Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        PROVIDE_DELEGATE = name4;
        Name name5 = Name.identifier("equals");
        Intrinsics.checkNotNullExpressionValue(name5, "identifier(...)");
        EQUALS = name5;
        Name name6 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue(name6, "identifier(...)");
        HASH_CODE = name6;
        Name name7 = Name.identifier("compareTo");
        Intrinsics.checkNotNullExpressionValue(name7, "identifier(...)");
        COMPARE_TO = name7;
        Name name8 = Name.identifier("contains");
        Intrinsics.checkNotNullExpressionValue(name8, "identifier(...)");
        CONTAINS = name8;
        Name name9 = Name.identifier("invoke");
        Intrinsics.checkNotNullExpressionValue(name9, "identifier(...)");
        INVOKE = name9;
        Name name10 = Name.identifier("iterator");
        Intrinsics.checkNotNullExpressionValue(name10, "identifier(...)");
        ITERATOR = name10;
        Name name11 = Name.identifier("get");
        Intrinsics.checkNotNullExpressionValue(name11, "identifier(...)");
        GET = name11;
        Name name12 = Name.identifier("set");
        Intrinsics.checkNotNullExpressionValue(name12, "identifier(...)");
        SET = name12;
        Name name13 = Name.identifier("next");
        Intrinsics.checkNotNullExpressionValue(name13, "identifier(...)");
        NEXT = name13;
        Name name14 = Name.identifier("hasNext");
        Intrinsics.checkNotNullExpressionValue(name14, "identifier(...)");
        HAS_NEXT = name14;
        Name name15 = Name.identifier("toString");
        Intrinsics.checkNotNullExpressionValue(name15, "identifier(...)");
        TO_STRING = name15;
        COMPONENT_REGEX = new Regex("component\\d+");
        Name name16 = Name.identifier("and");
        Intrinsics.checkNotNullExpressionValue(name16, "identifier(...)");
        AND = name16;
        Name name17 = Name.identifier("or");
        Intrinsics.checkNotNullExpressionValue(name17, "identifier(...)");
        OR = name17;
        Name name18 = Name.identifier("xor");
        Intrinsics.checkNotNullExpressionValue(name18, "identifier(...)");
        XOR = name18;
        Name name19 = Name.identifier("inv");
        Intrinsics.checkNotNullExpressionValue(name19, "identifier(...)");
        INV = name19;
        Name name20 = Name.identifier("shl");
        Intrinsics.checkNotNullExpressionValue(name20, "identifier(...)");
        SHL = name20;
        Name name21 = Name.identifier("shr");
        Intrinsics.checkNotNullExpressionValue(name21, "identifier(...)");
        SHR = name21;
        Name name22 = Name.identifier("ushr");
        Intrinsics.checkNotNullExpressionValue(name22, "identifier(...)");
        USHR = name22;
        Name name23 = Name.identifier("inc");
        Intrinsics.checkNotNullExpressionValue(name23, "identifier(...)");
        INC = name23;
        Name name24 = Name.identifier("dec");
        Intrinsics.checkNotNullExpressionValue(name24, "identifier(...)");
        DEC = name24;
        Name name25 = Name.identifier("plus");
        Intrinsics.checkNotNullExpressionValue(name25, "identifier(...)");
        PLUS = name25;
        Name name26 = Name.identifier("minus");
        Intrinsics.checkNotNullExpressionValue(name26, "identifier(...)");
        MINUS = name26;
        Name name27 = Name.identifier("not");
        Intrinsics.checkNotNullExpressionValue(name27, "identifier(...)");
        NOT = name27;
        Name name28 = Name.identifier("unaryMinus");
        Intrinsics.checkNotNullExpressionValue(name28, "identifier(...)");
        UNARY_MINUS = name28;
        Name name29 = Name.identifier("unaryPlus");
        Intrinsics.checkNotNullExpressionValue(name29, "identifier(...)");
        UNARY_PLUS = name29;
        Name name30 = Name.identifier("times");
        Intrinsics.checkNotNullExpressionValue(name30, "identifier(...)");
        TIMES = name30;
        Name name31 = Name.identifier("div");
        Intrinsics.checkNotNullExpressionValue(name31, "identifier(...)");
        DIV = name31;
        Name name32 = Name.identifier("mod");
        Intrinsics.checkNotNullExpressionValue(name32, "identifier(...)");
        MOD = name32;
        Name name33 = Name.identifier("rem");
        Intrinsics.checkNotNullExpressionValue(name33, "identifier(...)");
        REM = name33;
        Name name34 = Name.identifier("rangeTo");
        Intrinsics.checkNotNullExpressionValue(name34, "identifier(...)");
        RANGE_TO = name34;
        Name name35 = Name.identifier("rangeUntil");
        Intrinsics.checkNotNullExpressionValue(name35, "identifier(...)");
        RANGE_UNTIL = name35;
        Name name36 = Name.identifier("timesAssign");
        Intrinsics.checkNotNullExpressionValue(name36, "identifier(...)");
        TIMES_ASSIGN = name36;
        Name name37 = Name.identifier("divAssign");
        Intrinsics.checkNotNullExpressionValue(name37, "identifier(...)");
        DIV_ASSIGN = name37;
        Name name38 = Name.identifier("modAssign");
        Intrinsics.checkNotNullExpressionValue(name38, "identifier(...)");
        MOD_ASSIGN = name38;
        Name name39 = Name.identifier("remAssign");
        Intrinsics.checkNotNullExpressionValue(name39, "identifier(...)");
        REM_ASSIGN = name39;
        Name name40 = Name.identifier("plusAssign");
        Intrinsics.checkNotNullExpressionValue(name40, "identifier(...)");
        PLUS_ASSIGN = name40;
        Name name41 = Name.identifier("minusAssign");
        Intrinsics.checkNotNullExpressionValue(name41, "identifier(...)");
        MINUS_ASSIGN = name41;
        Object[] objectArray = new Name[]{INC, DEC, UNARY_PLUS, UNARY_MINUS, NOT, INV};
        UNARY_OPERATION_NAMES = SetsKt.setOf(objectArray);
        objectArray = new Name[]{UNARY_PLUS, UNARY_MINUS, NOT, INV};
        SIMPLE_UNARY_OPERATION_NAMES = SetsKt.setOf(objectArray);
        objectArray = new Name[]{TIMES, PLUS, MINUS, DIV, MOD, REM, RANGE_TO, RANGE_UNTIL};
        BINARY_OPERATION_NAMES = SetsKt.setOf(objectArray);
        objectArray = new Name[]{AND, OR, XOR, INV, SHL, SHR, USHR};
        BITWISE_OPERATION_NAMES = SetsKt.setOf(objectArray);
        objectArray = new Name[]{EQUALS, CONTAINS, COMPARE_TO};
        ALL_BINARY_OPERATION_NAMES = SetsKt.plus(SetsKt.plus(BINARY_OPERATION_NAMES, (Iterable)BITWISE_OPERATION_NAMES), (Iterable)SetsKt.setOf(objectArray));
        objectArray = new Name[]{TIMES_ASSIGN, DIV_ASSIGN, MOD_ASSIGN, REM_ASSIGN, PLUS_ASSIGN, MINUS_ASSIGN};
        ASSIGNMENT_OPERATIONS = SetsKt.setOf(objectArray);
        objectArray = new Name[]{GET_VALUE, SET_VALUE, PROVIDE_DELEGATE};
        DELEGATED_PROPERTY_OPERATORS = SetsKt.setOf(objectArray);
        objectArray = new Pair[]{TuplesKt.to(MOD, REM), TuplesKt.to(MOD_ASSIGN, REM_ASSIGN)};
        MOD_OPERATORS_REPLACEMENT = MapsKt.mapOf(objectArray);
        STATEMENT_LIKE_OPERATORS = SetsKt.plus(SetsKt.setOf(SET), (Iterable)ASSIGNMENT_OPERATIONS);
    }
}

