/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.SharedLibraryLoader;

public final class LibraryResource {
    private LibraryResource() {
    }

    public static Path load(String module, String name2) {
        return LibraryResource.load(LibraryResource.class, module, name2);
    }

    public static Path load(Class<?> context, String module, String name2) {
        return LibraryResource.load(context, module, name2, false, true);
    }

    public static Path load(Class<?> context, String module, String name2, boolean bundledWithLWJGL) {
        return LibraryResource.load(context, module, name2, bundledWithLWJGL, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path load(Class<?> context, String module, String name2, boolean bundledWithLWJGL, boolean printError) {
        String paths;
        Path path;
        block26: {
            if (Checks.DEBUG) {
                APIUtil.DEBUG_STREAM.print("[LWJGL] Loading library resource: " + name2 + "\n\tModule: " + module + "\n");
            }
            if ((path = Paths.get(name2, new String[0])).isAbsolute()) {
                if (!Files.exists(path, new LinkOption[0])) {
                    if (!printError) throw new IllegalStateException("Failed to locate library resource: " + name2);
                    LibraryResource.printError();
                    throw new IllegalStateException("Failed to locate library resource: " + name2);
                }
                APIUtil.apiLogMore("Success");
                return path;
            }
            URL resourceURL = Library.findResource(context, module, name2, bundledWithLWJGL);
            if (resourceURL == null) {
                path = LibraryResource.loadFromLibraryPath(module, name2, bundledWithLWJGL);
                if (path != null) {
                    return path;
                }
            } else {
                boolean debugLoader = Configuration.DEBUG_LOADER.get(false);
                try {
                    String regular = Library.getRegularFilePath(resourceURL);
                    if (regular != null) {
                        APIUtil.apiLogMore("Loaded from classpath: " + regular);
                        return Paths.get(regular, new String[0]);
                    }
                    if (debugLoader) {
                        APIUtil.apiLogMore("Using SharedLibraryLoader...");
                    }
                    try (FileChannel ignored = SharedLibraryLoader.load(name2, name2, resourceURL, null);){
                        path = LibraryResource.loadFromLibraryPath(module, name2, bundledWithLWJGL);
                        if (path != null) {
                            Path path2 = path;
                            return path2;
                        }
                    }
                }
                catch (Exception e) {
                    if (!debugLoader) break block26;
                    e.printStackTrace(APIUtil.DEBUG_STREAM);
                }
            }
        }
        if ((paths = System.getProperty("java.library.path")) != null && (path = LibraryResource.load(module, name2, bundledWithLWJGL, "java.library.path", paths)) != null) {
            return path;
        }
        if (!printError) throw new IllegalStateException("Failed to locate library resource: " + name2);
        LibraryResource.printError();
        throw new IllegalStateException("Failed to locate library resource: " + name2);
    }

    @Nullable
    private static Path loadFromLibraryPath(String module, String libName, boolean bundledWithLWJGL) {
        String paths = Configuration.LIBRARY_PATH.get();
        if (paths == null) {
            return null;
        }
        return LibraryResource.load(module, libName, bundledWithLWJGL, Configuration.LIBRARY_PATH.getProperty(), paths);
    }

    @Nullable
    private static Path load(String module, String name2, boolean bundledWithLWJGL, String property2, String paths) {
        Path resource2 = Library.findFile(paths, module, name2, bundledWithLWJGL);
        if (resource2 == null) {
            APIUtil.apiLogMore(name2 + " not found in " + property2 + "=" + paths);
            return null;
        }
        APIUtil.apiLogMore("Loaded from " + property2 + ": " + resource2);
        return resource2;
    }

    public static Path load(Class<?> context, String module, Configuration<String> name2, String ... defaultNames) {
        return LibraryResource.load(context, module, name2, null, defaultNames);
    }

    public static Path load(Class<?> context, String module, Configuration<String> name2, @Nullable Supplier<Path> fallback2, String ... defaultNames) {
        if (defaultNames.length == 0) {
            throw new IllegalArgumentException("No default names specified.");
        }
        String resourceName = name2.get();
        if (resourceName != null) {
            return LibraryResource.load(context, module, resourceName);
        }
        if (fallback2 == null && defaultNames.length <= 1) {
            return LibraryResource.load(context, module, defaultNames[0]);
        }
        try {
            return LibraryResource.load(context, module, defaultNames[0], false, false);
        }
        catch (Throwable t) {
            for (int i = 1; i < defaultNames.length; ++i) {
                try {
                    return LibraryResource.load(context, module, defaultNames[i], false, fallback2 == null && i == defaultNames.length - 1);
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            if (fallback2 != null) {
                return fallback2.get();
            }
            throw t;
        }
    }

    private static void printError() {
        Library.printError("[LWJGL] Failed to load a library resource. Possible solutions:\n\ta) Add the directory that contains the resource to -Djava.library.path or -Dorg.lwjgl.librarypath.\n\tb) Add the JAR that contains the resource to the classpath.");
    }

    static {
        Library.initialize();
    }
}

