/* webkit2gtk-4.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "WebKit", gir_namespace = "WebKit2", gir_version = "4.0", lower_case_cprefix = "webkit_")]
namespace WebKit {
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_application_info_ref", type_id = "webkit_application_info_get_type ()", unref_function = "webkit_application_info_unref")]
	[Compact]
	public class ApplicationInfo {
		[CCode (has_construct_function = false)]
		[Version (since = "2.18")]
		public ApplicationInfo ();
		[Version (since = "2.18")]
		public unowned string get_name ();
		[Version (since = "2.18")]
		public void get_version (out uint64 major, out uint64 minor, out uint64 micro);
		[Version (since = "2.18")]
		public unowned WebKit.ApplicationInfo @ref ();
		[Version (since = "2.18")]
		public void set_name (string name);
		[Version (since = "2.18")]
		public void set_version (uint64 major, uint64 minor, uint64 micro);
		[Version (since = "2.18")]
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_authentication_request_get_type ()")]
	public class AuthenticationRequest : GLib.Object {
		[CCode (has_construct_function = false)]
		protected AuthenticationRequest ();
		[Version (since = "2.2")]
		public void authenticate (WebKit.Credential? credential);
		[Version (since = "2.2")]
		public bool can_save_credentials ();
		[Version (since = "2.2")]
		public void cancel ();
		[Version (since = "2.34")]
		public GLib.TlsPasswordFlags get_certificate_pin_flags ();
		[Version (since = "2.2")]
		public unowned string get_host ();
		[Version (since = "2.2")]
		public uint get_port ();
		[Version (since = "2.2")]
		public WebKit.Credential get_proposed_credential ();
		[Version (since = "2.2")]
		public unowned string get_realm ();
		[Version (since = "2.2")]
		public WebKit.AuthenticationScheme get_scheme ();
		[Version (since = "2.30")]
		public WebKit.SecurityOrigin get_security_origin ();
		[Version (since = "2.2")]
		public bool is_for_proxy ();
		[Version (since = "2.2")]
		public bool is_retry ();
		[Version (since = "2.30")]
		public void set_can_save_credentials (bool enabled);
		[Version (since = "2.30")]
		public void set_proposed_credential (WebKit.Credential credential);
		[Version (since = "2.30")]
		public signal void authenticated (WebKit.Credential credential);
		[Version (since = "2.2")]
		public signal void cancelled ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_automation_session_get_type ()")]
	[Version (since = "2.18")]
	public class AutomationSession : GLib.Object {
		[CCode (has_construct_function = false)]
		protected AutomationSession ();
		public unowned WebKit.ApplicationInfo get_application_info ();
		public unowned string get_id ();
		public void set_application_info (WebKit.ApplicationInfo info);
		public string id { get; construct; }
		public signal unowned WebKit.WebView create_web_view ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_back_forward_list_get_type ()")]
	public class BackForwardList : GLib.Object {
		[CCode (has_construct_function = false)]
		protected BackForwardList ();
		public unowned WebKit.BackForwardListItem? get_back_item ();
		public GLib.List<weak WebKit.BackForwardListItem> get_back_list ();
		public GLib.List<weak WebKit.BackForwardListItem> get_back_list_with_limit (uint limit);
		public unowned WebKit.BackForwardListItem? get_current_item ();
		public unowned WebKit.BackForwardListItem? get_forward_item ();
		public GLib.List<weak WebKit.BackForwardListItem> get_forward_list ();
		public GLib.List<weak WebKit.BackForwardListItem> get_forward_list_with_limit (uint limit);
		public uint get_length ();
		public unowned WebKit.BackForwardListItem? get_nth_item (int index);
		public signal void changed (WebKit.BackForwardListItem? item_added, void* items_removed);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_back_forward_list_item_get_type ()")]
	public class BackForwardListItem : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		protected BackForwardListItem ();
		public unowned string get_original_uri ();
		public unowned string get_title ();
		public unowned string get_uri ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_color_chooser_request_get_type ()")]
	public class ColorChooserRequest : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ColorChooserRequest ();
		[Version (since = "2.8")]
		public void cancel ();
		[Version (since = "2.8")]
		public void finish ();
		[Version (since = "2.8")]
		public Gdk.Rectangle get_element_rectangle ();
		[Version (since = "2.8")]
		public Gdk.RGBA get_rgba ();
		[Version (since = "2.8")]
		public void set_rgba (Gdk.RGBA rgba);
		[Version (since = "2.8")]
		public Gdk.RGBA rgba { get; set construct; }
		[Version (since = "2.8")]
		public signal void finished ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_context_menu_get_type ()")]
	public class ContextMenu : GLib.Object {
		[CCode (has_construct_function = false)]
		public ContextMenu ();
		public void append (WebKit.ContextMenuItem item);
		public unowned WebKit.ContextMenuItem first ();
		[Version (since = "2.40")]
		public unowned Gdk.Event get_event ();
		public unowned WebKit.ContextMenuItem get_item_at_position (uint position);
		public unowned GLib.List<WebKit.ContextMenuItem> get_items ();
		public uint get_n_items ();
		[Version (since = "2.8")]
		public unowned GLib.Variant get_user_data ();
		public void insert (WebKit.ContextMenuItem item, int position);
		public unowned WebKit.ContextMenuItem last ();
		public void move_item (WebKit.ContextMenuItem item, int position);
		public void prepend (WebKit.ContextMenuItem item);
		public void remove (WebKit.ContextMenuItem item);
		public void remove_all ();
		[Version (since = "2.8")]
		public void set_user_data (GLib.Variant user_data);
		[CCode (has_construct_function = false)]
		public ContextMenu.with_items (GLib.List<WebKit.ContextMenuItem> items);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_context_menu_item_get_type ()")]
	public class ContextMenuItem : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		[Version (deprecated = true, deprecated_since = "2.18")]
		public ContextMenuItem (Gtk.Action action);
		[CCode (has_construct_function = false)]
		[Version (since = "2.18")]
		public ContextMenuItem.from_gaction (GLib.Action action, string label, GLib.Variant? target);
		[CCode (has_construct_function = false)]
		public ContextMenuItem.from_stock_action (WebKit.ContextMenuAction action);
		[CCode (has_construct_function = false)]
		public ContextMenuItem.from_stock_action_with_label (WebKit.ContextMenuAction action, string label);
		[Version (deprecated = true, deprecated_since = "2.18")]
		public unowned Gtk.Action get_action ();
		[Version (since = "2.18")]
		public unowned GLib.Action get_gaction ();
		public WebKit.ContextMenuAction get_stock_action ();
		public unowned WebKit.ContextMenu get_submenu ();
		public bool is_separator ();
		[CCode (has_construct_function = false)]
		public ContextMenuItem.separator ();
		public void set_submenu (WebKit.ContextMenu? submenu);
		[CCode (has_construct_function = false)]
		public ContextMenuItem.with_submenu (string label, WebKit.ContextMenu submenu);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_cookie_manager_get_type ()")]
	public class CookieManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected CookieManager ();
		[Version (since = "2.20")]
		public async bool add_cookie (Soup.Cookie cookie, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "2.16")]
		public void delete_all_cookies ();
		[Version (since = "2.20")]
		public async bool delete_cookie (Soup.Cookie cookie, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "2.16")]
		public void delete_cookies_for_domain (string domain);
		public async WebKit.CookieAcceptPolicy get_accept_policy (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.20")]
		public async GLib.List<Soup.Cookie> get_cookies (string uri, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (deprecated = true, deprecated_since = "2.16")]
		public async string[] get_domains_with_cookies (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void set_accept_policy (WebKit.CookieAcceptPolicy policy);
		public void set_persistent_storage (string filename, WebKit.CookiePersistentStorage storage);
		public signal void changed ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "webkit_credential_get_type ()")]
	[Compact]
	[Version (since = "2.2")]
	public class Credential {
		[CCode (has_construct_function = false)]
		public Credential (string username, string password, WebKit.CredentialPersistence persistence);
		public WebKit.Credential copy ();
		[CCode (has_construct_function = false)]
		[Version (since = "2.34")]
		public Credential.for_certificate (GLib.TlsCertificate? certificate, WebKit.CredentialPersistence persistence);
		[CCode (has_construct_function = false)]
		[Version (since = "2.34")]
		public Credential.for_certificate_pin (string pin, WebKit.CredentialPersistence persistence);
		public void free ();
		[Version (since = "2.34")]
		public unowned GLib.TlsCertificate get_certificate ();
		public unowned string get_password ();
		public WebKit.CredentialPersistence get_persistence ();
		public unowned string get_username ();
		public bool has_password ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_device_info_permission_request_get_type ()")]
	[Version (since = "2.24")]
	public class DeviceInfoPermissionRequest : GLib.Object, WebKit.PermissionRequest {
		[CCode (has_construct_function = false)]
		protected DeviceInfoPermissionRequest ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_download_get_type ()")]
	public class Download : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Download ();
		public void cancel ();
		[Version (since = "2.6")]
		public bool get_allow_overwrite ();
		public unowned string? get_destination ();
		public double get_elapsed_time ();
		public double get_estimated_progress ();
		public uint64 get_received_data_length ();
		public unowned WebKit.URIRequest get_request ();
		public unowned WebKit.URIResponse get_response ();
		public unowned WebKit.WebView get_web_view ();
		[Version (since = "2.6")]
		public void set_allow_overwrite (bool allowed);
		public void set_destination (string destination);
		[Version (since = "2.6")]
		public bool allow_overwrite { get; set; }
		public string destination { get; }
		public double estimated_progress { get; }
		public WebKit.URIResponse response { get; }
		public signal void created_destination (string destination);
		public virtual signal bool decide_destination (string suggested_filename);
		public signal void failed (WebKit.DownloadError error);
		public signal void finished ();
		public signal void received_data (uint64 data_length);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_editor_state_get_type ()")]
	[Version (since = "2.10")]
	public class EditorState : GLib.Object {
		[CCode (has_construct_function = false)]
		protected EditorState ();
		public uint get_typing_attributes ();
		[Version (since = "2.20")]
		public bool is_copy_available ();
		[Version (since = "2.20")]
		public bool is_cut_available ();
		[Version (since = "2.20")]
		public bool is_paste_available ();
		[Version (since = "2.20")]
		public bool is_redo_available ();
		[Version (since = "2.20")]
		public bool is_undo_available ();
		public uint typing_attributes { get; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_favicon_database_get_type ()")]
	public class FaviconDatabase : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FaviconDatabase ();
		public void clear ();
		public async Cairo.Surface get_favicon (string page_uri, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public string get_favicon_uri (string page_uri);
		public signal void favicon_changed (string page_uri, string favicon_uri);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_file_chooser_request_get_type ()")]
	public class FileChooserRequest : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FileChooserRequest ();
		public void cancel ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_mime_types ();
		public unowned Gtk.FileFilter get_mime_types_filter ();
		public bool get_select_multiple ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_selected_files ();
		public void select_files ([CCode (array_length = false, array_null_terminated = true)] string[] files);
		[NoAccessorMethod]
		public Gtk.FileFilter filter { owned get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] mime_types { get; }
		public bool select_multiple { get; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] selected_files { get; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_find_controller_get_type ()")]
	public class FindController : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FindController ();
		public void count_matches (string search_text, uint32 find_options, uint max_match_count);
		public uint get_max_match_count ();
		public uint32 get_options ();
		public unowned string get_search_text ();
		public unowned WebKit.WebView get_web_view ();
		public void search (string search_text, uint32 find_options, uint max_match_count);
		public void search_finish ();
		public void search_next ();
		public void search_previous ();
		public uint max_match_count { get; }
		public WebKit.FindOptions options { get; }
		[NoAccessorMethod]
		public string text { owned get; }
		public WebKit.WebView web_view { get; construct; }
		public signal void counted_matches (uint match_count);
		public signal void failed_to_find_text ();
		public signal void found_text (uint match_count);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_form_submission_request_get_type ()")]
	public class FormSubmissionRequest : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FormSubmissionRequest ();
		[Version (deprecated = true, deprecated_since = "2.20.")]
		public unowned GLib.HashTable<void*,void*>? get_text_fields ();
		[Version (since = "2.20")]
		public bool list_text_fields (out unowned GLib.GenericArray<string> field_names, out unowned GLib.GenericArray<string> field_values);
		public void submit ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_geolocation_manager_get_type ()")]
	[Version (since = "2.26")]
	public class GeolocationManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected GeolocationManager ();
		public void failed (string error_message);
		public bool get_enable_high_accuracy ();
		public void update_position (WebKit.GeolocationPosition position);
		public bool enable_high_accuracy { get; }
		public signal bool start ();
		public signal void stop ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_geolocation_permission_request_get_type ()")]
	public class GeolocationPermissionRequest : GLib.Object, WebKit.PermissionRequest {
		[CCode (has_construct_function = false)]
		protected GeolocationPermissionRequest ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "webkit_geolocation_position_get_type ()")]
	[Compact]
	[Version (since = "2.26")]
	public class GeolocationPosition {
		[CCode (has_construct_function = false)]
		public GeolocationPosition (double latitude, double longitude, double accuracy);
		public WebKit.GeolocationPosition copy ();
		public void free ();
		public void set_altitude (double altitude);
		public void set_altitude_accuracy (double altitude_accuracy);
		public void set_heading (double heading);
		public void set_speed (double speed);
		public void set_timestamp (uint64 timestamp);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_hit_test_result_get_type ()")]
	public class HitTestResult : GLib.Object {
		[CCode (has_construct_function = false)]
		protected HitTestResult ();
		public bool context_is_editable ();
		public bool context_is_image ();
		public bool context_is_link ();
		public bool context_is_media ();
		public bool context_is_scrollbar ();
		[Version (since = "2.8")]
		public bool context_is_selection ();
		public uint get_context ();
		public unowned string get_image_uri ();
		public unowned string get_link_label ();
		public unowned string get_link_title ();
		public unowned string get_link_uri ();
		public unowned string get_media_uri ();
		public uint context { get; construct; }
		public string image_uri { get; construct; }
		public string link_label { get; construct; }
		public string link_title { get; construct; }
		public string link_uri { get; construct; }
		public string media_uri { get; construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_itp_first_party_ref", type_id = "webkit_itp_first_party_get_type ()", unref_function = "webkit_itp_first_party_unref")]
	[Compact]
	[Version (since = "2.30")]
	public class ITPFirstParty {
		public unowned string get_domain ();
		public unowned GLib.DateTime get_last_update_time ();
		public bool get_website_data_access_allowed ();
		public unowned WebKit.ITPFirstParty @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_itp_third_party_ref", type_id = "webkit_itp_third_party_get_type ()", unref_function = "webkit_itp_third_party_unref")]
	[Compact]
	[Version (since = "2.30")]
	public class ITPThirdParty {
		public unowned string get_domain ();
		public unowned GLib.List<WebKit.ITPFirstParty> get_first_parties ();
		public unowned WebKit.ITPThirdParty @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_input_method_context_get_type ()")]
	[Version (since = "2.28")]
	public abstract class InputMethodContext : GLib.Object {
		[CCode (has_construct_function = false)]
		protected InputMethodContext ();
		public virtual bool filter_key_event (Gdk.EventKey key_event);
		public WebKit.InputHints get_input_hints ();
		public WebKit.InputPurpose get_input_purpose ();
		public virtual void get_preedit (out string? text, out GLib.List<WebKit.InputMethodUnderline>? underlines, out uint cursor_offset);
		public virtual void notify_cursor_area (int x, int y, int width, int height);
		public virtual void notify_focus_in ();
		public virtual void notify_focus_out ();
		public virtual void notify_surrounding (string text, uint length, uint cursor_index, uint selection_index);
		public virtual void reset ();
		public virtual void set_enable_preedit (bool enabled);
		public void set_input_hints (WebKit.InputHints hints);
		public void set_input_purpose (WebKit.InputPurpose purpose);
		public WebKit.InputHints input_hints { get; set; }
		public WebKit.InputPurpose input_purpose { get; set; }
		public virtual signal void committed (string text);
		public virtual signal void delete_surrounding (int offset, uint n_chars);
		public virtual signal void preedit_changed ();
		public virtual signal void preedit_finished ();
		public virtual signal void preedit_started ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "webkit_input_method_underline_get_type ()")]
	[Compact]
	[Version (since = "2.28")]
	public class InputMethodUnderline {
		[CCode (has_construct_function = false)]
		public InputMethodUnderline (uint start_offset, uint end_offset);
		public WebKit.InputMethodUnderline copy ();
		public void free ();
		public void set_color (Gdk.RGBA? rgba);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_install_missing_media_plugins_permission_request_get_type ()")]
	[Version (deprecated = true, deprecated_since = "2.40", since = "2.10")]
	public class InstallMissingMediaPluginsPermissionRequest : GLib.Object, WebKit.PermissionRequest {
		[CCode (has_construct_function = false)]
		protected InstallMissingMediaPluginsPermissionRequest ();
		public unowned string get_description ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_javascript_result_ref", type_id = "webkit_javascript_result_get_type ()", unref_function = "webkit_javascript_result_unref")]
	[Compact]
	public class JavascriptResult {
		[Version (deprecated = true, deprecated_since = "2.22")]
		public unowned JS.GlobalContext get_global_context ();
		[Version (since = "2.22")]
		public unowned JSC.Value get_js_value ();
		[Version (deprecated = true, deprecated_since = "2.22")]
		public unowned JS.Value get_value ();
		public unowned WebKit.JavascriptResult @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_media_key_system_permission_request_get_type ()")]
	public class MediaKeySystemPermissionRequest : GLib.Object, WebKit.PermissionRequest {
		[CCode (has_construct_function = false)]
		protected MediaKeySystemPermissionRequest ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "webkit_memory_pressure_settings_get_type ()")]
	[Compact]
	[Version (since = "2.34")]
	public class MemoryPressureSettings {
		[CCode (has_construct_function = false)]
		public MemoryPressureSettings ();
		public WebKit.MemoryPressureSettings copy ();
		public void free ();
		public double get_conservative_threshold ();
		public double get_kill_threshold ();
		public uint get_memory_limit ();
		public double get_poll_interval ();
		public double get_strict_threshold ();
		public void set_conservative_threshold (double value);
		public void set_kill_threshold (double value);
		public void set_memory_limit (uint memory_limit);
		public void set_poll_interval (double value);
		public void set_strict_threshold (double value);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_mime_info_ref", type_id = "webkit_mime_info_get_type ()", unref_function = "webkit_mime_info_unref")]
	[Compact]
	public class MimeInfo {
		[Version (deprecated = true, deprecated_since = "2.32")]
		public unowned string? get_description ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (deprecated = true, deprecated_since = "2.32")]
		public unowned string[] get_extensions ();
		[Version (deprecated = true, deprecated_since = "2.32")]
		public unowned string get_mime_type ();
		[Version (deprecated = true, deprecated_since = "2.32")]
		public unowned WebKit.MimeInfo @ref ();
		[Version (deprecated = true, deprecated_since = "2.32")]
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "webkit_navigation_action_get_type ()")]
	[Compact]
	public class NavigationAction {
		[Version (since = "2.6")]
		public WebKit.NavigationAction copy ();
		[Version (since = "2.6")]
		public void free ();
		[Version (since = "2.40")]
		public unowned string? get_frame_name ();
		[Version (since = "2.6")]
		public uint get_modifiers ();
		[Version (since = "2.6")]
		public uint get_mouse_button ();
		[Version (since = "2.6")]
		public WebKit.NavigationType get_navigation_type ();
		[Version (since = "2.6")]
		public unowned WebKit.URIRequest get_request ();
		[Version (since = "2.20")]
		public bool is_redirect ();
		[Version (since = "2.6")]
		public bool is_user_gesture ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_navigation_policy_decision_get_type ()")]
	public class NavigationPolicyDecision : WebKit.PolicyDecision {
		[CCode (has_construct_function = false)]
		protected NavigationPolicyDecision ();
		[Version (deprecated = true, deprecated_since = "2.40")]
		public unowned string get_frame_name ();
		[Version (deprecated = true, deprecated_since = "2.6")]
		public uint get_modifiers ();
		[Version (deprecated = true, deprecated_since = "2.6")]
		public uint get_mouse_button ();
		[Version (since = "2.6")]
		public unowned WebKit.NavigationAction get_navigation_action ();
		[Version (deprecated = true, deprecated_since = "2.6")]
		public WebKit.NavigationType get_navigation_type ();
		[Version (deprecated = true, deprecated_since = "2.6")]
		public unowned WebKit.URIRequest get_request ();
		[Version (deprecated = true, deprecated_since = "2.40")]
		public string frame_name { get; }
		[Version (deprecated = true, deprecated_since = "2.6")]
		public uint modifiers { get; }
		[Version (deprecated = true, deprecated_since = "2.6")]
		public uint mouse_button { get; }
		[Version (since = "2.6")]
		public WebKit.NavigationAction navigation_action { get; }
		[Version (deprecated = true, deprecated_since = "2.6")]
		public WebKit.NavigationType navigation_type { get; }
		[Version (deprecated = true, deprecated_since = "2.6")]
		public WebKit.URIRequest request { get; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "webkit_network_proxy_settings_get_type ()")]
	[Compact]
	[Version (since = "2.16")]
	public class NetworkProxySettings {
		[CCode (has_construct_function = false)]
		public NetworkProxySettings (string? default_proxy_uri, [CCode (array_length = false, array_null_terminated = true)] string[]? ignore_hosts);
		public void add_proxy_for_scheme (string scheme, string proxy_uri);
		public WebKit.NetworkProxySettings copy ();
		public void free ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_notification_get_type ()")]
	[Version (since = "2.8")]
	public class Notification : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Notification ();
		public void close ();
		public unowned string get_body ();
		public uint64 get_id ();
		[Version (since = "2.16")]
		public unowned string? get_tag ();
		public unowned string get_title ();
		public string body { get; }
		public uint64 id { get; }
		[Version (since = "2.16")]
		public string tag { get; }
		public string title { get; }
		[HasEmitter]
		[Version (since = "2.12")]
		public signal void clicked ();
		public signal void closed ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_notification_permission_request_get_type ()")]
	[Version (since = "2.8")]
	public class NotificationPermissionRequest : GLib.Object, WebKit.PermissionRequest {
		[CCode (has_construct_function = false)]
		protected NotificationPermissionRequest ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_option_menu_get_type ()")]
	[Version (since = "2.18")]
	public class OptionMenu : GLib.Object {
		[CCode (has_construct_function = false)]
		protected OptionMenu ();
		public void activate_item (uint index);
		[Version (since = "2.40")]
		public unowned Gdk.Event get_event ();
		public unowned WebKit.OptionMenuItem get_item (uint index);
		public uint get_n_items ();
		public void select_item (uint index);
		[HasEmitter]
		public signal void close ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "webkit_option_menu_item_get_type ()")]
	[Compact]
	[Version (since = "2.18")]
	public class OptionMenuItem {
		public WebKit.OptionMenuItem copy ();
		public void free ();
		public unowned string get_label ();
		public unowned string get_tooltip ();
		public bool is_enabled ();
		public bool is_group_child ();
		public bool is_group_label ();
		public bool is_selected ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_permission_state_query_ref", type_id = "webkit_permission_state_query_get_type ()", unref_function = "webkit_permission_state_query_unref")]
	[Compact]
	public class PermissionStateQuery {
		[Version (since = "2.40")]
		public void finish (WebKit.PermissionState state);
		[Version (since = "2.40")]
		public unowned string get_name ();
		[Version (since = "2.40")]
		public unowned WebKit.SecurityOrigin get_security_origin ();
		[Version (since = "2.40")]
		public unowned WebKit.PermissionStateQuery @ref ();
		[Version (since = "2.40")]
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_plugin_get_type ()")]
	[Version (deprecated = true, deprecated_since = "2.32")]
	public class Plugin : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Plugin ();
		public unowned string? get_description ();
		public unowned GLib.List<WebKit.MimeInfo> get_mime_info_list ();
		public unowned string? get_name ();
		public unowned string? get_path ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_pointer_lock_permission_request_get_type ()")]
	[Version (since = "2.28")]
	public class PointerLockPermissionRequest : GLib.Object, WebKit.PermissionRequest {
		[CCode (has_construct_function = false)]
		protected PointerLockPermissionRequest ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_policy_decision_get_type ()")]
	public abstract class PolicyDecision : GLib.Object {
		[CCode (has_construct_function = false)]
		protected PolicyDecision ();
		public void download ();
		public void ignore ();
		public void use ();
		[Version (since = "2.30")]
		public void use_with_policies (WebKit.WebsitePolicies policies);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_print_custom_widget_get_type ()")]
	[Version (deprecated = true, deprecated_since = "2.40", since = "2.16")]
	public class PrintCustomWidget : GLib.Object {
		[CCode (has_construct_function = false)]
		public PrintCustomWidget (Gtk.Widget widget, string title);
		public unowned string get_title ();
		public unowned Gtk.Widget get_widget ();
		public string title { get; construct; }
		public Gtk.Widget widget { get; construct; }
		public virtual signal void apply ();
		public virtual signal void update (Gtk.PageSetup widget, Gtk.PrintSettings page_setup);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_print_operation_get_type ()")]
	public class PrintOperation : GLib.Object {
		[CCode (has_construct_function = false)]
		public PrintOperation (WebKit.WebView web_view);
		public unowned Gtk.PageSetup get_page_setup ();
		public unowned Gtk.PrintSettings get_print_settings ();
		public void print ();
		public WebKit.PrintOperationResponse run_dialog (Gtk.Window? parent);
		public void set_page_setup (Gtk.PageSetup page_setup);
		public void set_print_settings (Gtk.PrintSettings print_settings);
		public Gtk.PageSetup page_setup { get; set; }
		public Gtk.PrintSettings print_settings { get; set; }
		[NoAccessorMethod]
		public WebKit.WebView web_view { owned get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.16")]
		public signal WebKit.PrintCustomWidget create_custom_widget ();
		public signal void failed (WebKit.PrintError error);
		public signal void finished ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_response_policy_decision_get_type ()")]
	public class ResponsePolicyDecision : WebKit.PolicyDecision {
		[CCode (has_construct_function = false)]
		protected ResponsePolicyDecision ();
		public unowned WebKit.URIRequest get_request ();
		public unowned WebKit.URIResponse get_response ();
		[Version (since = "2.40")]
		public bool is_main_frame_main_resource ();
		[Version (since = "2.4")]
		public bool is_mime_type_supported ();
		public WebKit.URIRequest request { get; }
		public WebKit.URIResponse response { get; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_script_dialog_ref", type_id = "webkit_script_dialog_get_type ()", unref_function = "webkit_script_dialog_unref")]
	[Compact]
	public class ScriptDialog {
		[Version (since = "2.24")]
		public void close ();
		public void confirm_set_confirmed (bool confirmed);
		public WebKit.ScriptDialogType get_dialog_type ();
		public unowned string get_message ();
		public unowned string prompt_get_default_text ();
		public void prompt_set_text (string text);
		[Version (since = "2.24")]
		public unowned WebKit.ScriptDialog @ref ();
		[Version (since = "2.24")]
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_script_message_reply_ref", type_id = "webkit_script_message_reply_get_type ()", unref_function = "webkit_script_message_reply_unref")]
	[Compact]
	[Version (since = "2.40")]
	public class ScriptMessageReply {
		public unowned WebKit.ScriptMessageReply @ref ();
		public void return_error_message (string error_message);
		public void return_value ([CCode (type = "JSCValue*")] JSC.Value reply_value);
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_security_manager_get_type ()")]
	public class SecurityManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected SecurityManager ();
		public void register_uri_scheme_as_cors_enabled (string scheme);
		public void register_uri_scheme_as_display_isolated (string scheme);
		public void register_uri_scheme_as_empty_document (string scheme);
		public void register_uri_scheme_as_local (string scheme);
		public void register_uri_scheme_as_no_access (string scheme);
		public void register_uri_scheme_as_secure (string scheme);
		public bool uri_scheme_is_cors_enabled (string scheme);
		public bool uri_scheme_is_display_isolated (string scheme);
		public bool uri_scheme_is_empty_document (string scheme);
		public bool uri_scheme_is_local (string scheme);
		public bool uri_scheme_is_no_access (string scheme);
		public bool uri_scheme_is_secure (string scheme);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_security_origin_ref", type_id = "webkit_security_origin_get_type ()", unref_function = "webkit_security_origin_unref")]
	[Compact]
	[Version (since = "2.16")]
	public class SecurityOrigin {
		[CCode (has_construct_function = false)]
		public SecurityOrigin (string protocol, string host, uint16 port);
		[CCode (has_construct_function = false)]
		public SecurityOrigin.for_uri (string uri);
		public unowned string? get_host ();
		public uint16 get_port ();
		public unowned string? get_protocol ();
		[Version (deprecated = true, deprecated_since = "2.32", since = "2.16")]
		public bool is_opaque ();
		public unowned WebKit.SecurityOrigin @ref ();
		public string? to_string ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_settings_get_type ()")]
	public class Settings : GLib.Object {
		[CCode (has_construct_function = false)]
		public Settings ();
		[Version (since = "2.20")]
		public static uint32 font_size_to_pixels (uint32 points);
		[Version (since = "2.20")]
		public static uint32 font_size_to_points (uint32 pixels);
		[Version (since = "2.10")]
		public bool get_allow_file_access_from_file_urls ();
		public bool get_allow_modal_dialogs ();
		[Version (since = "2.28")]
		public bool get_allow_top_navigation_to_data_urls ();
		[Version (since = "2.14")]
		public bool get_allow_universal_access_from_file_urls ();
		public bool get_auto_load_images ();
		public unowned string get_cursive_font_family ();
		public unowned string get_default_charset ();
		public unowned string get_default_font_family ();
		public uint32 get_default_font_size ();
		public uint32 get_default_monospace_font_size ();
		[Version (since = "2.40")]
		public bool get_disable_web_security ();
		public bool get_draw_compositing_indicators ();
		[Version (deprecated = true, deprecated_since = "2.32.", since = "2.2")]
		public bool get_enable_accelerated_2d_canvas ();
		[Version (since = "2.24")]
		public bool get_enable_back_forward_navigation_gestures ();
		public bool get_enable_caret_browsing ();
		public bool get_enable_developer_extras ();
		public bool get_enable_dns_prefetching ();
		[Version (since = "2.20")]
		public bool get_enable_encrypted_media ();
		[Version (deprecated = true, deprecated_since = "2.38")]
		public bool get_enable_frame_flattening ();
		public bool get_enable_fullscreen ();
		public bool get_enable_html5_database ();
		public bool get_enable_html5_local_storage ();
		public bool get_enable_hyperlink_auditing ();
		[Version (deprecated = true, deprecated_since = "2.38.")]
		public bool get_enable_java ();
		public bool get_enable_javascript ();
		[Version (since = "2.24")]
		public bool get_enable_javascript_markup ();
		[Version (since = "2.26")]
		public bool get_enable_media ();
		[Version (since = "2.22")]
		public bool get_enable_media_capabilities ();
		[Version (since = "2.4")]
		public bool get_enable_media_stream ();
		[Version (since = "2.4")]
		public bool get_enable_mediasource ();
		[Version (since = "2.24")]
		public bool get_enable_mock_capture_devices ();
		public bool get_enable_offline_web_application_cache ();
		public bool get_enable_page_cache ();
		[Version (deprecated = true, deprecated_since = "2.32")]
		public bool get_enable_plugins ();
		[Version (deprecated = true, deprecated_since = "2.16.")]
		public bool get_enable_private_browsing ();
		public bool get_enable_resizable_text_areas ();
		public bool get_enable_site_specific_quirks ();
		public bool get_enable_smooth_scrolling ();
		[Version (since = "2.2")]
		public bool get_enable_spatial_navigation ();
		public bool get_enable_tabs_to_links ();
		public bool get_enable_webaudio ();
		public bool get_enable_webgl ();
		[Version (since = "2.38")]
		public bool get_enable_webrtc ();
		[Version (since = "2.2")]
		public bool get_enable_write_console_messages_to_stdout ();
		[Version (deprecated = true, deprecated_since = "2.38.")]
		public bool get_enable_xss_auditor ();
		public unowned string get_fantasy_font_family ();
		[Version (since = "2.16")]
		public WebKit.HardwareAccelerationPolicy get_hardware_acceleration_policy ();
		public bool get_javascript_can_access_clipboard ();
		public bool get_javascript_can_open_windows_automatically ();
		public bool get_load_icons_ignoring_image_load_setting ();
		[Version (since = "2.30")]
		public unowned string get_media_content_types_requiring_hardware_support ();
		public bool get_media_playback_allows_inline ();
		public bool get_media_playback_requires_user_gesture ();
		public uint32 get_minimum_font_size ();
		public unowned string get_monospace_font_family ();
		public unowned string get_pictograph_font_family ();
		public bool get_print_backgrounds ();
		public unowned string get_sans_serif_font_family ();
		public unowned string get_serif_font_family ();
		public unowned string get_user_agent ();
		public bool get_zoom_text_only ();
		[Version (since = "2.10")]
		public void set_allow_file_access_from_file_urls (bool allowed);
		public void set_allow_modal_dialogs (bool allowed);
		[Version (since = "2.28")]
		public void set_allow_top_navigation_to_data_urls (bool allowed);
		[Version (since = "2.14")]
		public void set_allow_universal_access_from_file_urls (bool allowed);
		public void set_auto_load_images (bool enabled);
		public void set_cursive_font_family (string cursive_font_family);
		public void set_default_charset (string default_charset);
		public void set_default_font_family (string default_font_family);
		public void set_default_font_size (uint32 font_size);
		public void set_default_monospace_font_size (uint32 font_size);
		[Version (since = "2.40")]
		public void set_disable_web_security (bool disabled);
		public void set_draw_compositing_indicators (bool enabled);
		[Version (deprecated = true, deprecated_since = "2.32.", since = "2.2")]
		public void set_enable_accelerated_2d_canvas (bool enabled);
		[Version (since = "2.24")]
		public void set_enable_back_forward_navigation_gestures (bool enabled);
		public void set_enable_caret_browsing (bool enabled);
		public void set_enable_developer_extras (bool enabled);
		public void set_enable_dns_prefetching (bool enabled);
		[Version (since = "2.20")]
		public void set_enable_encrypted_media (bool enabled);
		[Version (deprecated = true, deprecated_since = "2.38")]
		public void set_enable_frame_flattening (bool enabled);
		public void set_enable_fullscreen (bool enabled);
		public void set_enable_html5_database (bool enabled);
		public void set_enable_html5_local_storage (bool enabled);
		public void set_enable_hyperlink_auditing (bool enabled);
		[Version (deprecated = true, deprecated_since = "2.38.")]
		public void set_enable_java (bool enabled);
		public void set_enable_javascript (bool enabled);
		[Version (since = "2.24")]
		public void set_enable_javascript_markup (bool enabled);
		[Version (since = "2.26")]
		public void set_enable_media (bool enabled);
		[Version (since = "2.22")]
		public void set_enable_media_capabilities (bool enabled);
		[Version (since = "2.4")]
		public void set_enable_media_stream (bool enabled);
		[Version (since = "2.4")]
		public void set_enable_mediasource (bool enabled);
		[Version (since = "2.4")]
		public void set_enable_mock_capture_devices (bool enabled);
		public void set_enable_offline_web_application_cache (bool enabled);
		public void set_enable_page_cache (bool enabled);
		[Version (deprecated = true, deprecated_since = "2.32")]
		public void set_enable_plugins (bool enabled);
		[Version (deprecated = true, deprecated_since = "2.16.")]
		public void set_enable_private_browsing (bool enabled);
		public void set_enable_resizable_text_areas (bool enabled);
		public void set_enable_site_specific_quirks (bool enabled);
		public void set_enable_smooth_scrolling (bool enabled);
		[Version (since = "2.2")]
		public void set_enable_spatial_navigation (bool enabled);
		public void set_enable_tabs_to_links (bool enabled);
		public void set_enable_webaudio (bool enabled);
		public void set_enable_webgl (bool enabled);
		[Version (since = "2.38")]
		public void set_enable_webrtc (bool enabled);
		[Version (since = "2.2")]
		public void set_enable_write_console_messages_to_stdout (bool enabled);
		[Version (deprecated = true, deprecated_since = "2.38.")]
		public void set_enable_xss_auditor (bool enabled);
		public void set_fantasy_font_family (string fantasy_font_family);
		[Version (since = "2.16")]
		public void set_hardware_acceleration_policy (WebKit.HardwareAccelerationPolicy policy);
		public void set_javascript_can_access_clipboard (bool enabled);
		public void set_javascript_can_open_windows_automatically (bool enabled);
		public void set_load_icons_ignoring_image_load_setting (bool enabled);
		[Version (since = "2.30")]
		public void set_media_content_types_requiring_hardware_support (string? content_types);
		public void set_media_playback_allows_inline (bool enabled);
		public void set_media_playback_requires_user_gesture (bool enabled);
		public void set_minimum_font_size (uint32 font_size);
		public void set_monospace_font_family (string monospace_font_family);
		public void set_pictograph_font_family (string pictograph_font_family);
		public void set_print_backgrounds (bool print_backgrounds);
		public void set_sans_serif_font_family (string sans_serif_font_family);
		public void set_serif_font_family (string serif_font_family);
		public void set_user_agent (string? user_agent);
		public void set_user_agent_with_application_details (string? application_name, string? application_version);
		public void set_zoom_text_only (bool zoom_text_only);
		[Version (since = "2.10")]
		public bool allow_file_access_from_file_urls { get; set construct; }
		public bool allow_modal_dialogs { get; set construct; }
		[Version (since = "2.28")]
		public bool allow_top_navigation_to_data_urls { get; set construct; }
		[Version (since = "2.14")]
		public bool allow_universal_access_from_file_urls { get; set construct; }
		public bool auto_load_images { get; set construct; }
		public string cursive_font_family { get; set construct; }
		public string default_charset { get; set construct; }
		public string default_font_family { get; set construct; }
		public uint default_font_size { get; set construct; }
		public uint default_monospace_font_size { get; set construct; }
		[Version (since = "2.40")]
		public bool disable_web_security { get; set construct; }
		public bool draw_compositing_indicators { get; set construct; }
		[Version (deprecated = true, deprecated_since = "2.32.", since = "2.2")]
		public bool enable_accelerated_2d_canvas { get; set construct; }
		[Version (since = "2.24")]
		public bool enable_back_forward_navigation_gestures { get; set construct; }
		public bool enable_caret_browsing { get; set construct; }
		public bool enable_developer_extras { get; set construct; }
		public bool enable_dns_prefetching { get; set construct; }
		[Version (since = "2.20")]
		public bool enable_encrypted_media { get; set construct; }
		[Version (deprecated = true, deprecated_since = "2.38")]
		public bool enable_frame_flattening { get; set construct; }
		public bool enable_fullscreen { get; set construct; }
		public bool enable_html5_database { get; set construct; }
		public bool enable_html5_local_storage { get; set construct; }
		public bool enable_hyperlink_auditing { get; set construct; }
		[Version (deprecated = true, deprecated_since = "2.38")]
		public bool enable_java { get; set construct; }
		public bool enable_javascript { get; set construct; }
		[Version (since = "2.24")]
		public bool enable_javascript_markup { get; set construct; }
		[Version (since = "2.26")]
		public bool enable_media { get; set construct; }
		[Version (since = "2.22")]
		public bool enable_media_capabilities { get; set construct; }
		[Version (since = "2.4")]
		public bool enable_media_stream { get; set construct; }
		[Version (since = "2.4")]
		public bool enable_mediasource { get; set construct; }
		[Version (since = "2.24")]
		public bool enable_mock_capture_devices { get; set construct; }
		public bool enable_offline_web_application_cache { get; set construct; }
		public bool enable_page_cache { get; set construct; }
		[Version (deprecated = true, deprecated_since = "2.32")]
		public bool enable_plugins { get; set construct; }
		[Version (deprecated = true, deprecated_since = "2.16.")]
		public bool enable_private_browsing { get; set construct; }
		public bool enable_resizable_text_areas { get; set construct; }
		public bool enable_site_specific_quirks { get; set construct; }
		public bool enable_smooth_scrolling { get; set construct; }
		[Version (since = "2.4")]
		public bool enable_spatial_navigation { get; set construct; }
		public bool enable_tabs_to_links { get; set construct; }
		public bool enable_webaudio { get; set construct; }
		public bool enable_webgl { get; set construct; }
		[Version (since = "2.38")]
		public bool enable_webrtc { get; set construct; }
		[Version (since = "2.2")]
		public bool enable_write_console_messages_to_stdout { get; set construct; }
		[Version (deprecated = true, deprecated_since = "2.38")]
		public bool enable_xss_auditor { get; set construct; }
		public string fantasy_font_family { get; set construct; }
		[Version (since = "2.16")]
		public WebKit.HardwareAccelerationPolicy hardware_acceleration_policy { get; set construct; }
		public bool javascript_can_access_clipboard { get; set construct; }
		public bool javascript_can_open_windows_automatically { get; set construct; }
		public bool load_icons_ignoring_image_load_setting { get; set construct; }
		[Version (since = "2.30")]
		public string media_content_types_requiring_hardware_support { get; set construct; }
		public bool media_playback_allows_inline { get; set construct; }
		public bool media_playback_requires_user_gesture { get; set construct; }
		public uint minimum_font_size { get; set construct; }
		public string monospace_font_family { get; set construct; }
		public string pictograph_font_family { get; set construct; }
		public bool print_backgrounds { get; set construct; }
		public string sans_serif_font_family { get; set construct; }
		public string serif_font_family { get; set construct; }
		public string user_agent { get; set construct; }
		public bool zoom_text_only { get; set construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_uri_request_get_type ()")]
	public class URIRequest : GLib.Object {
		[CCode (has_construct_function = false)]
		public URIRequest (string uri);
		public unowned Soup.MessageHeaders get_http_headers ();
		[Version (since = "2.12")]
		public unowned string get_http_method ();
		public unowned string get_uri ();
		public void set_uri (string uri);
		public string uri { get; set construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_uri_response_get_type ()")]
	public class URIResponse : GLib.Object {
		[CCode (has_construct_function = false)]
		protected URIResponse ();
		public uint64 get_content_length ();
		[Version (since = "2.6")]
		public unowned Soup.MessageHeaders get_http_headers ();
		public unowned string get_mime_type ();
		public uint get_status_code ();
		public unowned string get_suggested_filename ();
		public unowned string get_uri ();
		public uint64 content_length { get; }
		[Version (since = "2.6")]
		public Soup.MessageHeaders http_headers { get; }
		public string mime_type { get; }
		public uint status_code { get; }
		public string suggested_filename { get; }
		public string uri { get; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_uri_scheme_request_get_type ()")]
	public class URISchemeRequest : GLib.Object {
		[CCode (has_construct_function = false)]
		protected URISchemeRequest ();
		public void finish (GLib.InputStream stream, int64 stream_length, string? content_type);
		[Version (since = "2.2")]
		public void finish_error (GLib.Error error);
		[Version (since = "2.36")]
		public void finish_with_response (WebKit.URISchemeResponse response);
		[Version (since = "2.40")]
		public GLib.InputStream get_http_body ();
		[Version (since = "2.36")]
		public unowned Soup.MessageHeaders get_http_headers ();
		[Version (since = "2.36")]
		public unowned string get_http_method ();
		public unowned string get_path ();
		public unowned string get_scheme ();
		public unowned string get_uri ();
		public unowned WebKit.WebView get_web_view ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_uri_scheme_response_get_type ()")]
	public class URISchemeResponse : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "2.36")]
		public URISchemeResponse (GLib.InputStream input_stream, int64 stream_length);
		[Version (since = "2.36")]
		public void set_content_type (string content_type);
		[Version (since = "2.36")]
		public void set_http_headers (owned Soup.MessageHeaders headers);
		[Version (since = "2.36")]
		public void set_status (uint status_code, string? reason_phrase);
		[NoAccessorMethod]
		[Version (since = "2.36")]
		public GLib.InputStream stream { construct; }
		[NoAccessorMethod]
		[Version (since = "2.36")]
		public int64 stream_length { construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_user_content_filter_ref", type_id = "webkit_user_content_filter_get_type ()", unref_function = "webkit_user_content_filter_unref")]
	[Compact]
	[Version (since = "2.24")]
	public class UserContentFilter {
		public unowned string get_identifier ();
		public unowned WebKit.UserContentFilter @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_user_content_filter_store_get_type ()")]
	[Version (since = "2.24")]
	public class UserContentFilterStore : GLib.Object {
		[CCode (has_construct_function = false)]
		public UserContentFilterStore (string storage_path);
		[CCode (array_length = false, array_null_terminated = true)]
		public async string[] fetch_identifiers (GLib.Cancellable? cancellable = null);
		public unowned string get_path ();
		public async WebKit.UserContentFilter load (string identifier, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool remove (string identifier, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async WebKit.UserContentFilter save (string identifier, GLib.Bytes source, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async WebKit.UserContentFilter save_from_file (string identifier, GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public string path { get; construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_user_content_manager_get_type ()")]
	[Version (since = "2.6")]
	public class UserContentManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public UserContentManager ();
		[Version (since = "2.24")]
		public void add_filter (WebKit.UserContentFilter filter);
		public void add_script (WebKit.UserScript script);
		public void add_style_sheet (WebKit.UserStyleSheet stylesheet);
		[Version (since = "2.8")]
		public bool register_script_message_handler (string name);
		[Version (since = "2.22")]
		public bool register_script_message_handler_in_world (string name, string world_name);
		[Version (since = "2.40")]
		public bool register_script_message_handler_with_reply (string name, string world_name);
		[Version (since = "2.24")]
		public void remove_all_filters ();
		public void remove_all_scripts ();
		public void remove_all_style_sheets ();
		public void remove_filter (WebKit.UserContentFilter filter);
		[Version (since = "2.26")]
		public void remove_filter_by_id (string filter_id);
		[Version (since = "2.32")]
		public void remove_script (WebKit.UserScript script);
		[Version (since = "2.32")]
		public void remove_style_sheet (WebKit.UserStyleSheet stylesheet);
		[Version (since = "2.8")]
		public void unregister_script_message_handler (string name);
		[Version (since = "2.22")]
		public void unregister_script_message_handler_in_world (string name, string world_name);
		[Version (since = "2.8")]
		public signal void script_message_received (WebKit.JavascriptResult value);
		[Version (since = "2.40")]
		public signal bool script_message_with_reply_received (JSC.Value value, WebKit.ScriptMessageReply reply);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_user_media_permission_request_get_type ()")]
	[Version (since = "2.8")]
	public class UserMediaPermissionRequest : GLib.Object, WebKit.PermissionRequest {
		[CCode (has_construct_function = false)]
		protected UserMediaPermissionRequest ();
		[NoAccessorMethod]
		public bool is_for_audio_device { get; }
		[NoAccessorMethod]
		public bool is_for_video_device { get; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_user_message_get_type ()")]
	[Version (since = "2.28")]
	public class UserMessage : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public UserMessage (string name, GLib.Variant? parameters);
		public unowned GLib.UnixFDList? get_fd_list ();
		public unowned string get_name ();
		public unowned GLib.Variant? get_parameters ();
		public void send_reply (WebKit.UserMessage reply);
		[CCode (has_construct_function = false)]
		public UserMessage.with_fd_list (string name, GLib.Variant? parameters, GLib.UnixFDList? fd_list);
		public GLib.UnixFDList fd_list { get; construct; }
		public string name { get; construct; }
		public GLib.Variant parameters { get; construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_user_script_ref", type_id = "webkit_user_script_get_type ()", unref_function = "webkit_user_script_unref")]
	[Compact]
	[Version (since = "2.6")]
	public class UserScript {
		[CCode (has_construct_function = false)]
		public UserScript (string source, WebKit.UserContentInjectedFrames injected_frames, WebKit.UserScriptInjectionTime injection_time, [CCode (array_length = false, array_null_terminated = true)] string[]? allow_list, [CCode (array_length = false, array_null_terminated = true)] string[]? block_list);
		[CCode (has_construct_function = false)]
		[Version (since = "2.22")]
		public UserScript.for_world (string source, WebKit.UserContentInjectedFrames injected_frames, WebKit.UserScriptInjectionTime injection_time, string world_name, [CCode (array_length = false, array_null_terminated = true)] string[]? allow_list, [CCode (array_length = false, array_null_terminated = true)] string[]? block_list);
		public unowned WebKit.UserScript @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_user_style_sheet_ref", type_id = "webkit_user_style_sheet_get_type ()", unref_function = "webkit_user_style_sheet_unref")]
	[Compact]
	[Version (since = "2.6")]
	public class UserStyleSheet {
		[CCode (has_construct_function = false)]
		public UserStyleSheet (string source, WebKit.UserContentInjectedFrames injected_frames, WebKit.UserStyleLevel level, [CCode (array_length = false, array_null_terminated = true)] string[]? allow_list, [CCode (array_length = false, array_null_terminated = true)] string[]? block_list);
		[CCode (has_construct_function = false)]
		[Version (since = "2.22")]
		public UserStyleSheet.for_world (string source, WebKit.UserContentInjectedFrames injected_frames, WebKit.UserStyleLevel level, string world_name, [CCode (array_length = false, array_null_terminated = true)] string[]? allow_list, [CCode (array_length = false, array_null_terminated = true)] string[]? block_list);
		public unowned WebKit.UserStyleSheet @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_web_context_get_type ()")]
	public class WebContext : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "2.8")]
		public WebContext ();
		[Version (since = "2.26")]
		public void add_path_to_sandbox (string path, bool read_only);
		[Version (since = "2.6")]
		public void allow_tls_certificate_for_host (GLib.TlsCertificate certificate, string host);
		public void clear_cache ();
		public WebKit.Download download_uri (string uri);
		[CCode (has_construct_function = false)]
		[Version (since = "2.16")]
		public WebContext.ephemeral ();
		public WebKit.CacheModel get_cache_model ();
		public unowned WebKit.CookieManager get_cookie_manager ();
		public static unowned WebKit.WebContext get_default ();
		public unowned WebKit.FaviconDatabase get_favicon_database ();
		public unowned string get_favicon_database_directory ();
		[Version (since = "2.26")]
		public unowned WebKit.GeolocationManager get_geolocation_manager ();
		[Version (deprecated = true, deprecated_since = "2.32")]
		public async GLib.List<WebKit.Plugin> get_plugins (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.4")]
		public WebKit.ProcessModel get_process_model ();
		[Version (since = "2.26")]
		public bool get_sandbox_enabled ();
		public unowned WebKit.SecurityManager get_security_manager ();
		public bool get_spell_checking_enabled ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_spell_checking_languages ();
		[Version (since = "2.38")]
		public unowned string get_time_zone_override ();
		[Version (deprecated = true, deprecated_since = "2.32.")]
		public WebKit.TLSErrorsPolicy get_tls_errors_policy ();
		[Version (since = "2.30")]
		public bool get_use_system_appearance_for_scrollbars ();
		[Version (deprecated = true, deprecated_since = "2.26", since = "2.10")]
		public uint get_web_process_count_limit ();
		[Version (since = "2.10")]
		public unowned WebKit.WebsiteDataManager get_website_data_manager ();
		[CCode (cname = "webkit_web_context_initialize_notification_permissions")]
		[Version (since = "2.16")]
		public void init_notification_permissions (GLib.List<WebKit.SecurityOrigin> allowed_origins, GLib.List<WebKit.SecurityOrigin> disallowed_origins);
		[Version (since = "2.18")]
		public bool is_automation_allowed ();
		[Version (since = "2.16")]
		public bool is_ephemeral ();
		public void prefetch_dns (string hostname);
		public void register_uri_scheme (string scheme, owned WebKit.URISchemeRequestCallback callback);
		[Version (since = "2.28")]
		public void send_message_to_all_extensions (WebKit.UserMessage message);
		[Version (deprecated = true, deprecated_since = "2.32")]
		public void set_additional_plugins_directory (string directory);
		[Version (since = "2.18")]
		public void set_automation_allowed (bool allowed);
		public void set_cache_model (WebKit.CacheModel cache_model);
		[Version (deprecated = true, deprecated_since = "2.10.")]
		public void set_disk_cache_directory (string directory);
		public void set_favicon_database_directory (string? path);
		[Version (deprecated = true, deprecated_since = "2.32.", since = "2.16")]
		public void set_network_proxy_settings (WebKit.NetworkProxyMode proxy_mode, WebKit.NetworkProxySettings? proxy_settings);
		public void set_preferred_languages ([CCode (array_length = false, array_null_terminated = true)] string[]? languages);
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.4")]
		public void set_process_model (WebKit.ProcessModel process_model);
		[Version (since = "2.26")]
		public void set_sandbox_enabled (bool enabled);
		public void set_spell_checking_enabled (bool enabled);
		public void set_spell_checking_languages ([CCode (array_length = false, array_null_terminated = true)] string[] languages);
		[Version (deprecated = true, deprecated_since = "2.32.")]
		public void set_tls_errors_policy (WebKit.TLSErrorsPolicy policy);
		[Version (since = "2.30")]
		public void set_use_system_appearance_for_scrollbars (bool enabled);
		public void set_web_extensions_directory (string directory);
		[Version (since = "2.4")]
		public void set_web_extensions_initialization_user_data (GLib.Variant user_data);
		[Version (deprecated = true, deprecated_since = "2.26", since = "2.10")]
		public void set_web_process_count_limit (uint limit);
		[CCode (has_construct_function = false)]
		[Version (since = "2.10")]
		public WebContext.with_website_data_manager (WebKit.WebsiteDataManager manager);
		[NoAccessorMethod]
		[Version (deprecated = true, deprecated_since = "2.10.", since = "2.8")]
		public string local_storage_directory { owned get; construct; }
		[NoAccessorMethod]
		[Version (since = "2.34")]
		public WebKit.MemoryPressureSettings memory_pressure_settings { construct; }
		[NoAccessorMethod]
		[Version (since = "2.28")]
		public bool process_swap_on_cross_site_navigation_enabled { get; construct; }
		[Version (since = "2.38")]
		public string time_zone_override { get; construct; }
		[Version (since = "2.30")]
		public bool use_system_appearance_for_scrollbars { get; set construct; }
		[Version (since = "2.10")]
		public WebKit.WebsiteDataManager website_data_manager { get; construct; }
		[Version (since = "2.18")]
		public virtual signal void automation_started (WebKit.AutomationSession session);
		public virtual signal void download_started (WebKit.Download download);
		[Version (since = "2.16")]
		public virtual signal void initialize_notification_permissions ();
		[Version (since = "2.4")]
		public virtual signal void initialize_web_extensions ();
		[Version (since = "2.28")]
		public virtual signal bool user_message_received (WebKit.UserMessage message);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_web_inspector_get_type ()")]
	public class WebInspector : GLib.Object {
		[CCode (has_construct_function = false)]
		protected WebInspector ();
		public void close ();
		public uint get_attached_height ();
		[Version (since = "2.8")]
		public bool get_can_attach ();
		public unowned string get_inspected_uri ();
		public unowned WebKit.WebViewBase get_web_view ();
		public bool is_attached ();
		public void show ();
		public uint attached_height { get; }
		[Version (since = "2.8")]
		public bool can_attach { get; }
		public string inspected_uri { get; }
		[HasEmitter]
		public signal bool attach ();
		public signal bool bring_to_front ();
		public signal void closed ();
		[HasEmitter]
		public signal bool detach ();
		public signal bool open_window ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_web_resource_get_type ()")]
	public class WebResource : GLib.Object {
		[CCode (has_construct_function = false)]
		protected WebResource ();
		public async uint8[] get_data (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned WebKit.URIResponse get_response ();
		public unowned string get_uri ();
		public WebKit.URIResponse response { get; }
		public string uri { get; }
		public signal void failed (GLib.Error error);
		[Version (since = "2.8")]
		public signal void failed_with_tls_errors (GLib.TlsCertificate certificate, GLib.TlsCertificateFlags errors);
		public signal void finished ();
		[Version (deprecated = true, deprecated_since = "2.40")]
		public signal void received_data (uint64 data_length);
		public signal void sent_request (WebKit.URIRequest request, WebKit.URIResponse redirected_response);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_web_view_get_type ()")]
	public class WebView : WebKit.WebViewBase, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public WebView ();
		[Version (since = "2.40")]
		public async JSC.Value call_async_javascript_function (string body, ssize_t length, GLib.Variant? arguments, string? world_name, string? source_uri, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool can_execute_editing_command (string command, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public bool can_go_back ();
		public bool can_go_forward ();
		public bool can_show_mime_type (string mime_type);
		public WebKit.Download download_uri (string uri);
		[Version (since = "2.40")]
		public async JSC.Value evaluate_javascript (string script, ssize_t length, string? world_name, string? source_uri, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void execute_editing_command (string command);
		[Version (since = "2.10")]
		public void execute_editing_command_with_argument (string command, string argument);
		[Version (since = "2.28")]
		public WebKit.AutomationBrowsingContextPresentation get_automation_presentation_type ();
		public unowned WebKit.BackForwardList get_back_forward_list ();
		[Version (since = "2.8")]
		public Gdk.RGBA get_background_color ();
		[Version (since = "2.34")]
		public WebKit.MediaCaptureState get_camera_capture_state ();
		public unowned WebKit.WebContext get_context ();
		public unowned string get_custom_charset ();
		[Version (since = "2.38")]
		public unowned string? get_default_content_security_policy ();
		[Version (since = "2.34")]
		public WebKit.MediaCaptureState get_display_capture_state ();
		[Version (since = "2.10")]
		public unowned WebKit.EditorState get_editor_state ();
		public double get_estimated_load_progress ();
		public unowned Cairo.Surface get_favicon ();
		public unowned WebKit.FindController get_find_controller ();
		[Version (since = "2.28")]
		public unowned WebKit.InputMethodContext? get_input_method_context ();
		public unowned WebKit.WebInspector get_inspector ();
		[Version (since = "2.30")]
		public bool get_is_muted ();
		[Version (since = "2.34")]
		public bool get_is_web_process_responsive ();
		[Version (deprecated = true, deprecated_since = "2.22")]
		public unowned JS.GlobalContext get_javascript_global_context ();
		public unowned WebKit.WebResource get_main_resource ();
		[Version (since = "2.34")]
		public WebKit.MediaCaptureState get_microphone_capture_state ();
		public uint64 get_page_id ();
		[Version (since = "2.12")]
		public WebKit.WebViewSessionState get_session_state ();
		public unowned WebKit.Settings get_settings ();
		public async Cairo.Surface get_snapshot (WebKit.SnapshotRegion region, WebKit.SnapshotOptions options, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned string get_title ();
		public bool get_tls_info (out unowned GLib.TlsCertificate certificate, out GLib.TlsCertificateFlags errors);
		public unowned string get_uri ();
		[Version (since = "2.6")]
		public unowned WebKit.UserContentManager get_user_content_manager ();
		[Version (since = "2.38")]
		public WebKit.WebExtensionMode get_web_extension_mode ();
		[Version (since = "2.16")]
		public unowned WebKit.WebsiteDataManager get_website_data_manager ();
		[Version (since = "2.30")]
		public unowned WebKit.WebsitePolicies get_website_policies ();
		public unowned WebKit.WindowProperties get_window_properties ();
		public double get_zoom_level ();
		public void go_back ();
		public void go_forward ();
		public void go_to_back_forward_list_item (WebKit.BackForwardListItem list_item);
		[Version (since = "2.8")]
		public bool is_editable ();
		public void load_alternate_html (string content, string content_uri, string? base_uri);
		[Version (since = "2.6")]
		public void load_bytes (GLib.Bytes bytes, string? mime_type, string? encoding, string? base_uri);
		public void load_html (string content, string? base_uri);
		public void load_plain_text (string plain_text);
		public void load_request (WebKit.URIRequest request);
		public void load_uri (string uri);
		public void reload ();
		public void reload_bypass_cache ();
		[Version (since = "2.12")]
		public void restore_session_state (WebKit.WebViewSessionState state);
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.38")]
		public async void run_async_javascript_function_in_world (string body, GLib.Variant arguments, string world_name, GLib.Cancellable? cancellable = null);
		[Version (deprecated = true, deprecated_since = "2.40")]
		public async WebKit.JavascriptResult run_javascript (string script, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "2.40")]
		public async WebKit.JavascriptResult run_javascript_from_gresource (string resource, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.22")]
		public async WebKit.JavascriptResult run_javascript_in_world (string script, string world_name, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async GLib.InputStream save (WebKit.SaveMode save_mode, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool save_to_file (GLib.File file, WebKit.SaveMode save_mode, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.28")]
		public async WebKit.UserMessage send_message_to_page (WebKit.UserMessage message, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.8")]
		public void set_background_color (Gdk.RGBA rgba);
		[Version (since = "2.34")]
		public void set_camera_capture_state (WebKit.MediaCaptureState state);
		[Version (since = "2.34")]
		public void set_cors_allowlist ([CCode (array_length = false, array_null_terminated = true)] string[]? allowlist);
		public void set_custom_charset (string? charset);
		[Version (since = "2.34")]
		public void set_display_capture_state (WebKit.MediaCaptureState state);
		[Version (since = "2.8")]
		public void set_editable (bool editable);
		[Version (since = "2.28")]
		public void set_input_method_context (WebKit.InputMethodContext? context);
		[Version (since = "2.30")]
		public void set_is_muted (bool muted);
		[Version (since = "2.34")]
		public void set_microphone_capture_state (WebKit.MediaCaptureState state);
		public void set_settings (WebKit.Settings settings);
		public void set_zoom_level (double zoom_level);
		[NoWrapper]
		public virtual bool show_option_menu (WebKit.OptionMenu menu, Gdk.Event event, Gdk.Rectangle rectangle);
		public void stop_loading ();
		[Version (since = "2.34")]
		public void terminate_web_process ();
		[Version (since = "2.12")]
		public void try_close ();
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public WebView.with_context (WebKit.WebContext context);
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "2.4")]
		public WebView.with_related_view (WebKit.WebView web_view);
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "2.6")]
		public WebView.with_settings (WebKit.Settings settings);
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "2.6")]
		public WebView.with_user_content_manager (WebKit.UserContentManager user_content_manager);
		[Version (since = "2.28")]
		public WebKit.AutomationBrowsingContextPresentation automation_presentation_type { get; construct; }
		[Version (since = "2.34")]
		public WebKit.MediaCaptureState camera_capture_state { get; set; }
		[Version (since = "2.38")]
		public string default_content_security_policy { get; construct; }
		[Version (since = "2.34")]
		public WebKit.MediaCaptureState display_capture_state { get; set; }
		[NoAccessorMethod]
		[Version (since = "2.8")]
		public bool editable { get; set; }
		public double estimated_load_progress { get; }
		public void* favicon { get; }
		[NoAccessorMethod]
		[Version (since = "2.18")]
		public bool is_controlled_by_automation { get; construct; }
		[NoAccessorMethod]
		[Version (since = "2.16")]
		public bool is_ephemeral { get; construct; }
		[NoAccessorMethod]
		public bool is_loading { get; }
		[Version (since = "2.30")]
		public bool is_muted { get; set; }
		[NoAccessorMethod]
		[Version (since = "2.8")]
		public bool is_playing_audio { get; }
		[Version (since = "2.34")]
		public bool is_web_process_responsive { get; }
		[Version (since = "2.34")]
		public WebKit.MediaCaptureState microphone_capture_state { get; set; }
		[Version (since = "2.28")]
		public uint64 page_id { get; }
		[NoAccessorMethod]
		[Version (since = "2.4")]
		public WebKit.WebView related_view { construct; }
		[Version (since = "2.6")]
		public WebKit.Settings settings { set construct; }
		public string title { get; }
		public string uri { get; }
		[Version (since = "2.6")]
		public WebKit.UserContentManager user_content_manager { get; construct; }
		[NoAccessorMethod]
		public WebKit.WebContext web_context { owned get; construct; }
		[Version (since = "2.38")]
		public WebKit.WebExtensionMode web_extension_mode { get; construct; }
		[Version (since = "2.30")]
		public WebKit.WebsitePolicies website_policies { get; construct; }
		public double zoom_level { get; set; }
		[Version (since = "2.2")]
		public virtual signal bool authenticate (WebKit.AuthenticationRequest request);
		public virtual signal void close ();
		public virtual signal bool context_menu (WebKit.ContextMenu context_menu, Gdk.Event event, WebKit.HitTestResult hit_test_result);
		public virtual signal void context_menu_dismissed ();
		public signal Gtk.Widget create (WebKit.NavigationAction navigation_action);
		public virtual signal bool decide_policy (WebKit.PolicyDecision decision, WebKit.PolicyDecisionType type);
		public virtual signal bool enter_fullscreen ();
		public virtual signal void insecure_content_detected (WebKit.InsecureContentEvent event);
		public virtual signal bool leave_fullscreen ();
		public virtual signal void load_changed (WebKit.LoadEvent load_event);
		public virtual signal bool load_failed (WebKit.LoadEvent load_event, string failing_uri, GLib.Error error);
		[Version (since = "2.6")]
		public virtual signal bool load_failed_with_tls_errors (string failing_uri, GLib.TlsCertificate certificate, GLib.TlsCertificateFlags errors);
		public virtual signal void mouse_target_changed (WebKit.HitTestResult hit_test_result, uint modifiers);
		[CCode (cname = "show-option-menu")]
		[Version (since = "2.18")]
		public signal bool on_show_option_menu (WebKit.OptionMenu menu, Gdk.Event event, Gdk.Rectangle rectangle);
		public virtual signal bool permission_request (WebKit.PermissionRequest permission_request);
		public virtual signal bool print (WebKit.PrintOperation print_operation);
		[Version (since = "2.40")]
		public virtual signal bool query_permission_state (WebKit.PermissionStateQuery query);
		public virtual signal void ready_to_show ();
		public virtual signal void resource_load_started (WebKit.WebResource resource, WebKit.URIRequest request);
		public virtual signal void run_as_modal ();
		[Version (since = "2.8")]
		public virtual signal bool run_color_chooser (WebKit.ColorChooserRequest request);
		public virtual signal bool run_file_chooser (WebKit.FileChooserRequest request);
		public virtual signal bool script_dialog (WebKit.ScriptDialog dialog);
		[Version (since = "2.8")]
		public virtual signal bool show_notification (WebKit.Notification notification);
		public virtual signal void submit_form (WebKit.FormSubmissionRequest request);
		[Version (since = "2.28")]
		public virtual signal bool user_message_received (WebKit.UserMessage message);
		[Version (deprecated = true, deprecated_since = "2.20")]
		public virtual signal bool web_process_crashed ();
		[Version (since = "2.20")]
		public virtual signal void web_process_terminated (WebKit.WebProcessTerminationReason reason);
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_web_view_base_get_type ()")]
	public class WebViewBase : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected WebViewBase ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_web_view_session_state_ref", type_id = "webkit_web_view_session_state_get_type ()", unref_function = "webkit_web_view_session_state_unref")]
	[Compact]
	[Version (since = "2.12")]
	public class WebViewSessionState {
		[CCode (has_construct_function = false)]
		public WebViewSessionState (GLib.Bytes data);
		public unowned WebKit.WebViewSessionState @ref ();
		public GLib.Bytes serialize ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", ref_function = "webkit_website_data_ref", type_id = "webkit_website_data_get_type ()", unref_function = "webkit_website_data_unref")]
	[Compact]
	[Version (since = "2.16")]
	public class WebsiteData {
		public unowned string get_name ();
		public uint64 get_size (WebKit.WebsiteDataTypes types);
		public WebKit.WebsiteDataTypes get_types ();
		public unowned WebKit.WebsiteData @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_website_data_access_permission_request_get_type ()")]
	[Version (since = "2.30")]
	public class WebsiteDataAccessPermissionRequest : GLib.Object, WebKit.PermissionRequest {
		[CCode (has_construct_function = false)]
		protected WebsiteDataAccessPermissionRequest ();
		public unowned string get_current_domain ();
		public unowned string get_requesting_domain ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_website_data_manager_get_type ()")]
	[Version (since = "2.10")]
	public class WebsiteDataManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected WebsiteDataManager ();
		[Version (since = "2.16")]
		public async bool clear (WebKit.WebsiteDataTypes types, GLib.TimeSpan timespan, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[CCode (has_construct_function = false)]
		[Version (since = "2.16")]
		public WebsiteDataManager.ephemeral ();
		[Version (since = "2.16")]
		public async GLib.List<WebKit.WebsiteData> fetch (WebKit.WebsiteDataTypes types, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned string? get_base_cache_directory ();
		public unowned string? get_base_data_directory ();
		[Version (since = "2.16")]
		public unowned WebKit.CookieManager get_cookie_manager ();
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.10")]
		public unowned string? get_disk_cache_directory ();
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.30")]
		public unowned string? get_dom_cache_directory ();
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.26")]
		public unowned string? get_hsts_cache_directory ();
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.10")]
		public unowned string? get_indexeddb_directory ();
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.30")]
		public unowned string? get_itp_directory ();
		[Version (since = "2.30")]
		public bool get_itp_enabled ();
		[Version (since = "2.30")]
		public async GLib.List<WebKit.ITPThirdParty> get_itp_summary (GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.10")]
		public unowned string? get_local_storage_directory ();
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.10")]
		public unowned string? get_offline_application_cache_directory ();
		[Version (since = "2.30")]
		public bool get_persistent_credential_storage_enabled ();
		[Version (deprecated = true, deprecated_since = "2.40", since = "2.30")]
		public unowned string? get_service_worker_registrations_directory ();
		[Version (since = "2.32")]
		public WebKit.TLSErrorsPolicy get_tls_errors_policy ();
		[Version (deprecated = true, deprecated_since = "2.24.", since = "2.10")]
		public unowned string? get_websql_directory ();
		[Version (since = "2.16")]
		public async bool remove (WebKit.WebsiteDataTypes types, GLib.List<WebKit.WebsiteData> website_data, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "2.30")]
		public void set_itp_enabled (bool enabled);
		[Version (since = "2.34")]
		public static void set_memory_pressure_settings (WebKit.MemoryPressureSettings settings);
		[Version (since = "2.32")]
		public void set_network_proxy_settings (WebKit.NetworkProxyMode proxy_mode, WebKit.NetworkProxySettings? proxy_settings);
		[Version (since = "2.30")]
		public void set_persistent_credential_storage_enabled (bool enabled);
		[Version (since = "2.32")]
		public void set_tls_errors_policy (WebKit.TLSErrorsPolicy policy);
		public string base_cache_directory { get; construct; }
		public string base_data_directory { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40.", since = "2.10")]
		public string disk_cache_directory { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40.", since = "2.30")]
		public string dom_cache_directory { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40.", since = "2.26")]
		public string hsts_cache_directory { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40.", since = "2.10")]
		public string indexeddb_directory { get; construct; }
		[NoAccessorMethod]
		[Version (since = "2.16")]
		public bool is_ephemeral { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40.", since = "2.30")]
		public string itp_directory { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40.", since = "2.10")]
		public string local_storage_directory { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40.", since = "2.10")]
		public string offline_application_cache_directory { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.40.", since = "2.30")]
		public string service_worker_registrations_directory { get; construct; }
		[Version (deprecated = true, deprecated_since = "2.24.", since = "2.10")]
		public string websql_directory { get; construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_website_policies_get_type ()")]
	[Version (since = "2.30")]
	public class WebsitePolicies : GLib.Object {
		[CCode (has_construct_function = false)]
		public WebsitePolicies ();
		public WebKit.AutoplayPolicy get_autoplay_policy ();
		[NoAccessorMethod]
		public WebKit.AutoplayPolicy autoplay { get; construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_window_properties_get_type ()")]
	public class WindowProperties : GLib.Object {
		[CCode (has_construct_function = false)]
		protected WindowProperties ();
		public bool get_fullscreen ();
		public Gdk.Rectangle get_geometry ();
		public bool get_locationbar_visible ();
		public bool get_menubar_visible ();
		public bool get_resizable ();
		public bool get_scrollbars_visible ();
		public bool get_statusbar_visible ();
		public bool get_toolbar_visible ();
		public bool fullscreen { get; construct; }
		public Gdk.Rectangle geometry { get; construct; }
		public bool locationbar_visible { get; construct; }
		public bool menubar_visible { get; construct; }
		public bool resizable { get; construct; }
		public bool scrollbars_visible { get; construct; }
		public bool statusbar_visible { get; construct; }
		public bool toolbar_visible { get; construct; }
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", type_id = "webkit_permission_request_get_type ()")]
	public interface PermissionRequest : GLib.Object {
		public abstract void allow ();
		public abstract void deny ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_AUTHENTICATION_SCHEME_", type_id = "webkit_authentication_scheme_get_type ()")]
	[Version (since = "2.2")]
	public enum AuthenticationScheme {
		DEFAULT,
		HTTP_BASIC,
		HTTP_DIGEST,
		HTML_FORM,
		NTLM,
		NEGOTIATE,
		CLIENT_CERTIFICATE_REQUESTED,
		SERVER_TRUST_EVALUATION_REQUESTED,
		CLIENT_CERTIFICATE_PIN_REQUESTED,
		UNKNOWN
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_", type_id = "webkit_automation_browsing_context_presentation_get_type ()")]
	[Version (since = "2.28")]
	public enum AutomationBrowsingContextPresentation {
		WINDOW,
		TAB
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_AUTOPLAY_", type_id = "webkit_autoplay_policy_get_type ()")]
	[Version (since = "2.30")]
	public enum AutoplayPolicy {
		ALLOW,
		ALLOW_WITHOUT_SOUND,
		DENY
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_CACHE_MODEL_", type_id = "webkit_cache_model_get_type ()")]
	public enum CacheModel {
		DOCUMENT_VIEWER,
		WEB_BROWSER,
		DOCUMENT_BROWSER
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_CONTEXT_MENU_ACTION_", type_id = "webkit_context_menu_action_get_type ()")]
	public enum ContextMenuAction {
		NO_ACTION,
		OPEN_LINK,
		OPEN_LINK_IN_NEW_WINDOW,
		DOWNLOAD_LINK_TO_DISK,
		COPY_LINK_TO_CLIPBOARD,
		OPEN_IMAGE_IN_NEW_WINDOW,
		DOWNLOAD_IMAGE_TO_DISK,
		COPY_IMAGE_TO_CLIPBOARD,
		COPY_IMAGE_URL_TO_CLIPBOARD,
		OPEN_FRAME_IN_NEW_WINDOW,
		GO_BACK,
		GO_FORWARD,
		STOP,
		RELOAD,
		COPY,
		CUT,
		PASTE,
		DELETE,
		SELECT_ALL,
		INPUT_METHODS,
		UNICODE,
		SPELLING_GUESS,
		NO_GUESSES_FOUND,
		IGNORE_SPELLING,
		LEARN_SPELLING,
		IGNORE_GRAMMAR,
		FONT_MENU,
		BOLD,
		ITALIC,
		UNDERLINE,
		OUTLINE,
		INSPECT_ELEMENT,
		OPEN_VIDEO_IN_NEW_WINDOW,
		OPEN_AUDIO_IN_NEW_WINDOW,
		COPY_VIDEO_LINK_TO_CLIPBOARD,
		COPY_AUDIO_LINK_TO_CLIPBOARD,
		TOGGLE_MEDIA_CONTROLS,
		TOGGLE_MEDIA_LOOP,
		ENTER_VIDEO_FULLSCREEN,
		MEDIA_PLAY,
		MEDIA_PAUSE,
		MEDIA_MUTE,
		DOWNLOAD_VIDEO_TO_DISK,
		DOWNLOAD_AUDIO_TO_DISK,
		INSERT_EMOJI,
		PASTE_AS_PLAIN_TEXT,
		CUSTOM
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_COOKIE_POLICY_ACCEPT_", type_id = "webkit_cookie_accept_policy_get_type ()")]
	public enum CookieAcceptPolicy {
		ALWAYS,
		NEVER,
		NO_THIRD_PARTY
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_COOKIE_PERSISTENT_STORAGE_", type_id = "webkit_cookie_persistent_storage_get_type ()")]
	public enum CookiePersistentStorage {
		TEXT,
		SQLITE
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_CREDENTIAL_PERSISTENCE_", type_id = "webkit_credential_persistence_get_type ()")]
	[Version (since = "2.2")]
	public enum CredentialPersistence {
		NONE,
		FOR_SESSION,
		PERMANENT
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_EDITOR_TYPING_ATTRIBUTE_", type_id = "webkit_editor_typing_attributes_get_type ()")]
	[Flags]
	[Version (since = "2.10")]
	public enum EditorTypingAttributes {
		NONE,
		BOLD,
		ITALIC,
		UNDERLINE,
		STRIKETHROUGH
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_FIND_OPTIONS_", type_id = "webkit_find_options_get_type ()")]
	[Flags]
	public enum FindOptions {
		NONE,
		CASE_INSENSITIVE,
		AT_WORD_STARTS,
		TREAT_MEDIAL_CAPITAL_AS_WORD_START,
		BACKWARDS,
		WRAP_AROUND
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_HARDWARE_ACCELERATION_POLICY_", type_id = "webkit_hardware_acceleration_policy_get_type ()")]
	[Version (since = "2.16")]
	public enum HardwareAccelerationPolicy {
		ON_DEMAND,
		ALWAYS,
		NEVER
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_HIT_TEST_RESULT_CONTEXT_", type_id = "webkit_hit_test_result_context_get_type ()")]
	[Flags]
	public enum HitTestResultContext {
		DOCUMENT,
		LINK,
		IMAGE,
		MEDIA,
		EDITABLE,
		SCROLLBAR,
		SELECTION
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_INPUT_HINT_", type_id = "webkit_input_hints_get_type ()")]
	[Flags]
	[Version (since = "2.28")]
	public enum InputHints {
		NONE,
		SPELLCHECK,
		LOWERCASE,
		UPPERCASE_CHARS,
		UPPERCASE_WORDS,
		UPPERCASE_SENTENCES,
		INHIBIT_OSK
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_INPUT_PURPOSE_", type_id = "webkit_input_purpose_get_type ()")]
	[Version (since = "2.28")]
	public enum InputPurpose {
		FREE_FORM,
		DIGITS,
		NUMBER,
		PHONE,
		URL,
		EMAIL,
		PASSWORD
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_INSECURE_CONTENT_", type_id = "webkit_insecure_content_event_get_type ()")]
	public enum InsecureContentEvent {
		RUN,
		DISPLAYED
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_LOAD_", type_id = "webkit_load_event_get_type ()")]
	public enum LoadEvent {
		STARTED,
		REDIRECTED,
		COMMITTED,
		FINISHED
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_MEDIA_CAPTURE_STATE_", type_id = "webkit_media_capture_state_get_type ()")]
	[Version (since = "2.34")]
	public enum MediaCaptureState {
		NONE,
		ACTIVE,
		MUTED
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_NAVIGATION_TYPE_", type_id = "webkit_navigation_type_get_type ()")]
	public enum NavigationType {
		LINK_CLICKED,
		FORM_SUBMITTED,
		BACK_FORWARD,
		RELOAD,
		FORM_RESUBMITTED,
		OTHER
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_NETWORK_PROXY_MODE_", type_id = "webkit_network_proxy_mode_get_type ()")]
	[Version (since = "2.16")]
	public enum NetworkProxyMode {
		DEFAULT,
		NO_PROXY,
		CUSTOM
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_PERMISSION_STATE_", type_id = "webkit_permission_state_get_type ()")]
	[Version (since = "2.40")]
	public enum PermissionState {
		GRANTED,
		DENIED,
		PROMPT
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_POLICY_DECISION_TYPE_", type_id = "webkit_policy_decision_type_get_type ()")]
	public enum PolicyDecisionType {
		NAVIGATION_ACTION,
		NEW_WINDOW_ACTION,
		RESPONSE
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_PRINT_OPERATION_RESPONSE_", type_id = "webkit_print_operation_response_get_type ()")]
	public enum PrintOperationResponse {
		PRINT,
		CANCEL
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_PROCESS_MODEL_", type_id = "webkit_process_model_get_type ()")]
	[Version (deprecated = true, deprecated_since = "2.40", since = "2.4")]
	public enum ProcessModel {
		SHARED_SECONDARY_PROCESS,
		MULTIPLE_SECONDARY_PROCESSES
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_SAVE_MODE_", type_id = "webkit_save_mode_get_type ()")]
	public enum SaveMode {
		MHTML
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_SCRIPT_DIALOG_", type_id = "webkit_script_dialog_type_get_type ()")]
	public enum ScriptDialogType {
		ALERT,
		CONFIRM,
		PROMPT,
		BEFORE_UNLOAD_CONFIRM
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_SNAPSHOT_OPTIONS_", type_id = "webkit_snapshot_options_get_type ()")]
	[Flags]
	public enum SnapshotOptions {
		NONE,
		INCLUDE_SELECTION_HIGHLIGHTING,
		TRANSPARENT_BACKGROUND
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_SNAPSHOT_REGION_", type_id = "webkit_snapshot_region_get_type ()")]
	public enum SnapshotRegion {
		VISIBLE,
		FULL_DOCUMENT
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_TLS_ERRORS_POLICY_", type_id = "webkit_tls_errors_policy_get_type ()")]
	public enum TLSErrorsPolicy {
		IGNORE,
		FAIL
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_USER_CONTENT_INJECT_", type_id = "webkit_user_content_injected_frames_get_type ()")]
	[Version (since = "2.6")]
	public enum UserContentInjectedFrames {
		ALL_FRAMES,
		TOP_FRAME
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_", type_id = "webkit_user_script_injection_time_get_type ()")]
	[Version (since = "2.6")]
	public enum UserScriptInjectionTime {
		START,
		END
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_USER_STYLE_LEVEL_", type_id = "webkit_user_style_level_get_type ()")]
	[Version (since = "2.6")]
	public enum UserStyleLevel {
		USER,
		AUTHOR
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_WEB_EXTENSION_MODE_", type_id = "webkit_web_extension_mode_get_type ()")]
	[Version (since = "2.38")]
	public enum WebExtensionMode {
		NONE,
		MANIFESTV2,
		MANIFESTV3
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_WEB_PROCESS_", type_id = "webkit_web_process_termination_reason_get_type ()")]
	[Version (since = "2.20")]
	public enum WebProcessTerminationReason {
		CRASHED,
		EXCEEDED_MEMORY_LIMIT,
		TERMINATED_BY_API
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_WEBSITE_DATA_", type_id = "webkit_website_data_types_get_type ()")]
	[Flags]
	[Version (since = "2.16")]
	public enum WebsiteDataTypes {
		MEMORY_CACHE,
		DISK_CACHE,
		OFFLINE_APPLICATION_CACHE,
		SESSION_STORAGE,
		LOCAL_STORAGE,
		WEBSQL_DATABASES,
		INDEXEDDB_DATABASES,
		PLUGIN_DATA,
		COOKIES,
		DEVICE_ID_HASH_SALT,
		HSTS_CACHE,
		ITP,
		SERVICE_WORKER_REGISTRATIONS,
		DOM_CACHE,
		ALL
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_DOWNLOAD_ERROR_", type_id = "webkit_download_error_get_type ()")]
	public errordomain DownloadError {
		NETWORK,
		CANCELLED_BY_USER,
		DESTINATION;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_FAVICON_DATABASE_ERROR_", type_id = "webkit_favicon_database_error_get_type ()")]
	public errordomain FaviconDatabaseError {
		NOT_INITIALIZED,
		FAVICON_NOT_FOUND,
		FAVICON_UNKNOWN;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_JAVASCRIPT_ERROR_", type_id = "webkit_javascript_error_get_type ()")]
	public errordomain JavascriptError {
		[CCode (cname = "WEBKIT_JAVASCRIPT_ERROR_SCRIPT_FAILED")]
		FAILED,
		SCRIPT_FAILED,
		INVALID_PARAMETER,
		INVALID_RESULT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_NETWORK_ERROR_", type_id = "webkit_network_error_get_type ()")]
	public errordomain NetworkError {
		FAILED,
		TRANSPORT,
		UNKNOWN_PROTOCOL,
		CANCELLED,
		FILE_DOES_NOT_EXIST;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_PLUGIN_ERROR_", type_id = "webkit_plugin_error_get_type ()")]
	public errordomain PluginError {
		FAILED,
		CANNOT_FIND_PLUGIN,
		CANNOT_LOAD_PLUGIN,
		JAVA_UNAVAILABLE,
		CONNECTION_CANCELLED,
		WILL_HANDLE_LOAD;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_POLICY_ERROR_", type_id = "webkit_policy_error_get_type ()")]
	public errordomain PolicyError {
		FAILED,
		CANNOT_SHOW_MIME_TYPE,
		CANNOT_SHOW_URI,
		FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE,
		CANNOT_USE_RESTRICTED_PORT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_PRINT_ERROR_", type_id = "webkit_print_error_get_type ()")]
	public errordomain PrintError {
		GENERAL,
		PRINTER_NOT_FOUND,
		INVALID_PAGE_RANGE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_SNAPSHOT_ERROR_FAILED_TO_", type_id = "webkit_snapshot_error_get_type ()")]
	public errordomain SnapshotError {
		CREATE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_USER_CONTENT_FILTER_ERROR_", type_id = "webkit_user_content_filter_error_get_type ()")]
	[Version (since = "2.24")]
	public errordomain UserContentFilterError {
		INVALID_SOURCE,
		NOT_FOUND;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", cprefix = "WEBKIT_USER_MESSAGE_UNHANDLED_", type_id = "webkit_user_message_error_get_type ()")]
	[Version (since = "2.28")]
	public errordomain UserMessageError {
		MESSAGE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "webkit2/webkit2.h", instance_pos = 1.9)]
	public delegate void URISchemeRequestCallback (WebKit.URISchemeRequest request);
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_COPY")]
	public const string EDITING_COMMAND_COPY;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_CREATE_LINK")]
	[Version (since = "2.10")]
	public const string EDITING_COMMAND_CREATE_LINK;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_CUT")]
	public const string EDITING_COMMAND_CUT;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_INSERT_IMAGE")]
	[Version (since = "2.10")]
	public const string EDITING_COMMAND_INSERT_IMAGE;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_PASTE")]
	public const string EDITING_COMMAND_PASTE;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_PASTE_AS_PLAIN_TEXT")]
	[Version (since = "2.30")]
	public const string EDITING_COMMAND_PASTE_AS_PLAIN_TEXT;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_REDO")]
	public const string EDITING_COMMAND_REDO;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_SELECT_ALL")]
	public const string EDITING_COMMAND_SELECT_ALL;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_EDITING_COMMAND_UNDO")]
	public const string EDITING_COMMAND_UNDO;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "webkit2/webkit2.h", cname = "WEBKIT_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "DownloadError.quark")]
	public static GLib.Quark download_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "FaviconDatabaseError.quark")]
	public static GLib.Quark favicon_database_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	public static uint get_major_version ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	public static uint get_micro_version ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	public static uint get_minor_version ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "JavascriptError.quark")]
	public static GLib.Quark javascript_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (since = "2.32")]
	public static unowned string media_key_system_permission_get_name (WebKit.MediaKeySystemPermissionRequest request);
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "NetworkError.quark")]
	public static GLib.Quark network_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "PluginError.quark")]
	public static GLib.Quark plugin_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "PolicyError.quark")]
	public static GLib.Quark policy_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "PrintError.quark")]
	public static GLib.Quark print_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "SnapshotError.quark")]
	public static GLib.Quark snapshot_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (since = "2.24")]
	public static string? uri_for_display (string uri);
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "UserContentFilterError.quark")]
	public static GLib.Quark user_content_filter_error_quark ();
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (since = "2.8")]
	public static bool user_media_permission_is_for_audio_device (WebKit.UserMediaPermissionRequest request);
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (since = "2.34")]
	public static bool user_media_permission_is_for_display_device (WebKit.UserMediaPermissionRequest request);
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (since = "2.8")]
	public static bool user_media_permission_is_for_video_device (WebKit.UserMediaPermissionRequest request);
	[CCode (cheader_filename = "webkit2/webkit2.h")]
	[Version (replacement = "UserMessageError.quark")]
	public static GLib.Quark user_message_error_quark ();
}
