/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import vncviewer.CConn;
import vncviewer.VNCViewer;

public class F8Menu
extends PopupMenu
implements ActionListener {
    CConn cc;
    MenuItem exit;
    MenuItem clipboard;
    MenuItem f8;
    MenuItem ctrlAltDel;
    MenuItem refresh;
    MenuItem newConn;
    MenuItem options;
    MenuItem info;
    MenuItem about;
    MenuItem dismiss;

    public F8Menu(CConn cc_) {
        super("VNC Menu");
        this.cc = cc_;
        this.exit = this.addMenuItem("Exit viewer");
        this.addSeparator();
        this.clipboard = this.addMenuItem("Clipboard...");
        this.addSeparator();
        this.f8 = this.addMenuItem("Send F8");
        this.ctrlAltDel = this.addMenuItem("Send Ctrl-Alt-Del");
        this.addSeparator();
        this.refresh = this.addMenuItem("Refresh screen");
        this.addSeparator();
        this.newConn = this.addMenuItem("New connection...");
        this.options = this.addMenuItem("Options...");
        this.info = this.addMenuItem("Connection info...");
        this.about = this.addMenuItem("About VNCviewer...");
        this.addSeparator();
        this.dismiss = this.addMenuItem("Dismiss menu");
    }

    MenuItem addMenuItem(String str) {
        MenuItem item = new MenuItem(str);
        item.addActionListener(this);
        this.add(item);
        return item;
    }

    boolean actionMatch(ActionEvent ev, MenuItem item) {
        return ev.getActionCommand().equals(item.getActionCommand());
    }

    public void actionPerformed(ActionEvent ev) {
        if (this.actionMatch(ev, this.exit)) {
            this.cc.close();
        } else if (this.actionMatch(ev, this.clipboard)) {
            this.cc.clipboardDialog.showDialog();
        } else if (this.actionMatch(ev, this.f8)) {
            this.cc.writeKeyEvent(65477, true);
            this.cc.writeKeyEvent(65477, false);
        } else if (this.actionMatch(ev, this.ctrlAltDel)) {
            this.cc.writeKeyEvent(65507, true);
            this.cc.writeKeyEvent(65513, true);
            this.cc.writeKeyEvent(65535, true);
            this.cc.writeKeyEvent(65535, false);
            this.cc.writeKeyEvent(65513, false);
            this.cc.writeKeyEvent(65507, false);
        } else if (this.actionMatch(ev, this.refresh)) {
            this.cc.refresh();
        } else if (this.actionMatch(ev, this.newConn)) {
            VNCViewer.newViewer(this.cc.viewer);
        } else if (this.actionMatch(ev, this.options)) {
            this.cc.options.showDialog();
        } else if (this.actionMatch(ev, this.info)) {
            this.cc.showInfo();
        } else if (this.actionMatch(ev, this.about)) {
            this.cc.about.showDialog();
        } else {
            this.actionMatch(ev, this.dismiss);
        }
    }
}

