/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Enumeration;
import java.util.Vector;
import vrpn.TrackerRemote;
import vrpn.VRPNDevice;

public class TrackerRemote
extends VRPNDevice
implements Runnable {
    protected Vector changeListeners = new Vector();
    protected Vector velocityListeners = new Vector();
    protected Vector accelerationListeners = new Vector();
    protected static final Object notifyingChangeListenersLock = new Object();
    protected static final Object notifyingVelocityListenersLock = new Object();
    protected static final Object notifyingAccelerationListenersLock = new Object();

    public TrackerRemote(String string, String string2, String string3, String string4, String string5) throws InstantiationException {
        super(string, string2, string3, string4, string5);
    }

    public synchronized native int setUpdateRate(double var1);

    public synchronized void addPositionChangeListener(PositionChangeListener positionChangeListener) {
        this.changeListeners.addElement(positionChangeListener);
    }

    public synchronized boolean removePositionChangeListener(PositionChangeListener positionChangeListener) {
        return this.changeListeners.removeElement(positionChangeListener);
    }

    public synchronized void addVelocityChangeListener(VelocityChangeListener velocityChangeListener) {
        this.velocityListeners.addElement(velocityChangeListener);
    }

    public synchronized boolean removeVelocityChangeListener(VelocityChangeListener velocityChangeListener) {
        return this.velocityListeners.removeElement(velocityChangeListener);
    }

    public synchronized void addAccelerationChangeListener(AccelerationChangeListener accelerationChangeListener) {
        this.accelerationListeners.addElement(accelerationChangeListener);
    }

    public synchronized boolean removeAccelerationChangeListener(AccelerationChangeListener accelerationChangeListener) {
        return this.accelerationListeners.removeElement(accelerationChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stoppedRunning() {
        this.changeListeners.removeAllElements();
        this.velocityListeners.removeAllElements();
        this.accelerationListeners.removeAllElements();
        Object object = downInVrpnLock;
        synchronized (object) {
            this.shutdownTracker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTrackerChange(long l, long l2, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Object object = notifyingChangeListenersLock;
        synchronized (object) {
            TrackerUpdate trackerUpdate = new TrackerUpdate(this);
            trackerUpdate.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            trackerUpdate.sensor = n;
            trackerUpdate.pos[0] = d;
            trackerUpdate.pos[1] = d2;
            trackerUpdate.pos[2] = d3;
            trackerUpdate.quat[0] = d4;
            trackerUpdate.quat[1] = d5;
            trackerUpdate.quat[2] = d6;
            trackerUpdate.quat[3] = d7;
            Enumeration enumeration = this.changeListeners.elements();
            while (enumeration.hasMoreElements()) {
                PositionChangeListener positionChangeListener = (PositionChangeListener)enumeration.nextElement();
                positionChangeListener.trackerPositionUpdate(trackerUpdate, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleVelocityChange(long l, long l2, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        Object object = notifyingVelocityListenersLock;
        synchronized (object) {
            VelocityUpdate velocityUpdate = new VelocityUpdate(this);
            velocityUpdate.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            velocityUpdate.sensor = n;
            velocityUpdate.vel[0] = d;
            velocityUpdate.vel[1] = d2;
            velocityUpdate.vel[2] = d3;
            velocityUpdate.vel_quat[0] = d4;
            velocityUpdate.vel_quat[1] = d5;
            velocityUpdate.vel_quat[2] = d6;
            velocityUpdate.vel_quat[3] = d7;
            velocityUpdate.vel_quat_dt = d8;
            Enumeration enumeration = this.velocityListeners.elements();
            while (enumeration.hasMoreElements()) {
                VelocityChangeListener velocityChangeListener = (VelocityChangeListener)enumeration.nextElement();
                velocityChangeListener.trackerVelocityUpdate(velocityUpdate, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAccelerationChange(long l, long l2, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        Object object = notifyingAccelerationListenersLock;
        synchronized (object) {
            AccelerationUpdate accelerationUpdate = new AccelerationUpdate(this);
            accelerationUpdate.msg_time.setTime(l * 1000L + (long)((int)((double)l2 / 1000.0)));
            accelerationUpdate.sensor = n;
            accelerationUpdate.acc[0] = d;
            accelerationUpdate.acc[1] = d2;
            accelerationUpdate.acc[2] = d3;
            accelerationUpdate.acc_quat[0] = d4;
            accelerationUpdate.acc_quat[1] = d5;
            accelerationUpdate.acc_quat[2] = d6;
            accelerationUpdate.acc_quat[3] = d7;
            accelerationUpdate.acc_quat_dt = d8;
            Enumeration enumeration = this.accelerationListeners.elements();
            while (enumeration.hasMoreElements()) {
                AccelerationChangeListener accelerationChangeListener = (AccelerationChangeListener)enumeration.nextElement();
                accelerationChangeListener.trackerAccelerationUpdate(accelerationUpdate, this);
            }
        }
    }

    protected native void shutdownTracker();

    protected native void mainloop();

    protected native boolean init(String var1, String var2, String var3, String var4, String var5);
}

