/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-config.h.in                                                 *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : (X)MedCon template configuration header (configure)      *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id$
 */

/*
   Copyright (C) 1997-2020 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef __M_CONFIG_H__
#define __M_CONFIG_H__

/* Define some version variables */
#define XMEDCON_MAJOR    "0"
#define XMEDCON_MINOR    "16"
#define XMEDCON_MICRO    "3"
#define XMEDCON_PRGR     "(X)MedCon"
#define XMEDCON_DATE     "28-nov-2020"
#define XMEDCON_VERSION  "0.16.3"
#define XMEDCON_LIBVERS  "(X)MedCon 0.16.3 by Erik Nolf"

/* Define if format enabled */
#define MDC_INCLUDE_ACR   1
#define MDC_INCLUDE_GIF   1
#define MDC_INCLUDE_INW   1
#define MDC_INCLUDE_ANLZ  1
#define MDC_INCLUDE_CONC  1
#define MDC_INCLUDE_ECAT  1
#define MDC_INCLUDE_INTF  1
#define MDC_INCLUDE_DICM  1
#define MDC_INCLUDE_PNG   1
#define MDC_INCLUDE_NIFTI 1
#define MDC_INCLUDE_TPC   1    /* TPC ecat7 write */

/* Define decompression program */
#define MDC_DECOMPRESS  "gunzip"

/* Define GLIB related stuff */
#define GLIBSUPPORTED 1

/* Define XMedCon related stuff */
#define GTKSUPPORTED 1
#if GTKSUPPORTED
#  define XMDCHELP "http://xmedcon.sourceforge.net"
#  ifdef _WIN32
#    define XMDCLUT  "C:\\Program Files\\XMedCon\\etc\\"
#    define XMDCRC   "C:\\Program Files\\XMedCon\\etc\\xmedconrc"
#  else
#    define XMDCLUT  "/opt/local/etc/"
#    define XMDCRC   "/opt/local/etc/xmedconrc"
#  endif
#endif

#endif

