/*
 * Decompiled with CFR 0.152.
 */
package org.znerd.xmlenc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.znerd.xmlenc.InvalidXMLException;
import org.znerd.xmlenc.XMLChecker;

public class XMLEncoder {
    private static final char[] DECLARATION_START = "<?xml version=\"1.0\" encoding=\"".toCharArray();
    private static final int DECLARATION_START_LENGTH = DECLARATION_START.length;
    private static final char[] DECLARATION_END = "\"?>".toCharArray();
    private static final int DECLARATION_END_LENGTH = DECLARATION_END.length;
    private static final char[] ESC_GREATER_THAN = new char[]{'&', 'g', 't', ';'};
    private static final char[] ESC_LESS_THAN = new char[]{'&', 'l', 't', ';'};
    private static final char[] ESC_AMPERSAND = new char[]{'&', 'a', 'm', 'p', ';'};
    private static final char[] ESC_APOSTROPHE = new char[]{'&', 'a', 'p', 'o', 's', ';'};
    private static final char[] ESC_QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    private static final char[] AMPERSAND_HASH = new char[]{'&', '#'};
    private static final char[] EQUALS_APOSTROPHE = new char[]{'=', '\''};
    private static final char[] EQUALS_QUOTE = new char[]{'=', '\"'};
    private final String _encoding;
    private final char[] _encodingCharArray;
    private final boolean _sevenBitEncoding;

    public static final XMLEncoder getEncoder(String encoding) throws IllegalArgumentException, UnsupportedEncodingException {
        return new XMLEncoder(encoding);
    }

    public XMLEncoder(String encoding) throws IllegalArgumentException, UnsupportedEncodingException {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        String ucEncoding = encoding.toUpperCase();
        if (ucEncoding.equals("UTF-8") || ucEncoding.equals("UTF-16")) {
            this._sevenBitEncoding = false;
        } else if (ucEncoding.equals("US-ASCII") || ucEncoding.equals("ASCII") || ucEncoding.startsWith("ISO-8859-")) {
            this._sevenBitEncoding = true;
        } else {
            throw new UnsupportedEncodingException(encoding);
        }
        this._encoding = encoding;
        this._encodingCharArray = encoding.toCharArray();
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void declaration(Writer out) throws NullPointerException, IOException {
        out.write(DECLARATION_START, 0, DECLARATION_START_LENGTH);
        out.write(this._encodingCharArray);
        out.write(DECLARATION_END, 0, DECLARATION_END_LENGTH);
    }

    public void text(Writer out, String text, boolean escapeAmpersands) throws NullPointerException, InvalidXMLException, IOException {
        this.text(out, text.toCharArray(), 0, text.length(), escapeAmpersands);
    }

    public void text(Writer out, char[] ch, int start, int length, boolean escapeAmpersands) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        int end = start + length;
        int lastEscaped = start;
        for (int i = start; i < end; ++i) {
            char c = ch[i];
            if (c >= '?' && c <= '\u007f' || c >= '\'' && c <= ';' || c >= ' ' && c <= '%' || c == '&' && !escapeAmpersands || c > '\u007f' && !this._sevenBitEncoding || c == '\n' || c == '\r' || c == '=' || c == '\t') continue;
            out.write(ch, lastEscaped, i - lastEscaped);
            if (c == '<') {
                out.write(ESC_LESS_THAN, 0, 4);
            } else if (c == '>') {
                out.write(ESC_GREATER_THAN, 0, 4);
            } else if (c == '&') {
                out.write(ESC_AMPERSAND, 0, 5);
            } else if (c > '\u007f') {
                out.write(AMPERSAND_HASH, 0, 2);
                out.write(Integer.toString(c));
                out.write(59);
            } else {
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
            lastEscaped = i + 1;
        }
        out.write(ch, lastEscaped, end - lastEscaped);
    }

    public void text(Writer out, char c) throws InvalidXMLException, IOException {
        if (c >= '?' && c <= '\u007f' || c >= '\'' && c <= ';' || c >= ' ' && c <= '%' || c == '&' || c > '\u007f' && !this._sevenBitEncoding || c == '\n' || c == '\r' || c == '=' || c == '\t') {
            out.write(c);
        } else if (c == '<') {
            out.write(ESC_LESS_THAN, 0, 4);
        } else if (c == '>') {
            out.write(ESC_GREATER_THAN, 0, 4);
        } else if (c > '\u007f') {
            out.write(AMPERSAND_HASH, 0, 2);
            out.write(Integer.toString(c));
            out.write(59);
        } else {
            throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
        }
    }

    public void text(Writer out, char c, boolean escapeAmpersands) throws InvalidXMLException, IOException {
        if (c >= '?' && c <= '\u007f' || c >= '\'' && c <= ';' || c >= ' ' && c <= '%' || c == '&' && escapeAmpersands || c > '\u007f' && !this._sevenBitEncoding || c == '\n' || c == '\r' || c == '=' || c == '\t') {
            out.write(c);
        } else if (c == '<') {
            out.write(ESC_LESS_THAN, 0, 4);
        } else if (c == '>') {
            out.write(ESC_GREATER_THAN, 0, 4);
        } else if (c == '&') {
            out.write(ESC_AMPERSAND, 0, 5);
        } else if (c > '\u007f') {
            out.write(AMPERSAND_HASH, 0, 2);
            out.write(Integer.toString(c));
            out.write(59);
        } else {
            throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
        }
    }

    public void whitespace(Writer out, String s) throws NullPointerException, InvalidXMLException, IOException {
        char[] ch = s.toCharArray();
        int length = ch.length;
        this.whitespace(out, ch, 0, length);
    }

    public void whitespace(Writer out, char[] ch, int start, int length) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        XMLChecker.checkS(ch, start, length);
        out.write(ch, start, length);
    }

    public void attribute(Writer out, String name, String value, char quotationMark, boolean escapeAmpersands) throws NullPointerException, IOException {
        boolean useQuote;
        char[] ch = value.toCharArray();
        int length = ch.length;
        int start = 0;
        int end = start + length;
        int lastEscaped = 0;
        if (quotationMark == '\"') {
            useQuote = true;
        } else if (quotationMark == '\'') {
            useQuote = false;
        } else {
            String error = "Character 0x" + Integer.toHexString(quotationMark) + " ('" + quotationMark + "') is not a valid quotation mark.";
            throw new IllegalArgumentException(error);
        }
        out.write(32);
        out.write(name);
        if (useQuote) {
            out.write(EQUALS_QUOTE, 0, 2);
        } else {
            out.write(EQUALS_APOSTROPHE, 0, 2);
        }
        for (int i = start; i < end; ++i) {
            char c = ch[i];
            if (c >= '?' && c <= '\u007f' || c >= '(' && c <= ';' || c >= ' ' && c <= '%' && c != '\"' || c == '&' && !escapeAmpersands || c > '\u007f' && !this._sevenBitEncoding || !useQuote && c == '\"' || useQuote && c == '\'' || c == '\n' || c == '\r' || c == '=' || c == '\t') continue;
            out.write(ch, lastEscaped, i - lastEscaped);
            if (c == '<') {
                out.write(ESC_LESS_THAN, 0, 4);
            } else if (c == '>') {
                out.write(ESC_GREATER_THAN, 0, 4);
            } else if (c == '\"') {
                out.write(ESC_QUOTE, 0, 6);
            } else if (c == '\'') {
                out.write(ESC_APOSTROPHE, 0, 6);
            } else if (c == '&') {
                out.write(ESC_AMPERSAND, 0, 5);
            } else if (c > '\u007f') {
                out.write(AMPERSAND_HASH, 0, 2);
                out.write(Integer.toString(c));
                out.write(59);
            } else {
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid.");
            }
            lastEscaped = i + 1;
        }
        out.write(ch, lastEscaped, length - lastEscaped);
        out.write(quotationMark);
    }
}

