/*
 * Decompiled with CFR 0.152.
 */
package org.znerd.xmlenc;

import org.znerd.xmlenc.InvalidXMLException;

public final class XMLChecker {
    public static final void checkS(String s) throws NullPointerException {
        XMLChecker.checkS(s.toCharArray(), 0, s.length());
    }

    public static final void checkS(char[] ch, int start, int length) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException {
        for (int i = start; i < length; ++i) {
            char c = ch[i];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid for the 'S' production (white space).");
        }
    }

    public static final boolean isName(String s) throws NullPointerException {
        try {
            XMLChecker.checkName(s);
            return true;
        }
        catch (InvalidXMLException exception) {
            return false;
        }
    }

    public static final void checkName(String s) throws NullPointerException, InvalidXMLException {
        XMLChecker.checkName(s.toCharArray(), 0, s.length());
    }

    public static final void checkName(char[] ch, int start, int length) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException {
        if (length < 1) {
            throw new InvalidXMLException("An empty string does not match the 'Name' production.");
        }
        int i = start;
        char c = ch[i];
        if (c != '_' && c != ':' && !XMLChecker.isLetter(c)) {
            throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is invalid as a starting character in the 'Name' production.");
        }
        ++i;
        while (i < length) {
            c = ch[i];
            if (!XMLChecker.isNameChar(c)) {
                throw new InvalidXMLException("The character 0x" + Integer.toHexString(c) + " is not valid for the 'Name' production.");
            }
            ++i;
        }
    }

    public static final boolean isSystemLiteral(String s) throws NullPointerException {
        try {
            XMLChecker.checkSystemLiteral(s);
            return true;
        }
        catch (InvalidXMLException exception) {
            return false;
        }
    }

    public static final void checkSystemLiteral(String s) throws NullPointerException, InvalidXMLException {
        XMLChecker.checkSystemLiteral(s.toCharArray(), 0, s.length());
    }

    public static final void checkSystemLiteral(char[] ch, int start, int length) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException {
        String otherAllowedChars;
        if (length < 3) {
            throw new InvalidXMLException("Minimum length for the 'SystemLiteral' production is 3 characters.");
        }
        int lastIndex = start + length - 1;
        char firstChar = ch[0];
        char lastChar = ch[lastIndex];
        if (firstChar == '\'') {
            if (lastChar != '\'') {
                throw new InvalidXMLException("First character is '\\'', but the last character is 0x" + Integer.toHexString(lastChar) + '.');
            }
            otherAllowedChars = "-()+,./:=?;!*#@$_%";
        } else if (firstChar == '\"') {
            if (lastChar != '\"') {
                throw new InvalidXMLException("First character is '\"', but the last character is 0x" + Integer.toHexString(lastChar) + '.');
            }
            otherAllowedChars = "-'()+,./:=?;!*#@$_%";
        } else {
            throw new InvalidXMLException("First char must either be '\\'' or '\"' instead of 0x" + Integer.toHexString(firstChar) + '.');
        }
        for (int i = 1; i < length - 1; ++i) {
            char c = ch[i];
            if (c != firstChar) continue;
            if (firstChar == '\'') {
                throw new InvalidXMLException("Found '\\'' at position " + i + '.');
            }
            throw new InvalidXMLException("Found '\"' at position " + i + '.');
        }
    }

    public static final boolean isPubidLiteral(String s) throws NullPointerException {
        try {
            XMLChecker.checkPubidLiteral(s);
            return true;
        }
        catch (InvalidXMLException exception) {
            return false;
        }
    }

    public static final void checkPubidLiteral(String s) throws NullPointerException, InvalidXMLException {
        XMLChecker.checkPubidLiteral(s.toCharArray(), 0, s.length());
    }

    public static final void checkPubidLiteral(char[] ch, int start, int length) throws NullPointerException, IndexOutOfBoundsException, InvalidXMLException {
        String otherAllowedChars;
        if (length < 3) {
            throw new InvalidXMLException("Minimum length for the 'PubidLiteral' production is 3 characters.");
        }
        int lastIndex = start + length - 1;
        char firstChar = ch[0];
        char lastChar = ch[lastIndex];
        if (firstChar == '\'') {
            if (lastChar != '\'') {
                throw new InvalidXMLException("First character is '\\'', but the last character is 0x" + Integer.toHexString(lastChar) + '.');
            }
            otherAllowedChars = "-()+,./:=?;!*#@$_%";
        } else if (firstChar == '\"') {
            if (lastChar != '\"') {
                throw new InvalidXMLException("First character is '\"', but the last character is 0x" + Integer.toHexString(lastChar) + '.');
            }
            otherAllowedChars = "-'()+,./:=?;!*#@$_%";
        } else {
            throw new InvalidXMLException("First char must either be '\\'' or '\"' instead of 0x" + Integer.toHexString(firstChar) + '.');
        }
        for (int i = 1; i < length - 1; ++i) {
            char c = ch[i];
            if (c == ' ' || c == '\r' || c == '\n' || XMLChecker.isLetter(c) || XMLChecker.isDigit(c) || otherAllowedChars.indexOf(c) >= 0) continue;
            throw new InvalidXMLException("The character '" + c + "' (0x" + Integer.toHexString(c) + ") is not valid for the 'PubidLiteral' production.");
        }
    }

    private static final boolean isNameChar(char c) {
        return c == '.' || c == '-' || c == '_' || c == ':' || XMLChecker.isDigit(c) || XMLChecker.isLetter(c) || XMLChecker.isCombiningChar(c) || XMLChecker.isExtender(c);
    }

    private static final boolean isLetter(char c) {
        return XMLChecker.isBaseChar(c) || XMLChecker.isIdeographic(c);
    }

    private static final boolean isBaseChar(char c) {
        char n = c;
        return n >= 'A' && n <= 'Z' || n >= 'a' && n <= 'z' || n >= '\u00c0' && n <= '\u00d6' || n >= '\u00d8' && n <= '\u00f6' || n >= '\u00f8' && n <= '\u00ff' || n >= '\u0100' && n <= '\u0131' || n >= '\u0134' && n <= '\u013e' || n >= '\u0141' && n <= '\u0148' || n >= '\u014a' && n <= '\u017e' || n >= '\u0180' && n <= '\u01c3' || n >= '\u01cd' && n <= '\u01f0' || n >= '\u01f4' && n <= '\u01f5' || n >= '\u01fa' && n <= '\u0217' || n >= '\u0250' && n <= '\u02a8' || n >= '\u02bb' && n <= '\u02c1' || n == '\u0386' || n >= '\u0388' && n <= '\u038a' || n == '\u038c' || n >= '\u038e' && n <= '\u03a1' || n >= '\u03a3' && n <= '\u03ce' || n >= '\u03d0' && n <= '\u03d6' || n == '\u03da' || n == '\u03dc' || n == '\u03de' || n == '\u03e0' || n >= '\u03e2' && n <= '\u03f3' || n >= '\u0401' && n <= '\u040c' || n >= '\u040e' && n <= '\u044f' || n >= '\u0451' && n <= '\u045c' || n >= '\u045e' && n <= '\u0481' || n >= '\u0490' && n <= '\u04c4' || n >= '\u04c7' && n <= '\u04c8' || n >= '\u04cb' && n <= '\u04cc' || n >= '\u04d0' && n <= '\u04eb' || n >= '\u04ee' && n <= '\u04f5' || n >= '\u04f8' && n <= '\u04f9' || n >= '\u0531' && n <= '\u0556' || n == '\u0559' || n >= '\u0561' && n <= '\u0586' || n >= '\u05d0' && n <= '\u05ea' || n >= '\u05f0' && n <= '\u05f2' || n >= '\u0621' && n <= '\u063a' || n >= '\u0641' && n <= '\u064a' || n >= '\u0671' && n <= '\u06b7' || n >= '\u06ba' && n <= '\u06be' || n >= '\u06c0' && n <= '\u06ce' || n >= '\u06d0' && n <= '\u06d3' || n == '\u06d5' || n >= '\u06e5' && n <= '\u06e6' || n >= '\u0905' && n <= '\u0939' || n == '\u093d' || n >= '\u0958' && n <= '\u0961' || n >= '\u0985' && n <= '\u098c' || n >= '\u098f' && n <= '\u0990' || n >= '\u0993' && n <= '\u09a8' || n >= '\u09aa' && n <= '\u09b0' || n == '\u09b2' || n >= '\u09b6' && n <= '\u09b9' || n >= '\u09dc' && n <= '\u09dd' || n >= '\u09df' && n <= '\u09e1' || n >= '\u09f0' && n <= '\u09f1' || n >= '\u0a05' && n <= '\u0a0a' || n >= '\u0a0f' && n <= '\u0a10' || n >= '\u0a13' && n <= '\u0a28' || n >= '\u0a2a' && n <= '\u0a30' || n >= '\u0a32' && n <= '\u0a33' || n >= '\u0a35' && n <= '\u0a36' || n >= '\u0a38' && n <= '\u0a39' || n >= '\u0a59' && n <= '\u0a5c' || n == '\u0a5e' || n >= '\u0a72' && n <= '\u0a74' || n >= '\u0a85' && n <= '\u0a8b' || n == '\u0a8d' || n >= '\u0a8f' && n <= '\u0a91' || n >= '\u0a93' && n <= '\u0aa8' || n >= '\u0aaa' && n <= '\u0ab0' || n >= '\u0ab2' && n <= '\u0ab3' || n >= '\u0ab5' && n <= '\u0ab9' || n == '\u0abd' || n == '\u0ae0' || n >= '\u0b05' && n <= '\u0b0c' || n >= '\u0b0f' && n <= '\u0b10' || n >= '\u0b13' && n <= '\u0b28' || n >= '\u0b2a' && n <= '\u0b30' || n >= '\u0b32' && n <= '\u0b33' || n >= '\u0b36' && n <= '\u0b39' || n == '\u0b3d' || n >= '\u0b5c' && n <= '\u0b5d' || n >= '\u0b5f' && n <= '\u0b61' || n >= '\u0b85' && n <= '\u0b8a' || n >= '\u0b8e' && n <= '\u0b90' || n >= '\u0b92' && n <= '\u0b95' || n >= '\u0b99' && n <= '\u0b9a' || n == '\u0b9c' || n >= '\u0b9e' && n <= '\u0b9f' || n >= '\u0ba3' && n <= '\u0ba4' || n >= '\u0ba8' && n <= '\u0baa' || n >= '\u0bae' && n <= '\u0bb5' || n >= '\u0bb7' && n <= '\u0bb9' || n >= '\u0c05' && n <= '\u0c0c' || n >= '\u0c0e' && n <= '\u0c10' || n >= '\u0c12' && n <= '\u0c28' || n >= '\u0c2a' && n <= '\u0c33' || n >= '\u0c35' && n <= '\u0c39' || n >= '\u0c60' && n <= '\u0c61' || n >= '\u0c85' && n <= '\u0c8c' || n >= '\u0c8e' && n <= '\u0c90' || n >= '\u0c92' && n <= '\u0ca8' || n >= '\u0caa' && n <= '\u0cb3' || n >= '\u0cb5' && n <= '\u0cb9' || n == '\u0cde' || n >= '\u0ce0' && n <= '\u0ce1' || n >= '\u0d05' && n <= '\u0d0c' || n >= '\u0d0e' && n <= '\u0d10' || n >= '\u0d12' && n <= '\u0d28' || n >= '\u0d2a' && n <= '\u0d39' || n >= '\u0d60' && n <= '\u0d61' || n >= '\u0e01' && n <= '\u0e2e' || n == '\u0e30' || n >= '\u0e32' && n <= '\u0e33' || n >= '\u0e40' && n <= '\u0e45' || n >= '\u0e81' && n <= '\u0e82' || n == '\u0e84' || n >= '\u0e87' && n <= '\u0e88' || n == '\u0e8a' || n == '\u0e8d' || n >= '\u0e94' && n <= '\u0e97' || n >= '\u0e99' && n <= '\u0e9f' || n >= '\u0ea1' && n <= '\u0ea3' || n == '\u0ea5' || n == '\u0ea7' || n >= '\u0eaa' && n <= '\u0eab' || n >= '\u0ead' && n <= '\u0eae' || n == '\u0eb0' || n >= '\u0eb2' && n <= '\u0eb3' || n == '\u0ebd' || n >= '\u0ec0' && n <= '\u0ec4' || n >= '\u0f40' && n <= '\u0f47' || n >= '\u0f49' && n <= '\u0f69' || n >= '\u10a0' && n <= '\u10c5' || n >= '\u10d0' && n <= '\u10f6' || n == '\u1100' || n >= '\u1102' && n <= '\u1103' || n >= '\u1105' && n <= '\u1107' || n == '\u1109' || n >= '\u110b' && n <= '\u110c' || n >= '\u110e' && n <= '\u1112' || n == '\u113c' || n == '\u113e' || n == '\u1140' || n == '\u114c' || n == '\u114e' || n == '\u1150' || n >= '\u1154' && n <= '\u1155' || n == '\u1159' || n >= '\u115f' && n <= '\u1161' || n == '\u1163' || n == '\u1165' || n == '\u1167' || n == '\u1169' || n >= '\u116d' && n <= '\u116e' || n >= '\u1172' && n <= '\u1173' || n == '\u1175' || n == '\u119e' || n == '\u11a8' || n == '\u11ab' || n >= '\u11ae' && n <= '\u11af' || n >= '\u11b7' && n <= '\u11b8' || n == '\u11ba' || n >= '\u11bc' && n <= '\u11c2' || n == '\u11eb' || n == '\u11f0' || n == '\u11f9' || n >= '\u1e00' && n <= '\u1e9b' || n >= '\u1ea0' && n <= '\u1ef9' || n >= '\u1f00' && n <= '\u1f15' || n >= '\u1f18' && n <= '\u1f1d' || n >= '\u1f20' && n <= '\u1f45' || n >= '\u1f48' && n <= '\u1f4d' || n >= '\u1f50' && n <= '\u1f57' || n == '\u1f59' || n == '\u1f5b' || n == '\u1f5d' || n >= '\u1f5f' && n <= '\u1f7d' || n >= '\u1f80' && n <= '\u1fb4' || n >= '\u1fb6' && n <= '\u1fbc' || n == '\u1fbe' || n >= '\u1fc2' && n <= '\u1fc4' || n >= '\u1fc6' && n <= '\u1fcc' || n >= '\u1fd0' && n <= '\u1fd3' || n >= '\u1fd6' && n <= '\u1fdb' || n >= '\u1fe0' && n <= '\u1fec' || n >= '\u1ff2' && n <= '\u1ff4' || n >= '\u1ff6' && n <= '\u1ffc' || n == '\u2126' || n >= '\u212a' && n <= '\u212b' || n == '\u212e' || n >= '\u2180' && n <= '\u2182' || n >= '\u3041' && n <= '\u3094' || n >= '\u30a1' && n <= '\u30fa' || n >= '\u3105' && n <= '\u312c' || n >= '\uac00' && n <= '\ud7a3';
    }

    private static final boolean isIdeographic(char c) {
        char n = c;
        return n >= '\u4e00' && n <= '\u9fa5' || n == '\u3007' || n >= '\u3021' && n <= '\u3029';
    }

    private static final boolean isCombiningChar(char c) {
        char n = c;
        return n >= '\u0300' && n <= '\u0345' || n >= '\u0360' && n <= '\u0361' || n >= '\u0483' && n <= '\u0486' || n >= '\u0591' && n <= '\u05a1' || n >= '\u05a3' && n <= '\u05b9' || n >= '\u05bb' && n <= '\u05bd' || n == '\u05bf' || n >= '\u05c1' && n <= '\u05c2' || n == '\u05c4' || n >= '\u064b' && n <= '\u0652' || n == '\u0670' || n >= '\u06d6' && n <= '\u06dc' || n >= '\u06dd' && n <= '\u06df' || n >= '\u06e0' && n <= '\u06e4' || n >= '\u06e7' && n <= '\u06e8' || n >= '\u06ea' && n <= '\u06ed' || n >= '\u0901' && n <= '\u0903' || n == '\u093c' || n >= '\u093e' && n <= '\u094c' || n == '\u094d' || n >= '\u0951' && n <= '\u0954' || n >= '\u0962' && n <= '\u0963' || n >= '\u0981' && n <= '\u0983' || n == '\u09bc' || n == '\u09be' || n == '\u09bf' || n >= '\u09c0' && n <= '\u09c4' || n >= '\u09c7' && n <= '\u09c8' || n >= '\u09cb' && n <= '\u09cd' || n == '\u09d7' || n >= '\u09e2' && n <= '\u09e3' || n == '\u0a02' || n == '\u0a3c' || n == '\u0a3e' || n == '\u0a3f' || n >= '\u0a40' && n <= '\u0a42' || n >= '\u0a47' && n <= '\u0a48' || n >= '\u0a4b' && n <= '\u0a4d' || n >= '\u0a70' && n <= '\u0a71' || n >= '\u0a81' && n <= '\u0a83' || n == '\u0abc' || n >= '\u0abe' && n <= '\u0ac5' || n >= '\u0ac7' && n <= '\u0ac9' || n >= '\u0acb' && n <= '\u0acd' || n >= '\u0b01' && n <= '\u0b03' || n == '\u0b3c' || n >= '\u0b3e' && n <= '\u0b43' || n >= '\u0b47' && n <= '\u0b48' || n >= '\u0b4b' && n <= '\u0b4d' || n >= '\u0b56' && n <= '\u0b57' || n >= '\u0b82' && n <= '\u0b83' || n >= '\u0bbe' && n <= '\u0bc2' || n >= '\u0bc6' && n <= '\u0bc8' || n >= '\u0bca' && n <= '\u0bcd' || n == '\u0bd7' || n >= '\u0c01' && n <= '\u0c03' || n >= '\u0c3e' && n <= '\u0c44' || n >= '\u0c46' && n <= '\u0c48' || n >= '\u0c4a' && n <= '\u0c4d' || n >= '\u0c55' && n <= '\u0c56' || n >= '\u0c82' && n <= '\u0c83' || n >= '\u0cbe' && n <= '\u0cc4' || n >= '\u0cc6' && n <= '\u0cc8' || n >= '\u0cca' && n <= '\u0ccd' || n >= '\u0cd5' && n <= '\u0cd6' || n >= '\u0d02' && n <= '\u0d03' || n >= '\u0d3e' && n <= '\u0d43' || n >= '\u0d46' && n <= '\u0d48' || n >= '\u0d4a' && n <= '\u0d4d' || n == '\u0d57' || n == '\u0e31' || n >= '\u0e34' && n <= '\u0e3a' || n >= '\u0e47' && n <= '\u0e4e' || n == '\u0eb1' || n >= '\u0eb4' && n <= '\u0eb9' || n >= '\u0ebb' && n <= '\u0ebc' || n >= '\u0ec8' && n <= '\u0ecd' || n >= '\u0f18' && n <= '\u0f19' || n == '\u0f35' || n == '\u0f37' || n == '\u0f39' || n == '\u0f3e' || n == '\u0f3f' || n >= '\u0f71' && n <= '\u0f84' || n >= '\u0f86' && n <= '\u0f8b' || n >= '\u0f90' && n <= '\u0f95' || n == '\u0f97' || n >= '\u0f99' && n <= '\u0fad' || n >= '\u0fb1' && n <= '\u0fb7' || n == '\u0fb9' || n >= '\u20d0' && n <= '\u20dc' || n == '\u20e1' || n >= '\u302a' && n <= '\u302f' || n == '\u3099' || n == '\u309a';
    }

    private static final boolean isDigit(char c) {
        char n = c;
        return n >= '0' && n <= '9' || n >= '\u0660' && n <= '\u0669' || n >= '\u06f0' && n <= '\u06f9' || n >= '\u0966' && n <= '\u096f' || n >= '\u09e6' && n <= '\u09ef' || n >= '\u0a66' && n <= '\u0a6f' || n >= '\u0ae6' && n <= '\u0aef' || n >= '\u0b66' && n <= '\u0b6f' || n >= '\u0be7' && n <= '\u0bef' || n >= '\u0c66' && n <= '\u0c6f' || n >= '\u0ce6' && n <= '\u0cef' || n >= '\u0d66' && n <= '\u0d6f' || n >= '\u0e50' && n <= '\u0e59' || n >= '\u0ed0' && n <= '\u0ed9' || n >= '\u0f20' && n <= '\u0f29';
    }

    private static final boolean isExtender(char c) {
        char n = c;
        return n == '\u00b7' || n == '\u02d0' || n == '\u02d1' || n == '\u0387' || n == '\u0640' || n == '\u0e46' || n == '\u0ec6' || n == '\u3005' || n >= '\u3031' && n <= '\u3035' || n >= '\u309d' && n <= '\u309e' || n >= '\u30fc' && n <= '\u30fe';
    }

    private XMLChecker() {
    }
}

