/*
 * Decompiled with CFR 0.152.
 */
package org.znerd.xmlenc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.znerd.xmlenc.InvalidXMLException;
import org.znerd.xmlenc.LineBreak;
import org.znerd.xmlenc.StatefulXMLEventListener;
import org.znerd.xmlenc.XMLChecker;
import org.znerd.xmlenc.XMLEncoder;
import org.znerd.xmlenc.XMLEventListenerState;
import org.znerd.xmlenc.XMLEventListenerStates;

public class XMLOutputter
implements StatefulXMLEventListener {
    public static final String DEFAULT_INDENTATION = "";
    private boolean _anythingOutput;
    private Writer _out;
    private XMLEncoder _encoder;
    private XMLEventListenerState _state;
    private String[] _elementStack;
    private int _elementStackSize;
    private char _quotationMark;
    private boolean _escapeAmpersands = true;
    private LineBreak _lineBreak = LineBreak.NONE;
    private char[] _lineBreakChars;
    private String _indentation;

    public XMLOutputter() {
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        this._state = XMLEventListenerStates.UNINITIALIZED;
        this._elementStack = new String[16];
        this._quotationMark = (char)34;
        this._escapeAmpersands = true;
        this._lineBreak = LineBreak.NONE;
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        this._indentation = DEFAULT_INDENTATION;
    }

    public XMLOutputter(Writer out, String encoding) throws IllegalStateException, IllegalArgumentException, UnsupportedEncodingException {
        this();
        this.reset(out, encoding);
    }

    public XMLOutputter(Writer out, XMLEncoder encoder) throws IllegalStateException, IllegalArgumentException, UnsupportedEncodingException {
        this();
        this.reset(out, encoder);
    }

    private final void checkInvariants() throws Error {
        if (this._lineBreak == null) {
            throw new Error("_lineBreak == null");
        }
        if (this._lineBreak == LineBreak.NONE && this._indentation.length() > 0) {
            throw new Error("_lineBreak == LineBreak.NONE && _indentation = \"" + this._indentation + "\".");
        }
    }

    private final void writeIndentation() throws IOException {
        if (this._indentation.length() > 0) {
            int count = this._elementStackSize - 1;
            for (int i = 0; i < count; ++i) {
                this._out.write(this._indentation);
            }
        }
    }

    public final Writer getWriter() {
        return this._out;
    }

    public final String getEncoding() {
        if (this._encoder == null) {
            return null;
        }
        return this._encoder.getEncoding();
    }

    public void reset() {
        this._out = null;
        this._encoder = null;
        this._elementStackSize = 0;
        this._state = XMLEventListenerStates.UNINITIALIZED;
        this._lineBreak = LineBreak.NONE;
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        this._indentation = DEFAULT_INDENTATION;
        this.checkInvariants();
    }

    private final void reset(Writer out) throws IllegalArgumentException {
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        this._out = out;
        this._state = XMLEventListenerStates.BEFORE_XML_DECLARATION;
        this._elementStackSize = 0;
        this._lineBreak = LineBreak.NONE;
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        this._indentation = DEFAULT_INDENTATION;
        this.checkInvariants();
    }

    public final void reset(Writer out, String encoding) throws IllegalArgumentException, UnsupportedEncodingException {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding == null");
        }
        this.reset(out);
        this._encoder = XMLEncoder.getEncoder(encoding);
        this.checkInvariants();
    }

    public final void reset(Writer out, XMLEncoder encoder) throws IllegalArgumentException, UnsupportedEncodingException {
        if (encoder == null) {
            throw new IllegalArgumentException("encoder == null");
        }
        this.reset(out);
        this._encoder = encoder;
        this.checkInvariants();
    }

    public final void setState(XMLEventListenerState newState, String[] newElementStack) throws IllegalArgumentException {
        if (newState == null) {
            throw new IllegalArgumentException("newState == null");
        }
        if (newState == XMLEventListenerStates.START_TAG_OPEN && newElementStack == null) {
            throw new IllegalArgumentException("newState == START_TAG_OPEN && newElementStack == null");
        }
        if (newState == XMLEventListenerStates.WITHIN_ELEMENT && newElementStack == null) {
            throw new IllegalArgumentException("newState == WITHIN_ELEMENT && newElementStack == null");
        }
        if (newState != XMLEventListenerStates.START_TAG_OPEN && newState != XMLEventListenerStates.WITHIN_ELEMENT && newElementStack != null) {
            throw new IllegalArgumentException("newState != START_TAG_OPEN && newState != WITHIN_ELEMENT && newElementStack != null");
        }
        if (newElementStack != null) {
            for (int i = 0; i < newElementStack.length; ++i) {
                if (newElementStack[i] != null) continue;
                throw new IllegalArgumentException("newElementStack[" + i + "] == null");
            }
            if (newElementStack.length > this._elementStack.length) {
                try {
                    this._elementStack = new String[newElementStack.length + 16];
                }
                catch (OutOfMemoryError error) {
                    this._elementStack = new String[newElementStack.length];
                }
            }
            System.arraycopy(newElementStack, 0, this._elementStack, 0, newElementStack.length);
        }
        if (newState == XMLEventListenerStates.UNINITIALIZED) {
            this.reset();
        } else {
            this._state = newState;
            this._elementStackSize = newElementStack == null ? 0 : newElementStack.length;
        }
        this.checkInvariants();
    }

    public final XMLEventListenerState getState() {
        return this._state;
    }

    public final boolean isEscaping() {
        return this._escapeAmpersands;
    }

    public final void setEscaping(boolean escapeAmpersands) {
        this._escapeAmpersands = escapeAmpersands;
        this.checkInvariants();
    }

    public final String[] getElementStack() {
        if (this._elementStackSize == 0) {
            return null;
        }
        String[] newStack = new String[this._elementStackSize];
        System.arraycopy(this._elementStack, 0, newStack, 0, this._elementStackSize);
        return newStack;
    }

    public final int getElementStackSize() {
        return this._elementStackSize;
    }

    public final int getElementStackCapacity() {
        return this._elementStack.length;
    }

    public final void setElementStackCapacity(int newCapacity) throws IllegalArgumentException, OutOfMemoryError {
        if (newCapacity < this._elementStack.length) {
            throw new IllegalArgumentException("newCapacity < getElementStackSize()");
        }
        int currentCapacity = this._elementStack.length;
        if (currentCapacity == newCapacity) {
            return;
        }
        String[] newStack = new String[newCapacity];
        System.arraycopy(this._elementStack, 0, newStack, 0, this._elementStackSize);
        this._elementStack = newStack;
        this.checkInvariants();
    }

    public final void setQuotationMark(char c) throws IllegalArgumentException {
        if (c != '\'' && c != '\"') {
            throw new IllegalArgumentException("c != '\\'' && c != '\"'");
        }
        this._quotationMark = c;
        this.checkInvariants();
    }

    public final char getQuotationMark() {
        return this._quotationMark;
    }

    public final void setLineBreak(LineBreak lineBreak) {
        this._lineBreak = lineBreak != null ? lineBreak : LineBreak.NONE;
        this._lineBreakChars = this._lineBreak._lineBreakChars;
        if (this._lineBreak == LineBreak.NONE) {
            this._indentation = DEFAULT_INDENTATION;
        }
        this.checkInvariants();
    }

    public final LineBreak getLineBreak() {
        return this._lineBreak;
    }

    public final void setIndentation(String indentation) throws IllegalStateException {
        String string = indentation = indentation != null ? indentation : DEFAULT_INDENTATION;
        if (this._lineBreak == LineBreak.NONE) {
            throw new IllegalStateException("getLineBreak() == LineBreak.NONE");
        }
        int length = indentation.length();
        for (int i = 0; i < length; ++i) {
            char ch = indentation.charAt(i);
            if (ch == ' ' || ch == '\t') continue;
            String message = "indentation.charAt(" + i + ") = " + ch + ", while only space and tab are allowed.";
            throw new IllegalArgumentException(message);
        }
        this._indentation = indentation;
        this.checkInvariants();
    }

    public final String getIndentation() {
        return this._indentation;
    }

    private void closeStartTag() throws IOException {
        this._out.write(62);
    }

    public final void declaration() throws IllegalStateException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        this._state = XMLEventListenerStates.ERROR_STATE;
        this._encoder.declaration(this._out);
        this._state = XMLEventListenerStates.BEFORE_DTD_DECLARATION;
        this.checkInvariants();
    }

    public final void dtd(String name, String publicID, String systemID) throws IllegalStateException, IllegalArgumentException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (publicID != null && systemID == null) {
            throw new IllegalArgumentException("Found public identifier, but no system identifier.");
        }
        XMLChecker.checkName(name);
        if (publicID != null) {
            XMLChecker.checkPubidLiteral("\"" + publicID + "\"");
        }
        if (systemID != null) {
            XMLChecker.checkSystemLiteral("\"" + systemID + "\"");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (oldState == XMLEventListenerStates.BEFORE_DTD_DECLARATION) {
            this._out.write(this._lineBreakChars);
        }
        this._out.write("<!DOCTYPE ");
        this._out.write(name);
        if (publicID != null) {
            this._out.write(" PUBLIC \"");
            this._out.write(publicID);
            this._out.write(34);
            this._out.write(32);
            this._out.write(34);
            this._out.write(systemID);
            this._out.write(34);
        } else if (systemID != null) {
            this._out.write(" SYSTEM \"");
            this._out.write(systemID);
            this._out.write(34);
        }
        this.closeStartTag();
        this._state = XMLEventListenerStates.BEFORE_ROOT_ELEMENT;
        this.checkInvariants();
    }

    public final void startTag(String type) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (this._elementStackSize == this._elementStack.length) {
            String[] newStack;
            try {
                newStack = new String[(this._elementStackSize + 1) * 2];
            }
            catch (OutOfMemoryError error) {
                newStack = new String[this._elementStackSize + 1];
            }
            System.arraycopy(this._elementStack, 0, newStack, 0, this._elementStackSize);
            this._elementStack = newStack;
        }
        this._elementStack[this._elementStackSize] = type;
        ++this._elementStackSize;
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this._out.write(62);
        }
        if (oldState != XMLEventListenerStates.BEFORE_XML_DECLARATION) {
            this._out.write(this._lineBreakChars);
            this.writeIndentation();
        }
        this._out.write(60);
        this._out.write(type);
        this._state = XMLEventListenerStates.START_TAG_OPEN;
        this.checkInvariants();
    }

    public final void attribute(String name, String value) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (name == null || value == null) {
            if (name == null && value == null) {
                throw new IllegalArgumentException("name == null && value == null");
            }
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            throw new IllegalArgumentException("value == null");
        }
        this._state = XMLEventListenerStates.ERROR_STATE;
        this._encoder.attribute(this._out, name, value, this._quotationMark, this._escapeAmpersands);
        this._state = XMLEventListenerStates.START_TAG_OPEN;
        this.checkInvariants();
    }

    public final void endTag() throws IllegalStateException, IOException {
        if (this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        String type = this._elementStack[this._elementStackSize - 1];
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this._out.write(47);
            this._out.write(62);
        } else {
            this._out.write(this._lineBreakChars);
            this.writeIndentation();
            this._out.write(60);
            this._out.write(47);
            this._out.write(type);
            this.closeStartTag();
        }
        --this._elementStackSize;
        this._state = this._elementStackSize == 0 ? XMLEventListenerStates.AFTER_ROOT_ELEMENT : XMLEventListenerStates.WITHIN_ELEMENT;
        this.checkInvariants();
    }

    public final void pcdata(String text) throws IllegalStateException, IllegalArgumentException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
            this._out.write(this._lineBreakChars);
        }
        this._encoder.text(this._out, text, this._escapeAmpersands);
        this._state = XMLEventListenerStates.WITHIN_ELEMENT;
        this.checkInvariants();
    }

    public final void pcdata(char[] ch, int start, int length) throws IllegalStateException, IllegalArgumentException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (ch == null) {
            throw new IllegalArgumentException("ch == null");
        }
        if (start < 0) {
            throw new IllegalArgumentException("start (" + start + ") < 0");
        }
        if (start >= ch.length) {
            throw new IllegalArgumentException("start (" + start + ") >= ch.length (" + ch.length + ')');
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._encoder.text(this._out, ch, start, length, this._escapeAmpersands);
        this._state = XMLEventListenerStates.WITHIN_ELEMENT;
        this.checkInvariants();
    }

    public final void whitespace(String whitespace) throws IllegalStateException, IllegalArgumentException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (whitespace == null) {
            throw new IllegalArgumentException("whitespace == null");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._encoder.whitespace(this._out, whitespace);
        this._state = oldState == XMLEventListenerStates.BEFORE_XML_DECLARATION ? XMLEventListenerStates.BEFORE_DTD_DECLARATION : (oldState == XMLEventListenerStates.START_TAG_OPEN ? XMLEventListenerStates.WITHIN_ELEMENT : oldState);
        this.checkInvariants();
    }

    public final void whitespace(char[] ch, int start, int length) throws IllegalStateException, IllegalArgumentException, IndexOutOfBoundsException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (ch == null) {
            throw new IllegalArgumentException("ch == null");
        }
        if (start < 0) {
            throw new IllegalArgumentException("start (" + start + ") < 0");
        }
        if (start >= ch.length) {
            throw new IllegalArgumentException("start (" + start + ") >= ch.length (" + ch.length + ')');
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._encoder.whitespace(this._out, ch, start, length);
        this._state = oldState == XMLEventListenerStates.BEFORE_XML_DECLARATION ? XMLEventListenerStates.BEFORE_DTD_DECLARATION : (oldState == XMLEventListenerStates.START_TAG_OPEN ? XMLEventListenerStates.WITHIN_ELEMENT : oldState);
        this.checkInvariants();
    }

    public final void comment(String text) throws IllegalStateException, IllegalArgumentException, InvalidXMLException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this._out.write(62);
            this._out.write(60);
            this._out.write(33);
            this._out.write(45);
            this._out.write(45);
        } else {
            this._out.write(60);
            this._out.write(33);
            this._out.write(45);
            this._out.write(45);
        }
        this._encoder.text(this._out, text, this._escapeAmpersands);
        this._out.write(45);
        this._out.write(45);
        this._out.write(62);
        this._out.write(this._lineBreakChars);
        this._state = oldState == XMLEventListenerStates.BEFORE_XML_DECLARATION ? XMLEventListenerStates.BEFORE_DTD_DECLARATION : (oldState == XMLEventListenerStates.START_TAG_OPEN ? XMLEventListenerStates.WITHIN_ELEMENT : oldState);
        this.checkInvariants();
    }

    public final void pi(String target, String instruction) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this._state != XMLEventListenerStates.BEFORE_XML_DECLARATION && this._state != XMLEventListenerStates.BEFORE_DTD_DECLARATION && this._state != XMLEventListenerStates.BEFORE_ROOT_ELEMENT && this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (target == null) {
            throw new IllegalArgumentException("target == null");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._out.write(60);
        this._out.write(63);
        this._out.write(target);
        if (instruction != null) {
            this._out.write(32);
            this._out.write(instruction);
        }
        this._out.write(63);
        this._out.write(62);
        this._state = oldState == XMLEventListenerStates.BEFORE_XML_DECLARATION ? XMLEventListenerStates.BEFORE_DTD_DECLARATION : (oldState == XMLEventListenerStates.START_TAG_OPEN ? XMLEventListenerStates.WITHIN_ELEMENT : oldState);
        this.checkInvariants();
    }

    public final void cdata(String text) throws IllegalStateException, IllegalArgumentException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        XMLEventListenerState oldState = this._state;
        this._state = XMLEventListenerStates.ERROR_STATE;
        if (oldState == XMLEventListenerStates.START_TAG_OPEN) {
            this.closeStartTag();
        }
        this._out.write("<![CDATA[");
        this._out.write(text);
        this._out.write(93);
        this._out.write(93);
        this._out.write(62);
        this._state = XMLEventListenerStates.WITHIN_ELEMENT;
        this.checkInvariants();
    }

    public final void close() throws IllegalStateException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        while (this._elementStackSize > 0) {
            this.endTag();
        }
        this.checkInvariants();
    }

    public final void endDocument() throws IllegalStateException, IOException {
        if (this._state != XMLEventListenerStates.START_TAG_OPEN && this._state != XMLEventListenerStates.WITHIN_ELEMENT && this._state != XMLEventListenerStates.AFTER_ROOT_ELEMENT) {
            throw new IllegalStateException("getState() == " + this._state);
        }
        this.close();
        this._out.flush();
        this._state = XMLEventListenerStates.DOCUMENT_ENDED;
        this.checkInvariants();
    }
}

