/*
 * Decompiled with CFR 0.152.
 */
package org.znerd.xmlenc.sax;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.znerd.xmlenc.XMLEventListener;

public class SAXEventReceiver
implements ContentHandler {
    private final XMLEventListener _eventListener;

    public SAXEventReceiver(XMLEventListener eventListener) throws IllegalArgumentException {
        if (eventListener == null) {
            throw new IllegalArgumentException("eventListener == null");
        }
        this._eventListener = eventListener;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        try {
            this._eventListener.endDocument();
        }
        catch (IOException ioException) {
            throw new SAXException(ioException);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this._eventListener.startTag(qName);
            int attributeCount = atts.getLength();
            for (int i = 0; i < attributeCount; ++i) {
                this._eventListener.attribute(atts.getQName(i), atts.getValue(i));
            }
        }
        catch (IOException ioException) {
            throw new SAXException(ioException);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this._eventListener.endTag();
        }
        catch (IOException ioException) {
            throw new SAXException(ioException);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this._eventListener.pcdata(ch, start, length);
        }
        catch (IOException ioException) {
            throw new SAXException(ioException);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this._eventListener.whitespace(ch, start, length);
        }
        catch (IOException ioException) {
            throw new SAXException(ioException);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this._eventListener.pi(target, data);
        }
        catch (IOException ioException) {
            throw new SAXException(ioException);
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

