<?php
/*
** Zabbix
** Copyright (C) 2001-2022 Zabbix SIA
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/


/**
 * Problems by severity widget form.
 */
class CWidgetFormProblemsBySv extends CWidgetForm {

	public function __construct($data) {
		parent::__construct($data, WIDGET_PROBLEMS_BY_SV);

		// Host groups.
		$field_groups = new CWidgetFieldGroup('groupids', _('Host groups'));

		if (array_key_exists('groupids', $this->data)) {
			$field_groups->setValue($this->data['groupids']);
		}

		$this->fields[$field_groups->getName()] = $field_groups;

		// Exclude host groups.
		$field_exclude_groups = new CWidgetFieldGroup('exclude_groupids', _('Exclude host groups'));

		if (array_key_exists('exclude_groupids', $this->data)) {
			$field_exclude_groups->setValue($this->data['exclude_groupids']);
		}

		$this->fields[$field_exclude_groups->getName()] = $field_exclude_groups;

		// Hosts field.
		$field_hosts = new CWidgetFieldHost('hostids', _('Hosts'));

		if (array_key_exists('hostids', $this->data)) {
			$field_hosts->setValue($this->data['hostids']);
		}

		$this->fields[$field_hosts->getName()] = $field_hosts;

		// Problem field.
		$field_problem = new CWidgetFieldTextBox('problem', _('Problem'));

		if (array_key_exists('problem', $this->data)) {
			$field_problem->setValue($this->data['problem']);
		}

		$this->fields[$field_problem->getName()] = $field_problem;

		// Severity field.
		$field_severities = new CWidgetFieldSeverities('severities', _('Severity'));

		if (array_key_exists('severities', $this->data)) {
			$field_severities->setValue($this->data['severities']);
		}

		$this->fields[$field_severities->getName()] = $field_severities;

		// Show suppressed problems.
		$field_show_suppressed = (new CWidgetFieldCheckBox('show_suppressed', _('Show suppressed problems')))
			->setDefault(ZBX_PROBLEM_SUPPRESSED_FALSE);

		if (array_key_exists('show_suppressed', $this->data)) {
			$field_show_suppressed->setValue($this->data['show_suppressed']);
		}

		$this->fields[$field_show_suppressed->getName()] = $field_show_suppressed;

		// Hide groups without problems.
		$field_hide_empty_groups = new CWidgetFieldCheckBox('hide_empty_groups', _('Hide groups without problems'));

		if (array_key_exists('hide_empty_groups', $this->data)) {
			$field_hide_empty_groups->setValue($this->data['hide_empty_groups']);
		}

		$this->fields[$field_hide_empty_groups->getName()] = $field_hide_empty_groups;

		// Show last values.
		$field_show_latest_values = (new CWidgetFieldCheckBox('show_latest_values', _('Show latest values')))
			->setFlags(CWidgetField::FLAG_ACKNOWLEDGES);

		if (array_key_exists('show_latest_values', $this->data)) {
			$field_show_latest_values->setValue($this->data['show_latest_values']);
		}

		$this->fields[$field_show_latest_values->getName()] = $field_show_latest_values;

		// Problem display.
		$field_ext_ack = (new CWidgetFieldRadioButtonList('ext_ack', _('Problem display'), [
			EXTACK_OPTION_ALL => _('All'),
			EXTACK_OPTION_BOTH => _('Separated'),
			EXTACK_OPTION_UNACK => _('Unacknowledged only')
		]))
			->setDefault(EXTACK_OPTION_ALL)
			->setFlags(CWidgetField::FLAG_ACKNOWLEDGES)
			->setModern(true);

		if (array_key_exists('ext_ack', $this->data)) {
			$field_ext_ack->setValue($this->data['ext_ack']);
		}

		$this->fields[$field_ext_ack->getName()] = $field_ext_ack;

		// Show timeline.
		$field_show_timeline = (new CWidgetFieldCheckBox('show_timeline', _('Show timeline')))
			->setDefault(1);

		if (array_key_exists('show_timeline', $this->data)) {
			$field_show_timeline->setValue($this->data['show_timeline']);
		}

		$this->fields[$field_show_timeline->getName()] = $field_show_timeline;
	}
}
