/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address;

import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.field.address.Address;
import org.apache.james.mime4j.field.address.Builder;
import org.apache.james.mime4j.field.address.DomainList;
import org.apache.james.mime4j.field.address.parser.AddressListParser;
import org.apache.james.mime4j.field.address.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mailbox
extends Address {
    private static final long serialVersionUID = 1L;
    private static final DomainList EMPTY_ROUTE_LIST = new DomainList(Collections.<String>emptyList(), true);
    private final String name;
    private final DomainList route;
    private final String localPart;
    private final String domain;

    public Mailbox(String localPart, String domain) {
        this(null, null, localPart, domain);
    }

    public Mailbox(DomainList route, String localPart, String domain) {
        this(null, route, localPart, domain);
    }

    public Mailbox(String name, String localPart, String domain) {
        this(name, null, localPart, domain);
    }

    public Mailbox(String name, DomainList route, String localPart, String domain) {
        if (localPart == null || localPart.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = name == null || name.length() == 0 ? null : name;
        this.route = route == null ? EMPTY_ROUTE_LIST : route;
        this.localPart = localPart;
        this.domain = domain == null || domain.length() == 0 ? null : domain;
    }

    Mailbox(String name, Mailbox baseMailbox) {
        this(name, baseMailbox.getRoute(), baseMailbox.getLocalPart(), baseMailbox.getDomain());
    }

    public static Mailbox parse(String rawMailboxString) {
        AddressListParser parser = new AddressListParser(new StringReader(rawMailboxString));
        try {
            return Builder.getInstance().buildMailbox(parser.parseMailbox());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public DomainList getRoute() {
        return this.route;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getAddress() {
        if (this.domain == null) {
            return this.localPart;
        }
        return this.localPart + '@' + this.domain;
    }

    @Override
    public String getDisplayString(boolean includeRoute) {
        boolean includeAngleBrackets = this.name != null || (includeRoute &= this.route != null);
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
            sb.append(' ');
        }
        if (includeAngleBrackets) {
            sb.append('<');
        }
        if (includeRoute) {
            sb.append(this.route.toRouteString());
            sb.append(':');
        }
        sb.append(this.localPart);
        if (this.domain != null) {
            sb.append('@');
            sb.append(this.domain);
        }
        if (includeAngleBrackets) {
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public String getEncodedString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(EncoderUtil.encodeAddressDisplayName(this.name));
            sb.append(" <");
        }
        sb.append(EncoderUtil.encodeAddressLocalPart(this.localPart));
        if (this.domain != null) {
            sb.append('@');
            sb.append(this.domain);
        }
        if (this.name != null) {
            sb.append('>');
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.getCanonicalizedAddress().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Mailbox)) {
            return false;
        }
        Mailbox other = (Mailbox)obj;
        return this.getCanonicalizedAddress().equals(other.getCanonicalizedAddress());
    }

    @Override
    protected final void doAddMailboxesTo(List<Mailbox> results) {
        results.add(this);
    }

    private Object getCanonicalizedAddress() {
        if (this.domain == null) {
            return this.localPart;
        }
        return this.localPart + '@' + this.domain.toLowerCase(Locale.US);
    }
}

