/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseStatusFilter
implements ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ResponseStatusFilter.class);

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        int statusCode = responseContext.getStatus();
        Response.StatusType responseStatus = responseContext.getStatusInfo();
        if (ResponseStatusFilter.isRedirect(responseStatus)) {
            String message = "Server returned a redirect. You must change your url option or config file.";
            throw new RedirectionException(message, statusCode, responseContext.getLocation());
        }
        if (statusCode >= 400) {
            URI uri = requestContext.getUri();
            String entity = ResponseStatusFilter.tryGetEntity(responseContext);
            String msg = ResponseStatusFilter.generateErrorMessage(statusCode, responseStatus, uri, entity);
            if (responseStatus == Response.Status.UNAUTHORIZED) {
                throw new NotAuthorizedException((Object)"Incorrect username/password", new Object[0]);
            }
            if (responseStatus == Response.Status.NOT_FOUND) {
                responseContext.getEntityStream().close();
                throw new NotFoundException(msg);
            }
            if (statusCode < 500) {
                throw new ClientErrorException(msg, statusCode);
            }
            if (responseStatus == Response.Status.SERVICE_UNAVAILABLE) {
                throw new ServiceUnavailableException("Service is currently unavailable. Please check outage notification or try again later.");
            }
            throw new ServerErrorException(msg, statusCode);
        }
    }

    private static boolean isRedirect(Response.StatusType statusCode) {
        return statusCode == Response.Status.MOVED_PERMANENTLY || statusCode == Response.Status.FOUND;
    }

    private static String tryGetEntity(ClientResponseContext responseContext) {
        String entity = "";
        if (responseContext.hasEntity()) {
            try (BufferedInputStream bufferedIs = new BufferedInputStream(responseContext.getEntityStream());
                 ByteArrayOutputStream result = new ByteArrayOutputStream();){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = bufferedIs.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                entity = ":" + result.toString("UTF-8");
            }
            catch (Exception e) {
                log.debug("error reading input stream", (Throwable)e);
            }
        }
        return entity;
    }

    private static String generateErrorMessage(int statusCode, Response.StatusType responseStatus, URI uri, String entity) {
        return String.format("operation to [%s] returned %d (%s):%s", uri, statusCode, responseStatus, entity);
    }
}

