/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.openprops;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.fedorahosted.openprops.XMLUtils;

public class Properties {
    private static final long serialVersionUID = 1L;
    private static final String NEWLINE_REGEX = "(\r\n|\r|\n)";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String footerComment = "";
    private final Map<String, Entry> props = new LinkedHashMap<String, Entry>();
    static final String PROJECT_NAME = "OpenProperties";

    public synchronized Object setProperty(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Entry entry = this.props.get(key);
        if (entry == null) {
            entry = new Entry("", value);
            this.props.put(key, entry);
            return null;
        }
        String result = entry.getValue();
        entry.setValue(value);
        return result;
    }

    public synchronized void load(Reader reader) throws IOException {
        this.load0(new LineReader(reader));
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.load0(new LineReader(inStream));
    }

    private void load0(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        StringBuilder prevComment = new StringBuilder();
        int lineNumber = lr.lineNumber;
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            if (lr.isCommentLine) {
                prevComment.append(new String(lr.lineBuf, 0, limit));
            } else {
                String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
                String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
                this.props.put(key, new Entry(prevComment.toString(), value, lineNumber));
                prevComment.setLength(0);
            }
            lineNumber = lr.lineNumber;
        }
        this.footerComment = prevComment.toString();
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Properties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Properties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Properties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Properties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeComments(BufferedWriter bw, String comments, boolean writeHashes) throws IOException {
        int current;
        if (comments == null) {
            return;
        }
        if (writeHashes) {
            bw.write("#");
        }
        int len = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = Properties.toHex(c >> 12 & 0xF);
                uu[3] = Properties.toHex(c >> 8 & 0xF);
                uu[4] = Properties.toHex(c >> 4 & 0xF);
                uu[5] = Properties.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (writeHashes && (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!')) {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        if (writeHashes) {
            bw.newLine();
        }
    }

    public void store(Writer writer, String comments) throws IOException {
        this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments, false);
    }

    public void store(OutputStream out, String comments) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(out, "8859_1")), comments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            Properties.writeComments(bw, comments, true);
        }
        Properties properties = this;
        synchronized (properties) {
            for (String key : this.keySet()) {
                Entry entry = this.props.get(key);
                Properties.writeComments(bw, entry.getRawComment(), false);
                String val = entry.getValue();
                if (val == null) {
                    throw new NullPointerException("property key \"" + key + "\" has a comment but no value");
                }
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                bw.newLine();
            }
            Properties.writeComments(bw, this.footerComment, false);
        }
        bw.flush();
    }

    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        if (in == null) {
            throw new NullPointerException();
        }
        XMLUtils.load(this, in);
        in.close();
    }

    public synchronized void storeToXML(OutputStream os, String comment) throws IOException {
        if (os == null) {
            throw new NullPointerException();
        }
        this.storeToXML(os, comment, "UTF-8");
    }

    public synchronized void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        if (os == null) {
            throw new NullPointerException();
        }
        XMLUtils.save(this, os, comment, encoding);
    }

    public String getProperty(String key) {
        return this.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Enumeration<?> propertyNames() {
        Hashtable h = new Hashtable();
        this.enumerate(h);
        return h.keys();
    }

    public Set<String> stringPropertyNames() {
        return this.keySet();
    }

    public void list(PrintStream out) {
        out.println("-- listing properties --");
        Hashtable h = new Hashtable();
        this.enumerate(h);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)h.get(key);
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    public void list(PrintWriter out) {
        out.println("-- listing properties --");
        Hashtable h = new Hashtable();
        this.enumerate(h);
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)h.get(key);
            if (val.length() > 40) {
                val = val.substring(0, 37) + "...";
            }
            out.println(key + "=" + val);
        }
    }

    private synchronized void enumerate(Hashtable h) {
        for (String key : this.keySet()) {
            h.put(key, this.get(key));
        }
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private String get(String key) {
        Entry entry = this.props.get(key);
        return entry == null ? null : entry.getValue();
    }

    public Set<String> keySet() {
        return this.props.keySet();
    }

    public String getFooterComment() {
        return Properties.cookComment(this.footerComment);
    }

    public void setFooterComment(String comment) {
        this.footerComment = Properties.uncookComment(comment);
    }

    public String getRawFooterComment() {
        return this.footerComment;
    }

    public void setRawFooterComment(String comment) {
        this.footerComment = comment;
    }

    public String getRawComment(String key) {
        Entry entry = this.props.get(key);
        return entry == null ? null : entry.getRawComment();
    }

    public void setRawComment(String key, String rawComment) {
        if (rawComment == null) {
            throw new NullPointerException();
        }
        Entry entry = this.props.get(key);
        if (entry == null) {
            entry = new Entry(rawComment, null);
            this.props.put(key, entry);
        } else {
            entry.setRawComment(rawComment);
        }
    }

    public void setComment(String key, String comment) {
        if (comment == null) {
            throw new NullPointerException();
        }
        this.setRawComment(key, Properties.uncookComment(comment));
    }

    public String getComment(String key) {
        String raw = this.getRawComment(key);
        return Properties.cookComment(raw);
    }

    public int getLineNumber(String key) {
        return this.props.get(key).lineNumber;
    }

    public synchronized int size() {
        return this.props.size();
    }

    private static String cookComment(String raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(raw.length());
        String[] lines = raw.split(NEWLINE_REGEX);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            sb.append(Properties.cookCommentLine(line));
            if (i + 1 >= lines.length) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String uncookComment(String comment) {
        if (comment.length() != 0) {
            String[] lines;
            StringBuilder sb = new StringBuilder(comment.length() + 30);
            for (String line : lines = comment.split(NEWLINE_REGEX)) {
                sb.append("# ").append(line).append('\n');
            }
            return sb.toString();
        }
        return "";
    }

    public static String cookCommentLine(String line) {
        String trimmed = line.trim();
        if (trimmed.length() != 0) {
            switch (trimmed.charAt(0)) {
                case '!': 
                case '#': {
                    return trimmed.substring(1).trim();
                }
            }
            return trimmed;
        }
        return "";
    }

    private static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        return this.footerComment.equals(other.footerComment) && this.props.equals(other.props);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.footerComment.hashCode();
        hash = 31 * hash + this.props.hashCode();
        return hash;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.store(writer, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.getClass().getName() + "[" + writer.toString() + "]";
    }

    private static final class Entry {
        private String rawComment;
        private String value;
        private int lineNumber;

        public Entry(String rawComment, String value, int lineNumber) {
            this.rawComment = rawComment;
            this.value = value;
            this.lineNumber = lineNumber;
        }

        public Entry(String rawComment, String value) {
            this(rawComment, value, -1);
        }

        public String getRawComment() {
            return this.rawComment;
        }

        public void setRawComment(String rawComment) {
            this.rawComment = rawComment;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return Properties.equals(this.rawComment, other.rawComment) && Properties.equals(this.value, other.value);
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + (this.rawComment == null ? 0 : this.rawComment.hashCode());
            hash = 31 * hash + (this.value == null ? 0 : this.value.hashCode());
            return hash;
        }

        public String toString() {
            return "Entry[comment=" + this.rawComment + " value=" + this.value + "]";
        }
    }

    class LineReader {
        int lineNumber = 1;
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        boolean isCommentLine;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            this.isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0) {
                            return -1;
                        }
                        if (skipWhiteSpace) {
                            this.isCommentLine = true;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f') {
                        if (appendedLineBegin) continue;
                        this.lineBuf[len++] = c;
                        continue;
                    }
                    if (!(appendedLineBegin || c != '\r' && c != '\n')) {
                        this.isCommentLine = true;
                        this.lineBuf[len++] = c;
                        ++this.lineNumber;
                        return len;
                    }
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        this.lineBuf[len++] = c;
                        skipWhiteSpace = false;
                        this.isCommentLine = true;
                        continue;
                    }
                    if (c == '\r' || c == '\n') {
                        this.isCommentLine = true;
                        this.lineBuf[len++] = c;
                        ++this.lineNumber;
                        return len;
                    }
                    len = 0;
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                ++this.lineNumber;
                if (this.isCommentLine || len == 0) {
                    this.lineBuf[len++] = c;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    return len;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

