/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.glossary;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.PoWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.adapter.glossary.AbstractGlossaryPullWriter;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;

public class GlossaryPoWriter
extends AbstractGlossaryPullWriter {
    private static final Logger log = LoggerFactory.getLogger(GlossaryPoWriter.class);
    private final PoWriter poWriter;

    public GlossaryPoWriter(boolean encodeTabs) {
        this.poWriter = new PoWriter(encodeTabs);
    }

    public void write(@Nonnull OutputStream stream, @Nonnull List<GlossaryEntry> entries, @Nonnull LocaleId srcLocale, @Nonnull LocaleId targetLocale) throws IOException {
        OutputStreamWriter osWriter = new OutputStreamWriter(stream, Charsets.UTF_8);
        this.write(osWriter, entries, srcLocale, targetLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nonnull Writer fileWriter, @Nonnull List<GlossaryEntry> entries, @Nonnull LocaleId srcLocale, @Nonnull LocaleId targetLocale) throws IOException {
        if (fileWriter == null) {
            log.warn("Missing fileWriter.");
            return;
        }
        if (entries == null) {
            log.warn("No glossary entries to process.");
            return;
        }
        if (srcLocale == null || targetLocale == null) {
            log.warn("Missing source locale and translation locale.");
            return;
        }
        try {
            for (GlossaryEntry entry : entries) {
                GlossaryTerm srcTerm = this.getGlossaryTerm(entry.getGlossaryTerms(), srcLocale);
                GlossaryTerm transTerm = this.getGlossaryTerm(entry.getGlossaryTerms(), targetLocale);
                if (srcTerm == null) continue;
                Message message = new Message();
                message.setMsgid(srcTerm.getContent());
                message.setMsgstr(transTerm == null ? "" : transTerm.getContent());
                String srcRef = entry.getSourceReference();
                if (StringUtils.isNotBlank((CharSequence)srcRef)) {
                    message.getSourceReferences().add(srcRef);
                }
                GlossaryPoWriter.addCommentIfNotEmpty(message, entry.getDescription());
                GlossaryPoWriter.addCommentIfNotEmpty(message, srcTerm.getComment());
                GlossaryPoWriter.addCommentIfNotEmpty(message, transTerm == null ? null : transTerm.getComment());
                this.poWriter.write(message, fileWriter);
                fileWriter.write("\n");
            }
        }
        finally {
            fileWriter.flush();
        }
    }

    private static void addCommentIfNotEmpty(Message message, String comment) {
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            message.addComment(comment);
        }
    }
}

