/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.PutProjectOptions;
import org.zanata.common.EntityStatus;
import org.zanata.rest.client.ProjectClient;
import org.zanata.rest.dto.Project;

public class PutProjectCommand
extends ConfigurableCommand<PutProjectOptions> {
    private static final Logger log = LoggerFactory.getLogger(PutProjectCommand.class);

    public PutProjectCommand(PutProjectOptions opts) {
        super(opts);
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST", "SLF4J_SIGN_ONLY_FORMAT"})
    public void run() throws Exception {
        String op;
        String projectId = ((PutProjectOptions)this.getOpts()).getProjectSlug();
        Project project = this.getClientFactory().getProjectClient(projectId).get();
        if (project == null) {
            op = "Create new project {}";
            project = new Project();
            project.setId(((PutProjectOptions)this.getOpts()).getProjectSlug());
            if (StringUtils.isBlank((CharSequence)((PutProjectOptions)this.getOpts()).getProjectName()) || StringUtils.isBlank((CharSequence)((PutProjectOptions)this.getOpts()).getDefaultProjectType())) {
                throw new Exception("default-project-type and project-name must be specified for new projects");
            }
        } else {
            op = "Update project {}";
        }
        log.info(op, (Object)projectId);
        project.setStatus((EntityStatus)ObjectUtils.firstNonNull((Object[])new EntityStatus[]{this.statusFromString(((PutProjectOptions)this.getOpts()).getProjectStatus()), project.getStatus()}));
        project.setName((String)ObjectUtils.firstNonNull((Object[])new String[]{((PutProjectOptions)this.getOpts()).getProjectName(), project.getName()}));
        project.setDescription((String)ObjectUtils.firstNonNull((Object[])new String[]{((PutProjectOptions)this.getOpts()).getProjectDesc(), project.getDescription()}));
        project.setSourceViewURL((String)ObjectUtils.firstNonNull((Object[])new String[]{((PutProjectOptions)this.getOpts()).getSourceViewUrl(), project.getSourceViewURL()}));
        project.setSourceCheckoutURL((String)ObjectUtils.firstNonNull((Object[])new String[]{((PutProjectOptions)this.getOpts()).getSourceCheckoutUrl(), project.getSourceCheckoutURL()}));
        String defaultProjectType = (String)ObjectUtils.firstNonNull((Object[])new String[]{((PutProjectOptions)this.getOpts()).getDefaultProjectType(), project.getDefaultType()});
        if (StringUtils.isBlank((CharSequence)defaultProjectType)) {
            throw new Exception("Default project type must not be null or empty.");
        }
        project.setDefaultType(defaultProjectType);
        log.debug("{}", (Object)project);
        ProjectClient client = this.getClientFactory().getProjectClient(((PutProjectOptions)this.getOpts()).getProjectSlug());
        client.put(project);
        log.info(op, (Object)(projectId + " complete"));
    }

    private EntityStatus statusFromString(String status) throws Exception {
        if (status == null) {
            return null;
        }
        if (status.equalsIgnoreCase("active")) {
            return EntityStatus.ACTIVE;
        }
        if (status.equalsIgnoreCase("readonly")) {
            return EntityStatus.READONLY;
        }
        throw new Exception("Invalid value for project-status: " + status);
    }
}

