/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext.catalog.parse;

import antlr.ASTPair;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.fedorahosted.tennera.jgettext.Message;
import org.fedorahosted.tennera.jgettext.catalog.parse.CatalogLexer;
import org.fedorahosted.tennera.jgettext.catalog.parse.CatalogParser;
import org.fedorahosted.tennera.jgettext.catalog.parse.ParseException;
import org.fedorahosted.tennera.jgettext.catalog.parse.UnexpectedTokenException;

public class MessageStreamParser {
    private InternalMessageStreamParser internalParser;

    public MessageStreamParser(File file) throws FileNotFoundException, IOException {
        this.internalParser = new InternalMessageStreamParser(file);
    }

    public MessageStreamParser(Reader reader) {
        this.internalParser = new InternalMessageStreamParser(reader);
    }

    public MessageStreamParser(InputStream inputStream) throws IOException {
        this.internalParser = new InternalMessageStreamParser(inputStream);
    }

    public MessageStreamParser(InputStream inputStream, Charset charset) {
        this.internalParser = new InternalMessageStreamParser(inputStream, charset);
    }

    public boolean hasNext() {
        return this.internalParser.hasNext();
    }

    public Message next() throws ParseException {
        try {
            return this.internalParser.next();
        }
        catch (RecognitionException e) {
            throw new ParseException(e.getMessage(), e, e.getLine());
        }
        catch (TokenStreamException e) {
            throw new ParseException(e.getMessage(), e, -1);
        }
    }

    private class InternalMessageStreamParser
    extends CatalogParser {
        private Message currentMessage;
        private Message nextMessage;
        private RecognitionException currentRecognitionException;
        private TokenStreamException currentTokenStreamException;

        public InternalMessageStreamParser(File file) throws FileNotFoundException, IOException {
            super(new CatalogLexer(file));
            this.currentMessage = new Message();
            this.currentRecognitionException = null;
            this.currentTokenStreamException = null;
        }

        public InternalMessageStreamParser(Reader reader) {
            super(new CatalogLexer(reader));
            this.currentMessage = new Message();
            this.currentRecognitionException = null;
            this.currentTokenStreamException = null;
        }

        public InternalMessageStreamParser(InputStream inputStream) throws IOException {
            super(new CatalogLexer(inputStream));
            this.currentMessage = new Message();
            this.currentRecognitionException = null;
            this.currentTokenStreamException = null;
        }

        public InternalMessageStreamParser(InputStream inputStream, Charset charset) {
            super(new CatalogLexer(inputStream, charset));
            this.currentMessage = new Message();
            this.currentRecognitionException = null;
            this.currentTokenStreamException = null;
        }

        public void reportError(RecognitionException e) {
            throw new UnexpectedTokenException(e.getMessage(), e, e.getLine());
        }

        public void reportError(String s) {
            throw new ParseException("error parsing catalog : " + s, -1);
        }

        public void reportWarning(String s) {
        }

        protected boolean nextMessageBlock() throws RecognitionException, TokenStreamException {
            boolean ret = false;
            this.returnAST = null;
            ASTPair currentAST = new ASTPair();
            AST messageBlocks_AST = null;
            try {
                block8: while (true) {
                    switch (this.LA(1)) {
                        case 4: {
                            this.catalogComment();
                            this.astFactory.addASTChild(currentAST, this.returnAST);
                            continue block8;
                        }
                        case 5: {
                            this.extractedComment();
                            this.astFactory.addASTChild(currentAST, this.returnAST);
                            continue block8;
                        }
                        case 6: {
                            this.reference();
                            this.astFactory.addASTChild(currentAST, this.returnAST);
                            continue block8;
                        }
                        case 7: {
                            this.flag();
                            this.astFactory.addASTChild(currentAST, this.returnAST);
                            continue block8;
                        }
                    }
                    break;
                }
                if (1 != this.LA(1)) {
                    this.messageBlock();
                    this.astFactory.addASTChild(currentAST, this.returnAST);
                    ret = true;
                } else {
                    this.reportWarning("No more entries!");
                }
                messageBlocks_AST = currentAST.root;
            }
            catch (RecognitionException ex) {
                this.reportError(ex);
                this.recover(ex, _tokenSet_0);
            }
            this.returnAST = messageBlocks_AST;
            return ret;
        }

        @Override
        protected void handleMessageBlock(AST messageBlock) {
            this.nextMessage = this.currentMessage;
            this.currentMessage = new Message();
        }

        @Override
        protected void handleObsoleteMessageBlock(AST messageBlock) {
            this.currentMessage.markObsolete();
            this.handleMessageBlock(messageBlock);
        }

        @Override
        protected void handleCatalogComment(AST comment) {
            this.currentMessage.addComment(this.extractText(comment));
        }

        @Override
        protected void handleExtractedComment(AST comment) {
            this.currentMessage.addExtractedComment(this.extractText(comment));
        }

        @Override
        protected void handleReference(AST sourceRef) {
            this.currentMessage.addSourceReference(this.parseSourceReference(sourceRef));
        }

        @Override
        protected void handleFlag(AST flag) {
            String[] flags;
            for (String flagStr : flags = flag.getText().split(",")) {
                if ((flagStr = flagStr.trim()).isEmpty()) continue;
                this.currentMessage.addFormat(flagStr);
            }
        }

        @Override
        protected void handlePreviousMsgctxt(AST previousMsgctxt) {
            this.currentMessage.setPrevMsgctx(this.extractText(previousMsgctxt));
        }

        @Override
        protected void handlePreviousMsgid(AST previousMsgid) {
            this.currentMessage.setPrevMsgid(this.extractText(previousMsgid));
        }

        @Override
        protected void handlePreviousMsgidPlural(AST previousMsgidPlural) {
            this.currentMessage.setPrevMsgidPlural(this.extractText(previousMsgidPlural));
        }

        @Override
        protected void handleDomain(AST domain) {
            this.currentMessage.setDomain(this.extractText(domain));
        }

        @Override
        protected void handleMsgctxt(AST msgctxt) {
            this.currentMessage.setMsgctxt(this.extractText(msgctxt));
        }

        @Override
        protected void handleMsgid(AST msgid) {
            this.currentMessage.setMsgid(this.extractText(msgid));
        }

        @Override
        protected void handleMsgidPlural(AST msgidPlural) {
            this.currentMessage.setMsgidPlural(this.extractText(msgidPlural));
        }

        @Override
        protected void handleMsgstr(AST msgstr) {
            this.currentMessage.setMsgstr(this.extractText(msgstr));
        }

        @Override
        protected void handleMsgstrPlural(AST msgstr, AST plurality) {
            this.currentMessage.addMsgstrPlural(this.extractText(msgstr), Integer.parseInt(plurality.getText()));
        }

        private String extractText(AST ast) {
            return ast == null ? "" : ast.getText();
        }

        private String parseSourceReference(AST ast) {
            return ast.getText();
        }

        public boolean hasNext() {
            if (this.nextMessage != null) {
                return true;
            }
            boolean next = true;
            try {
                next = this.nextMessageBlock();
            }
            catch (RecognitionException e) {
                this.currentRecognitionException = e;
            }
            catch (TokenStreamException e) {
                this.currentTokenStreamException = e;
            }
            return next;
        }

        private void checkExceptions() throws RecognitionException, TokenStreamException {
            if (this.currentRecognitionException != null) {
                RecognitionException e = this.currentRecognitionException;
                this.currentRecognitionException = null;
                throw e;
            }
            if (this.currentTokenStreamException != null) {
                TokenStreamException e = this.currentTokenStreamException;
                this.currentTokenStreamException = null;
                throw e;
            }
        }

        public Message next() throws RecognitionException, TokenStreamException {
            this.checkExceptions();
            if (!this.hasNext()) {
                return null;
            }
            Message next = this.nextMessage;
            this.nextMessage = null;
            return next;
        }
    }
}

