/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import org.zanata.adapter.xliff.XliffWriter;
import org.zanata.client.commands.pull.AbstractPullStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.dto.LocaleMappedTranslatedDoc;
import org.zanata.common.io.FileDetails;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class XliffStrategy
extends AbstractPullStrategy {
    StringSet extensions = new StringSet("comment");

    protected XliffStrategy(PullOptions opts) {
        super(opts);
    }

    @Override
    public StringSet getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean needsDocToWriteTrans() {
        return true;
    }

    @Override
    public void writeSrcFile(Resource doc) throws IOException {
        XliffWriter.write((File)this.getOpts().getSrcDir(), (Resource)doc, (String)"en-US");
    }

    @Override
    public FileDetails writeTransFile(String docName, LocaleMappedTranslatedDoc translatedDoc) throws IOException {
        File transFileToWrite = this.getTransFileToWrite(docName, translatedDoc.getLocale());
        XliffWriter.writeFile((File)transFileToWrite, (Resource)translatedDoc.getSource(), (String)translatedDoc.getLocale().getLocalLocale(), (TranslationsResource)translatedDoc.getTranslation(), (boolean)this.getOpts().getCreateSkeletons(), (boolean)this.getOpts().getApprovedOnly());
        return null;
    }
}

