/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.stats;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.zanata.client.commands.stats.ContainerStatisticsCommandOutput;
import org.zanata.rest.dto.Link;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.dto.stats.TranslationStatistics;

public class CsvStatisticsOutput
implements ContainerStatisticsCommandOutput {
    private static final String NEW_LINE_SEPARATOR = "\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public void write(ContainerTranslationStatistics statistics) {
        try (OutputStreamWriter streamWriter = new OutputStreamWriter(System.out);
             CSVPrinter csvPrinter = new CSVPrinter((Appendable)streamWriter, CSVFormat.DEFAULT.withRecordSeparator(NEW_LINE_SEPARATOR));){
            this.writeToCsv(statistics, csvPrinter);
            csvPrinter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeToCsv(ContainerTranslationStatistics statistics, CSVPrinter writer) throws IOException {
        writer.printRecord((Iterable)Lists.newArrayList());
        Link sourceRef = statistics.getRefs().findLinkByRel("statSource");
        if (sourceRef.getType().equals("PROJ_ITER")) {
            writer.printRecord((Iterable)Lists.newArrayList((Object[])new String[]{"Project Version: ", statistics.getId()}));
        } else if (sourceRef.getType().equals("DOC")) {
            writer.printRecord((Iterable)Lists.newArrayList((Object[])new String[]{"Document: ", statistics.getId()}));
        }
        writer.printRecord((Iterable)Lists.newArrayList((Object[])new String[]{"Locale", "Unit", "Total", "Translated", "Need Review", "Untranslated", "Last Translated"}));
        if (statistics.getStats() != null) {
            for (TranslationStatistics transStats : statistics.getStats()) {
                writer.printRecord((Iterable)Lists.newArrayList((Object[])new String[]{transStats.getLocale(), transStats.getUnit().toString(), Long.toString(transStats.getTotal()), Long.toString(transStats.getTranslatedAndApproved()), Long.toString(transStats.getDraft()), Long.toString(transStats.getUntranslated()), transStats.getLastTranslated()}));
            }
        }
        writer.printRecord((Iterable)Lists.newArrayList());
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (statistics.getDetailedStats() != null) {
            for (ContainerTranslationStatistics detailedStats : statistics.getDetailedStats()) {
                this.writeToCsv(detailedStats, writer);
            }
        }
    }
}

