/***************************************************************
 * Name:      event.cpp
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#include "calendarday.h"

Calendarday::Calendarday()
    : m_day(44), m_daytype(0), m_tooltip(wxEmptyString), m_ids(wxEmptyString)
{
}

Calendarday::Calendarday(wxDateTime::wxDateTime_t day, wxUint8 daytype, const wxString &tooltip, const wxString &ids)
    : m_day(day), m_daytype(daytype), m_tooltip(tooltip), m_ids(ids)
{
}

Calendarday::~Calendarday()
{
}

wxDateTime::wxDateTime_t Calendarday::day() const
{
    return m_day;
}

void Calendarday::setDay(const wxDateTime::wxDateTime_t &day)
{
    m_day = day;
}

wxUint8 Calendarday::daytype() const
{
    return m_daytype;
}

void Calendarday::setDaytype(const wxUint8 &daytype)
{
    m_daytype = daytype;
}

wxString Calendarday::tooltip() const
{
    return m_tooltip;
}

void Calendarday::setTooltip(const wxString &tooltip)
{
    m_tooltip = tooltip;
}

wxString Calendarday::ids() const
{
    return m_ids;
}

void Calendarday::setIds(const wxString &ids)
{
    m_ids = ids;
}
