/***************************************************************
 * Name:      dxcalnedarpickerctrl.cpp
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#include "dxcalendarpickerctrl.h"
#include "dxsettings.h"
#include "dxdefs.h"
#include "data/engine.h"
#include "dxutils.h"
#include "dxicons.h"

BEGIN_EVENT_TABLE(dxCalendarPickerCtrl, wxPanel)
    EVT_BUTTON(ID_DATE_SELECT, dxCalendarPickerCtrl::OnSelect)
END_EVENT_TABLE()

dxCalendarPickerCtrl::dxCalendarPickerCtrl(wxWindow *parent, const wxDateTime &date)
    : wxPanel(parent), m_date(date)
{
    m_mainSizer = new wxBoxSizer(wxHORIZONTAL);
    m_text = new wxStaticText(this, wxID_ANY, dxutils::formatDate(m_date, dxsettings.dateFormat(), true));
    m_mainSizer->Add(m_text, 0, wxALIGN_CENTER_VERTICAL);
    m_mainSizer->AddSpacer(5);
    m_select = new wxBitmapButton(this, ID_DATE_SELECT, ICO_DATE);
    m_select->SetToolTip(_("Select date"));
    m_mainSizer->Add(m_select, 0, wxEXPAND|wxALL);
    this->SetSizer(m_mainSizer);
    m_mainSizer->Fit(this);
    m_mainSizer->SetSizeHints(this);
}

wxDateTime dxCalendarPickerCtrl::date() const
{
    return m_date;
}

void dxCalendarPickerCtrl::setDate(const wxDateTime &date)
{
    m_date = date;
    m_text->SetLabel(dxutils::formatDate(m_date, dxsettings.dateFormat(), true));
}

void dxCalendarPickerCtrl::OnSelect(wxCommandEvent &/*event*/)
{
    DateDialog dialog(this,m_date);
    if(dialog.ShowModal() == wxID_OK)
    {
        setDate(dialog.date());
        m_mainSizer->Layout();
        m_mainSizer->Fit(this);
        m_mainSizer->SetSizeHints(this);
    }
}

IMPLEMENT_DYNAMIC_CLASS(DateDialog, wxDialog)

DateDialog::DateDialog(wxWindow *parent, const wxDateTime &date)
    : wxDialog(parent, wxID_ANY, _("Select date"))
{
    wxBoxSizer *mainSizer = new wxBoxSizer(wxVERTICAL);
    m_calendar = new dxCalendar(this, ID_DATE_CALENDAR, false, false);
    m_calendar->setValue(date);
    m_calendar->updateCalendar();
    mainSizer->Add(m_calendar, 1, wxALL|wxEXPAND, 5);
    wxStdDialogButtonSizer *btnSizer = new wxStdDialogButtonSizer();
    wxButton* okButton = new wxButton(this, wxID_OK, "", wxDefaultPosition, wxDefaultSize, 0);
    btnSizer->AddButton(okButton);
    wxButton* cancelButton = new wxButton(this, wxID_CANCEL, "", wxDefaultPosition, wxDefaultSize, 0);
    btnSizer->AddButton(cancelButton);
    btnSizer->Realize();
    mainSizer->Add(btnSizer, 0, wxALL|wxALIGN_CENTER_HORIZONTAL, 5);
    this->SetSizer(mainSizer);
    mainSizer->Fit(this);
    mainSizer->SetSizeHints(this);

//    Connect(ID_DATE_CALENDAR, wxEVT_CALENDAR_PAGE_CHANGED, wxCalendarEventHandler(DateDialog::OnCalendarMonthYear), nullptr, this);
    Connect(ID_DATE_CALENDAR, wxEVT_CALENDAR_DOUBLECLICKED, wxCalendarEventHandler(DateDialog::OnCalendarDoubleclick), nullptr, this);

//    m_calendar->markDays();
}

wxDateTime DateDialog::date() const
{
    return m_calendar->getValue();
}

void DateDialog::OnCalendarMonthYear(wxCalendarEvent &/*event*/)
{
    m_calendar->Refresh();
}

void DateDialog::OnCalendarDoubleclick(wxCalendarEvent &/*event*/)
{
    EndModal(wxID_OK);
}
