/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.ch;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class AbstractFileChannel
extends FileChannel {
    private static final int BUFFER_SIZE = 4096;
    private final Set<Thread> blockingThreads = new HashSet<Thread>();
    private final ReadWriteLock readWriteLock;
    protected long position;

    public AbstractFileChannel(ReadWriteLock readWriteLock) {
        this.readWriteLock = readWriteLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beginBlocking() {
        this.begin();
        Set<Thread> set = this.blockingThreads;
        synchronized (set) {
            if (this.isOpen()) {
                this.blockingThreads.add(Thread.currentThread());
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endBlocking(boolean completed) throws AsynchronousCloseException {
        Set<Thread> set = this.blockingThreads;
        synchronized (set) {
            this.blockingThreads.remove(Thread.currentThread());
        }
        this.end(completed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        Set<Thread> set = this.blockingThreads;
        synchronized (set) {
            for (Thread thread : this.blockingThreads) {
                thread.interrupt();
            }
        }
    }

    @Override
    public long position() throws IOException {
        this.assertOpen();
        return this.position;
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0);
        this.assertOpen();
        this.position = newPosition;
        return this;
    }

    protected void assertWritable() throws IOException {
        if (!this.isWritable()) {
            throw new NonWritableChannelException();
        }
    }

    protected abstract boolean isWritable();

    protected void assertReadable() throws IOException {
        if (!this.isReadable()) {
            throw new NonReadableChannelException();
        }
    }

    protected abstract boolean isReadable();

    protected void assertOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        this.assertOpen();
        this.assertReadable();
        try {
            this.beginBlocking();
            long totalRead = 0L;
            for (int i = offset; i < offset + length; ++i) {
                int read = this.read(dsts[i]);
                if (read == -1 && totalRead == 0L) {
                    long l = -1L;
                    return l;
                }
                if (read == -1) {
                    long l = totalRead;
                    return l;
                }
                totalRead += (long)read;
            }
            long l = totalRead;
            return l;
        }
        finally {
            this.endBlocking(true);
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = this.read(dst, this.position);
        if (read != -1) {
            this.position += (long)read;
        }
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        this.assertOpen();
        this.assertReadable();
        boolean completed = false;
        try {
            this.beginBlocking();
            this.readWriteLock.readLock().lockInterruptibly();
            try {
                int read = this.readLocked(dst, position);
                completed = true;
                int n = read;
                this.readWriteLock.readLock().unlock();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.readWriteLock.readLock().unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        finally {
            this.endBlocking(completed);
        }
    }

    protected abstract int readLocked(ByteBuffer var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        this.assertOpen();
        this.assertWritable();
        try {
            this.beginBlocking();
            long totalWritten = 0L;
            for (int i = offset; i < offset + length; ++i) {
                totalWritten += (long)this.write(srcs[i]);
            }
            long l = totalWritten;
            return l;
        }
        finally {
            this.endBlocking(true);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int written = this.write(src, this.position);
        this.position += (long)written;
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        this.assertOpen();
        this.assertWritable();
        boolean completed = false;
        try {
            this.beginBlocking();
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                int written = this.writeLocked(src, position);
                completed = true;
                int n = written;
                this.readWriteLock.writeLock().unlock();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.readWriteLock.writeLock().unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        finally {
            this.endBlocking(completed);
        }
    }

    protected abstract int writeLocked(ByteBuffer var1, long var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel truncate(long size) throws IOException {
        this.assertOpen();
        this.assertWritable();
        boolean completed = false;
        try {
            this.beginBlocking();
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                this.truncateLocked(size);
                completed = true;
                AbstractFileChannel abstractFileChannel = this;
                this.readWriteLock.writeLock().unlock();
                return abstractFileChannel;
            }
            catch (Throwable throwable) {
                try {
                    this.readWriteLock.writeLock().unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        finally {
            this.endBlocking(completed);
        }
    }

    protected abstract void truncateLocked(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        this.assertOpen();
        this.assertReadable();
        boolean completed = false;
        try {
            this.beginBlocking();
            this.readWriteLock.readLock().lockInterruptibly();
            try {
                long transferred = this.transferToLocked(position, count, target);
                completed = true;
                long l = transferred;
                this.readWriteLock.readLock().unlock();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.readWriteLock.readLock().unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        finally {
            this.endBlocking(completed);
        }
    }

    protected long transferToLocked(long position, long count, WritableByteChannel target) throws IOException {
        long transferred;
        ByteBuffer buf = ByteBuffer.allocate((int)Math.min(count, 4096L));
        for (transferred = 0L; transferred < count; transferred += (long)target.write(buf)) {
            buf.clear();
            int read = this.read(buf, position + transferred);
            if (read == -1) break;
            buf.flip();
            buf.limit((int)Math.min((long)buf.limit(), count - transferred));
        }
        return transferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.assertOpen();
        this.assertWritable();
        boolean completed = false;
        try {
            this.beginBlocking();
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                long transferred = this.transferFromLocked(src, position, count);
                completed = true;
                long l = transferred;
                this.readWriteLock.writeLock().unlock();
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.readWriteLock.writeLock().unlock();
                    throw throwable;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
        finally {
            this.endBlocking(completed);
        }
    }

    protected long transferFromLocked(ReadableByteChannel src, long position, long count) throws IOException {
        long transferred;
        if (position > this.size()) {
            return 0L;
        }
        ByteBuffer buf = ByteBuffer.allocate((int)Math.min(count, 4096L));
        for (transferred = 0L; transferred < count; transferred += (long)this.write(buf, position + transferred)) {
            buf.clear();
            int read = src.read(buf);
            if (read == -1) break;
            buf.flip();
            buf.limit((int)Math.min((long)buf.limit(), count - transferred));
        }
        return transferred;
    }
}

