/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.common;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public class DeletingFileVisitor
extends SimpleFileVisitor<Path> {
    public static final DeletingFileVisitor INSTANCE = new DeletingFileVisitor();
    private static final Set<PosixFilePermission> POSIX_PERMISSIONS_770 = EnumSet.of(PosixFilePermission.OWNER_WRITE, new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE});

    private DeletingFileVisitor() {
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc instanceof NoSuchFileException) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        throw exc;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        DeletingFileVisitor.forceDeleteIfExists(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        DeletingFileVisitor.forceDeleteIfExists(dir);
        return FileVisitResult.CONTINUE;
    }

    public static void forceDeleteIfExists(Path path) throws IOException {
        DeletingFileVisitor.setWritableSilently(path);
        Files.deleteIfExists(path);
    }

    private static void setWritableSilently(Path path) {
        try {
            DeletingFileVisitor.setWritable(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void setWritable(Path path) throws IOException {
        DosFileAttributeView dosAttributes = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
        PosixFileAttributeView posixAttributes = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (dosAttributes != null) {
            dosAttributes.setReadOnly(false);
            dosAttributes.setSystem(false);
        }
        if (posixAttributes != null) {
            posixAttributes.setPermissions(POSIX_PERMISSIONS_770);
        }
    }
}

