/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.nio.file.Path;
import java.util.Map;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;

public class DirIdCollision
implements DiagnosticResult {
    final String dirId;
    final Path file;
    final Path otherFile;

    DirIdCollision(String dirId, Path file, Path otherFile) {
        this.dirId = dirId;
        this.file = file;
        this.otherFile = otherFile;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.CRITICAL;
    }

    @Override
    public String toString() {
        return String.format("Directory ID reused: %s found in %s and %s", this.dirId, this.file, this.otherFile);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Directory ID", this.dirId, "Directory ID File", this.file.toString(), "Other Directory ID File", this.otherFile.toString());
    }
}

