/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.api;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cryptomator.cryptofs.migration.api.MigrationContinuationListener;

public abstract class SimpleMigrationContinuationListener
implements MigrationContinuationListener {
    private final Lock lock = new ReentrantLock();
    private final Condition waitForResult = this.lock.newCondition();
    private final AtomicReference<MigrationContinuationListener.ContinuationResult> atomicResult = new AtomicReference();

    public abstract void migrationHaltedDueToEvent(MigrationContinuationListener.ContinuationEvent var1);

    public final void continueMigrationWithResult(MigrationContinuationListener.ContinuationResult result) {
        this.lock.lock();
        try {
            this.atomicResult.set(result);
            this.waitForResult.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MigrationContinuationListener.ContinuationResult continueMigrationOnEvent(MigrationContinuationListener.ContinuationEvent event) {
        this.migrationHaltedDueToEvent(event);
        this.lock.lock();
        try {
            this.waitForResult.await();
            MigrationContinuationListener.ContinuationResult continuationResult = this.atomicResult.get();
            return continuationResult;
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            MigrationContinuationListener.ContinuationResult continuationResult = MigrationContinuationListener.ContinuationResult.CANCEL;
            return continuationResult;
        }
        finally {
            this.lock.unlock();
        }
    }
}

