/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure.filesecurity;

import com.dokany.java.structure.EnumIntegerSet;
import com.dokany.java.structure.filesecurity.AccessControlList;
import com.dokany.java.structure.filesecurity.Byteable;
import com.dokany.java.structure.filesecurity.SecurityDescriptorControlFlag;
import com.dokany.java.structure.filesecurity.SecurityIdentifier;
import java.nio.ByteBuffer;
import java.util.Optional;

public class SelfRelativeSecurityDescriptor
implements Byteable {
    private static final byte[] EMPTY = new byte[0];
    private final byte revision = 1;
    private final byte sbz1 = 0;
    private EnumIntegerSet<SecurityDescriptorControlFlag> control;
    private Optional<SecurityIdentifier> ownerSid;
    private Optional<SecurityIdentifier> groupSid;
    private Optional<AccessControlList> sacl;
    private Optional<AccessControlList> dacl;

    private SelfRelativeSecurityDescriptor(EnumIntegerSet<SecurityDescriptorControlFlag> control) {
        this.control = control;
        this.ownerSid = Optional.empty();
        this.groupSid = Optional.empty();
        this.sacl = Optional.empty();
        this.dacl = Optional.empty();
    }

    private SelfRelativeSecurityDescriptor(EnumIntegerSet<SecurityDescriptorControlFlag> control, SecurityIdentifier ownerSid, SecurityIdentifier groupSid, AccessControlList sacl, AccessControlList dacl) {
        this.control = control;
        this.ownerSid = ownerSid != null ? Optional.of(ownerSid) : Optional.empty();
        this.groupSid = groupSid != null ? Optional.of(groupSid) : Optional.empty();
        this.sacl = sacl != null ? Optional.of(sacl) : Optional.empty();
        this.dacl = dacl != null ? Optional.of(dacl) : Optional.empty();
    }

    @Override
    public byte[] toByteArray() {
        int offset = 20;
        int offsetOwner = 0;
        int offsetGroup = 0;
        int offsetSacl = 0;
        int offsetDacl = 0;
        if (this.ownerSid.isPresent()) {
            offsetOwner = offset;
            offset += this.ownerSid.get().sizeOfByteArray();
        }
        if (this.groupSid.isPresent()) {
            offsetGroup = offset;
            offset += this.groupSid.get().sizeOfByteArray();
        }
        if (this.sacl.isPresent()) {
            offsetSacl = offset;
            offset += this.sacl.get().sizeOfByteArray();
        }
        if (this.dacl.isPresent()) {
            offsetDacl = offset;
            offset += this.dacl.get().sizeOfByteArray();
        }
        ByteBuffer buf = ByteBuffer.allocate(this.sizeOfByteArray());
        buf.put((byte)1);
        buf.put((byte)0);
        buf.putShort(Short.reverseBytes((short)this.control.toInt()));
        buf.putInt(Integer.reverseBytes(offsetOwner));
        buf.putInt(Integer.reverseBytes(offsetGroup));
        buf.putInt(Integer.reverseBytes(offsetSacl));
        buf.putInt(Integer.reverseBytes(offsetDacl));
        buf.put(this.ownerSid.map(SecurityIdentifier::toByteArray).orElse(EMPTY));
        buf.put(this.groupSid.map(SecurityIdentifier::toByteArray).orElse(EMPTY));
        buf.put(this.sacl.map(AccessControlList::toByteArray).orElse(EMPTY));
        buf.put(this.dacl.map(AccessControlList::toByteArray).orElse(EMPTY));
        return buf.array();
    }

    @Override
    public int sizeOfByteArray() {
        return 20 + this.ownerSid.map(SecurityIdentifier::sizeOfByteArray).orElse(0) + this.groupSid.map(SecurityIdentifier::sizeOfByteArray).orElse(0) + this.sacl.map(AccessControlList::sizeOfByteArray).orElse(0) + this.dacl.map(AccessControlList::sizeOfByteArray).orElse(0);
    }

    public static SelfRelativeSecurityDescriptor createEmptySD(EnumIntegerSet<SecurityDescriptorControlFlag> flags) {
        if ((flags.toInt() & (SecurityDescriptorControlFlag.DP.getMask() | SecurityDescriptorControlFlag.SP.getMask())) == 0) {
            flags.add(SecurityDescriptorControlFlag.SR);
            return new SelfRelativeSecurityDescriptor(flags);
        }
        return null;
    }

    public static SelfRelativeSecurityDescriptor createSD(EnumIntegerSet<SecurityDescriptorControlFlag> flags, SecurityIdentifier owner, SecurityIdentifier group, AccessControlList sacl, AccessControlList dacl) {
        int controlMask = flags.toInt();
        if ((controlMask & SecurityDescriptorControlFlag.DP.getMask()) != 0 && dacl == null) {
            return null;
        }
        if ((controlMask & SecurityDescriptorControlFlag.SP.getMask()) != 0 && sacl == null) {
            return null;
        }
        flags.add(SecurityDescriptorControlFlag.SR);
        return new SelfRelativeSecurityDescriptor(flags, owner, group, sacl, dacl);
    }
}

