/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany;

import com.dokany.java.constants.AccessMask;
import com.dokany.java.constants.CreateOptions;
import com.dokany.java.constants.CreationDisposition;
import com.dokany.java.constants.FileAccessMask;
import com.dokany.java.constants.FileAttribute;
import com.dokany.java.structure.EnumIntegerSet;
import com.google.common.collect.Sets;
import com.sun.jna.platform.win32.WinBase;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    public static final Instant WINDOWS_EPOCH_START = Instant.parse("1601-01-01T00:00:00Z");
    public static final int FILE_SUPERSEDE = 0;
    public static final int FILE_OPEN = 1;
    public static final int FILE_CREATE = 2;
    public static final int FILE_OPEN_IF = 3;
    public static final int FILE_OVERWRITE = 4;
    public static final int FILE_OVERWRITE_IF = 5;
    static final FileAttribute[] supportedAttributeValuesToSet = new FileAttribute[]{FileAttribute.HIDDEN, FileAttribute.READONLY, FileAttribute.SYSTEM, FileAttribute.ARCHIVE};
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);
    private static final Set<Integer> globOperatorsToEscapeCodePoints;

    public static EnumIntegerSet<FileAttribute> dosAttributesToEnumIntegerSet(DosFileAttributes attr) {
        EnumIntegerSet<FileAttribute> set = new EnumIntegerSet<FileAttribute>(FileAttribute.class);
        if (attr.isArchive()) {
            set.add(FileAttribute.ARCHIVE);
        }
        if (attr.isHidden()) {
            set.add(FileAttribute.HIDDEN);
        }
        if (attr.isReadOnly()) {
            set.add(FileAttribute.READONLY);
        }
        if (attr.isSystem()) {
            set.add(FileAttribute.SYSTEM);
        }
        if (attr.isDirectory()) {
            set.add(FileAttribute.DIRECTORY);
        }
        if (attr.isSymbolicLink()) {
            set.add(FileAttribute.REPARSE_POINT);
        }
        if (attr.isRegularFile() && set.isEmpty()) {
            set.add(FileAttribute.NORMAL);
        }
        return set;
    }

    public static void setAttribute(DosFileAttributeView attrView, FileAttribute attr, boolean value) throws IOException {
        switch (attr) {
            case ARCHIVE: {
                attrView.setArchive(value);
                break;
            }
            case HIDDEN: {
                attrView.setHidden(value);
                break;
            }
            case READONLY: {
                attrView.setReadOnly(value);
                break;
            }
            case SYSTEM: {
                attrView.setSystem(value);
                break;
            }
            default: {
                LOG.debug("Windows file attribute {} is currently not supported and thus will be ignored", (Object)attr.name());
            }
        }
    }

    public static String convertToGlobPattern(String rawWindowsPattern) {
        String javaPattern = FileUtil.convertToJavaPattern(rawWindowsPattern);
        return FileUtil.addEscapeSequencesForPathPattern(javaPattern);
    }

    private static String convertToJavaPattern(String rawWindowsPattern) {
        String tmp1 = rawWindowsPattern.replace('>', '?');
        String tmp2 = tmp1.replace('<', '*');
        String tmp3 = tmp2.replace('\"', '.');
        return tmp3;
    }

    private static String addEscapeSequencesForPathPattern(String rawPattern) {
        return rawPattern.codePoints().flatMap(c -> {
            if (Character.isBmpCodePoint(c) && globOperatorsToEscapeCodePoints.contains(c)) {
                return IntStream.of(92, c);
            }
            return IntStream.of(c);
        }).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    public static Set<OpenOption> buildOpenOptions(EnumIntegerSet<AccessMask> accessMasks, EnumIntegerSet<FileAccessMask> fileAccessMasks, EnumIntegerSet<FileAttribute> fileAttributes, EnumIntegerSet<CreateOptions> createOptions, CreationDisposition creationDisposition, boolean append, boolean fileExists) {
        HashSet openOptions = Sets.newHashSet();
        if (accessMasks.contains(AccessMask.GENERIC_WRITE) || fileAccessMasks.contains(FileAccessMask.WRITE_DATA) || fileAccessMasks.contains(FileAccessMask.APPEND_DATA)) {
            openOptions.add(StandardOpenOption.WRITE);
        }
        if (accessMasks.contains(AccessMask.GENERIC_READ) || fileAccessMasks.contains(FileAccessMask.READ_DATA)) {
            openOptions.add(StandardOpenOption.READ);
        }
        if (accessMasks.contains(AccessMask.MAXIMUM_ALLOWED) || accessMasks.contains(AccessMask.GENERIC_ALL)) {
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        if (createOptions.contains(CreateOptions.FILE_WRITE_THROUGH)) {
            openOptions.add(StandardOpenOption.SYNC);
        }
        if (append) {
            openOptions.add(StandardOpenOption.APPEND);
        }
        if (fileAttributes.contains(FileAttribute.SPARSE_FILE)) {
            openOptions.add(StandardOpenOption.SPARSE);
        }
        switch (creationDisposition) {
            case CREATE_NEW: {
                openOptions.add(StandardOpenOption.CREATE_NEW);
                openOptions.add(StandardOpenOption.WRITE);
                break;
            }
            case CREATE_ALWAYS: {
                if (fileExists) {
                    openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                    break;
                }
                openOptions.add(StandardOpenOption.CREATE);
                openOptions.add(StandardOpenOption.WRITE);
                break;
            }
            case OPEN_EXISTING: {
                openOptions.add(StandardOpenOption.READ);
                break;
            }
            case OPEN_ALWAYS: {
                openOptions.add(StandardOpenOption.CREATE);
                if (fileExists) break;
                openOptions.add(StandardOpenOption.WRITE);
                break;
            }
            case TRUNCATE_EXISTING: {
                openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown createDispostion attribute: " + creationDisposition.name());
            }
        }
        return openOptions;
    }

    public static Optional<FileTime> toFileTime(WinBase.FILETIME windowsTime) {
        Instant instant = windowsTime.toDate().toInstant();
        if (instant.equals(WINDOWS_EPOCH_START)) {
            return Optional.empty();
        }
        return Optional.of(FileTime.from(instant));
    }

    public static int mapFileGenericAccessToGenericAccess(int fileAccess) {
        boolean genericRead = false;
        boolean genericWrite = false;
        boolean genericExecute = false;
        boolean genericAll = false;
        int outDesiredAccess = fileAccess;
        if ((outDesiredAccess & 0x120089) == 1179785) {
            outDesiredAccess |= Integer.MIN_VALUE;
            genericRead = true;
        }
        if ((outDesiredAccess & 0x120116) == 1179926) {
            outDesiredAccess |= 0x40000000;
            genericWrite = true;
        }
        if ((outDesiredAccess & 0x1200A0) == 1179808) {
            outDesiredAccess |= 0x20000000;
            genericExecute = true;
        }
        if ((outDesiredAccess & 0x1F01FF) == 0x1F01FF) {
            outDesiredAccess |= 0x10000000;
            genericAll = true;
        }
        if (genericRead) {
            outDesiredAccess &= 0xFFEDFF76;
        }
        if (genericWrite) {
            outDesiredAccess &= 0xFFEDFEE9;
        }
        if (genericExecute) {
            outDesiredAccess &= 0xFFEDFF5F;
        }
        if (genericAll) {
            outDesiredAccess &= 0xFFE0FE00;
        }
        return outDesiredAccess;
    }

    public static int convertCreateDispositionToCreationDispostion(int createDisposition) {
        switch (createDisposition) {
            case 2: {
                return CreationDisposition.CREATE_NEW.getMask();
            }
            case 1: {
                return CreationDisposition.OPEN_EXISTING.getMask();
            }
            case 3: {
                return CreationDisposition.OPEN_ALWAYS.getMask();
            }
            case 4: {
                return CreationDisposition.TRUNCATE_EXISTING.getMask();
            }
            case 0: 
            case 5: {
                return CreationDisposition.CREATE_ALWAYS.getMask();
            }
        }
        return 0;
    }

    static {
        char[] globOperatorsToEscape = new char[]{'[', ']', '{', '}'};
        globOperatorsToEscapeCodePoints = Sets.newHashSet();
        for (int i = 0; i < globOperatorsToEscape.length; ++i) {
            globOperatorsToEscapeCodePoints.add(Character.codePointAt(globOperatorsToEscape, i));
        }
    }
}

